/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.entity;

import dev.sterner.witchery.content.entity.HuntsmanSpearEntity;
import dev.sterner.witchery.core.registry.WitcheryEntityTypes;
import dev.sterner.witchery.core.registry.WitcheryItems;
import java.util.EnumSet;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.Holder;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 @2\u00020\u0001:\u0002@AB\u001f\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00000\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\bJ\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010\u001e\u001a\u00020\u001bH\u0014J,\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u0004\u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\b\u0010&\u001a\u0004\u0018\u00010 H\u0016J\b\u0010'\u001a\u00020(H\u0014J\u0010\u0010)\u001a\u00020(2\u0006\u0010*\u001a\u00020+H\u0014J\b\u0010,\u001a\u00020(H\u0014J\b\u0010-\u001a\u00020\u001bH\u0016J\b\u0010.\u001a\u00020\u001bH\u0014J\u0018\u0010/\u001a\u00020\u00112\u0006\u00100\u001a\u00020+2\u0006\u00101\u001a\u000202H\u0016J\u0010\u00103\u001a\u00020\u00112\u0006\u00104\u001a\u000205H\u0016J\u000e\u00106\u001a\u00020\u001b2\u0006\u00104\u001a\u000207J \u00108\u001a\u00020\u001b2\u0006\u0010\u0004\u001a\u0002092\u0006\u0010*\u001a\u00020+2\u0006\u0010:\u001a\u00020\u0011H\u0014J\u0006\u0010;\u001a\u00020\u0011J\u000e\u0010<\u001a\u00020\u001b2\u0006\u0010=\u001a\u00020\u0011J\u0006\u0010>\u001a\u00020\u0011J\u000e\u0010?\u001a\u00020\u001b2\u0006\u0010>\u001a\u00020\u0011R\u001e\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001e\u0010\u000e\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\r\"\u0004\b\u0018\u0010\u0019\u00a8\u0006B"}, d2={"Ldev/sterner/witchery/content/entity/HornedHuntsmanEntity;", "Lnet/minecraft/world/entity/monster/Monster;", "entityType", "Lnet/minecraft/world/entity/EntityType;", "level", "Lnet/minecraft/world/level/Level;", "<init>", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V", "(Lnet/minecraft/world/level/Level;)V", "value", "", "attackCooldown", "getAttackCooldown", "()I", "spearThrowCooldown", "getSpearThrowCooldown", "strafingBackwards", "", "getStrafingBackwards", "()Z", "setStrafingBackwards", "(Z)V", "strafingTime", "getStrafingTime", "setStrafingTime", "(I)V", "defineSynchedData", "", "builder", "Lnet/minecraft/network/syncher/SynchedEntityData$Builder;", "registerGoals", "finalizeSpawn", "Lnet/minecraft/world/entity/SpawnGroupData;", "Lnet/minecraft/world/level/ServerLevelAccessor;", "difficulty", "Lnet/minecraft/world/DifficultyInstance;", "spawnType", "Lnet/minecraft/world/entity/MobSpawnType;", "spawnGroupData", "getAmbientSound", "Lnet/minecraft/sounds/SoundEvent;", "getHurtSound", "damageSource", "Lnet/minecraft/world/damagesource/DamageSource;", "getDeathSound", "tick", "customServerAiStep", "hurt", "source", "amount", "", "doHurtTarget", "target", "Lnet/minecraft/world/entity/Entity;", "performRangedAttack", "Lnet/minecraft/world/entity/LivingEntity;", "dropCustomDeathLoot", "Lnet/minecraft/server/level/ServerLevel;", "recentlyHit", "isAttacking", "setAttacking", "attacking", "hasSpear", "setHasSpear", "Companion", "HuntsmanRangedAttackGoal", "witchery"})
public final class HornedHuntsmanEntity
extends Monster {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int attackCooldown;
    private int spearThrowCooldown;
    private boolean strafingBackwards;
    private int strafingTime;
    private static final EntityDataAccessor<Boolean> ATTACKING = SynchedEntityData.defineId(HornedHuntsmanEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> HAS_SPEAR = SynchedEntityData.defineId(HornedHuntsmanEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final int RANGED_ATTACK_INTERVAL = 60;
    private static final int MELEE_ATTACK_INTERVAL = 20;
    private static final int SPEAR_RECOVERY_TIME = 100;

    public HornedHuntsmanEntity(@NotNull EntityType<? extends HornedHuntsmanEntity> entityType, @NotNull Level level) {
        Intrinsics.checkNotNullParameter(entityType, (String)"entityType");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        super(entityType, level);
    }

    public final int getAttackCooldown() {
        return this.attackCooldown;
    }

    public final int getSpearThrowCooldown() {
        return this.spearThrowCooldown;
    }

    public final boolean getStrafingBackwards() {
        return this.strafingBackwards;
    }

    public final void setStrafingBackwards(boolean bl) {
        this.strafingBackwards = bl;
    }

    public final int getStrafingTime() {
        return this.strafingTime;
    }

    public final void setStrafingTime(int n) {
        this.strafingTime = n;
    }

    public HornedHuntsmanEntity(@NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Object object = WitcheryEntityTypes.INSTANCE.getHORNED_HUNTSMAN().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        this((EntityType<? extends HornedHuntsmanEntity>)((EntityType)object), level);
    }

    protected void defineSynchedData(@NotNull SynchedEntityData.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        super.defineSynchedData(builder);
        builder.define(ATTACKING, (Object)false);
        builder.define(HAS_SPEAR, (Object)true);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new HuntsmanRangedAttackGoal(this));
        this.goalSelector.addGoal(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.goalSelector.addGoal(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(@NotNull ServerLevelAccessor level, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)difficulty, (String)"difficulty");
        Intrinsics.checkNotNullParameter((Object)spawnType, (String)"spawnType");
        this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)WitcheryItems.INSTANCE.getHUNTSMAN_SPEAR().get()));
        this.setDropChance(EquipmentSlot.MAINHAND, 0.0f);
        this.setHasSpear(true);
        return super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
    }

    @NotNull
    protected SoundEvent getAmbientSound() {
        SoundEvent soundEvent = SoundEvents.RAVAGER_AMBIENT;
        Intrinsics.checkNotNullExpressionValue((Object)soundEvent, (String)"RAVAGER_AMBIENT");
        return soundEvent;
    }

    @NotNull
    protected SoundEvent getHurtSound(@NotNull DamageSource damageSource) {
        Intrinsics.checkNotNullParameter((Object)damageSource, (String)"damageSource");
        SoundEvent soundEvent = SoundEvents.RAVAGER_HURT;
        Intrinsics.checkNotNullExpressionValue((Object)soundEvent, (String)"RAVAGER_HURT");
        return soundEvent;
    }

    @NotNull
    protected SoundEvent getDeathSound() {
        SoundEvent soundEvent = SoundEvents.RAVAGER_DEATH;
        Intrinsics.checkNotNullExpressionValue((Object)soundEvent, (String)"RAVAGER_DEATH");
        return soundEvent;
    }

    public void tick() {
        int n;
        super.tick();
        if (this.attackCooldown > 0) {
            n = this.attackCooldown;
            this.attackCooldown = n + -1;
        }
        if (this.spearThrowCooldown > 0) {
            n = this.spearThrowCooldown;
            this.spearThrowCooldown = n + -1;
        }
        if (!this.hasSpear() && this.spearThrowCooldown <= 0 && !this.level().isClientSide) {
            this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)WitcheryItems.INSTANCE.getHUNTSMAN_SPEAR().get()));
            this.setHasSpear(true);
        }
    }

    protected void customServerAiStep() {
        super.customServerAiStep();
        if (this.isAttacking() && this.getTarget() == null) {
            this.setAttacking(false);
        }
    }

    public boolean hurt(@NotNull DamageSource source, float amount) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (source.getDirectEntity() instanceof LivingEntity) {
            Entity entity = source.getDirectEntity();
            Intrinsics.checkNotNull((Object)entity, (String)"null cannot be cast to non-null type net.minecraft.world.entity.LivingEntity");
            LivingEntity attacker = (LivingEntity)entity;
            float angleToAttacker = Mth.degreesDifferenceAbs((float)this.getYRot(), (float)Mth.wrapDegrees((float)attacker.getYRot()));
            if (angleToAttacker > 120.0f) {
                return super.hurt(source, amount * 1.5f);
            }
        }
        return super.hurt(source, amount);
    }

    public boolean doHurtTarget(@NotNull Entity target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        if (target instanceof LivingEntity && this.attackCooldown <= 0) {
            this.attackCooldown = 20;
            boolean result = super.doHurtTarget(target);
            if (result && this.random.nextFloat() < 0.2f) {
                Holder effect = switch (this.random.nextInt(3)) {
                    case 0 -> MobEffects.WEAKNESS;
                    case 1 -> MobEffects.MOVEMENT_SLOWDOWN;
                    default -> MobEffects.POISON;
                };
                ((LivingEntity)target).addEffect(new MobEffectInstance(effect, 100, 1));
            }
            return result;
        }
        return false;
    }

    public final void performRangedAttack(@NotNull LivingEntity target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        if (!this.hasSpear() || this.spearThrowCooldown > 0) {
            return;
        }
        Level level = this.level();
        Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
        HuntsmanSpearEntity spearEntity = new HuntsmanSpearEntity(level, (LivingEntity)this, new ItemStack((ItemLike)WitcheryItems.INSTANCE.getHUNTSMAN_SPEAR().get()));
        spearEntity.setPos(this.getX(), this.getEyeY() - 0.1, this.getZ());
        double dx = target.getX() - this.getX();
        double dy = target.getEyeY() - spearEntity.getY();
        double dz = target.getZ() - this.getZ();
        double horizontalDistance = Math.sqrt(dx * dx + dz * dz);
        float velocity = 1.6f;
        spearEntity.shoot(dx, dy + horizontalDistance * 0.2, dz, velocity, 1.0f);
        this.playSound((SoundEvent)SoundEvents.TRIDENT_THROW.value(), 1.0f, 1.0f);
        if (!this.level().isClientSide) {
            this.level().addFreshEntity((Entity)spearEntity);
            this.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
            this.setHasSpear(false);
            this.spearThrowCooldown = 100;
        }
    }

    protected void dropCustomDeathLoot(@NotNull ServerLevel level, @NotNull DamageSource damageSource, boolean recentlyHit) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)damageSource, (String)"damageSource");
        super.dropCustomDeathLoot(level, damageSource, recentlyHit);
        this.spawnAtLocation((ItemLike)WitcheryItems.INSTANCE.getHUNTSMAN_SPEAR().get());
    }

    public final boolean isAttacking() {
        Object object = this.entityData.get(ATTACKING);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (Boolean)object;
    }

    public final void setAttacking(boolean attacking) {
        this.entityData.set(ATTACKING, (Object)attacking);
    }

    public final boolean hasSpear() {
        Object object = this.entityData.get(HAS_SPEAR);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (Boolean)object;
    }

    public final void setHasSpear(boolean hasSpear) {
        this.entityData.set(HAS_SPEAR, (Object)hasSpear);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\r\u001a\u00020\u000eR2\u0010\u0004\u001a&\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006 \u0007*\u0012\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\b\u001a&\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006 \u0007*\u0012\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Ldev/sterner/witchery/content/entity/HornedHuntsmanEntity$Companion;", "", "<init>", "()V", "ATTACKING", "Lnet/minecraft/network/syncher/EntityDataAccessor;", "", "kotlin.jvm.PlatformType", "HAS_SPEAR", "RANGED_ATTACK_INTERVAL", "", "MELEE_ATTACK_INTERVAL", "SPEAR_RECOVERY_TIME", "createAttributes", "Lnet/minecraft/world/entity/ai/attributes/AttributeSupplier$Builder;", "witchery"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AttributeSupplier.Builder createAttributes() {
            AttributeSupplier.Builder builder = Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 150.0).add(Attributes.ATTACK_DAMAGE, 12.0).add(Attributes.MOVEMENT_SPEED, 0.3).add(Attributes.FOLLOW_RANGE, 40.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.6).add(Attributes.ARMOR, 8.0);
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"add(...)");
            return builder;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0011H\u0016J\b\u0010\u0013\u001a\u00020\u000eH\u0016J\b\u0010\u0014\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Ldev/sterner/witchery/content/entity/HornedHuntsmanEntity$HuntsmanRangedAttackGoal;", "Lnet/minecraft/world/entity/ai/goal/Goal;", "huntsman", "Ldev/sterner/witchery/content/entity/HornedHuntsmanEntity;", "<init>", "(Ldev/sterner/witchery/content/entity/HornedHuntsmanEntity;)V", "attackTime", "", "seeTime", "targetX", "", "targetY", "targetZ", "canUse", "", "canContinueToUse", "start", "", "stop", "requiresUpdateEveryTick", "tick", "witchery"})
    private static final class HuntsmanRangedAttackGoal
    extends Goal {
        @NotNull
        private final HornedHuntsmanEntity huntsman;
        private int attackTime;
        private int seeTime;
        private double targetX;
        private double targetY;
        private double targetZ;

        public HuntsmanRangedAttackGoal(@NotNull HornedHuntsmanEntity huntsman) {
            Intrinsics.checkNotNullParameter((Object)((Object)huntsman), (String)"huntsman");
            this.huntsman = huntsman;
            this.attackTime = -1;
            this.setFlags(EnumSet.of((Enum)Goal.Flag.MOVE, (Enum)Goal.Flag.LOOK));
        }

        public boolean canUse() {
            LivingEntity target = this.huntsman.getTarget();
            if (target == null || !target.isAlive()) {
                return false;
            }
            if (!this.huntsman.hasSpear() || this.huntsman.getSpearThrowCooldown() > 0) {
                return false;
            }
            double distanceToTarget = this.huntsman.distanceToSqr((Entity)target);
            return distanceToTarget > 16.0 && distanceToTarget < 400.0;
        }

        public boolean canContinueToUse() {
            LivingEntity target = this.huntsman.getTarget();
            if (target == null || !target.isAlive()) {
                return false;
            }
            if (!this.huntsman.hasSpear()) {
                return false;
            }
            double distanceToTarget = this.huntsman.distanceToSqr((Entity)target);
            return distanceToTarget > 9.0 && distanceToTarget < 400.0 || !this.huntsman.navigation.isDone();
        }

        public void start() {
            super.start();
            this.huntsman.setAttacking(true);
            this.attackTime = 0;
            this.seeTime = 0;
        }

        public void stop() {
            super.stop();
            this.huntsman.setAttacking(false);
            this.attackTime = -1;
            this.seeTime = 0;
            this.huntsman.setStrafingBackwards(false);
            this.huntsman.setStrafingTime(0);
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public void tick() {
            LivingEntity livingEntity = this.huntsman.getTarget();
            if (livingEntity == null) {
                return;
            }
            LivingEntity target = livingEntity;
            double distanceToTarget = this.huntsman.distanceToSqr((Entity)target);
            boolean hasLineOfSight = this.huntsman.hasLineOfSight((Entity)target);
            this.seeTime = hasLineOfSight ? ++this.seeTime : 0;
            if (distanceToTarget <= 64.0 && distanceToTarget > 16.0) {
                HornedHuntsmanEntity hornedHuntsmanEntity = this.huntsman;
                hornedHuntsmanEntity.setStrafingTime(hornedHuntsmanEntity.getStrafingTime() + 1);
                if (hornedHuntsmanEntity.getStrafingTime() >= 20) {
                    this.huntsman.setStrafingBackwards(!this.huntsman.getStrafingBackwards());
                    this.huntsman.setStrafingTime(0);
                }
            } else {
                this.huntsman.setStrafingBackwards(false);
                this.huntsman.setStrafingTime(0);
            }
            if (distanceToTarget > 225.0) {
                this.huntsman.navigation.moveTo((Entity)target, 1.0);
            } else if (distanceToTarget < 36.0 && this.seeTime > 0) {
                double dz;
                double dx = this.huntsman.getX() - target.getX();
                double norm = Math.sqrt(dx * dx + (dz = this.huntsman.getZ() - target.getZ()) * dz);
                if (norm > 0.01) {
                    this.targetX = this.huntsman.getX() + dx / norm * 8.0;
                    this.targetZ = this.huntsman.getZ() + dz / norm * 8.0;
                    this.targetY = this.huntsman.getY();
                    this.huntsman.navigation.moveTo(this.targetX, this.targetY, this.targetZ, 1.0);
                }
            } else if (distanceToTarget >= 36.0 && distanceToTarget <= 64.0 && this.huntsman.getStrafingTime() > 0) {
                double dx = target.getX() - this.huntsman.getX();
                double dz = target.getZ() - this.huntsman.getZ();
                double angle = Math.atan2(dz, dx) + (this.huntsman.getStrafingBackwards() ? 1.5707963267948966 : -1.5707963267948966);
                this.targetX = this.huntsman.getX() + Math.cos(angle) * 6.0;
                this.targetZ = this.huntsman.getZ() + Math.sin(angle) * 6.0;
                this.targetY = this.huntsman.getY();
                this.huntsman.navigation.moveTo(this.targetX, this.targetY, this.targetZ, 0.9);
            }
            this.huntsman.lookControl.setLookAt((Entity)target, 30.0f, 30.0f);
            if (this.seeTime > 5) {
                if (this.attackTime == -1) {
                    this.attackTime = 0;
                }
                ++this.attackTime;
                if (this.attackTime >= 60 && distanceToTarget <= 256.0 && this.huntsman.hasSpear()) {
                    this.huntsman.performRangedAttack(target);
                    this.attackTime = 0;
                }
            } else {
                this.attackTime = -1;
            }
        }
    }
}

