/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.entity.goal;

import dev.sterner.witchery.content.entity.DemonEntity;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0010H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0013H\u0016J\b\u0010\u0015\u001a\u00020\u0013H\u0016J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J \u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Ldev/sterner/witchery/content/entity/goal/DemonFireBreathGoal;", "Lnet/minecraft/world/entity/ai/goal/Goal;", "demon", "Ldev/sterner/witchery/content/entity/DemonEntity;", "cooldownMin", "", "cooldownMax", "breathDuration", "range", "", "coneAngle", "<init>", "(Ldev/sterner/witchery/content/entity/DemonEntity;IIIDD)V", "breathingTicks", "cooldownTicks", "canUse", "", "canContinueToUse", "start", "", "stop", "tick", "spawnFireBreath", "target", "Lnet/minecraft/world/entity/LivingEntity;", "isInFireCone", "entity", "eyePos", "Lnet/minecraft/world/phys/Vec3;", "lookVec", "witchery"})
public final class DemonFireBreathGoal
extends Goal {
    @NotNull
    private final DemonEntity demon;
    private final int cooldownMin;
    private final int cooldownMax;
    private final int breathDuration;
    private final double range;
    private final double coneAngle;
    private int breathingTicks;
    private int cooldownTicks;

    public DemonFireBreathGoal(@NotNull DemonEntity demon, int cooldownMin, int cooldownMax, int breathDuration, double range, double coneAngle) {
        Intrinsics.checkNotNullParameter((Object)((Object)demon), (String)"demon");
        this.demon = demon;
        this.cooldownMin = cooldownMin;
        this.cooldownMax = cooldownMax;
        this.breathDuration = breathDuration;
        this.range = range;
        this.coneAngle = coneAngle;
        this.setFlags(EnumSet.of((Enum)Goal.Flag.MOVE, (Enum)Goal.Flag.LOOK));
    }

    public /* synthetic */ DemonFireBreathGoal(DemonEntity demonEntity, int n, int n2, int n3, double d, double d2, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 2) != 0) {
            n = 100;
        }
        if ((n4 & 4) != 0) {
            n2 = 140;
        }
        if ((n4 & 8) != 0) {
            n3 = 40;
        }
        if ((n4 & 0x10) != 0) {
            d = 8.0;
        }
        if ((n4 & 0x20) != 0) {
            d2 = 30.0;
        }
        this(demonEntity, n, n2, n3, d, d2);
    }

    public boolean canUse() {
        LivingEntity livingEntity = this.demon.getTarget();
        if (livingEntity == null) {
            return false;
        }
        LivingEntity target = livingEntity;
        if (this.cooldownTicks > 0) {
            return false;
        }
        if (!this.demon.hasLineOfSight((Entity)target)) {
            return false;
        }
        return !(this.demon.distanceToSqr((Entity)target) > this.range * this.range);
    }

    public boolean canContinueToUse() {
        return this.breathingTicks > 0;
    }

    public void start() {
        this.breathingTicks = this.breathDuration;
        this.demon.setBreathing(true);
        this.demon.getNavigation().stop();
    }

    public void stop() {
        this.breathingTicks = 0;
        this.cooldownTicks = this.demon.getRandom().nextInt(this.cooldownMin, this.cooldownMax);
        this.demon.setBreathing(false);
    }

    public void tick() {
        LivingEntity livingEntity = this.demon.getTarget();
        if (livingEntity == null) {
            return;
        }
        LivingEntity target = livingEntity;
        if (this.cooldownTicks > 0) {
            int n = this.cooldownTicks;
            this.cooldownTicks = n + -1;
            return;
        }
        if (this.breathingTicks > 0) {
            int n = this.breathingTicks;
            this.breathingTicks = n + -1;
            this.demon.getLookControl().setLookAt((Entity)target, 30.0f, 30.0f);
            if (this.breathingTicks % 2 == 0) {
                this.spawnFireBreath(target);
            }
            if (this.breathingTicks % 10 == 0) {
                this.demon.level().playSound(null, this.demon.blockPosition(), SoundEvents.BLAZE_SHOOT, SoundSource.HOSTILE, 1.0f, 0.8f + this.demon.getRandom().nextFloat() * 0.4f);
            }
        }
    }

    private final void spawnFireBreath(LivingEntity target) {
        Level level = this.demon.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        Vec3 eyePos = this.demon.getEyePosition(1.0f);
        Vec3 lookVec = this.demon.getLookAngle();
        int particleCount = this.demon.isEnraged() ? 45 : 30;
        for (int i = 0; i < particleCount; ++i) {
            double distance = this.demon.getRandom().nextDouble() * this.range;
            double spreadAngle = Math.toRadians(this.coneAngle);
            double yaw = (this.demon.getRandom().nextDouble() - 0.5) * spreadAngle;
            double pitch = (this.demon.getRandom().nextDouble() - 0.5) * spreadAngle;
            Vec3 particleVec = lookVec.yRot((float)yaw).xRot((float)pitch);
            Vec3 particlePos = eyePos.add(particleVec.scale(distance));
            ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.FLAME, particlePos.x, particlePos.y, particlePos.z, 1, 0.05, 0.05, 0.05, 0.02);
            if (!(this.demon.getRandom().nextFloat() < 0.3f)) continue;
            ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.LARGE_SMOKE, particlePos.x, particlePos.y, particlePos.z, 1, 0.1, 0.1, 0.1, 0.01);
        }
        List nearbyEntities = ((ServerLevel)level).getEntitiesOfClass(LivingEntity.class, this.demon.getBoundingBox().inflate(this.range), arg_0 -> DemonFireBreathGoal.spawnFireBreath$lambda$1(arg_0 -> DemonFireBreathGoal.spawnFireBreath$lambda$0(this, arg_0), arg_0));
        for (LivingEntity entity : nearbyEntities) {
            Intrinsics.checkNotNull((Object)entity);
            Intrinsics.checkNotNull((Object)eyePos);
            Intrinsics.checkNotNull((Object)lookVec);
            if (!this.isInFireCone(entity, eyePos, lookVec)) continue;
            float damage = this.demon.isEnraged() ? 3.5f : 2.5f;
            entity.hurt(this.demon.damageSources().mobAttack((LivingEntity)this.demon), damage);
            int fireDuration = this.demon.isEnraged() ? 8 : 5;
            entity.igniteForSeconds((float)fireDuration);
            double knockbackStrength = 0.3;
            Vec3 knockbackVec = entity.position().subtract(this.demon.position()).normalize();
            entity.setDeltaMovement(entity.getDeltaMovement().add(knockbackVec.x * knockbackStrength, 0.1, knockbackVec.z * knockbackStrength));
            entity.hurtMarked = true;
        }
    }

    private final boolean isInFireCone(LivingEntity entity, Vec3 eyePos, Vec3 lookVec) {
        double angleThreshold;
        Vec3 toEntity = entity.position().add(0.0, (double)entity.getBbHeight() / 2.0, 0.0).subtract(eyePos);
        double distance = toEntity.length();
        if (distance > this.range) {
            return false;
        }
        Vec3 toEntityNorm = toEntity.normalize();
        double dot = lookVec.dot(toEntityNorm);
        return dot >= (angleThreshold = Math.cos(Math.toRadians(this.coneAngle)));
    }

    private static final boolean spawnFireBreath$lambda$0(DemonFireBreathGoal this$0, LivingEntity it) {
        return !Intrinsics.areEqual((Object)it, (Object)((Object)this$0.demon)) && it.isAlive();
    }

    private static final boolean spawnFireBreath$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

