/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.entity.goal;

import dev.sterner.witchery.content.entity.ImpEntity;
import java.util.EnumSet;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Ldev/sterner/witchery/content/entity/goal/TradeWithPlayerGoal;", "Lnet/minecraft/world/entity/ai/goal/Goal;", "mob", "Ldev/sterner/witchery/content/entity/ImpEntity;", "<init>", "(Ldev/sterner/witchery/content/entity/ImpEntity;)V", "canUse", "", "start", "", "stop", "witchery"})
public final class TradeWithPlayerGoal
extends Goal {
    @NotNull
    private final ImpEntity mob;

    public TradeWithPlayerGoal(@NotNull ImpEntity mob) {
        Intrinsics.checkNotNullParameter((Object)((Object)mob), (String)"mob");
        this.mob = mob;
        this.setFlags(EnumSet.of((Enum)Goal.Flag.JUMP, (Enum)Goal.Flag.MOVE));
    }

    public boolean canUse() {
        if (!this.mob.isAlive()) {
            return false;
        }
        if (this.mob.isInWater()) {
            return false;
        }
        if (this.mob.hurtMarked) {
            return false;
        }
        Player player = this.mob.getTradingPlayer();
        if (player == null) {
            return false;
        }
        return this.mob.distanceToSqr((Entity)player) > 16.0 ? false : player.containerMenu != null;
    }

    public void start() {
        this.mob.getNavigation().stop();
    }

    public void stop() {
        this.mob.setTradingPlayer(null);
    }
}

