/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.entity.move_control;

import dev.sterner.witchery.content.entity.AbstractSpectralEntity;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007H\u0002J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Ldev/sterner/witchery/content/entity/move_control/GhostMoveControl;", "Lnet/minecraft/world/entity/ai/control/MoveControl;", "ghost", "Ldev/sterner/witchery/content/entity/AbstractSpectralEntity;", "<init>", "(Ldev/sterner/witchery/content/entity/AbstractSpectralEntity;)V", "floatDuration", "", "tick", "", "canReach", "", "pos", "Lnet/minecraft/world/phys/Vec3;", "length", "rotateTowards", "", "currentYaw", "targetYaw", "maxTurn", "witchery"})
public final class GhostMoveControl
extends MoveControl {
    @NotNull
    private final AbstractSpectralEntity ghost;
    private int floatDuration;

    public GhostMoveControl(@NotNull AbstractSpectralEntity ghost) {
        Intrinsics.checkNotNullParameter((Object)((Object)ghost), (String)"ghost");
        super((Mob)ghost);
        this.ghost = ghost;
    }

    public void tick() {
        if (this.operation == MoveControl.Operation.MOVE_TO) {
            int n = this.floatDuration;
            this.floatDuration = n + -1;
            if (n <= 0) {
                this.floatDuration = this.floatDuration + this.ghost.getRandom().nextInt(5) + 2;
                Vec3 vec3 = new Vec3(this.wantedX - this.ghost.getX(), this.wantedY - this.ghost.getY(), this.wantedZ - this.ghost.getZ());
                double d = vec3.length();
                Vec3 vec32 = vec3.normalize();
                Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"normalize(...)");
                vec3 = vec32;
                if (this.canReach(vec3, Mth.ceil((double)d))) {
                    this.ghost.setDeltaMovement(this.ghost.getDeltaMovement().add(vec3.scale(0.1)));
                } else {
                    this.operation = MoveControl.Operation.WAIT;
                }
                if (d > 0.1) {
                    float targetYaw = (float)(Mth.atan2((double)vec3.z, (double)vec3.x) * 57.29577951308232) - 90.0f;
                    this.ghost.setYRot(this.rotateTowards(this.ghost.getYRot(), targetYaw, 25.0f));
                }
            }
        }
    }

    private final boolean canReach(Vec3 pos, int length) {
        AABB aABB = this.ghost.getBoundingBox();
        for (int i = 1; i < length; ++i) {
            aABB = aABB.move(pos);
            if (this.ghost.level().noCollision((Entity)this.ghost, aABB)) continue;
            return false;
        }
        return true;
    }

    private final float rotateTowards(float currentYaw, float targetYaw, float maxTurn) {
        float deltaYaw = Mth.wrapDegrees((float)(targetYaw - currentYaw));
        return currentYaw + Mth.clamp((float)deltaYaw, (float)(-maxTurn), (float)maxTurn);
    }
}

