/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.item;

import dev.sterner.witchery.content.entity.CovenWitchEntity;
import dev.sterner.witchery.core.registry.WitcheryDataComponents;
import dev.sterner.witchery.features.coven.CovenDialogue;
import dev.sterner.witchery.features.coven.CovenHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J(\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u0012H\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u000e\u001a\u00020\rH\u0016J&\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\r0 2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J.\u0010!\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\"\u001a\u00020#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%2\u0006\u0010'\u001a\u00020(H\u0016\u00a8\u0006)"}, d2={"Ldev/sterner/witchery/content/item/CovenContractItem;", "Lnet/minecraft/world/item/Item;", "properties", "Lnet/minecraft/world/item/Item$Properties;", "<init>", "(Lnet/minecraft/world/item/Item$Properties;)V", "onDestroyed", "", "itemEntity", "Lnet/minecraft/world/entity/item/ItemEntity;", "damageSource", "Lnet/minecraft/world/damagesource/DamageSource;", "finishUsingItem", "Lnet/minecraft/world/item/ItemStack;", "stack", "level", "Lnet/minecraft/world/level/Level;", "livingEntity", "Lnet/minecraft/world/entity/LivingEntity;", "interactLivingEntity", "Lnet/minecraft/world/InteractionResult;", "player", "Lnet/minecraft/world/entity/player/Player;", "interactionTarget", "usedHand", "Lnet/minecraft/world/InteractionHand;", "getUseDuration", "", "entity", "getUseAnimation", "Lnet/minecraft/world/item/UseAnim;", "use", "Lnet/minecraft/world/InteractionResultHolder;", "appendHoverText", "context", "Lnet/minecraft/world/item/Item$TooltipContext;", "tooltip", "", "Lnet/minecraft/network/chat/Component;", "flag", "Lnet/minecraft/world/item/TooltipFlag;", "witchery"})
@SourceDebugExtension(value={"SMAP\nCovenContractItem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CovenContractItem.kt\ndev/sterner/witchery/content/item/CovenContractItem\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,176:1\n1761#2,3:177\n1869#2,2:180\n*S KotlinDebug\n*F\n+ 1 CovenContractItem.kt\ndev/sterner/witchery/content/item/CovenContractItem\n*L\n45#1:177,3\n168#1:180,2\n*E\n"})
public final class CovenContractItem
extends Item {
    public CovenContractItem(@NotNull Item.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
    }

    public void onDestroyed(@NotNull ItemEntity itemEntity, @NotNull DamageSource damageSource) {
        Intrinsics.checkNotNullParameter((Object)itemEntity, (String)"itemEntity");
        Intrinsics.checkNotNullParameter((Object)damageSource, (String)"damageSource");
        if (itemEntity.level() instanceof ServerLevel) {
            ItemStack stack = itemEntity.getItem();
            Level level = itemEntity.level();
            Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
            ServerLevel serverLevel = (ServerLevel)level;
            Intrinsics.checkNotNull((Object)stack);
            CovenHandler.INSTANCE.disbandCovenFromContract(serverLevel, stack);
        }
        super.onDestroyed(itemEntity, damageSource);
    }

    @NotNull
    public ItemStack finishUsingItem(@NotNull ItemStack stack, @NotNull Level level, @NotNull LivingEntity livingEntity) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)livingEntity, (String)"livingEntity");
        super.finishUsingItem(stack, level, livingEntity);
        if (!level.isClientSide && livingEntity instanceof ServerPlayer) {
            List<Pair> list;
            DataComponentType componentType = (DataComponentType)WitcheryDataComponents.INSTANCE.getPLAYER_UUID_ORDERED_LIST().get();
            List list2 = (LinkedList)stack.get(componentType);
            if (list2 == null || (list2 = CollectionsKt.toMutableList((Collection)list2)) == null) {
                list2 = new ArrayList();
            }
            if ((list = list2).size() < 8) {
                boolean bl;
                block11: {
                    Iterable $this$any$iv = list;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            Pair it = (Pair)element$iv;
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual((Object)it.getFirst(), (Object)((ServerPlayer)livingEntity).getUUID())) continue;
                            bl = true;
                            break block11;
                        }
                        bl = false;
                    }
                }
                if (!bl) {
                    list.add(new Pair((Object)((ServerPlayer)livingEntity).getUUID(), (Object)((ServerPlayer)livingEntity).getName().getString()));
                    stack.set(componentType, new LinkedList(list));
                    ((ServerPlayer)livingEntity).displayClientMessage((Component)Component.translatable((String)"witchery.coven.contract_signed"), false);
                }
            }
            if (list.size() > 1) {
                ServerPlayer leader;
                MinecraftServer minecraftServer = level.getServer();
                ServerPlayer serverPlayer = minecraftServer != null && (minecraftServer = minecraftServer.getPlayerList()) != null ? minecraftServer.getPlayer((UUID)((Pair)CollectionsKt.first(list)).getFirst()) : (leader = null);
                if (leader != null && Intrinsics.areEqual(leader, (Object)livingEntity)) {
                    int successCount = 0;
                    for (Pair memberEntry : CollectionsKt.drop((Iterable)list, (int)1)) {
                        MinecraftServer minecraftServer2 = level.getServer();
                        ServerPlayer memberPlayer = minecraftServer2 != null && (minecraftServer2 = minecraftServer2.getPlayerList()) != null ? minecraftServer2.getPlayer((UUID)memberEntry.getFirst()) : null;
                        if (memberPlayer == null || !CovenHandler.INSTANCE.addPlayerToCoven(leader, memberPlayer)) continue;
                        ++successCount;
                    }
                    if (successCount > 0) {
                        Iterator<Object> iterator = new Object[]{successCount};
                        leader.displayClientMessage((Component)Component.translatable((String)"witchery.coven.bound_members", iterator), false);
                        level.playSound(null, leader.blockPosition(), SoundEvents.ENCHANTMENT_TABLE_USE, SoundSource.PLAYERS, 1.0f, 1.0f);
                    }
                }
            }
        }
        return stack;
    }

    @NotNull
    public InteractionResult interactLivingEntity(@NotNull ItemStack stack, @NotNull Player player, @NotNull LivingEntity interactionTarget, @NotNull InteractionHand usedHand) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)interactionTarget, (String)"interactionTarget");
        Intrinsics.checkNotNullParameter((Object)usedHand, (String)"usedHand");
        if (interactionTarget instanceof CovenWitchEntity && player instanceof ServerPlayer) {
            Component witchName;
            Component component = ((CovenWitchEntity)interactionTarget).getCustomName();
            if (component == null) {
                RandomSource randomSource = ((CovenWitchEntity)interactionTarget).getRandom();
                Intrinsics.checkNotNullExpressionValue((Object)randomSource, (String)"getRandom(...)");
                component = witchName = (Component)CovenDialogue.INSTANCE.generateName(randomSource);
            }
            if (((CovenWitchEntity)interactionTarget).getIsCoven()) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                RandomSource randomSource = ((CovenWitchEntity)interactionTarget).getRandom();
                Intrinsics.checkNotNullExpressionValue((Object)randomSource, (String)"getRandom(...)");
                serverPlayer.sendSystemMessage((Component)CovenDialogue.INSTANCE.getAlreadyBoundResponse(witchName, randomSource).withStyle(ChatFormatting.GOLD));
                return InteractionResult.FAIL;
            }
            if (CovenHandler.INSTANCE.addWitchToCoven((ServerPlayer)player, (CovenWitchEntity)interactionTarget)) {
                DataComponentType componentType = (DataComponentType)WitcheryDataComponents.INSTANCE.getPLAYER_UUID_ORDERED_LIST().get();
                List list = (LinkedList)stack.get(componentType);
                if (list == null || (list = CollectionsKt.toMutableList((Collection)list)) == null) {
                    list = new ArrayList();
                }
                List<Pair> list2 = list;
                UUID uUID = ((CovenWitchEntity)interactionTarget).getUUID();
                Component component2 = ((CovenWitchEntity)interactionTarget).getCustomName();
                Intrinsics.checkNotNull((Object)component2);
                list2.add(new Pair((Object)uUID, (Object)component2.getString()));
                stack.set(componentType, new LinkedList(list2));
                player.setItemInHand(usedHand, stack.copy());
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }

    public int getUseDuration(@NotNull ItemStack stack, @NotNull LivingEntity entity) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return 40;
    }

    @NotNull
    public UseAnim getUseAnimation(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return UseAnim.BOW;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand usedHand) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)usedHand, (String)"usedHand");
        InteractionResultHolder interactionResultHolder = ItemUtils.startUsingInstantly((Level)level, (Player)player, (InteractionHand)usedHand);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"startUsingInstantly(...)");
        return interactionResultHolder;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        List members;
        List list;
        ChatFormatting[] chatFormattingArray;
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(tooltip, (String)"tooltip");
        Intrinsics.checkNotNullParameter((Object)flag, (String)"flag");
        super.appendHoverText(stack, context, tooltip, flag);
        DataComponentType componentType = (DataComponentType)WitcheryDataComponents.INSTANCE.getPLAYER_UUID_ORDERED_LIST().get();
        LinkedList list2 = (LinkedList)stack.get(componentType);
        Collection collection = list2;
        if (!(collection == null || collection.isEmpty())) {
            Pair leader = (Pair)CollectionsKt.first((List)list2);
            chatFormattingArray = new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.BOLD};
            MutableComponent mutableComponent = Component.literal((String)"Contract Holder:").withStyle(chatFormattingArray);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"withStyle(...)");
            tooltip.add((Component)mutableComponent);
            MutableComponent mutableComponent2 = Component.literal((String)(" - " + leader.getSecond())).withStyle(ChatFormatting.BLUE);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent2, (String)"withStyle(...)");
            tooltip.add((Component)mutableComponent2);
        }
        if ((list = list2) == null || (list = CollectionsKt.drop((Iterable)list, (int)1)) == null) {
            list = CollectionsKt.emptyList();
        }
        if (!((Collection)(members = list)).isEmpty()) {
            chatFormattingArray = new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.BOLD};
            MutableComponent mutableComponent = Component.literal((String)"Contract Members:").withStyle(chatFormattingArray);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"withStyle(...)");
            tooltip.add((Component)mutableComponent);
            Iterable $this$forEach$iv = members;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Pair pair = (Pair)element$iv;
                boolean bl = false;
                String name = (String)pair.component2();
                MutableComponent mutableComponent3 = Component.literal((String)(" - " + name)).withStyle(ChatFormatting.AQUA);
                Intrinsics.checkNotNullExpressionValue((Object)mutableComponent3, (String)"withStyle(...)");
                tooltip.add((Component)mutableComponent3);
            }
        }
    }
}

