/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.item;

import dev.sterner.witchery.core.registry.WitcheryBlocks;
import dev.sterner.witchery.features.lifeblood.LifebloodHandler;
import dev.sterner.witchery.features.lifeblood.LifebloodPlayerAttachment;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J.\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0016\u00a8\u0006\u0016"}, d2={"Ldev/sterner/witchery/content/item/LifebloodBerryItem;", "Lnet/minecraft/world/item/ItemNameBlockItem;", "properties", "Lnet/minecraft/world/item/Item$Properties;", "<init>", "(Lnet/minecraft/world/item/Item$Properties;)V", "finishUsingItem", "Lnet/minecraft/world/item/ItemStack;", "stack", "level", "Lnet/minecraft/world/level/Level;", "livingEntity", "Lnet/minecraft/world/entity/LivingEntity;", "appendHoverText", "", "context", "Lnet/minecraft/world/item/Item$TooltipContext;", "tooltipComponents", "", "Lnet/minecraft/network/chat/Component;", "tooltipFlag", "Lnet/minecraft/world/item/TooltipFlag;", "witchery"})
public final class LifebloodBerryItem
extends ItemNameBlockItem {
    public LifebloodBerryItem(@NotNull Item.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super((Block)WitcheryBlocks.INSTANCE.getLIFE_BLOOD().get(), properties);
    }

    @NotNull
    public ItemStack finishUsingItem(@NotNull ItemStack stack, @NotNull Level level, @NotNull LivingEntity livingEntity) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)livingEntity, (String)"livingEntity");
        if (!level.isClientSide) {
            livingEntity.heal(2.0f);
            livingEntity.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 40, 0));
            if (livingEntity instanceof Player && LifebloodPlayerAttachment.getData((Player)livingEntity).getLifebloodPoints() <= 5) {
                LifebloodHandler.INSTANCE.addLifeblood((Player)livingEntity, 1);
                if (!((Player)livingEntity).getAbilities().instabuild) {
                    stack.shrink(1);
                }
            }
        }
        ItemStack itemStack = super.finishUsingItem(stack, level, livingEntity);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"finishUsingItem(...)");
        return itemStack;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(tooltipComponents, (String)"tooltipComponents");
        Intrinsics.checkNotNullParameter((Object)tooltipFlag, (String)"tooltipFlag");
        MutableComponent mutableComponent = Component.translatable((String)"item.witchery.lifeblood_berry.tooltip").withStyle(LifebloodBerryItem::appendHoverText$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"withStyle(...)");
        tooltipComponents.add((Component)mutableComponent);
        MutableComponent mutableComponent2 = Component.translatable((String)"item.witchery.lifeblood_berry.tooltip2").withStyle(LifebloodBerryItem::appendHoverText$lambda$1);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent2, (String)"withStyle(...)");
        tooltipComponents.add((Component)mutableComponent2);
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    private static final Style appendHoverText$lambda$0(Style it) {
        return it.withColor(0x6BB6FF);
    }

    private static final Style appendHoverText$lambda$1(Style it) {
        return it.withColor(5087231);
    }
}

