/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.item.brew;

import dev.sterner.witchery.content.block.spirit_portal.SpiritPortalBlock;
import dev.sterner.witchery.content.item.brew.ThrowableBrewItem;
import dev.sterner.witchery.core.api.WitcheryApi;
import dev.sterner.witchery.core.api.multiblock.MultiBlockComponentBlockEntity;
import dev.sterner.witchery.core.registry.WitcheryBlocks;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J \u0010\u0014\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J \u0010\u0019\u001a\u00020\u00182\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006\u001c"}, d2={"Ldev/sterner/witchery/content/item/brew/BrewOfFlowingSpiritItem;", "Ldev/sterner/witchery/content/item/brew/ThrowableBrewItem;", "color", "", "properties", "Lnet/minecraft/world/item/Item$Properties;", "<init>", "(ILnet/minecraft/world/item/Item$Properties;)V", "useOn", "Lnet/minecraft/world/InteractionResult;", "context", "Lnet/minecraft/world/item/context/UseOnContext;", "makePortal", "", "level", "Lnet/minecraft/world/level/Level;", "pos", "Lnet/minecraft/core/BlockPos;", "direction", "Lnet/minecraft/core/Direction;", "applyEffectOnBlock", "blockHit", "Lnet/minecraft/world/phys/BlockHitResult;", "hasFrog", "", "lookForDoors", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "witchery"})
public final class BrewOfFlowingSpiritItem
extends ThrowableBrewItem {
    public BrewOfFlowingSpiritItem(int color, @NotNull Item.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(color, properties, null, 4, null);
    }

    @Override
    @NotNull
    public InteractionResult useOn(@NotNull UseOnContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Level level = context.getLevel();
        BlockPos clickedPos = context.getClickedPos();
        BlockState state = level.getBlockState(clickedPos);
        Intrinsics.checkNotNull((Object)level);
        Intrinsics.checkNotNull((Object)state);
        Intrinsics.checkNotNull((Object)clickedPos);
        if (this.lookForDoors(level, state, clickedPos)) {
            return InteractionResult.SUCCESS;
        }
        return super.useOn(context);
    }

    private final void makePortal(Level level, BlockPos pos, Direction direction) {
        SpiritPortalBlock.Companion.getSTRUCTURE().get().placeNoContext(level, pos, direction);
        level.setBlockAndUpdate(pos, (BlockState)((SpiritPortalBlock)((Object)WitcheryBlocks.INSTANCE.getSPIRIT_PORTAL().get())).defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)direction.getOpposite()));
        if (level.getBlockEntity(pos) instanceof MultiBlockComponentBlockEntity) {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            Intrinsics.checkNotNull((Object)blockEntity, (String)"null cannot be cast to non-null type dev.sterner.witchery.core.api.multiblock.MultiBlockComponentBlockEntity");
            ((MultiBlockComponentBlockEntity)blockEntity).setCorePos(pos);
        }
    }

    @Override
    public void applyEffectOnBlock(@NotNull Level level, @NotNull BlockHitResult blockHit, boolean hasFrog) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)blockHit, (String)"blockHit");
        BlockPos pos = blockHit.getBlockPos();
        int n = pos.getX() + 1;
        for (int x = pos.getX() - 1; x < n; ++x) {
            int n2 = pos.getZ() + 1;
            for (int z = pos.getZ() - 1; z < n2; ++z) {
                BlockState state = level.getBlockState(new BlockPos(x, pos.getY(), z));
                if (!(state.getBlock() instanceof DoorBlock) || !state.hasProperty((Property)BlockStateProperties.DOUBLE_BLOCK_HALF)) continue;
                Intrinsics.checkNotNull((Object)state);
                if (!this.lookForDoors(level, state, new BlockPos(x, pos.getY(), z))) continue;
                return;
            }
        }
        if (level.getBlockState(pos).canBeReplaced()) {
            v0 = level.setBlockAndUpdate(pos, ((Block)WitcheryBlocks.INSTANCE.getFLOWING_SPIRIT_BLOCK().get()).defaultBlockState());
        } else {
            pos = pos.relative(blockHit.getDirection());
            v0 = level.setBlockAndUpdate(pos, ((Block)WitcheryBlocks.INSTANCE.getFLOWING_SPIRIT_BLOCK().get()).defaultBlockState());
        }
    }

    private final boolean lookForDoors(Level level, BlockState state, BlockPos pos) {
        if (!WitcheryApi.INSTANCE.isInSpiritWorld(level)) {
            return false;
        }
        if (state.getBlock() instanceof DoorBlock && state.hasProperty((Property)BlockStateProperties.DOUBLE_BLOCK_HALF)) {
            BlockPos belowPops;
            DoubleBlockHalf half = (DoubleBlockHalf)state.getValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF);
            Direction direction = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
            BlockPos blockPos = belowPops = half == DoubleBlockHalf.UPPER ? pos.below() : pos;
            if (level.getBlockState(belowPops.east()).getBlock() instanceof DoorBlock) {
                Direction direction2 = direction;
                switch (direction2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[direction2.ordinal()]) {
                    case 1: {
                        Intrinsics.checkNotNull((Object)belowPops);
                        Direction direction3 = direction.getOpposite();
                        Intrinsics.checkNotNullExpressionValue((Object)direction3, (String)"getOpposite(...)");
                        this.makePortal(level, belowPops, direction3);
                        break;
                    }
                    case 2: {
                        BlockPos blockPos2 = belowPops.east();
                        Intrinsics.checkNotNullExpressionValue((Object)blockPos2, (String)"east(...)");
                        Direction direction4 = direction.getOpposite();
                        Intrinsics.checkNotNullExpressionValue((Object)direction4, (String)"getOpposite(...)");
                        this.makePortal(level, blockPos2, direction4);
                        break;
                    }
                    default: {
                        Intrinsics.checkNotNull((Object)belowPops);
                        Intrinsics.checkNotNull((Object)direction);
                        this.makePortal(level, belowPops, direction);
                    }
                }
                return true;
            }
            if (level.getBlockState(belowPops.west()).getBlock() instanceof DoorBlock) {
                Direction direction5 = direction;
                switch (direction5 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[direction5.ordinal()]) {
                    case 1: {
                        BlockPos blockPos3 = belowPops.west();
                        Intrinsics.checkNotNullExpressionValue((Object)blockPos3, (String)"west(...)");
                        Direction direction6 = direction.getOpposite();
                        Intrinsics.checkNotNullExpressionValue((Object)direction6, (String)"getOpposite(...)");
                        this.makePortal(level, blockPos3, direction6);
                        break;
                    }
                    case 2: {
                        Intrinsics.checkNotNull((Object)belowPops);
                        Direction direction7 = direction.getOpposite();
                        Intrinsics.checkNotNullExpressionValue((Object)direction7, (String)"getOpposite(...)");
                        this.makePortal(level, belowPops, direction7);
                        break;
                    }
                    default: {
                        Intrinsics.checkNotNull((Object)belowPops);
                        Intrinsics.checkNotNull((Object)direction);
                        this.makePortal(level, belowPops, direction);
                    }
                }
                return true;
            }
            if (level.getBlockState(belowPops.north()).getBlock() instanceof DoorBlock) {
                Direction direction8 = direction;
                switch (direction8 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[direction8.ordinal()]) {
                    case 3: {
                        BlockPos blockPos4 = belowPops.north();
                        Intrinsics.checkNotNullExpressionValue((Object)blockPos4, (String)"north(...)");
                        Direction direction9 = direction.getOpposite();
                        Intrinsics.checkNotNullExpressionValue((Object)direction9, (String)"getOpposite(...)");
                        this.makePortal(level, blockPos4, direction9);
                        break;
                    }
                    case 4: {
                        Intrinsics.checkNotNull((Object)belowPops);
                        Direction direction10 = direction.getOpposite();
                        Intrinsics.checkNotNullExpressionValue((Object)direction10, (String)"getOpposite(...)");
                        this.makePortal(level, belowPops, direction10);
                        break;
                    }
                    default: {
                        Intrinsics.checkNotNull((Object)belowPops);
                        Intrinsics.checkNotNull((Object)direction);
                        this.makePortal(level, belowPops, direction);
                    }
                }
                return true;
            }
            if (level.getBlockState(belowPops.south()).getBlock() instanceof DoorBlock) {
                Direction direction11 = direction;
                switch (direction11 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[direction11.ordinal()]) {
                    case 3: {
                        Intrinsics.checkNotNull((Object)belowPops);
                        Direction direction12 = direction.getOpposite();
                        Intrinsics.checkNotNullExpressionValue((Object)direction12, (String)"getOpposite(...)");
                        this.makePortal(level, belowPops, direction12);
                        break;
                    }
                    case 4: {
                        BlockPos blockPos5 = belowPops.south();
                        Intrinsics.checkNotNullExpressionValue((Object)blockPos5, (String)"south(...)");
                        Direction direction13 = direction.getOpposite();
                        Intrinsics.checkNotNullExpressionValue((Object)direction13, (String)"getOpposite(...)");
                        this.makePortal(level, blockPos5, direction13);
                        break;
                    }
                    default: {
                        Intrinsics.checkNotNull((Object)belowPops);
                        Intrinsics.checkNotNull((Object)direction);
                        this.makePortal(level, belowPops, direction);
                    }
                }
                return true;
            }
        }
        return false;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Direction.values().length];
            try {
                nArray[Direction.NORTH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.SOUTH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.EAST.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.WEST.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

