/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.core.api;

import dev.sterner.witchery.content.block.effigy.EffigyBlockEntity;
import dev.sterner.witchery.content.block.effigy.EffigyState;
import dev.sterner.witchery.content.item.TaglockItem;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\b\u0016\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005JB\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\b\b\u0002\u0010\u0016\u001a\u00020\u0003H\u0016J.\u0010\u0017\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002J.\u0010\u0019\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0016J.\u0010\u001d\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002J(\u0010\u001e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u001cH\u0016J.\u0010 \u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002J.\u0010!\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\"0\u001bH\u0016J.\u0010#\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002J(\u0010$\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010%\u001a\u00020\"H\u0016J.\u0010&\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002J \u0010'\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J.\u0010(\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\"0\u001bH\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005\u00a8\u0006*"}, d2={"Ldev/sterner/witchery/core/api/FetishEffect;", "", "rangeMod", "", "<init>", "(I)V", "getRangeMod", "()I", "setRangeMod", "onTickEffect", "", "level", "Lnet/minecraft/world/level/Level;", "blockEntity", "Ldev/sterner/witchery/content/block/effigy/EffigyBlockEntity;", "state", "Ldev/sterner/witchery/content/block/effigy/EffigyState;", "pos", "Lnet/minecraft/core/BlockPos;", "taglock", "Lnet/minecraft/core/NonNullList;", "Lnet/minecraft/world/item/ItemStack;", "tickRate", "checkUnknownPlayerNearby", "taglocks", "onUnknownPlayerNearbyTick", "nearby", "", "Lnet/minecraft/world/entity/player/Player;", "checkKnownPlayerNearby", "onKnownPlayerNearbyTick", "taggedPlayer", "checkUnknownEntityNearby", "onUnknownEntityTick", "Lnet/minecraft/world/entity/LivingEntity;", "checkAnyKnownEntityNearby", "onKnownEntityTick", "known", "checkAllKnownEntitiesAway", "onKnownEntityAwayTick", "all", "list", "witchery"})
public class FetishEffect {
    private int rangeMod;

    public FetishEffect(int rangeMod) {
        this.rangeMod = rangeMod;
    }

    public /* synthetic */ FetishEffect(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 1;
        }
        this(n);
    }

    public final int getRangeMod() {
        return this.rangeMod;
    }

    public final void setRangeMod(int n) {
        this.rangeMod = n;
    }

    public void onTickEffect(@NotNull Level level, @NotNull EffigyBlockEntity blockEntity, @Nullable EffigyState state, @NotNull BlockPos pos, @NotNull NonNullList<ItemStack> taglock, int tickRate) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)blockEntity, (String)"blockEntity");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter(taglock, (String)"taglock");
        if (level.getGameTime() % (long)tickRate == 0L) {
            EffigyState effigyState = state;
            switch (effigyState == null ? -1 : WhenMappings.$EnumSwitchMapping$0[effigyState.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    this.checkUnknownPlayerNearby(level, blockEntity, pos, taglock);
                    break;
                }
                case 3: {
                    this.checkKnownPlayerNearby(level, blockEntity, pos, taglock);
                    break;
                }
                case 4: {
                    this.checkUnknownEntityNearby(level, blockEntity, pos, taglock);
                    break;
                }
                case 5: {
                    this.checkAnyKnownEntityNearby(level, blockEntity, pos, taglock);
                    break;
                }
                case 6: {
                    this.checkAllKnownEntitiesAway(level, blockEntity, pos, taglock);
                    break;
                }
                case -1: {
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
    }

    public static /* synthetic */ void onTickEffect$default(FetishEffect fetishEffect, Level level, EffigyBlockEntity effigyBlockEntity, EffigyState effigyState, BlockPos blockPos, NonNullList nonNullList, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: onTickEffect");
        }
        if ((n2 & 0x20) != 0) {
            n = 20;
        }
        fetishEffect.onTickEffect(level, effigyBlockEntity, effigyState, blockPos, (NonNullList<ItemStack>)nonNullList, n);
    }

    private final void checkUnknownPlayerNearby(Level level, EffigyBlockEntity blockEntity, BlockPos pos, NonNullList<ItemStack> taglocks) {
        Iterator iterator = taglocks.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            ItemStack taglock = (ItemStack)iterator2.next();
            Intrinsics.checkNotNull((Object)taglock);
            Player taggedPlayer = TaglockItem.Companion.getPlayer(level, taglock);
            List nearby = level.getEntitiesOfClass(Player.class, AABB.ofSize((Vec3)pos.getCenter(), (double)(16.0 * (double)this.rangeMod), (double)(8.0 * (double)this.rangeMod), (double)(16.0 * (double)this.rangeMod)), arg_0 -> FetishEffect.checkUnknownPlayerNearby$lambda$1(arg_0 -> FetishEffect.checkUnknownPlayerNearby$lambda$0(taggedPlayer, arg_0), arg_0));
            Intrinsics.checkNotNull((Object)nearby);
            if (!(!((Collection)nearby).isEmpty())) continue;
            this.onUnknownPlayerNearbyTick(level, blockEntity, pos, nearby);
        }
    }

    public void onUnknownPlayerNearbyTick(@NotNull Level level, @NotNull EffigyBlockEntity blockEntity, @NotNull BlockPos pos, @NotNull List<? extends Player> nearby) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)blockEntity, (String)"blockEntity");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter(nearby, (String)"nearby");
        this.all(level, blockEntity, pos, nearby);
    }

    private final void checkKnownPlayerNearby(Level level, EffigyBlockEntity blockEntity, BlockPos pos, NonNullList<ItemStack> taglocks) {
        Iterator iterator = taglocks.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            ItemStack taglock = (ItemStack)iterator2.next();
            Intrinsics.checkNotNull((Object)taglock);
            Player taggedPlayer = TaglockItem.Companion.getPlayer(level, taglock);
            if (taggedPlayer == null || !(taggedPlayer.distanceToSqr(pos.getCenter()) < 64.0 * (double)this.rangeMod)) continue;
            this.onKnownPlayerNearbyTick(level, blockEntity, pos, taggedPlayer);
        }
    }

    public void onKnownPlayerNearbyTick(@NotNull Level level, @NotNull EffigyBlockEntity blockEntity, @NotNull BlockPos pos, @NotNull Player taggedPlayer) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)blockEntity, (String)"blockEntity");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)taggedPlayer, (String)"taggedPlayer");
        this.all(level, blockEntity, pos, CollectionsKt.listOf((Object)taggedPlayer));
    }

    private final void checkUnknownEntityNearby(Level level, EffigyBlockEntity blockEntity, BlockPos pos, NonNullList<ItemStack> taglocks) {
        Iterator iterator = taglocks.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            ItemStack taglock = (ItemStack)iterator2.next();
            Intrinsics.checkNotNull((Object)taglock);
            LivingEntity taggedEntity = TaglockItem.Companion.getLivingEntity(level, taglock);
            List nearby = level.getEntitiesOfClass(LivingEntity.class, AABB.ofSize((Vec3)pos.getCenter(), (double)(16.0 * (double)this.rangeMod), (double)(8.0 * (double)this.rangeMod), (double)(16.0 * (double)this.rangeMod)), arg_0 -> FetishEffect.checkUnknownEntityNearby$lambda$1(arg_0 -> FetishEffect.checkUnknownEntityNearby$lambda$0(taggedEntity, arg_0), arg_0));
            Intrinsics.checkNotNull((Object)nearby);
            if (!(!((Collection)nearby).isEmpty())) continue;
            this.onUnknownEntityTick(level, blockEntity, pos, nearby);
        }
    }

    public void onUnknownEntityTick(@NotNull Level level, @NotNull EffigyBlockEntity blockEntity, @NotNull BlockPos pos, @NotNull List<? extends LivingEntity> nearby) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)blockEntity, (String)"blockEntity");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter(nearby, (String)"nearby");
        this.all(level, blockEntity, pos, nearby);
    }

    private final void checkAnyKnownEntityNearby(Level level, EffigyBlockEntity blockEntity, BlockPos pos, NonNullList<ItemStack> taglocks) {
        Iterator iterator = taglocks.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            ItemStack taglock = (ItemStack)iterator2.next();
            Intrinsics.checkNotNull((Object)taglock);
            LivingEntity known = TaglockItem.Companion.getLivingEntity(level, taglock);
            if (known == null || !(known.distanceToSqr(pos.getCenter()) < 64.0 * (double)this.rangeMod)) continue;
            this.onKnownEntityTick(level, blockEntity, pos, known);
        }
    }

    public void onKnownEntityTick(@NotNull Level level, @NotNull EffigyBlockEntity blockEntity, @NotNull BlockPos pos, @NotNull LivingEntity known) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)blockEntity, (String)"blockEntity");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)known, (String)"known");
        this.all(level, blockEntity, pos, CollectionsKt.listOf((Object)known));
    }

    private final void checkAllKnownEntitiesAway(Level level, EffigyBlockEntity blockEntity, BlockPos pos, NonNullList<ItemStack> taglocks) {
        Iterator iterator = taglocks.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            ItemStack taglock = (ItemStack)iterator2.next();
            Intrinsics.checkNotNull((Object)taglock);
            LivingEntity known = TaglockItem.Companion.getLivingEntity(level, taglock);
            if (known != null && !(known.distanceToSqr(pos.getCenter()) >= 64.0 * (double)this.rangeMod)) continue;
            this.onKnownEntityAwayTick(level, blockEntity, pos);
        }
    }

    public void onKnownEntityAwayTick(@NotNull Level level, @NotNull EffigyBlockEntity blockEntity, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)blockEntity, (String)"blockEntity");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        this.all(level, blockEntity, pos, CollectionsKt.emptyList());
    }

    public void all(@NotNull Level level, @NotNull EffigyBlockEntity blockEntity, @NotNull BlockPos pos, @NotNull List<? extends LivingEntity> list) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)blockEntity, (String)"blockEntity");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter(list, (String)"list");
    }

    private static final boolean checkUnknownPlayerNearby$lambda$0(Player $taggedPlayer, Player it) {
        return !Intrinsics.areEqual((Object)it, (Object)$taggedPlayer);
    }

    private static final boolean checkUnknownPlayerNearby$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean checkUnknownEntityNearby$lambda$0(LivingEntity $taggedEntity, LivingEntity it) {
        return !Intrinsics.areEqual((Object)it, (Object)$taggedEntity);
    }

    private static final boolean checkUnknownEntityNearby$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    public FetishEffect() {
        this(0, 1, null);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EffigyState.values().length];
            try {
                nArray[EffigyState.IDLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EffigyState.PLAYER_UNKNOWN_TAGLOCK_NEAR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EffigyState.PLAYER_KNOWN_TAGLOCK_NEAR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EffigyState.ENTITY_UNKNOWN_TAGLOCK_NEAR.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EffigyState.ANY_KNOWN_TAGLOCK_ENTITY_NEAR.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EffigyState.ALL_KNOWN_TAGLOCK_ENTITY_AWAY.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

