/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.core.registry;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.sterner.witchery.Witchery;
import dev.sterner.witchery.content.entity.player_shell.SoulShellPlayerEntity;
import dev.sterner.witchery.core.api.Curse;
import dev.sterner.witchery.core.api.InventorySlots;
import dev.sterner.witchery.core.commands.CurseArgumentType;
import dev.sterner.witchery.core.commands.InfusionArgumentType;
import dev.sterner.witchery.core.registry.WitcheryCurseRegistry;
import dev.sterner.witchery.core.registry.WitcheryTarotEffects;
import dev.sterner.witchery.core.util.WitcheryUtil;
import dev.sterner.witchery.features.affliction.AfflictionPlayerAttachment;
import dev.sterner.witchery.features.affliction.lich.LichdomLeveling;
import dev.sterner.witchery.features.affliction.lich.LichdomSpecificEventHandler;
import dev.sterner.witchery.features.affliction.vampire.VampireLeveling;
import dev.sterner.witchery.features.affliction.werewolf.WerewolfLeveling;
import dev.sterner.witchery.features.blood.BloodPoolLivingEntityAttachment;
import dev.sterner.witchery.features.coven.CovenHandler;
import dev.sterner.witchery.features.coven.CovenPlayerAttachment;
import dev.sterner.witchery.features.curse.CurseHandler;
import dev.sterner.witchery.features.curse.CursePlayerAttachment;
import dev.sterner.witchery.features.familiar.FamiliarHandler;
import dev.sterner.witchery.features.infusion.InfusionHandler;
import dev.sterner.witchery.features.infusion.InfusionPlayerAttachment;
import dev.sterner.witchery.features.infusion.InfusionType;
import dev.sterner.witchery.features.necromancy.SoulPoolPlayerAttachment;
import dev.sterner.witchery.features.petrification.PetrificationHandler;
import dev.sterner.witchery.features.petrification.PetrifiedEntityAttachment;
import dev.sterner.witchery.features.possession.EntityAiToggle;
import dev.sterner.witchery.features.possession.PossessionComponentAttachment;
import dev.sterner.witchery.features.spirit_world.ManifestationHandler;
import dev.sterner.witchery.features.spirit_world.ManifestationPlayerAttachment;
import dev.sterner.witchery.features.tarot.TarotEffect;
import dev.sterner.witchery.features.tarot.TarotPlayerAttachment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.SingletonArgumentInfo;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J_\u0010\u0013\u001a\u0002H\u0014\"\u000e\b\u0000\u0010\u0015*\b\u0012\u0002\b\u0003\u0018\u00010\u0016\"\u0010\b\u0001\u0010\u0017*\n\u0012\u0004\u0012\u0002H\u0015\u0018\u00010\u0018\"\u0016\b\u0002\u0010\u0014*\u0010\u0012\u0004\u0012\u0002H\u0015\u0012\u0004\u0012\u0002H\u0017\u0018\u00010\u00062\u000e\u0010\u0019\u001a\n\u0012\u0004\u0012\u0002H\u0015\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u0002H\u0014H\u0002\u00a2\u0006\u0002\u0010\u001cJ$\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%J\u000e\u0010&\u001a\b\u0012\u0004\u0012\u00020!0'H\u0002J\u000e\u0010(\u001a\b\u0012\u0004\u0012\u00020!0'H\u0002J\u000e\u0010)\u001a\b\u0012\u0004\u0012\u00020!0'H\u0002J\u000e\u0010*\u001a\b\u0012\u0004\u0012\u00020!0'H\u0002J\u000e\u0010+\u001a\b\u0012\u0004\u0012\u00020!0'H\u0002J\u000e\u0010,\u001a\b\u0012\u0004\u0012\u00020!0'H\u0002J\u000e\u0010-\u001a\b\u0012\u0004\u0012\u00020!0'H\u0002J\u000e\u0010.\u001a\b\u0012\u0004\u0012\u00020!0'H\u0002J\u000e\u0010/\u001a\b\u0012\u0004\u0012\u00020!0'H\u0002J\f\u00100\u001a\b\u0012\u0004\u0012\u00020!0'J&\u00101\u001a\u0002022\f\u00103\u001a\b\u0012\u0004\u0012\u00020!042\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u000202H\u0002J\u001e\u00108\u001a\u0002022\f\u00103\u001a\b\u0012\u0004\u0012\u00020!042\u0006\u00105\u001a\u000206H\u0002J\u001e\u00109\u001a\u0002022\f\u00103\u001a\b\u0012\u0004\u0012\u00020!042\u0006\u00105\u001a\u000206H\u0002J.\u0010:\u001a\u0002022\f\u00103\u001a\b\u0012\u0004\u0012\u00020!042\u0006\u00105\u001a\u00020;2\u0006\u0010<\u001a\u0002022\u0006\u0010=\u001a\u00020>H\u0002J\u001e\u0010?\u001a\u0002022\f\u00103\u001a\b\u0012\u0004\u0012\u00020!042\u0006\u00105\u001a\u00020;H\u0002J\u0016\u0010@\u001a\u0002022\f\u00103\u001a\b\u0012\u0004\u0012\u00020!04H\u0002J\u001e\u0010A\u001a\u0002022\f\u00103\u001a\b\u0012\u0004\u0012\u00020!042\u0006\u00105\u001a\u00020;H\u0002R\u001f\u0010\u0004\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u00aa\u0001\u0010\t\u001a\u009a\u0001\u0012\u001c\u0012\u001a\u0012\u0002\b\u0003\u0012\u0002\b\u0003 \u000b*\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u00060\u0006\u0012(\u0012&\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\r0\r \u000b*\u0012\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\r0\r\u0018\u00010\f0\f \u000b*L\u0012\u001c\u0012\u001a\u0012\u0002\b\u0003\u0012\u0002\b\u0003 \u000b*\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u00060\u0006\u0012(\u0012&\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\r0\r \u000b*\u0012\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\r0\r\u0018\u00010\f0\f\u0018\u00010\n0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u00aa\u0001\u0010\u0010\u001a\u009a\u0001\u0012\u001c\u0012\u001a\u0012\u0002\b\u0003\u0012\u0002\b\u0003 \u000b*\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u00060\u0006\u0012(\u0012&\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00110\u0011 \u000b*\u0012\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00110\u0011\u0018\u00010\f0\f \u000b*L\u0012\u001c\u0012\u001a\u0012\u0002\b\u0003\u0012\u0002\b\u0003 \u000b*\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u00060\u0006\u0012(\u0012&\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00110\u0011 \u000b*\u0012\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00110\u0011\u0018\u00010\f0\f\u0018\u00010\n0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000f\u00a8\u0006B"}, d2={"Ldev/sterner/witchery/core/registry/WitcheryCommands;", "", "<init>", "()V", "COMMAND_ARGUMENTS", "Lnet/neoforged/neoforge/registries/DeferredRegister;", "Lnet/minecraft/commands/synchronization/ArgumentTypeInfo;", "getCOMMAND_ARGUMENTS", "()Lnet/neoforged/neoforge/registries/DeferredRegister;", "INFUSION_TYPE", "Lnet/neoforged/neoforge/registries/DeferredHolder;", "kotlin.jvm.PlatformType", "Lnet/minecraft/commands/synchronization/SingletonArgumentInfo;", "Ldev/sterner/witchery/core/commands/InfusionArgumentType;", "getINFUSION_TYPE", "()Lnet/neoforged/neoforge/registries/DeferredHolder;", "CURSE_TYPE", "Ldev/sterner/witchery/core/commands/CurseArgumentType;", "getCURSE_TYPE", "registerByClass", "I", "A", "Lcom/mojang/brigadier/arguments/ArgumentType;", "T", "Lnet/minecraft/commands/synchronization/ArgumentTypeInfo$Template;", "infoClass", "Ljava/lang/Class;", "argumentTypeInfo", "(Ljava/lang/Class;Lnet/minecraft/commands/synchronization/ArgumentTypeInfo;)Lnet/minecraft/commands/synchronization/ArgumentTypeInfo;", "register", "", "dispatcher", "Lcom/mojang/brigadier/CommandDispatcher;", "Lnet/minecraft/commands/CommandSourceStack;", "context", "Lnet/minecraft/commands/CommandBuildContext;", "selection", "Lnet/minecraft/commands/Commands$CommandSelection;", "registerDebugCommands", "Lcom/mojang/brigadier/builder/LiteralArgumentBuilder;", "registerInfusionCommands", "registerManifestationCommands", "registerCurseCommands", "registerLichdomCommands", "registerVampireCommands", "registerWerewolfCommands", "registerCovenCommands", "registerTarotCommands", "registerPetrificationCommands", "applyPetrification", "", "ctx", "Lcom/mojang/brigadier/context/CommandContext;", "target", "Lnet/minecraft/world/entity/Entity;", "duration", "removePetrification", "checkPetrification", "applyTarotCard", "Lnet/minecraft/server/level/ServerPlayer;", "cardNumber", "reversed", "", "clearTarotCards", "listTarotCards", "showTarotInfo", "witchery"})
@SourceDebugExtension(value={"SMAP\nWitcheryCommands.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WitcheryCommands.kt\ndev/sterner/witchery/core/registry/WitcheryCommands\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 AfflictionPlayerAttachment.kt\ndev/sterner/witchery/features/affliction/AfflictionPlayerAttachment\n*L\n1#1,1235:1\n126#2:1236\n153#2,3:1237\n126#2:1240\n153#2,3:1241\n126#2:1244\n153#2,3:1245\n1878#3,3:1248\n1788#3,4:1281\n1869#3,2:1285\n1878#3,3:1287\n1869#3,2:1290\n1869#3,2:1292\n69#4,15:1251\n69#4,15:1266\n*S KotlinDebug\n*F\n+ 1 WitcheryCommands.kt\ndev/sterner/witchery/core/registry/WitcheryCommands\n*L\n377#1:1236\n377#1:1237,3\n542#1:1240\n542#1:1241,3\n614#1:1244\n614#1:1245,3\n1207#1:1248,3\n669#1:1281,4\n680#1:1285,2\n717#1:1287,3\n748#1:1290,2\n845#1:1292,2\n434#1:1251,15\n448#1:1266,15\n*E\n"})
public final class WitcheryCommands {
    @NotNull
    public static final WitcheryCommands INSTANCE = new WitcheryCommands();
    @NotNull
    private static final DeferredRegister<ArgumentTypeInfo<?, ?>> COMMAND_ARGUMENTS;
    private static final DeferredHolder<ArgumentTypeInfo<?, ?>, SingletonArgumentInfo<InfusionArgumentType>> INFUSION_TYPE;
    private static final DeferredHolder<ArgumentTypeInfo<?, ?>, SingletonArgumentInfo<CurseArgumentType>> CURSE_TYPE;

    private WitcheryCommands() {
    }

    @NotNull
    public final DeferredRegister<ArgumentTypeInfo<?, ?>> getCOMMAND_ARGUMENTS() {
        return COMMAND_ARGUMENTS;
    }

    public final DeferredHolder<ArgumentTypeInfo<?, ?>, SingletonArgumentInfo<InfusionArgumentType>> getINFUSION_TYPE() {
        return INFUSION_TYPE;
    }

    public final DeferredHolder<ArgumentTypeInfo<?, ?>, SingletonArgumentInfo<CurseArgumentType>> getCURSE_TYPE() {
        return CURSE_TYPE;
    }

    private final <A extends ArgumentType<?>, T extends ArgumentTypeInfo.Template<A>, I extends ArgumentTypeInfo<A, T>> I registerByClass(Class<A> infoClass, I argumentTypeInfo) {
        Map<Class<?>, ArgumentTypeInfo<?, ?>> byClass = WitcheryUtil.getByClass();
        Intrinsics.checkNotNull(infoClass, (String)"null cannot be cast to non-null type java.lang.Class<*>");
        Intrinsics.checkNotNull(argumentTypeInfo, (String)"null cannot be cast to non-null type net.minecraft.commands.synchronization.ArgumentTypeInfo<*, *>");
        byClass.put(infoClass, argumentTypeInfo);
        return argumentTypeInfo;
    }

    public final void register(@NotNull CommandDispatcher<CommandSourceStack> dispatcher, @NotNull CommandBuildContext context, @NotNull Commands.CommandSelection selection) {
        Intrinsics.checkNotNullParameter(dispatcher, (String)"dispatcher");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"witchery").then((ArgumentBuilder)this.registerInfusionCommands())).then((ArgumentBuilder)this.registerManifestationCommands())).then((ArgumentBuilder)this.registerCurseCommands())).then((ArgumentBuilder)this.registerVampireCommands())).then((ArgumentBuilder)this.registerWerewolfCommands())).then((ArgumentBuilder)this.registerLichdomCommands())).then((ArgumentBuilder)this.registerCovenCommands())).then((ArgumentBuilder)this.registerTarotCommands())).then((ArgumentBuilder)this.registerPetrificationCommands())).then((ArgumentBuilder)this.registerDebugCommands()));
    }

    private final LiteralArgumentBuilder<CommandSourceStack> registerDebugCommands() {
        ArgumentBuilder argumentBuilder = ((LiteralArgumentBuilder)Commands.literal((String)"debug").requires(WitcheryCommands::registerDebugCommands$lambda$0)).then(Commands.literal((String)"setHunger").then(Commands.argument((String)"player", (ArgumentType)((ArgumentType)EntityArgument.player())).then(Commands.argument((String)"amount", (ArgumentType)((ArgumentType)IntegerArgumentType.integer((int)0))).executes(WitcheryCommands::registerDebugCommands$lambda$1))));
        Intrinsics.checkNotNullExpressionValue((Object)argumentBuilder, (String)"then(...)");
        return (LiteralArgumentBuilder)argumentBuilder;
    }

    private final LiteralArgumentBuilder<CommandSourceStack> registerInfusionCommands() {
        ArgumentBuilder argumentBuilder = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"infusion").requires(WitcheryCommands::registerInfusionCommands$lambda$0)).then(Commands.literal((String)"set").then(Commands.argument((String)"player", (ArgumentType)((ArgumentType)EntityArgument.player())).then(Commands.argument((String)"infusion", (ArgumentType)InfusionArgumentType.Companion.infusionType()).executes(WitcheryCommands::registerInfusionCommands$lambda$1))))).then(Commands.literal((String)"get").then(Commands.argument((String)"player", (ArgumentType)((ArgumentType)EntityArgument.player())).executes(WitcheryCommands::registerInfusionCommands$lambda$2)))).then(Commands.literal((String)"increase").then(Commands.argument((String)"player", (ArgumentType)((ArgumentType)EntityArgument.player())).then(Commands.argument((String)"amount", (ArgumentType)((ArgumentType)IntegerArgumentType.integer((int)1))).executes(WitcheryCommands::registerInfusionCommands$lambda$3))))).then(Commands.literal((String)"setAndKill").then(Commands.argument((String)"player", (ArgumentType)((ArgumentType)EntityArgument.player())).then(Commands.argument((String)"infusionType", (ArgumentType)InfusionArgumentType.Companion.infusionType()).executes(WitcheryCommands::registerInfusionCommands$lambda$4))));
        Intrinsics.checkNotNullExpressionValue((Object)argumentBuilder, (String)"then(...)");
        return (LiteralArgumentBuilder)argumentBuilder;
    }

    private final LiteralArgumentBuilder<CommandSourceStack> registerManifestationCommands() {
        ArgumentBuilder argumentBuilder = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"manifestation").requires(WitcheryCommands::registerManifestationCommands$lambda$0)).then(Commands.literal((String)"set").then(Commands.argument((String)"player", (ArgumentType)((ArgumentType)EntityArgument.player())).then(Commands.argument((String)"status", (ArgumentType)((ArgumentType)BoolArgumentType.bool())).executes(WitcheryCommands::registerManifestationCommands$lambda$1))))).then(Commands.literal((String)"get").then(Commands.argument((String)"player", (ArgumentType)((ArgumentType)EntityArgument.player())).executes(WitcheryCommands::registerManifestationCommands$lambda$2)));
        Intrinsics.checkNotNullExpressionValue((Object)argumentBuilder, (String)"then(...)");
        return (LiteralArgumentBuilder)argumentBuilder;
    }

    private final LiteralArgumentBuilder<CommandSourceStack> registerCurseCommands() {
        ArgumentBuilder argumentBuilder = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"curse").requires(WitcheryCommands::registerCurseCommands$lambda$0)).then(Commands.literal((String)"apply").then(Commands.argument((String)"player", (ArgumentType)((ArgumentType)EntityArgument.player())).then(Commands.argument((String)"curse", (ArgumentType)CurseArgumentType.Companion.curseType()).executes(WitcheryCommands::registerCurseCommands$lambda$1))))).then(Commands.literal((String)"remove").then(Commands.argument((String)"player", (ArgumentType)((ArgumentType)EntityArgument.player())).then(Commands.argument((String)"curse", (ArgumentType)CurseArgumentType.Companion.curseType()).executes(WitcheryCommands::registerCurseCommands$lambda$2))))).then(Commands.literal((String)"get").then(Commands.argument((String)"player", (ArgumentType)((ArgumentType)EntityArgument.player())).executes(WitcheryCommands::registerCurseCommands$lambda$3)))).then(Commands.literal((String)"clear").then(Commands.argument((String)"player", (ArgumentType)((ArgumentType)EntityArgument.player())).executes(WitcheryCommands::registerCurseCommands$lambda$4)));
        Intrinsics.checkNotNullExpressionValue((Object)argumentBuilder, (String)"then(...)");
        return (LiteralArgumentBuilder)argumentBuilder;
    }

    /*
     * WARNING - void declaration
     */
    private final LiteralArgumentBuilder<CommandSourceStack> registerLichdomCommands() {
        Collection<Integer> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Map<Integer, LichdomLeveling.Requirement> map = LichdomLeveling.INSTANCE.getLEVEL_REQUIREMENTS();
        int n = 0;
        String string = "level";
        RequiredArgumentBuilder requiredArgumentBuilder = Commands.argument((String)"player", (ArgumentType)((ArgumentType)EntityArgument.player()));
        LiteralArgumentBuilder literalArgumentBuilder = Commands.literal((String)"set");
        LiteralArgumentBuilder literalArgumentBuilder2 = Commands.literal((String)"soul");
        LiteralArgumentBuilder literalArgumentBuilder3 = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"lichdom").requires(WitcheryCommands::registerLichdomCommands$lambda$0)).then(((LiteralArgumentBuilder)Commands.literal((String)"level").then(Commands.literal((String)"get").then(Commands.argument((String)"player", (ArgumentType)((ArgumentType)EntityArgument.player())).executes(WitcheryCommands::registerLichdomCommands$lambda$1)))).then(Commands.literal((String)"set").then(Commands.argument((String)"player", (ArgumentType)((ArgumentType)EntityArgument.player())).then(Commands.argument((String)"level", (ArgumentType)((ArgumentType)IntegerArgumentType.integer((int)0))).executes(WitcheryCommands::registerLichdomCommands$lambda$2)))));
        boolean $i$f$map = false;
        void var3_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Number)it.getKey()).intValue());
        }
        collection = (List)destination$iv$iv;
        ArgumentBuilder argumentBuilder = ((LiteralArgumentBuilder)literalArgumentBuilder3.then(((LiteralArgumentBuilder)literalArgumentBuilder2.then(literalArgumentBuilder.then(requiredArgumentBuilder.then(Commands.argument((String)string, (ArgumentType)((ArgumentType)IntegerArgumentType.integer((int)n, (int)((Number)((Object)CollectionsKt.maxOrThrow((Iterable)collection))).intValue()))).executes(WitcheryCommands::registerLichdomCommands$lambda$4))))).then(Commands.literal((String)"get").then(Commands.argument((String)"player", (ArgumentType)((ArgumentType)EntityArgument.player())).executes(WitcheryCommands::registerLichdomCommands$lambda$5))))).then(Commands.literal((String)"soul_form").then(((RequiredArgumentBuilder)Commands.argument((String)"player", (ArgumentType)((ArgumentType)EntityArgument.player())).then(Commands.argument((String)"enable", (ArgumentType)((ArgumentType)BoolArgumentType.bool())).executes(WitcheryCommands::registerLichdomCommands$lambda$6))).then(Commands.literal((String)"cure").executes(WitcheryCommands::registerLichdomCommands$lambda$7))));
        Intrinsics.checkNotNullExpressionValue((Object)argumentBuilder, (String)"then(...)");
        return (LiteralArgumentBuilder)argumentBuilder;
    }

    /*
     * WARNING - void declaration
     */
    private final LiteralArgumentBuilder<CommandSourceStack> registerVampireCommands() {
        Collection<Integer> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Map<Integer, VampireLeveling.Requirement> map = VampireLeveling.INSTANCE.getLEVEL_REQUIREMENTS();
        VampireLeveling vampireLeveling = VampireLeveling.INSTANCE;
        int n = 0;
        String string = "level";
        RequiredArgumentBuilder requiredArgumentBuilder = Commands.argument((String)"player", (ArgumentType)((ArgumentType)EntityArgument.player()));
        LiteralArgumentBuilder literalArgumentBuilder = Commands.literal((String)"set");
        LiteralArgumentBuilder literalArgumentBuilder2 = Commands.literal((String)"blood");
        LiteralArgumentBuilder literalArgumentBuilder3 = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"vampire").requires(WitcheryCommands::registerVampireCommands$lambda$0)).then(((LiteralArgumentBuilder)Commands.literal((String)"level").then(Commands.literal((String)"get").then(Commands.argument((String)"player", (ArgumentType)((ArgumentType)EntityArgument.player())).executes(WitcheryCommands::registerVampireCommands$lambda$1)))).then(Commands.literal((String)"set").then(Commands.argument((String)"player", (ArgumentType)((ArgumentType)EntityArgument.player())).then(Commands.argument((String)"level", (ArgumentType)((ArgumentType)IntegerArgumentType.integer((int)0))).executes(WitcheryCommands::registerVampireCommands$lambda$2)))));
        boolean $i$f$map = false;
        void var3_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Number)it.getKey()).intValue());
        }
        collection = (List)destination$iv$iv;
        ArgumentBuilder argumentBuilder = literalArgumentBuilder3.then(((LiteralArgumentBuilder)literalArgumentBuilder2.then(literalArgumentBuilder.then(requiredArgumentBuilder.then(Commands.argument((String)string, (ArgumentType)((ArgumentType)IntegerArgumentType.integer((int)n, (int)vampireLeveling.levelToBlood(((Number)((Object)CollectionsKt.maxOrThrow((Iterable)collection))).intValue())))).executes(WitcheryCommands::registerVampireCommands$lambda$4))))).then(Commands.literal((String)"get").then(Commands.argument((String)"player", (ArgumentType)((ArgumentType)EntityArgument.player())).executes(WitcheryCommands::registerVampireCommands$lambda$5))));
        Intrinsics.checkNotNullExpressionValue((Object)argumentBuilder, (String)"then(...)");
        return (LiteralArgumentBuilder)argumentBuilder;
    }

    /*
     * WARNING - void declaration
     */
    private final LiteralArgumentBuilder<CommandSourceStack> registerWerewolfCommands() {
        Collection<Integer> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Map<Integer, WerewolfLeveling.Requirement> map = WerewolfLeveling.INSTANCE.getLEVEL_REQUIREMENTS();
        int n = 0;
        String string = "level";
        RequiredArgumentBuilder requiredArgumentBuilder = Commands.argument((String)"player", (ArgumentType)((ArgumentType)EntityArgument.player()));
        LiteralArgumentBuilder literalArgumentBuilder = Commands.literal((String)"set");
        LiteralArgumentBuilder literalArgumentBuilder2 = (LiteralArgumentBuilder)Commands.literal((String)"level").then(Commands.literal((String)"try_curse").then(Commands.argument((String)"player", (ArgumentType)((ArgumentType)EntityArgument.player())).executes(WitcheryCommands::registerWerewolfCommands$lambda$1)));
        LiteralArgumentBuilder literalArgumentBuilder3 = (LiteralArgumentBuilder)Commands.literal((String)"werewolf").requires(WitcheryCommands::registerWerewolfCommands$lambda$0);
        boolean $i$f$map = false;
        void var3_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Number)it.getKey()).intValue());
        }
        collection = (List)destination$iv$iv;
        ArgumentBuilder argumentBuilder = literalArgumentBuilder3.then(((LiteralArgumentBuilder)literalArgumentBuilder2.then(literalArgumentBuilder.then(requiredArgumentBuilder.then(Commands.argument((String)string, (ArgumentType)((ArgumentType)IntegerArgumentType.integer((int)n, (int)((Number)((Object)CollectionsKt.maxOrThrow((Iterable)collection))).intValue()))).executes(WitcheryCommands::registerWerewolfCommands$lambda$3))))).then(Commands.literal((String)"get").then(Commands.argument((String)"player", (ArgumentType)((ArgumentType)EntityArgument.player())).executes(WitcheryCommands::registerWerewolfCommands$lambda$4))));
        Intrinsics.checkNotNullExpressionValue((Object)argumentBuilder, (String)"then(...)");
        return (LiteralArgumentBuilder)argumentBuilder;
    }

    private final LiteralArgumentBuilder<CommandSourceStack> registerCovenCommands() {
        ArgumentBuilder argumentBuilder = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"coven").requires(WitcheryCommands::registerCovenCommands$lambda$0)).then(Commands.literal((String)"info").then(Commands.argument((String)"player", (ArgumentType)((ArgumentType)EntityArgument.player())).executes(WitcheryCommands::registerCovenCommands$lambda$1)))).then(Commands.literal((String)"witches").then(Commands.argument((String)"player", (ArgumentType)((ArgumentType)EntityArgument.player())).executes(WitcheryCommands::registerCovenCommands$lambda$2)))).then(Commands.literal((String)"members").then(Commands.argument((String)"player", (ArgumentType)((ArgumentType)EntityArgument.player())).executes(WitcheryCommands::registerCovenCommands$lambda$3)))).then(Commands.literal((String)"add_player").then(Commands.argument((String)"leader", (ArgumentType)((ArgumentType)EntityArgument.player())).then(Commands.argument((String)"member", (ArgumentType)((ArgumentType)EntityArgument.player())).executes(WitcheryCommands::registerCovenCommands$lambda$4))))).then(Commands.literal((String)"remove_player").then(Commands.argument((String)"leader", (ArgumentType)((ArgumentType)EntityArgument.player())).then(Commands.argument((String)"member", (ArgumentType)((ArgumentType)EntityArgument.player())).executes(WitcheryCommands::registerCovenCommands$lambda$5))))).then(Commands.literal((String)"resurrect_witch").then(Commands.argument((String)"player", (ArgumentType)((ArgumentType)EntityArgument.player())).then(Commands.argument((String)"index", (ArgumentType)((ArgumentType)IntegerArgumentType.integer((int)0))).executes(WitcheryCommands::registerCovenCommands$lambda$6))))).then(Commands.literal((String)"clear").then(Commands.argument((String)"player", (ArgumentType)((ArgumentType)EntityArgument.player())).executes(WitcheryCommands::registerCovenCommands$lambda$7)));
        Intrinsics.checkNotNullExpressionValue((Object)argumentBuilder, (String)"then(...)");
        return (LiteralArgumentBuilder)argumentBuilder;
    }

    private final LiteralArgumentBuilder<CommandSourceStack> registerTarotCommands() {
        ArgumentBuilder argumentBuilder = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"tarot").requires(WitcheryCommands::registerTarotCommands$lambda$0)).then(Commands.literal((String)"apply").then(Commands.argument((String)"player", (ArgumentType)((ArgumentType)EntityArgument.player())).then(((RequiredArgumentBuilder)Commands.argument((String)"cardNumber", (ArgumentType)((ArgumentType)IntegerArgumentType.integer((int)1, (int)22))).then(Commands.argument((String)"reversed", (ArgumentType)((ArgumentType)BoolArgumentType.bool())).executes(WitcheryCommands::registerTarotCommands$lambda$1))).executes(WitcheryCommands::registerTarotCommands$lambda$2))))).then(Commands.literal((String)"clear").then(Commands.argument((String)"player", (ArgumentType)((ArgumentType)EntityArgument.player())).executes(WitcheryCommands::registerTarotCommands$lambda$3)))).then(Commands.literal((String)"list").executes(WitcheryCommands::registerTarotCommands$lambda$4))).then(Commands.literal((String)"info").then(Commands.argument((String)"player", (ArgumentType)((ArgumentType)EntityArgument.player())).executes(WitcheryCommands::registerTarotCommands$lambda$5)));
        Intrinsics.checkNotNullExpressionValue((Object)argumentBuilder, (String)"then(...)");
        return (LiteralArgumentBuilder)argumentBuilder;
    }

    @NotNull
    public final LiteralArgumentBuilder<CommandSourceStack> registerPetrificationCommands() {
        ArgumentBuilder argumentBuilder = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"petrification").requires(WitcheryCommands::registerPetrificationCommands$lambda$0)).then(Commands.literal((String)"apply").then(((RequiredArgumentBuilder)Commands.argument((String)"target", (ArgumentType)((ArgumentType)EntityArgument.entity())).then(Commands.argument((String)"duration", (ArgumentType)((ArgumentType)IntegerArgumentType.integer((int)1, (int)72000))).executes(WitcheryCommands::registerPetrificationCommands$lambda$1))).executes(WitcheryCommands::registerPetrificationCommands$lambda$2)))).then(Commands.literal((String)"remove").then(Commands.argument((String)"target", (ArgumentType)((ArgumentType)EntityArgument.entity())).executes(WitcheryCommands::registerPetrificationCommands$lambda$3)))).then(Commands.literal((String)"check").then(Commands.argument((String)"target", (ArgumentType)((ArgumentType)EntityArgument.entity())).executes(WitcheryCommands::registerPetrificationCommands$lambda$4)));
        Intrinsics.checkNotNullExpressionValue((Object)argumentBuilder, (String)"then(...)");
        return (LiteralArgumentBuilder)argumentBuilder;
    }

    private final int applyPetrification(CommandContext<CommandSourceStack> ctx, Entity target, int duration) {
        if (!(target instanceof LivingEntity)) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"Target must be a living entity"));
            return 0;
        }
        PetrificationHandler.INSTANCE.petrify((LivingEntity)target, duration);
        int minutes = duration / 1200;
        int seconds = duration % 1200 / 20;
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> WitcheryCommands.applyPetrification$lambda$0(target, minutes, seconds), true);
        return 1;
    }

    private final int removePetrification(CommandContext<CommandSourceStack> ctx, Entity target) {
        if (!(target instanceof LivingEntity)) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"Target must be a living entity"));
            return 0;
        }
        PetrificationHandler.INSTANCE.unpetrify((LivingEntity)target);
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> WitcheryCommands.removePetrification$lambda$0(target), true);
        return 1;
    }

    private final int checkPetrification(CommandContext<CommandSourceStack> ctx, Entity target) {
        if (!(target instanceof LivingEntity)) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"Target must be a living entity"));
            return 0;
        }
        PetrifiedEntityAttachment.Data data2 = PetrifiedEntityAttachment.INSTANCE.getData((LivingEntity)target);
        if (!data2.isPetrified()) {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> WitcheryCommands.checkPetrification$lambda$0(target), false);
            return 0;
        }
        int ticksRemaining = data2.getPetrificationTicks();
        int minutes = ticksRemaining / 1200;
        int seconds = ticksRemaining % 1200 / 20;
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> WitcheryCommands.checkPetrification$lambda$1(target, minutes, seconds), false);
        return 1;
    }

    private final int applyTarotCard(CommandContext<CommandSourceStack> ctx, ServerPlayer target, int cardNumber, boolean reversed) {
        TarotEffect effect = WitcheryTarotEffects.INSTANCE.getByCardNumber(cardNumber);
        if (effect == null) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)("Invalid card number: " + cardNumber + ". Must be between 1 and 22.")).withStyle(ChatFormatting.RED));
            return 0;
        }
        TarotPlayerAttachment.Data currentData = TarotPlayerAttachment.getData((Player)target);
        List newCards = CollectionsKt.toMutableList((Collection)currentData.getDrawnCards());
        List newReversed = CollectionsKt.toMutableList((Collection)currentData.getReversedCards());
        int existingIndex = newCards.indexOf(cardNumber);
        if (existingIndex != -1) {
            newCards.remove(existingIndex);
            newReversed.remove(existingIndex);
        }
        newCards.add(cardNumber);
        newReversed.add(reversed);
        if (newCards.size() > 3) {
            newCards.remove(0);
            newReversed.remove(0);
        }
        TarotPlayerAttachment.Data newData = new TarotPlayerAttachment.Data(newCards, newReversed, target.level().getGameTime());
        TarotPlayerAttachment.setData((Player)target, newData);
        String cardName = effect.getDisplayName(reversed).getString();
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> WitcheryCommands.applyTarotCard$lambda$0(cardName, target), true);
        target.displayClientMessage((Component)Component.literal((String)"You have been granted: ").withStyle(ChatFormatting.GRAY).append((Component)effect.getDisplayName(reversed).copy().withStyle(ChatFormatting.GOLD)), false);
        return 1;
    }

    private final int clearTarotCards(CommandContext<CommandSourceStack> ctx, ServerPlayer target) {
        TarotPlayerAttachment.Data newData = new TarotPlayerAttachment.Data(CollectionsKt.emptyList(), CollectionsKt.emptyList(), 0L);
        TarotPlayerAttachment.setData((Player)target, newData);
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> WitcheryCommands.clearTarotCards$lambda$0(target), true);
        target.displayClientMessage((Component)Component.literal((String)"Your tarot cards have been cleared.").withStyle(ChatFormatting.GRAY), false);
        return 1;
    }

    private final int listTarotCards(CommandContext<CommandSourceStack> ctx) {
        ((CommandSourceStack)ctx.getSource()).sendSuccess(WitcheryCommands::listTarotCards$lambda$0, false);
        for (int i = 1; i < 23; ++i) {
            TarotEffect effect = WitcheryTarotEffects.INSTANCE.getByCardNumber(i);
            if (effect == null) continue;
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> WitcheryCommands.listTarotCards$lambda$1(i, effect), false);
        }
        return 1;
    }

    /*
     * WARNING - void declaration
     */
    private final int showTarotInfo(CommandContext<CommandSourceStack> ctx, ServerPlayer target) {
        TarotPlayerAttachment.Data data2 = TarotPlayerAttachment.getData((Player)target);
        if (data2.getDrawnCards().isEmpty()) {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> WitcheryCommands.showTarotInfo$lambda$0(target), false);
            return 1;
        }
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> WitcheryCommands.showTarotInfo$lambda$1(target), false);
        long timeRemaining = 72000L - (target.level().getGameTime() - data2.getReadingTimestamp());
        long daysRemaining = timeRemaining / 24000L;
        long hoursRemaining = timeRemaining % 24000L / 1000L;
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> WitcheryCommands.showTarotInfo$lambda$2(daysRemaining, hoursRemaining), false);
        Iterable $this$forEachIndexed$iv = data2.getDrawnCards();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void cardNumber;
            boolean isReversed;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = ((Number)item$iv).intValue();
            int index = n;
            boolean bl = false;
            Boolean bl2 = (Boolean)CollectionsKt.getOrNull(data2.getReversedCards(), (int)index);
            boolean bl3 = isReversed = bl2 != null ? bl2 : false;
            TarotEffect effect = WitcheryTarotEffects.INSTANCE.getByCardNumber((int)cardNumber);
            if (effect == null) continue;
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> WitcheryCommands.showTarotInfo$lambda$3$0(index, effect, isReversed), false);
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> WitcheryCommands.showTarotInfo$lambda$3$1(effect, isReversed), false);
        }
        return 1;
    }

    private static final SingletonArgumentInfo INFUSION_TYPE$lambda$0() {
        return (SingletonArgumentInfo)INSTANCE.registerByClass(InfusionArgumentType.class, (ArgumentTypeInfo)SingletonArgumentInfo.contextFree(InfusionArgumentType::new));
    }

    private static final SingletonArgumentInfo CURSE_TYPE$lambda$0() {
        return (SingletonArgumentInfo)INSTANCE.registerByClass(CurseArgumentType.class, (ArgumentTypeInfo)SingletonArgumentInfo.contextFree(CurseArgumentType::new));
    }

    private static final boolean registerDebugCommands$lambda$0(CommandSourceStack it) {
        return it.hasPermission(2);
    }

    private static final int registerDebugCommands$lambda$1(CommandContext ctx) {
        ServerPlayer player = EntityArgument.getPlayer((CommandContext)ctx, (String)"player");
        int amount = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"amount");
        player.getFoodData().setFoodLevel(amount);
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> WitcheryCommands.registerDebugCommands$lambda$1$0(player, amount), true);
        return 1;
    }

    private static final Component registerDebugCommands$lambda$1$0(ServerPlayer $player, int $amount) {
        return (Component)Component.literal((String)("Set " + $player.getName().getString() + "'s hunger to " + $amount));
    }

    private static final boolean registerInfusionCommands$lambda$0(CommandSourceStack it) {
        return it.hasPermission(2);
    }

    private static final int registerInfusionCommands$lambda$1(CommandContext ctx) {
        ServerPlayer player = EntityArgument.getPlayer((CommandContext)ctx, (String)"player");
        Intrinsics.checkNotNull((Object)ctx);
        InfusionType infusionType = InfusionArgumentType.Companion.getInfusionType((CommandContext<CommandSourceStack>)ctx, "infusion");
        Intrinsics.checkNotNull((Object)player);
        InfusionPlayerAttachment.setData((Player)player, new InfusionPlayerAttachment.Data(infusionType, 0, 2, null));
        return 1;
    }

    private static final int registerInfusionCommands$lambda$2(CommandContext ctx) {
        ServerPlayer player = EntityArgument.getPlayer((CommandContext)ctx, (String)"player");
        Intrinsics.checkNotNull((Object)player);
        InfusionPlayerAttachment.Data currentInfusion = InfusionPlayerAttachment.getData((Player)player);
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> WitcheryCommands.registerInfusionCommands$lambda$2$0(currentInfusion, player), false);
        return 1;
    }

    private static final Component registerInfusionCommands$lambda$2$0(InfusionPlayerAttachment.Data $currentInfusion, ServerPlayer $player) {
        return (Component)Component.literal((String)("Current infusion type: " + $currentInfusion.getType().getSerializedName() + " for player " + $player.getName().getString()));
    }

    private static final int registerInfusionCommands$lambda$3(CommandContext ctx) {
        ServerPlayer player = EntityArgument.getPlayer((CommandContext)ctx, (String)"player");
        int amount = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"amount");
        Intrinsics.checkNotNull((Object)player);
        if (InfusionPlayerAttachment.getData((Player)player).getType() != InfusionType.NONE) {
            InfusionHandler.increaseInfusionCharge((Player)player, amount);
        }
        return 1;
    }

    private static final int registerInfusionCommands$lambda$4(CommandContext ctx) {
        ServerPlayer player = EntityArgument.getPlayer((CommandContext)ctx, (String)"player");
        Intrinsics.checkNotNull((Object)ctx);
        InfusionType infusionType = InfusionArgumentType.Companion.getInfusionType((CommandContext<CommandSourceStack>)ctx, "infusionType");
        player.hurt(player.level().damageSources().magic(), 100.0f);
        if (player.getHealth() > 0.0f) {
            Intrinsics.checkNotNull((Object)player);
            InfusionPlayerAttachment.setData((Player)player, new InfusionPlayerAttachment.Data(infusionType, 0, 2, null));
        }
        return 1;
    }

    private static final boolean registerManifestationCommands$lambda$0(CommandSourceStack it) {
        return it.hasPermission(2);
    }

    private static final int registerManifestationCommands$lambda$1(CommandContext ctx) {
        ServerPlayer player = EntityArgument.getPlayer((CommandContext)ctx, (String)"player");
        boolean status = BoolArgumentType.getBool((CommandContext)ctx, (String)"status");
        Intrinsics.checkNotNull((Object)player);
        ManifestationHandler.INSTANCE.setHasRiteOfManifestation((Player)player, status);
        return 1;
    }

    private static final int registerManifestationCommands$lambda$2(CommandContext ctx) {
        ServerPlayer player = EntityArgument.getPlayer((CommandContext)ctx, (String)"player");
        Intrinsics.checkNotNull((Object)player);
        boolean status = ManifestationPlayerAttachment.getData((Player)player).getHasRiteOfManifestation();
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> WitcheryCommands.registerManifestationCommands$lambda$2$0(status, player), false);
        return 1;
    }

    private static final Component registerManifestationCommands$lambda$2$0(boolean $status, ServerPlayer $player) {
        return (Component)Component.literal((String)("Current manifestation status: " + $status + " for player " + $player.getName().getString()));
    }

    private static final boolean registerCurseCommands$lambda$0(CommandSourceStack it) {
        return it.hasPermission(2);
    }

    private static final int registerCurseCommands$lambda$1(CommandContext ctx) {
        boolean bl;
        ServerPlayer player = EntityArgument.getPlayer((CommandContext)ctx, (String)"player");
        Intrinsics.checkNotNull((Object)ctx);
        Curse curseType = CurseArgumentType.Companion.getCurse((CommandContext<CommandSourceStack>)ctx, "curse");
        ServerPlayer commandSender = ((CommandSourceStack)ctx.getSource()).getPlayer();
        if (commandSender != null) {
            UUID uUID = commandSender.getUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
            ServerLevel serverLevel = commandSender.serverLevel();
            Intrinsics.checkNotNullExpressionValue((Object)serverLevel, (String)"serverLevel(...)");
            bl = Intrinsics.areEqual(FamiliarHandler.INSTANCE.getFamiliarEntityType(uUID, serverLevel), (Object)EntityType.CAT);
        } else {
            bl = false;
        }
        boolean cat = bl;
        Intrinsics.checkNotNull((Object)player);
        Player player2 = (Player)player;
        ResourceLocation resourceLocation = WitcheryCurseRegistry.INSTANCE.getCURSES_REGISTRY().getKey((Object)curseType);
        Intrinsics.checkNotNull((Object)resourceLocation);
        CurseHandler.addCurse$default(CurseHandler.INSTANCE, player2, commandSender, resourceLocation, cat, 0, 16, null);
        return 1;
    }

    private static final int registerCurseCommands$lambda$2(CommandContext ctx) {
        ServerPlayer player = EntityArgument.getPlayer((CommandContext)ctx, (String)"player");
        Intrinsics.checkNotNull((Object)ctx);
        Curse curseType = CurseArgumentType.Companion.getCurse((CommandContext<CommandSourceStack>)ctx, "curse");
        Intrinsics.checkNotNull((Object)player);
        CurseHandler.INSTANCE.removeCurse((Player)player, curseType);
        return 1;
    }

    private static final int registerCurseCommands$lambda$3(CommandContext ctx) {
        MutableComponent mutableComponent;
        ServerPlayer player = EntityArgument.getPlayer((CommandContext)ctx, (String)"player");
        Intrinsics.checkNotNull((Object)player);
        List<CursePlayerAttachment.PlayerCurseData> curseData = CursePlayerAttachment.getData((Player)player).getPlayerCurseList();
        if (curseData.isEmpty()) {
            mutableComponent = Component.literal((String)("No curses on " + player.getName().getString()));
        } else {
            String curseNames = CollectionsKt.joinToString$default((Iterable)curseData, (CharSequence)", ", null, null, (int)0, null, WitcheryCommands::registerCurseCommands$lambda$3$0, (int)30, null);
            mutableComponent = Component.literal((String)("Curses on " + player.getName().getString() + ": " + curseNames));
        }
        MutableComponent message = mutableComponent;
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> WitcheryCommands.registerCurseCommands$lambda$3$1(message), false);
        return 1;
    }

    private static final CharSequence registerCurseCommands$lambda$3$0(CursePlayerAttachment.PlayerCurseData curse) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)curse, (String)"curse");
        Object object = (Curse)WitcheryCurseRegistry.INSTANCE.getCURSES_REGISTRY().get(curse.getCurseId());
        if (object != null && (object = object.getClass()) != null && (object = ((Class)object).getSimpleName()) != null) {
            charSequence = (CharSequence)object;
        } else {
            String string = curse.getCurseId().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            charSequence = string;
        }
        return charSequence;
    }

    private static final Component registerCurseCommands$lambda$3$1(MutableComponent $message) {
        return (Component)$message;
    }

    private static final int registerCurseCommands$lambda$4(CommandContext ctx) {
        ServerPlayer player = EntityArgument.getPlayer((CommandContext)ctx, (String)"player");
        Intrinsics.checkNotNull((Object)player);
        CurseHandler.INSTANCE.removeAllCurses((Player)player);
        return 1;
    }

    private static final boolean registerLichdomCommands$lambda$0(CommandSourceStack it) {
        return it.hasPermission(2);
    }

    private static final int registerLichdomCommands$lambda$1(CommandContext context) {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        Intrinsics.checkNotNull((Object)player);
        int level = AfflictionPlayerAttachment.getData((Player)player).getLichLevel();
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> WitcheryCommands.registerLichdomCommands$lambda$1$0(level, player), true);
        return 1;
    }

    private static final Component registerLichdomCommands$lambda$1$0(int $level, ServerPlayer $player) {
        return (Component)Component.literal((String)("Level: " + $level + " for " + $player.getName().getString()));
    }

    private static final int registerLichdomCommands$lambda$2(CommandContext context) {
        int level = IntegerArgumentType.getInteger((CommandContext)context, (String)"level");
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        Intrinsics.checkNotNull((Object)player);
        LichdomLeveling.setLevel(player, level);
        LichdomLeveling.INSTANCE.updateModifiers((Player)player, level);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> WitcheryCommands.registerLichdomCommands$lambda$2$0(level, player), true);
        return 1;
    }

    private static final Component registerLichdomCommands$lambda$2$0(int $level, ServerPlayer $player) {
        return (Component)Component.literal((String)("Set lichdom level to " + $level + " for " + $player.getName().getString()));
    }

    private static final int registerLichdomCommands$lambda$4(CommandContext context) {
        int level = IntegerArgumentType.getInteger((CommandContext)context, (String)"level");
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        Intrinsics.checkNotNull((Object)player);
        SoulPoolPlayerAttachment.Data data2 = SoulPoolPlayerAttachment.getData((Player)player);
        SoulPoolPlayerAttachment.setData((Player)player, new SoulPoolPlayerAttachment.Data(data2.getMaxSouls(), Mth.clamp((int)level, (int)0, (int)data2.getMaxSouls())));
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> WitcheryCommands.registerLichdomCommands$lambda$4$0(level, player), true);
        return 1;
    }

    private static final Component registerLichdomCommands$lambda$4$0(int $level, ServerPlayer $player) {
        return (Component)Component.literal((String)("Set soul level to " + $level + " for " + $player.getName().getString()));
    }

    private static final int registerLichdomCommands$lambda$5(CommandContext context) {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        Intrinsics.checkNotNull((Object)player);
        SoulPoolPlayerAttachment.Data data2 = SoulPoolPlayerAttachment.getData((Player)player);
        player.sendSystemMessage((Component)Component.literal((String)("Soul Level: " + data2.getSoulPool() + "/" + data2.getMaxSouls())));
        return 1;
    }

    private static final int registerLichdomCommands$lambda$6(CommandContext ctx) {
        boolean enable = BoolArgumentType.getBool((CommandContext)ctx, (String)"enable");
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
        Intrinsics.checkNotNull((Object)player);
        boolean isSoulForm = AfflictionPlayerAttachment.getData((Player)player).isSoulForm();
        boolean isVagrant = AfflictionPlayerAttachment.getData((Player)player).isVagrant();
        if (isSoulForm && !isVagrant && !enable) {
            AfflictionPlayerAttachment.Data currentData$iv;
            SoulShellPlayerEntity.Companion.disableFlight(player);
            InventorySlots.INSTANCE.unlockAll((Player)player);
            player.getAbilities().flying = false;
            player.onUpdateAbilities();
            AfflictionPlayerAttachment afflictionPlayerAttachment = AfflictionPlayerAttachment.INSTANCE;
            Player player$iv = (Player)player;
            boolean sync$iv = true;
            boolean $i$f$smartUpdate = false;
            AfflictionPlayerAttachment.Data $this$registerLichdomCommands_u24lambda_u246_u240 = currentData$iv = AfflictionPlayerAttachment.getData(player$iv);
            boolean bl = false;
            AfflictionPlayerAttachment.Data newData$iv = $this$registerLichdomCommands_u24lambda_u246_u240.withSoulForm(false).withVagrant(false);
            AfflictionPlayerAttachment.setData(player$iv, newData$iv, false);
            if (player$iv.level() instanceof ServerLevel) {
                AfflictionPlayerAttachment.syncSmart(player$iv, newData$iv);
            }
        } else if (!isSoulForm && !isVagrant && enable) {
            LichdomSpecificEventHandler.INSTANCE.activateSoulForm(player);
        } else if (isVagrant && enable) {
            AfflictionPlayerAttachment.Data currentData$iv;
            PossessionComponentAttachment.PossessionComponent possessionComponent = PossessionComponentAttachment.INSTANCE.get((Player)player);
            Mob host = possessionComponent.getHost();
            if (host != null) {
                possessionComponent.stopPossessing(false);
                EntityAiToggle.toggleAi((LivingEntity)host, EntityAiToggle.INSTANCE.getPOSSESSION_MECHANISM_ID(), false, false);
            }
            AfflictionPlayerAttachment sync$iv = AfflictionPlayerAttachment.INSTANCE;
            Player player$iv = (Player)player;
            boolean sync$iv2 = true;
            boolean $i$f$smartUpdate = false;
            AfflictionPlayerAttachment.Data $this$registerLichdomCommands_u24lambda_u246_u241 = currentData$iv = AfflictionPlayerAttachment.getData(player$iv);
            boolean bl = false;
            AfflictionPlayerAttachment.Data newData$iv = $this$registerLichdomCommands_u24lambda_u246_u241.withSoulForm(true).withVagrant(false);
            AfflictionPlayerAttachment.setData(player$iv, newData$iv, false);
            if (player$iv.level() instanceof ServerLevel) {
                AfflictionPlayerAttachment.syncSmart(player$iv, newData$iv);
            }
            InventorySlots.INSTANCE.lockAll((Player)player);
            SoulShellPlayerEntity.Companion.enableFlight(player);
            player.getAbilities().flying = true;
            RandomSource random = player.getRandom();
            player.setDeltaMovement(player.getDeltaMovement().add((random.nextDouble() - 0.5) * 0.1, 0.2 + random.nextDouble() * 0.1, (random.nextDouble() - 0.5) * 0.1));
            player.hurtMarked = true;
            player.onUpdateAbilities();
        }
        return 1;
    }

    private static final int registerLichdomCommands$lambda$7(CommandContext ctx) {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
        Intrinsics.checkNotNull((Object)player);
        PossessionComponentAttachment.PossessionComponent possess = PossessionComponentAttachment.INSTANCE.get((Player)player);
        possess.startCuring();
        return 1;
    }

    private static final boolean registerVampireCommands$lambda$0(CommandSourceStack it) {
        return it.hasPermission(2);
    }

    private static final int registerVampireCommands$lambda$1(CommandContext context) {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        Intrinsics.checkNotNull((Object)player);
        int level = AfflictionPlayerAttachment.getData((Player)player).getVampireLevel();
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> WitcheryCommands.registerVampireCommands$lambda$1$0(level, player), true);
        return 1;
    }

    private static final Component registerVampireCommands$lambda$1$0(int $level, ServerPlayer $player) {
        return (Component)Component.literal((String)("Level: " + $level + " for " + $player.getName().getString()));
    }

    private static final int registerVampireCommands$lambda$2(CommandContext context) {
        int level = IntegerArgumentType.getInteger((CommandContext)context, (String)"level");
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        Intrinsics.checkNotNull((Object)player);
        VampireLeveling.setLevel(player, level);
        VampireLeveling.INSTANCE.updateModifiers((Player)player, level, false);
        int maxBlood = VampireLeveling.INSTANCE.levelToBlood(level);
        BloodPoolLivingEntityAttachment.setData((LivingEntity)player, new BloodPoolLivingEntityAttachment.Data(maxBlood, maxBlood));
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> WitcheryCommands.registerVampireCommands$lambda$2$0(level, player), true);
        return 1;
    }

    private static final Component registerVampireCommands$lambda$2$0(int $level, ServerPlayer $player) {
        return (Component)Component.literal((String)("Set vampire level to " + $level + " for " + $player.getName().getString()));
    }

    private static final int registerVampireCommands$lambda$4(CommandContext context) {
        int level = IntegerArgumentType.getInteger((CommandContext)context, (String)"level");
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        Intrinsics.checkNotNull((Object)player);
        BloodPoolLivingEntityAttachment.Data data2 = BloodPoolLivingEntityAttachment.getData((LivingEntity)player);
        BloodPoolLivingEntityAttachment.setData((LivingEntity)player, new BloodPoolLivingEntityAttachment.Data(data2.getMaxBlood(), Mth.clamp((int)level, (int)0, (int)data2.getMaxBlood())));
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> WitcheryCommands.registerVampireCommands$lambda$4$0(level, player), true);
        return 1;
    }

    private static final Component registerVampireCommands$lambda$4$0(int $level, ServerPlayer $player) {
        return (Component)Component.literal((String)("Set blood level to " + $level + " for " + $player.getName().getString()));
    }

    private static final int registerVampireCommands$lambda$5(CommandContext context) {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        Intrinsics.checkNotNull((Object)player);
        BloodPoolLivingEntityAttachment.Data data2 = BloodPoolLivingEntityAttachment.getData((LivingEntity)player);
        player.sendSystemMessage((Component)Component.literal((String)("Blood Level: " + data2.getBloodPool() + "/" + data2.getMaxBlood())));
        return 1;
    }

    private static final boolean registerWerewolfCommands$lambda$0(CommandSourceStack it) {
        return it.hasPermission(2);
    }

    private static final int registerWerewolfCommands$lambda$1(CommandContext context) {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        Intrinsics.checkNotNull((Object)player);
        int currentLevel = AfflictionPlayerAttachment.getData((Player)player).getWerewolfLevel();
        if (currentLevel == 0) {
            ResourceLocation resourceLocation = Witchery.Companion.id("werewolf/1");
            Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"id(...)");
            WitcheryUtil.INSTANCE.grantAdvancementCriterion(player, resourceLocation, "impossible_1");
            WerewolfLeveling.increaseWerewolfLevel(player);
        }
        return 1;
    }

    private static final int registerWerewolfCommands$lambda$3(CommandContext context) {
        int level = IntegerArgumentType.getInteger((CommandContext)context, (String)"level");
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        Intrinsics.checkNotNull((Object)player);
        WerewolfLeveling.setLevel(player, level);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> WitcheryCommands.registerWerewolfCommands$lambda$3$0(level, player), true);
        return 1;
    }

    private static final Component registerWerewolfCommands$lambda$3$0(int $level, ServerPlayer $player) {
        return (Component)Component.literal((String)("Set werewolf level to " + $level + " for " + $player.getName().getString()));
    }

    private static final int registerWerewolfCommands$lambda$4(CommandContext context) {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        Intrinsics.checkNotNull((Object)player);
        int level = AfflictionPlayerAttachment.getData((Player)player).getWerewolfLevel();
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> WitcheryCommands.registerWerewolfCommands$lambda$4$0(level, player), true);
        return 1;
    }

    private static final Component registerWerewolfCommands$lambda$4$0(int $level, ServerPlayer $player) {
        return (Component)Component.literal((String)("Level " + $level + " for " + $player.getName().getString()));
    }

    private static final boolean registerCovenCommands$lambda$0(CommandSourceStack it) {
        return it.hasPermission(2);
    }

    private static final int registerCovenCommands$lambda$1(CommandContext ctx) {
        int n;
        ServerPlayer player = EntityArgument.getPlayer((CommandContext)ctx, (String)"player");
        Intrinsics.checkNotNull((Object)player);
        CovenPlayerAttachment.Data data2 = CovenPlayerAttachment.getData((Player)player);
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> WitcheryCommands.registerCovenCommands$lambda$1$0(player), false);
        int witchCount = data2.getCovenWitches().size();
        Iterable $this$count$iv = data2.getCovenWitches();
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                CovenPlayerAttachment.Data.WitchData it = (CovenPlayerAttachment.Data.WitchData)element$iv;
                boolean bl = false;
                if (!it.isActive() || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int activeWitches = n;
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> WitcheryCommands.registerCovenCommands$lambda$1$2(activeWitches, witchCount), false);
        if (!((Collection)data2.getPlayerMembers()).isEmpty()) {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> WitcheryCommands.registerCovenCommands$lambda$1$3(data2), false);
            Iterable $this$forEach$iv = data2.getPlayerMembers();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                UUID memberUuid = (UUID)element$iv;
                boolean bl = false;
                ServerPlayer member = ((CommandSourceStack)ctx.getSource()).getServer().getPlayerList().getPlayer(memberUuid);
                Object object = member;
                if (object == null || (object = object.getName()) == null || (object = object.getString()) == null) {
                    object = "Offline Player";
                }
                Object memberName = object;
                ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> WitcheryCommands.registerCovenCommands$lambda$1$4$0((String)memberName), false);
            }
        } else {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(WitcheryCommands::registerCovenCommands$lambda$1$5, false);
        }
        return 1;
    }

    private static final Component registerCovenCommands$lambda$1$0(ServerPlayer $player) {
        return (Component)Component.literal((String)("=== Coven Info for " + $player.getName().getString() + " ==="));
    }

    private static final Component registerCovenCommands$lambda$1$2(int $activeWitches, int $witchCount) {
        return (Component)Component.literal((String)("Coven Witches: " + $activeWitches + "/" + $witchCount + " active"));
    }

    private static final Component registerCovenCommands$lambda$1$3(CovenPlayerAttachment.Data $data) {
        return (Component)Component.literal((String)("Player Members (" + $data.getPlayerMembers().size() + "):"));
    }

    private static final Component registerCovenCommands$lambda$1$4$0(String $memberName) {
        return (Component)Component.literal((String)("  - " + $memberName));
    }

    private static final Component registerCovenCommands$lambda$1$5() {
        return (Component)Component.literal((String)"No player members");
    }

    /*
     * WARNING - void declaration
     */
    private static final int registerCovenCommands$lambda$2(CommandContext ctx) {
        ServerPlayer player = EntityArgument.getPlayer((CommandContext)ctx, (String)"player");
        Intrinsics.checkNotNull((Object)player);
        CovenPlayerAttachment.Data data2 = CovenPlayerAttachment.getData((Player)player);
        if (data2.getCovenWitches().isEmpty()) {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> WitcheryCommands.registerCovenCommands$lambda$2$0(player), false);
        } else {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> WitcheryCommands.registerCovenCommands$lambda$2$1(player), false);
            Iterable $this$forEachIndexed$iv = data2.getCovenWitches();
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void witch;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                CovenPlayerAttachment.Data.WitchData witchData = (CovenPlayerAttachment.Data.WitchData)item$iv;
                int index = n;
                boolean bl = false;
                String status = witch.isActive() ? "Active" : "Dead";
                String health = witch.isActive() ? (int)witch.getHealth() + " HP" : "0 HP";
                ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> WitcheryCommands.registerCovenCommands$lambda$2$2$0(index, (CovenPlayerAttachment.Data.WitchData)witch, status, health), false);
            }
        }
        return 1;
    }

    private static final Component registerCovenCommands$lambda$2$0(ServerPlayer $player) {
        return (Component)Component.literal((String)($player.getName().getString() + " has no coven witches"));
    }

    private static final Component registerCovenCommands$lambda$2$1(ServerPlayer $player) {
        return (Component)Component.literal((String)("=== Coven Witches for " + $player.getName().getString() + " ==="));
    }

    private static final Component registerCovenCommands$lambda$2$2$0(int $index, CovenPlayerAttachment.Data.WitchData $witch, String $status, String $health) {
        return (Component)Component.literal((String)("[" + $index + "] " + $witch.getName().getString() + " - " + $status + " (" + $health + ")"));
    }

    private static final int registerCovenCommands$lambda$3(CommandContext ctx) {
        ServerPlayer player = EntityArgument.getPlayer((CommandContext)ctx, (String)"player");
        Intrinsics.checkNotNull((Object)player);
        CovenPlayerAttachment.Data data2 = CovenPlayerAttachment.getData((Player)player);
        if (data2.getPlayerMembers().isEmpty()) {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> WitcheryCommands.registerCovenCommands$lambda$3$0(player), false);
        } else {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> WitcheryCommands.registerCovenCommands$lambda$3$1(player), false);
            Iterable $this$forEach$iv = data2.getPlayerMembers();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                UUID memberUuid = (UUID)element$iv;
                boolean bl = false;
                ServerPlayer member = ((CommandSourceStack)ctx.getSource()).getServer().getPlayerList().getPlayer(memberUuid);
                Object object = member;
                if (object == null || (object = object.getName()) == null || (object = object.getString()) == null) {
                    object = "Offline";
                }
                Object memberName = object;
                String status = member != null ? "Online" : "Offline";
                ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> WitcheryCommands.registerCovenCommands$lambda$3$2$0((String)memberName, status), false);
            }
        }
        return 1;
    }

    private static final Component registerCovenCommands$lambda$3$0(ServerPlayer $player) {
        return (Component)Component.literal((String)($player.getName().getString() + " has no player members in their coven"));
    }

    private static final Component registerCovenCommands$lambda$3$1(ServerPlayer $player) {
        return (Component)Component.literal((String)("=== Player Members for " + $player.getName().getString() + " ==="));
    }

    private static final Component registerCovenCommands$lambda$3$2$0(String $memberName, String $status) {
        return (Component)Component.literal((String)("  - " + $memberName + " (" + $status + ")"));
    }

    private static final int registerCovenCommands$lambda$4(CommandContext ctx) {
        ServerPlayer leader = EntityArgument.getPlayer((CommandContext)ctx, (String)"leader");
        ServerPlayer member = EntityArgument.getPlayer((CommandContext)ctx, (String)"member");
        Intrinsics.checkNotNull((Object)leader);
        Intrinsics.checkNotNull((Object)member);
        if (CovenHandler.INSTANCE.addPlayerToCoven(leader, member)) {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> WitcheryCommands.registerCovenCommands$lambda$4$0(member, leader), true);
        } else {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)("Failed to add " + member.getName().getString() + " to coven")));
        }
        return 1;
    }

    private static final Component registerCovenCommands$lambda$4$0(ServerPlayer $member, ServerPlayer $leader) {
        return (Component)Component.literal((String)("Added " + $member.getName().getString() + " to " + $leader.getName().getString() + "'s coven"));
    }

    private static final int registerCovenCommands$lambda$5(CommandContext ctx) {
        ServerPlayer leader = EntityArgument.getPlayer((CommandContext)ctx, (String)"leader");
        ServerPlayer member = EntityArgument.getPlayer((CommandContext)ctx, (String)"member");
        Intrinsics.checkNotNull((Object)leader);
        UUID uUID = member.getUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        if (CovenHandler.INSTANCE.removePlayerFromCoven(leader, uUID)) {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> WitcheryCommands.registerCovenCommands$lambda$5$0(member, leader), true);
        } else {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)("Failed to remove " + member.getName().getString() + " from coven")));
        }
        return 1;
    }

    private static final Component registerCovenCommands$lambda$5$0(ServerPlayer $member, ServerPlayer $leader) {
        return (Component)Component.literal((String)("Removed " + $member.getName().getString() + " from " + $leader.getName().getString() + "'s coven"));
    }

    private static final int registerCovenCommands$lambda$6(CommandContext ctx) {
        ServerPlayer player = EntityArgument.getPlayer((CommandContext)ctx, (String)"player");
        int index = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"index");
        Intrinsics.checkNotNull((Object)player);
        if (CovenHandler.INSTANCE.resurrectWitch(player, index)) {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> WitcheryCommands.registerCovenCommands$lambda$6$0(index, player), true);
        } else {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"Failed to resurrect witch (invalid index or witch is already alive)"));
        }
        return 1;
    }

    private static final Component registerCovenCommands$lambda$6$0(int $index, ServerPlayer $player) {
        return (Component)Component.literal((String)("Resurrected witch at index " + $index + " for " + $player.getName().getString()));
    }

    private static final int registerCovenCommands$lambda$7(CommandContext ctx) {
        ServerPlayer player = EntityArgument.getPlayer((CommandContext)ctx, (String)"player");
        Intrinsics.checkNotNull((Object)player);
        CovenPlayerAttachment.Data data2 = CovenPlayerAttachment.getData((Player)player);
        Iterable $this$forEach$iv = CollectionsKt.toList((Iterable)data2.getPlayerMembers());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UUID memberUuid = (UUID)element$iv;
            boolean bl = false;
            CovenHandler.INSTANCE.removePlayerFromCoven(player, memberUuid);
        }
        for (int i = data2.getCovenWitches().size() - 1; -1 < i; --i) {
            CovenHandler.INSTANCE.removeWitchFromCoven(player, i);
        }
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> WitcheryCommands.registerCovenCommands$lambda$7$1(player), true);
        return 1;
    }

    private static final Component registerCovenCommands$lambda$7$1(ServerPlayer $player) {
        return (Component)Component.literal((String)("Cleared all coven members for " + $player.getName().getString()));
    }

    private static final boolean registerTarotCommands$lambda$0(CommandSourceStack it) {
        return it.hasPermission(2);
    }

    private static final int registerTarotCommands$lambda$1(CommandContext ctx) {
        ServerPlayer player = EntityArgument.getPlayer((CommandContext)ctx, (String)"player");
        int cardNumber = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"cardNumber");
        boolean reversed = BoolArgumentType.getBool((CommandContext)ctx, (String)"reversed");
        Intrinsics.checkNotNull((Object)ctx);
        Intrinsics.checkNotNull((Object)player);
        return INSTANCE.applyTarotCard((CommandContext<CommandSourceStack>)ctx, player, cardNumber, reversed);
    }

    private static final int registerTarotCommands$lambda$2(CommandContext ctx) {
        ServerPlayer player = EntityArgument.getPlayer((CommandContext)ctx, (String)"player");
        int cardNumber = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"cardNumber");
        Intrinsics.checkNotNull((Object)ctx);
        Intrinsics.checkNotNull((Object)player);
        return INSTANCE.applyTarotCard((CommandContext<CommandSourceStack>)ctx, player, cardNumber, false);
    }

    private static final int registerTarotCommands$lambda$3(CommandContext ctx) {
        ServerPlayer player = EntityArgument.getPlayer((CommandContext)ctx, (String)"player");
        Intrinsics.checkNotNull((Object)ctx);
        Intrinsics.checkNotNull((Object)player);
        return INSTANCE.clearTarotCards((CommandContext<CommandSourceStack>)ctx, player);
    }

    private static final int registerTarotCommands$lambda$4(CommandContext ctx) {
        Intrinsics.checkNotNull((Object)ctx);
        return INSTANCE.listTarotCards((CommandContext<CommandSourceStack>)ctx);
    }

    private static final int registerTarotCommands$lambda$5(CommandContext ctx) {
        ServerPlayer player = EntityArgument.getPlayer((CommandContext)ctx, (String)"player");
        Intrinsics.checkNotNull((Object)ctx);
        Intrinsics.checkNotNull((Object)player);
        return INSTANCE.showTarotInfo((CommandContext<CommandSourceStack>)ctx, player);
    }

    private static final boolean registerPetrificationCommands$lambda$0(CommandSourceStack it) {
        return it.hasPermission(2);
    }

    private static final int registerPetrificationCommands$lambda$1(CommandContext ctx) {
        Intrinsics.checkNotNull((Object)ctx);
        Entity entity = EntityArgument.getEntity((CommandContext)ctx, (String)"target");
        Intrinsics.checkNotNullExpressionValue((Object)entity, (String)"getEntity(...)");
        return INSTANCE.applyPetrification((CommandContext<CommandSourceStack>)ctx, entity, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"duration"));
    }

    private static final int registerPetrificationCommands$lambda$2(CommandContext ctx) {
        Intrinsics.checkNotNull((Object)ctx);
        Entity entity = EntityArgument.getEntity((CommandContext)ctx, (String)"target");
        Intrinsics.checkNotNullExpressionValue((Object)entity, (String)"getEntity(...)");
        return INSTANCE.applyPetrification((CommandContext<CommandSourceStack>)ctx, entity, 6000);
    }

    private static final int registerPetrificationCommands$lambda$3(CommandContext ctx) {
        Intrinsics.checkNotNull((Object)ctx);
        Entity entity = EntityArgument.getEntity((CommandContext)ctx, (String)"target");
        Intrinsics.checkNotNullExpressionValue((Object)entity, (String)"getEntity(...)");
        return INSTANCE.removePetrification((CommandContext<CommandSourceStack>)ctx, entity);
    }

    private static final int registerPetrificationCommands$lambda$4(CommandContext ctx) {
        Intrinsics.checkNotNull((Object)ctx);
        Entity entity = EntityArgument.getEntity((CommandContext)ctx, (String)"target");
        Intrinsics.checkNotNullExpressionValue((Object)entity, (String)"getEntity(...)");
        return INSTANCE.checkPetrification((CommandContext<CommandSourceStack>)ctx, entity);
    }

    private static final Component applyPetrification$lambda$0(Entity $target, int $minutes, int $seconds) {
        return (Component)Component.literal((String)("Petrified " + ((LivingEntity)$target).getName().getString() + " for " + $minutes + "m " + $seconds + "s"));
    }

    private static final Component removePetrification$lambda$0(Entity $target) {
        return (Component)Component.literal((String)("Removed petrification from " + ((LivingEntity)$target).getName().getString()));
    }

    private static final Component checkPetrification$lambda$0(Entity $target) {
        return (Component)Component.literal((String)(((LivingEntity)$target).getName().getString() + " is not petrified"));
    }

    private static final Component checkPetrification$lambda$1(Entity $target, int $minutes, int $seconds) {
        return (Component)Component.literal((String)(((LivingEntity)$target).getName().getString() + " is petrified with " + $minutes + "m " + $seconds + "s remaining"));
    }

    private static final Component applyTarotCard$lambda$0(String $cardName, ServerPlayer $target) {
        return (Component)Component.literal((String)"Applied tarot card ").withStyle(ChatFormatting.GREEN).append((Component)Component.literal((String)$cardName).withStyle(ChatFormatting.GOLD)).append(" to " + $target.getName().getString());
    }

    private static final Component clearTarotCards$lambda$0(ServerPlayer $target) {
        return (Component)Component.literal((String)("Cleared all tarot cards from " + $target.getName().getString())).withStyle(ChatFormatting.GREEN);
    }

    private static final Component listTarotCards$lambda$0() {
        ChatFormatting[] chatFormattingArray = new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD};
        return (Component)Component.literal((String)"=== Available Tarot Cards ===").withStyle(chatFormattingArray);
    }

    private static final Component listTarotCards$lambda$1(int $i, TarotEffect $effect) {
        return (Component)Component.literal((String)($i + ". ")).withStyle(ChatFormatting.GRAY).append((Component)$effect.getDisplayName(false).copy().withStyle(ChatFormatting.WHITE));
    }

    private static final Component showTarotInfo$lambda$0(ServerPlayer $target) {
        return (Component)Component.literal((String)($target.getName().getString() + " has no active tarot cards")).withStyle(ChatFormatting.GRAY);
    }

    private static final Component showTarotInfo$lambda$1(ServerPlayer $target) {
        ChatFormatting[] chatFormattingArray = new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD};
        return (Component)Component.literal((String)("=== Tarot Cards for " + $target.getName().getString() + " ===")).withStyle(chatFormattingArray);
    }

    private static final Component showTarotInfo$lambda$2(long $daysRemaining, long $hoursRemaining) {
        return (Component)Component.literal((String)("Time Remaining: " + $daysRemaining + "d " + $hoursRemaining + "h")).withStyle(ChatFormatting.YELLOW);
    }

    private static final Component showTarotInfo$lambda$3$0(int $index, TarotEffect $effect, boolean $isReversed) {
        return (Component)Component.literal((String)($index + 1 + ". ")).withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)$effect.getDisplayName($isReversed).getString()).withStyle(ChatFormatting.WHITE));
    }

    private static final Component showTarotInfo$lambda$3$1(TarotEffect $effect, boolean $isReversed) {
        return (Component)Component.literal((String)"   ").append((Component)$effect.getDescription($isReversed).copy().withStyle(ChatFormatting.DARK_GRAY));
    }

    static {
        DeferredRegister deferredRegister = DeferredRegister.create((ResourceKey)Registries.COMMAND_ARGUMENT_TYPE, (String)"witchery");
        Intrinsics.checkNotNullExpressionValue((Object)deferredRegister, (String)"create(...)");
        COMMAND_ARGUMENTS = deferredRegister;
        INFUSION_TYPE = COMMAND_ARGUMENTS.register("infusion_type", WitcheryCommands::INFUSION_TYPE$lambda$0);
        CURSE_TYPE = COMMAND_ARGUMENTS.register("curse_type", WitcheryCommands::CURSE_TYPE$lambda$0);
    }
}

