/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.features.affliction.lich;

import dev.sterner.witchery.Witchery;
import dev.sterner.witchery.client.hud.QuestHudRenderer;
import dev.sterner.witchery.core.api.WitcheryApi;
import dev.sterner.witchery.core.api.event.LichEvent;
import dev.sterner.witchery.features.affliction.AfflictionPlayerAttachment;
import dev.sterner.witchery.features.affliction.AfflictionTypes;
import dev.sterner.witchery.features.affliction.ability.AfflictionAbilityHandler;
import dev.sterner.witchery.features.affliction.event.TransformationHandler;
import dev.sterner.witchery.features.affliction.lich.LichdomSoulPoolHandler;
import dev.sterner.witchery.network.RefreshDimensionsS2CPayload;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001,B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\rH\u0002J\u0018\u0010\u0012\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\rH\u0002J\u0010\u0010\u0014\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\u0015\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\u0016\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0018\u0010\u0017\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\rH\u0007J\u0010\u0010\u0019\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\u001a\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\u001b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\u001c\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\u001d\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0018\u0010\u001e\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020 H\u0007J\u0016\u0010!\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\"2\u0006\u0010\f\u001a\u00020\rJ\u0018\u0010#\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020%H\u0002J \u0010+\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020%2\u0006\u0010\u0011\u001a\u00020\rH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020(0'\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*\u00a8\u0006-"}, d2={"Ldev/sterner/witchery/features/affliction/lich/LichdomLeveling;", "", "<init>", "()V", "SOUL_DRAIN_WEAKNESS", "Lnet/minecraft/world/entity/ai/attributes/AttributeModifier;", "LICH_HEALTH_BONUS", "LICH_ARMOR_BONUS", "setLevel", "", "player", "Lnet/minecraft/server/level/ServerPlayer;", "level", "", "increaseNecromancerLevel", "canPerformQuest", "", "targetLevel", "hasTabletKnowledge", "tier", "bindVillagerSoul", "recordZombieKill", "increaseKilledGolems", "bindMultipleSouls", "count", "drainAnimalLife", "recordPossessedKill", "recordWitherKill", "recordPhylacteryUse", "recordPhylacteryTripleDeath", "readAncientTablet", "tabletId", "Ljava/util/UUID;", "updateModifiers", "Lnet/minecraft/world/entity/player/Player;", "checkAndLevelUp", "data", "Ldev/sterner/witchery/features/affliction/AfflictionPlayerAttachment$Data;", "LEVEL_REQUIREMENTS", "", "Ldev/sterner/witchery/features/affliction/lich/LichdomLeveling$Requirement;", "getLEVEL_REQUIREMENTS", "()Ljava/util/Map;", "canLevelUp", "Requirement", "witchery"})
@SourceDebugExtension(value={"SMAP\nLichdomLeveling.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LichdomLeveling.kt\ndev/sterner/witchery/features/affliction/lich/LichdomLeveling\n+ 2 AfflictionPlayerAttachment.kt\ndev/sterner/witchery/features/affliction/AfflictionPlayerAttachment\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,354:1\n69#2,15:355\n69#2,15:370\n69#2,15:385\n69#2,15:400\n69#2,15:415\n69#2,15:430\n69#2,15:445\n69#2,15:460\n69#2,15:475\n69#2,15:490\n1#3:505\n*S KotlinDebug\n*F\n+ 1 LichdomLeveling.kt\ndev/sterner/witchery/features/affliction/lich/LichdomLeveling\n*L\n47#1:355,15\n125#1:370,15\n137#1:385,15\n149#1:400,15\n161#1:415,15\n173#1:430,15\n185#1:445,15\n197#1:460,15\n209#1:475,15\n239#1:490,15\n*E\n"})
public final class LichdomLeveling {
    @NotNull
    public static final LichdomLeveling INSTANCE = new LichdomLeveling();
    @NotNull
    private static final AttributeModifier SOUL_DRAIN_WEAKNESS = new AttributeModifier(Witchery.Companion.id("lich_soul_drain"), -2.0, AttributeModifier.Operation.ADD_VALUE);
    @NotNull
    private static final AttributeModifier LICH_HEALTH_BONUS = new AttributeModifier(Witchery.Companion.id("lich_health"), 10.0, AttributeModifier.Operation.ADD_VALUE);
    @NotNull
    private static final AttributeModifier LICH_ARMOR_BONUS = new AttributeModifier(Witchery.Companion.id("lich_armor"), 4.0, AttributeModifier.Operation.ADD_VALUE);
    @NotNull
    private static final Map<Integer, Requirement> LEVEL_REQUIREMENTS;

    private LichdomLeveling() {
    }

    @JvmStatic
    public static final void setLevel(@NotNull ServerPlayer player, int level) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        int previousLevel = AfflictionPlayerAttachment.getData((Player)player).getLichLevel();
        if (level == 0) {
            AfflictionPlayerAttachment.Data newData = AfflictionPlayerAttachment.getData((Player)player).setLevel(AfflictionTypes.LICHDOM, 0).withSoulForm(false).withPhylacteryBound(false).withPhylacterySouls(0);
            AfflictionPlayerAttachment.setData((Player)player, newData, false);
            AfflictionPlayerAttachment.syncFull((Player)player, newData);
            TransformationHandler.removeForm((Player)player);
        } else {
            AfflictionPlayerAttachment.Data currentData$iv;
            AfflictionPlayerAttachment newData = AfflictionPlayerAttachment.INSTANCE;
            Player player$iv = (Player)player;
            boolean sync$iv = true;
            boolean $i$f$smartUpdate = false;
            AfflictionPlayerAttachment.Data $this$setLevel_u24lambda_u240 = currentData$iv = AfflictionPlayerAttachment.getData(player$iv);
            boolean bl = false;
            AfflictionPlayerAttachment.Data newData$iv = $this$setLevel_u24lambda_u240.setLevel(AfflictionTypes.LICHDOM, level);
            AfflictionPlayerAttachment.setData(player$iv, newData$iv, false);
            if (player$iv.level() instanceof ServerLevel) {
                AfflictionPlayerAttachment.syncSmart(player$iv, newData$iv);
            }
        }
        if (level >= 2) {
            LichdomSoulPoolHandler.INSTANCE.setMaxSouls((Player)player, level);
        } else if (level == 0 && previousLevel >= 2) {
            LichdomSoulPoolHandler.INSTANCE.setMaxSouls((Player)player, 0);
        }
        if (level == 1) {
            QuestHudRenderer.INSTANCE.setVisible(true);
        }
        INSTANCE.updateModifiers((Player)player, level);
        player.refreshDimensions();
        if (level == 0 && previousLevel > 0) {
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)player.serverLevel(), (ChunkPos)player.chunkPosition(), (CustomPacketPayload)new RefreshDimensionsS2CPayload(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @JvmStatic
    public static final void increaseNecromancerLevel(@NotNull ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        AfflictionPlayerAttachment.Data currentData = AfflictionPlayerAttachment.getData((Player)player);
        int currentLevel = currentData.getLichLevel();
        int nextLevel = currentLevel + 1;
        if (nextLevel > 10) {
            return;
        }
        if (nextLevel > 1 && !INSTANCE.canLevelUp(player, currentData, nextLevel)) {
            return;
        }
        LichEvent.LevelUp event = new LichEvent.LevelUp((Player)player, currentLevel, nextLevel);
        NeoForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return;
        }
        LichdomLeveling.setLevel(player, nextLevel);
        player.sendSystemMessage((Component)Component.literal((String)("Necromancer Level Up: " + nextLevel)));
        player.refreshDimensions();
        PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)player.serverLevel(), (ChunkPos)player.chunkPosition(), (CustomPacketPayload)new RefreshDimensionsS2CPayload(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        if (nextLevel > currentLevel) {
            AfflictionAbilityHandler.addAbilityOnLevelUp$default(AfflictionAbilityHandler.INSTANCE, (Player)player, nextLevel, AfflictionTypes.LICHDOM, false, 8, null);
        }
        WitcheryApi.INSTANCE.makePlayerWitchy((Player)player);
    }

    private final boolean canPerformQuest(ServerPlayer player, int targetLevel) {
        AfflictionPlayerAttachment.Data data2 = AfflictionPlayerAttachment.getData((Player)player);
        if (data2.getLichLevel() != targetLevel) {
            return false;
        }
        Object object = LEVEL_REQUIREMENTS.get(targetLevel);
        if (object == null || (object = ((Requirement)object).getTabletTier()) == null) {
            return true;
        }
        int requiredTablet = (Integer)object;
        return this.hasTabletKnowledge(player, requiredTablet);
    }

    private final boolean hasTabletKnowledge(ServerPlayer player, int tier) {
        AfflictionPlayerAttachment.Data data2 = AfflictionPlayerAttachment.getData((Player)player);
        return data2.getReadTablets().size() >= tier;
    }

    @JvmStatic
    public static final void bindVillagerSoul(@NotNull ServerPlayer player) {
        AfflictionPlayerAttachment.Data currentData$iv;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (!INSTANCE.canPerformQuest(player, 1)) {
            return;
        }
        AfflictionPlayerAttachment afflictionPlayerAttachment = AfflictionPlayerAttachment.INSTANCE;
        Player player$iv = (Player)player;
        boolean sync$iv = true;
        boolean $i$f$smartUpdate = false;
        AfflictionPlayerAttachment.Data $this$bindVillagerSoul_u24lambda_u240 = currentData$iv = AfflictionPlayerAttachment.getData(player$iv);
        boolean bl = false;
        AfflictionPlayerAttachment.Data newData$iv = AfflictionPlayerAttachment.Data.incrementBoundSouls$default($this$bindVillagerSoul_u24lambda_u240, 0, 1, null);
        AfflictionPlayerAttachment.setData(player$iv, newData$iv, false);
        if (player$iv.level() instanceof ServerLevel) {
            AfflictionPlayerAttachment.syncSmart(player$iv, newData$iv);
        }
        AfflictionPlayerAttachment.Data newData = newData$iv;
        INSTANCE.checkAndLevelUp(player, newData);
    }

    @JvmStatic
    public static final void recordZombieKill(@NotNull ServerPlayer player) {
        AfflictionPlayerAttachment.Data currentData$iv;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (!INSTANCE.canPerformQuest(player, 2)) {
            return;
        }
        AfflictionPlayerAttachment afflictionPlayerAttachment = AfflictionPlayerAttachment.INSTANCE;
        Player player$iv = (Player)player;
        boolean sync$iv = true;
        boolean $i$f$smartUpdate = false;
        AfflictionPlayerAttachment.Data $this$recordZombieKill_u24lambda_u240 = currentData$iv = AfflictionPlayerAttachment.getData(player$iv);
        boolean bl = false;
        AfflictionPlayerAttachment.Data newData$iv = $this$recordZombieKill_u24lambda_u240.withZombieKilledMob(true);
        AfflictionPlayerAttachment.setData(player$iv, newData$iv, false);
        if (player$iv.level() instanceof ServerLevel) {
            AfflictionPlayerAttachment.syncSmart(player$iv, newData$iv);
        }
        AfflictionPlayerAttachment.Data newData = newData$iv;
        INSTANCE.checkAndLevelUp(player, newData);
    }

    @JvmStatic
    public static final void increaseKilledGolems(@NotNull ServerPlayer player) {
        AfflictionPlayerAttachment.Data currentData$iv;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (!INSTANCE.canPerformQuest(player, 3)) {
            return;
        }
        AfflictionPlayerAttachment afflictionPlayerAttachment = AfflictionPlayerAttachment.INSTANCE;
        Player player$iv = (Player)player;
        boolean sync$iv = true;
        boolean $i$f$smartUpdate = false;
        AfflictionPlayerAttachment.Data $this$increaseKilledGolems_u24lambda_u240 = currentData$iv = AfflictionPlayerAttachment.getData(player$iv);
        boolean bl = false;
        AfflictionPlayerAttachment.Data newData$iv = AfflictionPlayerAttachment.Data.incrementKilledGolems$default($this$increaseKilledGolems_u24lambda_u240, 0, 1, null);
        AfflictionPlayerAttachment.setData(player$iv, newData$iv, false);
        if (player$iv.level() instanceof ServerLevel) {
            AfflictionPlayerAttachment.syncSmart(player$iv, newData$iv);
        }
        AfflictionPlayerAttachment.Data newData = newData$iv;
        INSTANCE.checkAndLevelUp(player, newData);
    }

    @JvmStatic
    public static final void bindMultipleSouls(@NotNull ServerPlayer player, int count) {
        AfflictionPlayerAttachment.Data currentData$iv;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (!INSTANCE.canPerformQuest(player, 4)) {
            return;
        }
        AfflictionPlayerAttachment afflictionPlayerAttachment = AfflictionPlayerAttachment.INSTANCE;
        Player player$iv = (Player)player;
        boolean sync$iv = true;
        boolean $i$f$smartUpdate = false;
        AfflictionPlayerAttachment.Data $this$bindMultipleSouls_u24lambda_u240 = currentData$iv = AfflictionPlayerAttachment.getData(player$iv);
        boolean bl = false;
        AfflictionPlayerAttachment.Data newData$iv = $this$bindMultipleSouls_u24lambda_u240.withBoundSouls($this$bindMultipleSouls_u24lambda_u240.getBoundSouls() + count);
        AfflictionPlayerAttachment.setData(player$iv, newData$iv, false);
        if (player$iv.level() instanceof ServerLevel) {
            AfflictionPlayerAttachment.syncSmart(player$iv, newData$iv);
        }
        AfflictionPlayerAttachment.Data newData = newData$iv;
        INSTANCE.checkAndLevelUp(player, newData);
    }

    @JvmStatic
    public static final void drainAnimalLife(@NotNull ServerPlayer player) {
        AfflictionPlayerAttachment.Data currentData$iv;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (!INSTANCE.canPerformQuest(player, 5)) {
            return;
        }
        AfflictionPlayerAttachment afflictionPlayerAttachment = AfflictionPlayerAttachment.INSTANCE;
        Player player$iv = (Player)player;
        boolean sync$iv = true;
        boolean $i$f$smartUpdate = false;
        AfflictionPlayerAttachment.Data $this$drainAnimalLife_u24lambda_u240 = currentData$iv = AfflictionPlayerAttachment.getData(player$iv);
        boolean bl = false;
        AfflictionPlayerAttachment.Data newData$iv = AfflictionPlayerAttachment.Data.incrementDrainedAnimals$default($this$drainAnimalLife_u24lambda_u240, 0, 1, null);
        AfflictionPlayerAttachment.setData(player$iv, newData$iv, false);
        if (player$iv.level() instanceof ServerLevel) {
            AfflictionPlayerAttachment.syncSmart(player$iv, newData$iv);
        }
        AfflictionPlayerAttachment.Data newData = newData$iv;
        INSTANCE.checkAndLevelUp(player, newData);
    }

    @JvmStatic
    public static final void recordPossessedKill(@NotNull ServerPlayer player) {
        AfflictionPlayerAttachment.Data currentData$iv;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (!INSTANCE.canPerformQuest(player, 6)) {
            return;
        }
        AfflictionPlayerAttachment afflictionPlayerAttachment = AfflictionPlayerAttachment.INSTANCE;
        Player player$iv = (Player)player;
        boolean sync$iv = true;
        boolean $i$f$smartUpdate = false;
        AfflictionPlayerAttachment.Data $this$recordPossessedKill_u24lambda_u240 = currentData$iv = AfflictionPlayerAttachment.getData(player$iv);
        boolean bl = false;
        AfflictionPlayerAttachment.Data newData$iv = $this$recordPossessedKill_u24lambda_u240.withPossessedKillVillager(true);
        AfflictionPlayerAttachment.setData(player$iv, newData$iv, false);
        if (player$iv.level() instanceof ServerLevel) {
            AfflictionPlayerAttachment.syncSmart(player$iv, newData$iv);
        }
        AfflictionPlayerAttachment.Data newData = newData$iv;
        INSTANCE.checkAndLevelUp(player, newData);
    }

    @JvmStatic
    public static final void recordWitherKill(@NotNull ServerPlayer player) {
        AfflictionPlayerAttachment.Data currentData$iv;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (!INSTANCE.canPerformQuest(player, 7)) {
            return;
        }
        AfflictionPlayerAttachment afflictionPlayerAttachment = AfflictionPlayerAttachment.INSTANCE;
        Player player$iv = (Player)player;
        boolean sync$iv = true;
        boolean $i$f$smartUpdate = false;
        AfflictionPlayerAttachment.Data $this$recordWitherKill_u24lambda_u240 = currentData$iv = AfflictionPlayerAttachment.getData(player$iv);
        boolean bl = false;
        AfflictionPlayerAttachment.Data newData$iv = $this$recordWitherKill_u24lambda_u240.withKilledWither(true);
        AfflictionPlayerAttachment.setData(player$iv, newData$iv, false);
        if (player$iv.level() instanceof ServerLevel) {
            AfflictionPlayerAttachment.syncSmart(player$iv, newData$iv);
        }
        AfflictionPlayerAttachment.Data newData = newData$iv;
        INSTANCE.checkAndLevelUp(player, newData);
    }

    @JvmStatic
    public static final void recordPhylacteryUse(@NotNull ServerPlayer player) {
        AfflictionPlayerAttachment.Data currentData$iv;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (!INSTANCE.canPerformQuest(player, 8)) {
            return;
        }
        AfflictionPlayerAttachment afflictionPlayerAttachment = AfflictionPlayerAttachment.INSTANCE;
        Player player$iv = (Player)player;
        boolean sync$iv = true;
        boolean $i$f$smartUpdate = false;
        AfflictionPlayerAttachment.Data $this$recordPhylacteryUse_u24lambda_u240 = currentData$iv = AfflictionPlayerAttachment.getData(player$iv);
        boolean bl = false;
        AfflictionPlayerAttachment.Data newData$iv = $this$recordPhylacteryUse_u24lambda_u240.withPhylacteryBound(true).incrementPhylacteryDeaths(player);
        AfflictionPlayerAttachment.setData(player$iv, newData$iv, false);
        if (player$iv.level() instanceof ServerLevel) {
            AfflictionPlayerAttachment.syncSmart(player$iv, newData$iv);
        }
        AfflictionPlayerAttachment.Data newData = newData$iv;
        INSTANCE.checkAndLevelUp(player, newData);
    }

    @JvmStatic
    public static final void recordPhylacteryTripleDeath(@NotNull ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (!INSTANCE.canPerformQuest(player, 9)) {
            return;
        }
        AfflictionPlayerAttachment.Data data2 = AfflictionPlayerAttachment.getData((Player)player);
        int recentDeaths = data2.getPhylacteryDeaths();
        if (recentDeaths >= 3) {
            LichdomLeveling.increaseNecromancerLevel(player);
        }
    }

    @JvmStatic
    public static final boolean readAncientTablet(@NotNull ServerPlayer player, @NotNull UUID tabletId) {
        AfflictionPlayerAttachment.Data currentData$iv;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)tabletId, (String)"tabletId");
        AfflictionPlayerAttachment.Data data2 = AfflictionPlayerAttachment.getData((Player)player);
        if (data2.getReadTablets().contains(tabletId)) {
            player.sendSystemMessage((Component)Component.literal((String)"You have already studied this tablet"));
            return false;
        }
        AfflictionPlayerAttachment afflictionPlayerAttachment = AfflictionPlayerAttachment.INSTANCE;
        Player player$iv = (Player)player;
        boolean sync$iv = true;
        boolean $i$f$smartUpdate = false;
        AfflictionPlayerAttachment.Data $this$readAncientTablet_u24lambda_u240 = currentData$iv = AfflictionPlayerAttachment.getData(player$iv);
        boolean bl = false;
        AfflictionPlayerAttachment.Data newData$iv = $this$readAncientTablet_u24lambda_u240.addReadTablet(tabletId);
        AfflictionPlayerAttachment.setData(player$iv, newData$iv, false);
        if (player$iv.level() instanceof ServerLevel) {
            AfflictionPlayerAttachment.syncSmart(player$iv, newData$iv);
        }
        AfflictionPlayerAttachment.Data newData = newData$iv;
        int tabletsRead = newData.getReadTablets().size();
        player.sendSystemMessage((Component)Component.literal((String)("Ancient knowledge gained... (" + tabletsRead + "/3 tablets read)")));
        return true;
    }

    public final void updateModifiers(@NotNull Player player, int level) {
        block7: {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            AttributeInstance attributeInstance = player.getAttributes().getInstance(Attributes.MAX_HEALTH);
            if (attributeInstance != null) {
                attributeInstance.removeModifier(SOUL_DRAIN_WEAKNESS);
            }
            AttributeInstance attributeInstance2 = player.getAttributes().getInstance(Attributes.MAX_HEALTH);
            if (attributeInstance2 != null) {
                attributeInstance2.removeModifier(LICH_HEALTH_BONUS);
            }
            AttributeInstance attributeInstance3 = player.getAttributes().getInstance(Attributes.ARMOR);
            if (attributeInstance3 != null) {
                attributeInstance3.removeModifier(LICH_ARMOR_BONUS);
            }
            if (level >= 3) {
                AttributeInstance attributeInstance4 = player.getAttributes().getInstance(Attributes.MAX_HEALTH);
                if (attributeInstance4 != null) {
                    attributeInstance4.addPermanentModifier(SOUL_DRAIN_WEAKNESS);
                }
            }
            if (level < 10) break block7;
            AttributeInstance attributeInstance5 = player.getAttributes().getInstance(Attributes.MAX_HEALTH);
            if (attributeInstance5 != null) {
                attributeInstance5.addPermanentModifier(LICH_HEALTH_BONUS);
            }
            AttributeInstance attributeInstance6 = player.getAttributes().getInstance(Attributes.ARMOR);
            if (attributeInstance6 != null) {
                attributeInstance6.addPermanentModifier(LICH_ARMOR_BONUS);
            }
        }
    }

    private final void checkAndLevelUp(ServerPlayer player, AfflictionPlayerAttachment.Data data2) {
        int currentLevel = data2.getLichLevel();
        int nextLevel = currentLevel + 1;
        if (nextLevel <= 10 && this.canLevelUp(player, data2, nextLevel)) {
            LichdomLeveling.increaseNecromancerLevel(player);
        }
    }

    @NotNull
    public final Map<Integer, Requirement> getLEVEL_REQUIREMENTS() {
        return LEVEL_REQUIREMENTS;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean canLevelUp(ServerPlayer player, AfflictionPlayerAttachment.Data data2, int targetLevel) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        boolean bl5;
        boolean bl6;
        boolean bl7;
        boolean bl8;
        boolean bl9;
        int it;
        if (targetLevel > 10) {
            return false;
        }
        if (targetLevel == 1) {
            return true;
        }
        Requirement requirement = LEVEL_REQUIREMENTS.get(targetLevel);
        if (requirement == null) {
            return false;
        }
        Requirement requirement2 = requirement;
        Integer n = requirement2.getTabletTier();
        if (n != null) {
            it = ((Number)n).intValue();
            boolean bl10 = false;
            bl9 = INSTANCE.hasTabletKnowledge(player, it);
        } else {
            bl9 = true;
        }
        if (!bl9) return false;
        Integer n2 = requirement2.getBoundSouls();
        if (n2 != null) {
            it = ((Number)n2).intValue();
            boolean bl11 = false;
            if (data2.getBoundSouls() < it) return false;
            bl8 = true;
        } else {
            bl8 = true;
        }
        if (!bl8) return false;
        Boolean bl12 = requirement2.getZombieKilledMob();
        if (bl12 != null) {
            it = bl12.booleanValue() ? 1 : 0;
            boolean bl13 = false;
            bl7 = data2.hasZombieKilledMob();
        } else {
            bl7 = true;
        }
        if (!bl7) return false;
        Integer n3 = requirement2.getKilledGolems();
        if (n3 != null) {
            it = ((Number)n3).intValue();
            boolean bl14 = false;
            if (data2.getKilledGolems() < it) return false;
            bl6 = true;
        } else {
            bl6 = true;
        }
        if (!bl6) return false;
        Integer n4 = requirement2.getDrainedAnimals();
        if (n4 != null) {
            it = ((Number)n4).intValue();
            boolean bl15 = false;
            if (data2.getDrainedAnimals() < it) return false;
            bl5 = true;
        } else {
            bl5 = true;
        }
        if (!bl5) return false;
        Boolean bl16 = requirement2.getPossessedKillVillager();
        if (bl16 != null) {
            it = bl16.booleanValue() ? 1 : 0;
            boolean bl17 = false;
            bl4 = data2.hasPossessedKillVillager();
        } else {
            bl4 = true;
        }
        if (!bl4) return false;
        Boolean bl18 = requirement2.getKilledWither();
        if (bl18 != null) {
            it = bl18.booleanValue() ? 1 : 0;
            boolean bl19 = false;
            bl3 = data2.hasKilledWither();
        } else {
            bl3 = true;
        }
        if (!bl3) return false;
        Boolean bl20 = requirement2.getPhylacteryBound();
        if (bl20 != null) {
            it = bl20.booleanValue() ? 1 : 0;
            boolean bl21 = false;
            bl2 = data2.isPhylacteryBound();
        } else {
            bl2 = true;
        }
        if (!bl2) return false;
        Integer n5 = requirement2.getPhylacteryDeaths();
        if (n5 != null) {
            it = ((Number)n5).intValue();
            boolean bl22 = false;
            if (data2.getPhylacteryDeaths() < it) return false;
            bl = true;
        } else {
            bl = true;
        }
        if (!bl) return false;
        Integer n6 = requirement2.getPhylacteryDeathsInHour();
        if (n6 == null) return true;
        it = ((Number)n6).intValue();
        boolean bl23 = false;
        if (data2.getPhylacteryDeaths() < it) return false;
        return true;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)2, (Object)new Requirement(1, 1, null, null, null, null, null, null, null, null, 1020, null)), TuplesKt.to((Object)3, (Object)new Requirement(1, null, true, null, null, null, null, null, null, null, 1018, null)), TuplesKt.to((Object)4, (Object)new Requirement(1, null, null, 5, null, null, null, null, null, null, 1014, null)), TuplesKt.to((Object)5, (Object)new Requirement(1, 3, null, null, null, null, null, null, null, null, 1020, null)), TuplesKt.to((Object)6, (Object)new Requirement(2, null, null, null, 5, null, null, null, null, null, 1006, null)), TuplesKt.to((Object)7, (Object)new Requirement(2, null, null, null, null, true, null, null, null, null, 990, null)), TuplesKt.to((Object)8, (Object)new Requirement(2, null, null, null, null, null, true, null, null, null, 958, null)), TuplesKt.to((Object)9, (Object)new Requirement(3, null, null, null, null, null, null, true, 1, null, 638, null)), TuplesKt.to((Object)10, (Object)new Requirement(3, null, null, null, null, null, null, null, null, 3, 510, null))};
        LEVEL_REQUIREMENTS = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b'\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u007f\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010\u001f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010 \u001a\u0004\u0018\u00010\u0006H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0015J\u0010\u0010!\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010\"\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010#\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0015J\u0010\u0010$\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0015J\u0010\u0010%\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0015J\u0010\u0010&\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010'\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0011J\u0086\u0001\u0010(\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010)J\u0013\u0010*\u001a\u00020\u00062\b\u0010+\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010,\u001a\u00020\u0003H\u00d6\u0001J\t\u0010-\u001a\u00020.H\u00d6\u0001R\u0015\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\u0012\u001a\u0004\b\u0010\u0010\u0011R\u0015\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\u0012\u001a\u0004\b\u0013\u0010\u0011R\u0015\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\n\n\u0002\u0010\u0016\u001a\u0004\b\u0014\u0010\u0015R\u0015\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\u0012\u001a\u0004\b\u0017\u0010\u0011R\u0015\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\u0012\u001a\u0004\b\u0018\u0010\u0011R\u0015\u0010\t\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\n\n\u0002\u0010\u0016\u001a\u0004\b\u0019\u0010\u0015R\u0015\u0010\n\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\n\n\u0002\u0010\u0016\u001a\u0004\b\u001a\u0010\u0015R\u0015\u0010\u000b\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\n\n\u0002\u0010\u0016\u001a\u0004\b\u001b\u0010\u0015R\u0015\u0010\f\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\u0012\u001a\u0004\b\u001c\u0010\u0011R\u0015\u0010\r\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\u0012\u001a\u0004\b\u001d\u0010\u0011\u00a8\u0006/"}, d2={"Ldev/sterner/witchery/features/affliction/lich/LichdomLeveling$Requirement;", "", "tabletTier", "", "boundSouls", "zombieKilledMob", "", "killedGolems", "drainedAnimals", "possessedKillVillager", "killedWither", "phylacteryBound", "phylacteryDeaths", "phylacteryDeathsInHour", "<init>", "(Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Boolean;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Boolean;Ljava/lang/Boolean;Ljava/lang/Boolean;Ljava/lang/Integer;Ljava/lang/Integer;)V", "getTabletTier", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getBoundSouls", "getZombieKilledMob", "()Ljava/lang/Boolean;", "Ljava/lang/Boolean;", "getKilledGolems", "getDrainedAnimals", "getPossessedKillVillager", "getKilledWither", "getPhylacteryBound", "getPhylacteryDeaths", "getPhylacteryDeathsInHour", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "component10", "copy", "(Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Boolean;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Boolean;Ljava/lang/Boolean;Ljava/lang/Boolean;Ljava/lang/Integer;Ljava/lang/Integer;)Ldev/sterner/witchery/features/affliction/lich/LichdomLeveling$Requirement;", "equals", "other", "hashCode", "toString", "", "witchery"})
    public static final class Requirement {
        @Nullable
        private final Integer tabletTier;
        @Nullable
        private final Integer boundSouls;
        @Nullable
        private final Boolean zombieKilledMob;
        @Nullable
        private final Integer killedGolems;
        @Nullable
        private final Integer drainedAnimals;
        @Nullable
        private final Boolean possessedKillVillager;
        @Nullable
        private final Boolean killedWither;
        @Nullable
        private final Boolean phylacteryBound;
        @Nullable
        private final Integer phylacteryDeaths;
        @Nullable
        private final Integer phylacteryDeathsInHour;

        public Requirement(@Nullable Integer tabletTier, @Nullable Integer boundSouls, @Nullable Boolean zombieKilledMob, @Nullable Integer killedGolems, @Nullable Integer drainedAnimals, @Nullable Boolean possessedKillVillager, @Nullable Boolean killedWither, @Nullable Boolean phylacteryBound, @Nullable Integer phylacteryDeaths, @Nullable Integer phylacteryDeathsInHour) {
            this.tabletTier = tabletTier;
            this.boundSouls = boundSouls;
            this.zombieKilledMob = zombieKilledMob;
            this.killedGolems = killedGolems;
            this.drainedAnimals = drainedAnimals;
            this.possessedKillVillager = possessedKillVillager;
            this.killedWither = killedWither;
            this.phylacteryBound = phylacteryBound;
            this.phylacteryDeaths = phylacteryDeaths;
            this.phylacteryDeathsInHour = phylacteryDeathsInHour;
        }

        public /* synthetic */ Requirement(Integer n, Integer n2, Boolean bl, Integer n3, Integer n4, Boolean bl2, Boolean bl3, Boolean bl4, Integer n5, Integer n6, int n7, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n7 & 1) != 0) {
                n = null;
            }
            if ((n7 & 2) != 0) {
                n2 = null;
            }
            if ((n7 & 4) != 0) {
                bl = null;
            }
            if ((n7 & 8) != 0) {
                n3 = null;
            }
            if ((n7 & 0x10) != 0) {
                n4 = null;
            }
            if ((n7 & 0x20) != 0) {
                bl2 = null;
            }
            if ((n7 & 0x40) != 0) {
                bl3 = null;
            }
            if ((n7 & 0x80) != 0) {
                bl4 = null;
            }
            if ((n7 & 0x100) != 0) {
                n5 = null;
            }
            if ((n7 & 0x200) != 0) {
                n6 = null;
            }
            this(n, n2, bl, n3, n4, bl2, bl3, bl4, n5, n6);
        }

        @Nullable
        public final Integer getTabletTier() {
            return this.tabletTier;
        }

        @Nullable
        public final Integer getBoundSouls() {
            return this.boundSouls;
        }

        @Nullable
        public final Boolean getZombieKilledMob() {
            return this.zombieKilledMob;
        }

        @Nullable
        public final Integer getKilledGolems() {
            return this.killedGolems;
        }

        @Nullable
        public final Integer getDrainedAnimals() {
            return this.drainedAnimals;
        }

        @Nullable
        public final Boolean getPossessedKillVillager() {
            return this.possessedKillVillager;
        }

        @Nullable
        public final Boolean getKilledWither() {
            return this.killedWither;
        }

        @Nullable
        public final Boolean getPhylacteryBound() {
            return this.phylacteryBound;
        }

        @Nullable
        public final Integer getPhylacteryDeaths() {
            return this.phylacteryDeaths;
        }

        @Nullable
        public final Integer getPhylacteryDeathsInHour() {
            return this.phylacteryDeathsInHour;
        }

        @Nullable
        public final Integer component1() {
            return this.tabletTier;
        }

        @Nullable
        public final Integer component2() {
            return this.boundSouls;
        }

        @Nullable
        public final Boolean component3() {
            return this.zombieKilledMob;
        }

        @Nullable
        public final Integer component4() {
            return this.killedGolems;
        }

        @Nullable
        public final Integer component5() {
            return this.drainedAnimals;
        }

        @Nullable
        public final Boolean component6() {
            return this.possessedKillVillager;
        }

        @Nullable
        public final Boolean component7() {
            return this.killedWither;
        }

        @Nullable
        public final Boolean component8() {
            return this.phylacteryBound;
        }

        @Nullable
        public final Integer component9() {
            return this.phylacteryDeaths;
        }

        @Nullable
        public final Integer component10() {
            return this.phylacteryDeathsInHour;
        }

        @NotNull
        public final Requirement copy(@Nullable Integer tabletTier, @Nullable Integer boundSouls, @Nullable Boolean zombieKilledMob, @Nullable Integer killedGolems, @Nullable Integer drainedAnimals, @Nullable Boolean possessedKillVillager, @Nullable Boolean killedWither, @Nullable Boolean phylacteryBound, @Nullable Integer phylacteryDeaths, @Nullable Integer phylacteryDeathsInHour) {
            return new Requirement(tabletTier, boundSouls, zombieKilledMob, killedGolems, drainedAnimals, possessedKillVillager, killedWither, phylacteryBound, phylacteryDeaths, phylacteryDeathsInHour);
        }

        public static /* synthetic */ Requirement copy$default(Requirement requirement, Integer n, Integer n2, Boolean bl, Integer n3, Integer n4, Boolean bl2, Boolean bl3, Boolean bl4, Integer n5, Integer n6, int n7, Object object) {
            if ((n7 & 1) != 0) {
                n = requirement.tabletTier;
            }
            if ((n7 & 2) != 0) {
                n2 = requirement.boundSouls;
            }
            if ((n7 & 4) != 0) {
                bl = requirement.zombieKilledMob;
            }
            if ((n7 & 8) != 0) {
                n3 = requirement.killedGolems;
            }
            if ((n7 & 0x10) != 0) {
                n4 = requirement.drainedAnimals;
            }
            if ((n7 & 0x20) != 0) {
                bl2 = requirement.possessedKillVillager;
            }
            if ((n7 & 0x40) != 0) {
                bl3 = requirement.killedWither;
            }
            if ((n7 & 0x80) != 0) {
                bl4 = requirement.phylacteryBound;
            }
            if ((n7 & 0x100) != 0) {
                n5 = requirement.phylacteryDeaths;
            }
            if ((n7 & 0x200) != 0) {
                n6 = requirement.phylacteryDeathsInHour;
            }
            return requirement.copy(n, n2, bl, n3, n4, bl2, bl3, bl4, n5, n6);
        }

        @NotNull
        public String toString() {
            return "Requirement(tabletTier=" + this.tabletTier + ", boundSouls=" + this.boundSouls + ", zombieKilledMob=" + this.zombieKilledMob + ", killedGolems=" + this.killedGolems + ", drainedAnimals=" + this.drainedAnimals + ", possessedKillVillager=" + this.possessedKillVillager + ", killedWither=" + this.killedWither + ", phylacteryBound=" + this.phylacteryBound + ", phylacteryDeaths=" + this.phylacteryDeaths + ", phylacteryDeathsInHour=" + this.phylacteryDeathsInHour + ")";
        }

        public int hashCode() {
            int result = this.tabletTier == null ? 0 : ((Object)this.tabletTier).hashCode();
            result = result * 31 + (this.boundSouls == null ? 0 : ((Object)this.boundSouls).hashCode());
            result = result * 31 + (this.zombieKilledMob == null ? 0 : ((Object)this.zombieKilledMob).hashCode());
            result = result * 31 + (this.killedGolems == null ? 0 : ((Object)this.killedGolems).hashCode());
            result = result * 31 + (this.drainedAnimals == null ? 0 : ((Object)this.drainedAnimals).hashCode());
            result = result * 31 + (this.possessedKillVillager == null ? 0 : ((Object)this.possessedKillVillager).hashCode());
            result = result * 31 + (this.killedWither == null ? 0 : ((Object)this.killedWither).hashCode());
            result = result * 31 + (this.phylacteryBound == null ? 0 : ((Object)this.phylacteryBound).hashCode());
            result = result * 31 + (this.phylacteryDeaths == null ? 0 : ((Object)this.phylacteryDeaths).hashCode());
            result = result * 31 + (this.phylacteryDeathsInHour == null ? 0 : ((Object)this.phylacteryDeathsInHour).hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Requirement)) {
                return false;
            }
            Requirement requirement = (Requirement)other;
            if (!Intrinsics.areEqual((Object)this.tabletTier, (Object)requirement.tabletTier)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.boundSouls, (Object)requirement.boundSouls)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.zombieKilledMob, (Object)requirement.zombieKilledMob)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.killedGolems, (Object)requirement.killedGolems)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.drainedAnimals, (Object)requirement.drainedAnimals)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.possessedKillVillager, (Object)requirement.possessedKillVillager)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.killedWither, (Object)requirement.killedWither)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.phylacteryBound, (Object)requirement.phylacteryBound)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.phylacteryDeaths, (Object)requirement.phylacteryDeaths)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.phylacteryDeathsInHour, (Object)requirement.phylacteryDeathsInHour);
        }

        public Requirement() {
            this(null, null, null, null, null, null, null, null, null, null, 1023, null);
        }
    }
}

