/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.features.familiar;

import dev.sterner.witchery.content.entity.OwlEntity;
import dev.sterner.witchery.features.familiar.FamiliarLevelAttachment;
import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\tJ\u001e\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011J\u001c\u0010\u0012\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00132\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007J\u001a\u0010\u0014\u001a\u00020\u000b2\b\u0010\u0015\u001a\u0004\u0018\u00010\t2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017\u00a8\u0006\u0018"}, d2={"Ldev/sterner/witchery/features/familiar/FamiliarHandler;", "", "<init>", "()V", "isBound", "", "level", "Lnet/minecraft/server/level/ServerLevel;", "entity", "Lnet/minecraft/world/entity/LivingEntity;", "bindOwnerAndFamiliar", "", "playerUUID", "Ljava/util/UUID;", "familiar", "resurrectDeadFamiliar", "blockPos", "Lnet/minecraft/core/BlockPos;", "getFamiliarEntityType", "Lnet/minecraft/world/entity/EntityType;", "familiarDeath", "livingEntity", "damageSource", "Lnet/minecraft/world/damagesource/DamageSource;", "witchery"})
@SourceDebugExtension(value={"SMAP\nFamiliarHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FamiliarHandler.kt\ndev/sterner/witchery/features/familiar/FamiliarHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,116:1\n1761#2,3:117\n1#3:120\n*S KotlinDebug\n*F\n+ 1 FamiliarHandler.kt\ndev/sterner/witchery/features/familiar/FamiliarHandler\n*L\n21#1:117,3\n*E\n"})
public final class FamiliarHandler {
    @NotNull
    public static final FamiliarHandler INSTANCE = new FamiliarHandler();

    private FamiliarHandler() {
    }

    public final boolean isBound(@NotNull ServerLevel level, @NotNull LivingEntity entity) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            Iterable $this$any$iv = FamiliarLevelAttachment.getData(level).getFamiliarList();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FamiliarLevelAttachment.FamiliarData it = (FamiliarLevelAttachment.FamiliarData)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getFamiliar(), (Object)entity.getUUID())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final void bindOwnerAndFamiliar(@NotNull ServerLevel level, @NotNull UUID playerUUID, @NotNull LivingEntity familiar) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)playerUUID, (String)"playerUUID");
        Intrinsics.checkNotNullParameter((Object)familiar, (String)"familiar");
        FamiliarLevelAttachment.Data oldData = FamiliarLevelAttachment.getData(level);
        Set updatedFamiliarSet = CollectionsKt.toMutableSet((Iterable)oldData.getFamiliarList());
        updatedFamiliarSet.removeIf(arg_0 -> FamiliarHandler.bindOwnerAndFamiliar$lambda$1(arg_0 -> FamiliarHandler.bindOwnerAndFamiliar$lambda$0(playerUUID, arg_0), arg_0));
        CompoundTag tag = new CompoundTag();
        familiar.saveAsPassenger(tag);
        UUID uUID = familiar.getUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        updatedFamiliarSet.add(new FamiliarLevelAttachment.FamiliarData(playerUUID, uUID, tag, !familiar.isAlive()));
        FamiliarLevelAttachment.setData(level, new FamiliarLevelAttachment.Data(updatedFamiliarSet));
    }

    public final boolean resurrectDeadFamiliar(@NotNull ServerLevel level, @NotNull UUID playerUUID, @NotNull BlockPos blockPos) {
        Object v0;
        FamiliarLevelAttachment.Data data2;
        block4: {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)playerUUID, (String)"playerUUID");
            Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
            data2 = FamiliarLevelAttachment.getData(level);
            Iterable iterable = data2.getFamiliarList();
            for (Object t : iterable) {
                FamiliarLevelAttachment.FamiliarData it = (FamiliarLevelAttachment.FamiliarData)t;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)it.getOwner(), (Object)playerUUID) && it.getDead())) continue;
                v0 = t;
                break block4;
            }
            v0 = null;
        }
        FamiliarLevelAttachment.FamiliarData familiarData = v0;
        if (familiarData != null) {
            CompoundTag entityTag = familiarData.getEntityTag();
            if (!entityTag.contains("id")) {
                return false;
            }
            Entity resurrectedFamiliar = EntityType.loadEntityRecursive((CompoundTag)entityTag, (Level)((Level)level), arg_0 -> FamiliarHandler.resurrectDeadFamiliar$lambda$1(blockPos, arg_0));
            if (resurrectedFamiliar != null) {
                level.addFreshEntity(resurrectedFamiliar);
                Set updatedFamiliarSet = CollectionsKt.toMutableSet((Iterable)data2.getFamiliarList());
                updatedFamiliarSet.remove(familiarData);
                updatedFamiliarSet.add(FamiliarLevelAttachment.FamiliarData.copy$default(familiarData, null, null, null, false, 7, null));
                FamiliarLevelAttachment.setData(level, new FamiliarLevelAttachment.Data(updatedFamiliarSet));
                return true;
            }
        }
        return false;
    }

    @Nullable
    public final EntityType<?> getFamiliarEntityType(@NotNull UUID playerUUID, @NotNull ServerLevel level) {
        Object v0;
        block5: {
            Intrinsics.checkNotNullParameter((Object)playerUUID, (String)"playerUUID");
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Iterable iterable = FamiliarLevelAttachment.getData(level).getFamiliarList();
            for (Object t : iterable) {
                FamiliarLevelAttachment.FamiliarData it = (FamiliarLevelAttachment.FamiliarData)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getOwner(), (Object)playerUUID)) continue;
                v0 = t;
                break block5;
            }
            v0 = null;
        }
        FamiliarLevelAttachment.FamiliarData familiarData = v0;
        if (familiarData != null) {
            EntityType entityType;
            FamiliarLevelAttachment.FamiliarData familiar = familiarData;
            boolean bl = false;
            if (familiar.getDead()) {
                return null;
            }
            Entity familiarEntity = level.getEntity(familiar.getFamiliar());
            if (familiarEntity instanceof LivingEntity) {
                EntityType entityType2 = ((LivingEntity)familiarEntity).getType();
                entityType = entityType2;
                Intrinsics.checkNotNull((Object)entityType2, (String)"null cannot be cast to non-null type net.minecraft.world.entity.EntityType<*>");
            } else {
                entityType = null;
            }
            return entityType;
        }
        return null;
    }

    public final void familiarDeath(@Nullable LivingEntity livingEntity, @Nullable DamageSource damageSource) {
        block4: {
            Object v1;
            FamiliarLevelAttachment.Data data2;
            ServerLevel level;
            block3: {
                if (!(livingEntity instanceof OwlEntity) && !(livingEntity instanceof Frog) && !(livingEntity instanceof Cat)) break block4;
                Level level2 = ((Animal)livingEntity).level();
                ServerLevel serverLevel = level2 instanceof ServerLevel ? (ServerLevel)level2 : null;
                if (serverLevel == null) {
                    return;
                }
                level = serverLevel;
                UUID familiarUUID = ((Animal)livingEntity).getUUID();
                data2 = FamiliarLevelAttachment.getData(level);
                Iterable iterable = data2.getFamiliarList();
                for (Object t : iterable) {
                    FamiliarLevelAttachment.FamiliarData it = (FamiliarLevelAttachment.FamiliarData)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getFamiliar(), (Object)familiarUUID)) continue;
                    v1 = t;
                    break block3;
                }
                v1 = null;
            }
            FamiliarLevelAttachment.FamiliarData familiarData = v1;
            if (familiarData != null) {
                FamiliarLevelAttachment.FamiliarData familiarData2 = familiarData;
                boolean bl = false;
                Set updatedFamiliarSet = CollectionsKt.toMutableSet((Iterable)data2.getFamiliarList());
                updatedFamiliarSet.remove(familiarData2);
                updatedFamiliarSet.add(FamiliarLevelAttachment.FamiliarData.copy$default(familiarData2, null, null, null, true, 7, null));
                FamiliarLevelAttachment.setData(level, new FamiliarLevelAttachment.Data(updatedFamiliarSet));
            }
        }
    }

    private static final boolean bindOwnerAndFamiliar$lambda$0(UUID $playerUUID, FamiliarLevelAttachment.FamiliarData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getOwner(), (Object)$playerUUID);
    }

    private static final boolean bindOwnerAndFamiliar$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Entity resurrectDeadFamiliar$lambda$1(BlockPos $blockPos, Entity entity) {
        entity.moveTo((double)$blockPos.getX() + 0.5, (double)$blockPos.getY(), (double)$blockPos.getZ() + 0.5);
        return entity;
    }
}

