/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.features.hunter;

import dev.sterner.witchery.core.registry.WitcheryItems;
import dev.sterner.witchery.features.hunter.HunterArmorParticleEffects;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\tJ\u001d\u0010\u000f\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Ldev/sterner/witchery/features/hunter/HunterArmorDefenseHandler;", "", "<init>", "()V", "POTION_DURATION_REDUCTION", "", "CURSE_DURATION_REDUCTION", "MAGIC_DAMAGE_REDUCTION", "getHunterArmorPieceCount", "", "player", "Lnet/minecraft/world/entity/player/Player;", "getProtectionMultiplier", "reduceCurseDuration", "originalDuration", "getReducedEffectDuration", "effectInstance", "Lnet/minecraft/world/effect/MobEffectInstance;", "(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/effect/MobEffectInstance;)Ljava/lang/Integer;", "witchery"})
public final class HunterArmorDefenseHandler {
    @NotNull
    public static final HunterArmorDefenseHandler INSTANCE = new HunterArmorDefenseHandler();
    private static final float POTION_DURATION_REDUCTION = 0.5f;
    private static final float CURSE_DURATION_REDUCTION = 0.4f;
    public static final float MAGIC_DAMAGE_REDUCTION = 0.25f;

    private HunterArmorDefenseHandler() {
    }

    public final int getHunterArmorPieceCount(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        int count = 0;
        if (Intrinsics.areEqual((Object)player.getItemBySlot(EquipmentSlot.HEAD).getItem(), (Object)WitcheryItems.INSTANCE.getHUNTER_HELMET().get())) {
            ++count;
        }
        if (Intrinsics.areEqual((Object)player.getItemBySlot(EquipmentSlot.CHEST).getItem(), (Object)WitcheryItems.INSTANCE.getHUNTER_CHESTPLATE().get())) {
            ++count;
        }
        if (Intrinsics.areEqual((Object)player.getItemBySlot(EquipmentSlot.LEGS).getItem(), (Object)WitcheryItems.INSTANCE.getHUNTER_LEGGINGS().get())) {
            ++count;
        }
        if (Intrinsics.areEqual((Object)player.getItemBySlot(EquipmentSlot.FEET).getItem(), (Object)WitcheryItems.INSTANCE.getHUNTER_BOOTS().get())) {
            ++count;
        }
        return count;
    }

    public final float getProtectionMultiplier(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        int pieceCount = this.getHunterArmorPieceCount(player);
        return (float)pieceCount * 0.25f * 0.5f;
    }

    public final int reduceCurseDuration(@NotNull Player player, int originalDuration) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        int pieceCount = this.getHunterArmorPieceCount(player);
        if (pieceCount == 0) {
            return originalDuration;
        }
        float multiplier = this.getProtectionMultiplier(player);
        float reduction = 0.4f * multiplier;
        int newDuration = (int)((float)originalDuration * (1.0f - reduction));
        HunterArmorParticleEffects.INSTANCE.spawnProtectionParticles(player, HunterArmorParticleEffects.ProtectionType.CURSE_REDUCTION);
        return RangesKt.coerceAtLeast((int)newDuration, (int)20);
    }

    @Nullable
    public final Integer getReducedEffectDuration(@NotNull Player player, @NotNull MobEffectInstance effectInstance) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)effectInstance, (String)"effectInstance");
        int count = this.getHunterArmorPieceCount(player);
        if (count == 0) {
            return null;
        }
        if (((MobEffect)effectInstance.getEffect().value()).getCategory() == MobEffectCategory.HARMFUL) {
            float durationModifier = 1.0f - (float)count * 0.25f * 0.5f;
            int modifiedDuration = (int)((float)effectInstance.getDuration() * durationModifier);
            if (modifiedDuration < effectInstance.getDuration()) {
                return RangesKt.coerceAtLeast((int)modifiedDuration, (int)1);
            }
        }
        return null;
    }
}

