/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.features.misc;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.sterner.witchery.Witchery;
import dev.sterner.witchery.core.registry.WitcheryDataAttachments;
import dev.sterner.witchery.network.SyncInventoryLockS2CPayload;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001eB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0005H\u0007J\u0016\u0010\u000b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0005J\u000e\u0010\f\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u000b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\rJ\u0016\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010J\u0016\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010J\u001c\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u0014J\u001c\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u0014J\u0016\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010J\u0018\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u000e\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001d\u00a8\u0006\u001f"}, d2={"Ldev/sterner/witchery/features/misc/InventoryLockPlayerAttachment;", "", "<init>", "()V", "getData", "Ldev/sterner/witchery/features/misc/InventoryLockPlayerAttachment$Data;", "player", "Lnet/minecraft/world/entity/player/Player;", "setData", "", "data", "sync", "unlockAllSlots", "Lnet/minecraft/server/level/ServerPlayer;", "lockSlot", "slot", "", "unlockSlot", "unlockSlots", "slots", "", "lockSlots", "isSlotLocked", "", "dropItemFromSlot", "blockPlaceEvent", "event", "Lnet/neoforged/neoforge/event/level/BlockEvent$EntityPlaceEvent;", "blockBreakEvent", "Lnet/neoforged/neoforge/event/level/BlockEvent$BreakEvent;", "Data", "witchery"})
@SourceDebugExtension(value={"SMAP\nInventoryLockPlayerAttachment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InventoryLockPlayerAttachment.kt\ndev/sterner/witchery/features/misc/InventoryLockPlayerAttachment\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,132:1\n1#2:133\n1869#3,2:134\n*S KotlinDebug\n*F\n+ 1 InventoryLockPlayerAttachment.kt\ndev/sterner/witchery/features/misc/InventoryLockPlayerAttachment\n*L\n74#1:134,2\n*E\n"})
public final class InventoryLockPlayerAttachment {
    @NotNull
    public static final InventoryLockPlayerAttachment INSTANCE = new InventoryLockPlayerAttachment();

    private InventoryLockPlayerAttachment() {
    }

    @JvmStatic
    @NotNull
    public static final Data getData(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Object object = player.getData(WitcheryDataAttachments.getINVENTORY_KEEPER_DATA_ATTACHMENT());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getData(...)");
        return (Data)object;
    }

    @JvmStatic
    public static final void setData(@NotNull Player player, @NotNull Data data2) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        player.setData(WitcheryDataAttachments.getINVENTORY_KEEPER_DATA_ATTACHMENT(), (Object)data2);
        INSTANCE.sync(player, data2);
    }

    public final void sync(@NotNull Player player, @NotNull Data data2) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        if (player instanceof ServerPlayer) {
            PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new SyncInventoryLockS2CPayload(player, data2), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public final void unlockAllSlots(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        InventoryLockPlayerAttachment.setData(player, new Data(SetsKt.emptySet()));
    }

    public final void sync(@NotNull ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Data data2 = InventoryLockPlayerAttachment.getData((Player)player);
        this.sync((Player)player, data2);
    }

    public final void lockSlot(@NotNull Player player, int slot) {
        Set set;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Data data2 = InventoryLockPlayerAttachment.getData(player);
        Set $this$lockSlot_u24lambda_u240 = set = CollectionsKt.toMutableSet((Iterable)data2.getLockedSlots());
        boolean bl = false;
        $this$lockSlot_u24lambda_u240.add(slot);
        Set newLockedSlots = set;
        if (player instanceof ServerPlayer) {
            this.dropItemFromSlot((ServerPlayer)player, slot);
        }
        InventoryLockPlayerAttachment.setData(player, data2.copy(newLockedSlots));
    }

    public final void unlockSlot(@NotNull Player player, int slot) {
        Set set;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Data data2 = InventoryLockPlayerAttachment.getData(player);
        Set $this$unlockSlot_u24lambda_u240 = set = CollectionsKt.toMutableSet((Iterable)data2.getLockedSlots());
        boolean bl = false;
        $this$unlockSlot_u24lambda_u240.remove(slot);
        Set newLockedSlots = set;
        InventoryLockPlayerAttachment.setData(player, data2.copy(newLockedSlots));
    }

    public final void unlockSlots(@NotNull Player player, @NotNull Set<Integer> slots) {
        Set set;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter(slots, (String)"slots");
        Data data2 = InventoryLockPlayerAttachment.getData(player);
        Set $this$unlockSlots_u24lambda_u240 = set = CollectionsKt.toMutableSet((Iterable)data2.getLockedSlots());
        boolean bl = false;
        $this$unlockSlots_u24lambda_u240.removeAll((Collection)slots);
        Set newLockedSlots = set;
        InventoryLockPlayerAttachment.setData(player, data2.copy(newLockedSlots));
    }

    public final void lockSlots(@NotNull Player player, @NotNull Set<Integer> slots) {
        Set set;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter(slots, (String)"slots");
        Data data2 = InventoryLockPlayerAttachment.getData(player);
        Set $this$lockSlots_u24lambda_u240 = set = CollectionsKt.toMutableSet((Iterable)data2.getLockedSlots());
        boolean bl = false;
        $this$lockSlots_u24lambda_u240.addAll((Collection)slots);
        Set newLockedSlots = set;
        if (player instanceof ServerPlayer && !((ServerPlayer)player).serverLevel().getGameRules().getBoolean(GameRules.RULE_KEEPINVENTORY)) {
            Iterable $this$forEach$iv = slots;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                int slot = ((Number)element$iv).intValue();
                boolean bl2 = false;
                if (data2.getLockedSlots().contains(slot)) continue;
                INSTANCE.dropItemFromSlot((ServerPlayer)player, slot);
            }
        }
        InventoryLockPlayerAttachment.setData(player, data2.copy(newLockedSlots));
    }

    public final boolean isSlotLocked(@NotNull Player player, int slot) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return InventoryLockPlayerAttachment.getData(player).getLockedSlots().contains(slot);
    }

    private final void dropItemFromSlot(ServerPlayer player, int slot) {
        ItemStack item = player.getInventory().getItem(slot);
        if (!item.isEmpty()) {
            player.drop(item.copy(), false);
            player.getInventory().setItem(slot, ItemStack.EMPTY);
        }
    }

    public final void blockPlaceEvent(@NotNull BlockEvent.EntityPlaceEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Entity entity = event.getEntity();
        Player player = entity instanceof Player ? (Player)entity : null;
        if (player == null) {
            return;
        }
        Player player2 = player;
        Data data2 = InventoryLockPlayerAttachment.getData(player2);
        int selected = player2.getInventory().selected;
        if (data2.getLockedSlots().contains(selected)) {
            event.setCanceled(true);
        }
    }

    public final void blockBreakEvent(@NotNull BlockEvent.BreakEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Player player = event.getPlayer();
        if (player == null) {
            return;
        }
        Player player2 = player;
        Data data2 = InventoryLockPlayerAttachment.getData(player2);
        int selected = player2.getInventory().selected;
        if (data2.getLockedSlots().contains(selected)) {
            event.setCanceled(true);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0017\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\n\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u0004H\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"Ldev/sterner/witchery/features/misc/InventoryLockPlayerAttachment$Data;", "", "lockedSlots", "", "", "<init>", "(Ljava/util/Set;)V", "getLockedSlots", "()Ljava/util/Set;", "component1", "copy", "equals", "", "other", "hashCode", "toString", "", "Companion", "witchery"})
    public static final class Data {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Set<Integer> lockedSlots;
        @NotNull
        private static final Codec<Data> CODEC;
        @NotNull
        private static final ResourceLocation ID;

        public Data(@NotNull Set<Integer> lockedSlots) {
            Intrinsics.checkNotNullParameter(lockedSlots, (String)"lockedSlots");
            this.lockedSlots = lockedSlots;
        }

        public /* synthetic */ Data(Set set, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                set = SetsKt.emptySet();
            }
            this(set);
        }

        @NotNull
        public final Set<Integer> getLockedSlots() {
            return this.lockedSlots;
        }

        @NotNull
        public final Set<Integer> component1() {
            return this.lockedSlots;
        }

        @NotNull
        public final Data copy(@NotNull Set<Integer> lockedSlots) {
            Intrinsics.checkNotNullParameter(lockedSlots, (String)"lockedSlots");
            return new Data(lockedSlots);
        }

        public static /* synthetic */ Data copy$default(Data data2, Set set, int n, Object object) {
            if ((n & 1) != 0) {
                set = data2.lockedSlots;
            }
            return data2.copy(set);
        }

        @NotNull
        public String toString() {
            return "Data(lockedSlots=" + this.lockedSlots + ")";
        }

        public int hashCode() {
            return ((Object)this.lockedSlots).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Data)) {
                return false;
            }
            Data data2 = (Data)other;
            return Intrinsics.areEqual(this.lockedSlots, data2.lockedSlots);
        }

        private static final App CODEC$lambda$0(RecordCodecBuilder.Instance instance) {
            return instance.group((App)Codec.INT.listOf().xmap(arg_0 -> Data.CODEC$lambda$0$1(Data::CODEC$lambda$0$0, arg_0), arg_0 -> Data.CODEC$lambda$0$3(Data::CODEC$lambda$0$2, arg_0)).fieldOf("lockedSlots").forGetter(Data::CODEC$lambda$0$4)).apply((Applicative)instance, Data::new);
        }

        private static final Set CODEC$lambda$0$0(List it) {
            Intrinsics.checkNotNull((Object)it);
            return CollectionsKt.toSet((Iterable)it);
        }

        private static final Set CODEC$lambda$0$1(Function1 $tmp0, Object p0) {
            return (Set)$tmp0.invoke(p0);
        }

        private static final List CODEC$lambda$0$2(Set it) {
            Intrinsics.checkNotNull((Object)it);
            return CollectionsKt.toList((Iterable)it);
        }

        private static final List CODEC$lambda$0$3(Function1 $tmp0, Object p0) {
            return (List)$tmp0.invoke(p0);
        }

        private static final Set CODEC$lambda$0$4(Data it) {
            return it.lockedSlots;
        }

        public Data() {
            this(null, 1, null);
        }

        static {
            Codec codec = RecordCodecBuilder.create(Data::CODEC$lambda$0);
            Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"create(...)");
            CODEC = codec;
            ResourceLocation resourceLocation = Witchery.Companion.id("inventory_lock_data");
            Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"id(...)");
            ID = resourceLocation;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Ldev/sterner/witchery/features/misc/InventoryLockPlayerAttachment$Data$Companion;", "", "<init>", "()V", "CODEC", "Lcom/mojang/serialization/Codec;", "Ldev/sterner/witchery/features/misc/InventoryLockPlayerAttachment$Data;", "getCODEC", "()Lcom/mojang/serialization/Codec;", "ID", "Lnet/minecraft/resources/ResourceLocation;", "getID", "()Lnet/minecraft/resources/ResourceLocation;", "witchery"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Codec<Data> getCODEC() {
                return CODEC;
            }

            @NotNull
            public final ResourceLocation getID() {
                return ID;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

