/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.features.necromancy;

import com.klikli_dev.modonomicon.util.Codecs;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.sterner.witchery.Witchery;
import dev.sterner.witchery.core.registry.WitcheryDataAttachments;
import dev.sterner.witchery.network.SyncEtherealS2CPayload;
import java.util.Optional;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\rB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0005H\u0007J\u0016\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0005\u00a8\u0006\u000e"}, d2={"Ldev/sterner/witchery/features/necromancy/EtherealEntityAttachment;", "", "<init>", "()V", "getData", "Ldev/sterner/witchery/features/necromancy/EtherealEntityAttachment$Data;", "livingEntity", "Lnet/minecraft/world/entity/LivingEntity;", "setData", "", "data", "sync", "living", "Data", "witchery"})
public final class EtherealEntityAttachment {
    @NotNull
    public static final EtherealEntityAttachment INSTANCE = new EtherealEntityAttachment();

    private EtherealEntityAttachment() {
    }

    @JvmStatic
    @NotNull
    public static final Data getData(@NotNull LivingEntity livingEntity) {
        Intrinsics.checkNotNullParameter((Object)livingEntity, (String)"livingEntity");
        Object object = livingEntity.getData(WitcheryDataAttachments.getETHEREAL_DATA_ATTACHMENT());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getData(...)");
        return (Data)object;
    }

    @JvmStatic
    public static final void setData(@NotNull LivingEntity livingEntity, @NotNull Data data2) {
        Intrinsics.checkNotNullParameter((Object)livingEntity, (String)"livingEntity");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        livingEntity.setData(WitcheryDataAttachments.getETHEREAL_DATA_ATTACHMENT(), (Object)data2);
        INSTANCE.sync(livingEntity, data2);
    }

    public final void sync(@NotNull LivingEntity living, @NotNull Data data2) {
        Intrinsics.checkNotNullParameter((Object)living, (String)"living");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        if (living.level() instanceof ServerLevel) {
            SyncEtherealS2CPayload packet = new SyncEtherealS2CPayload(living.getId(), data2);
            PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)((Entity)living), (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0013\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB;\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000b\u0010\u0013\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\bH\u00c6\u0003J\t\u0010\u0017\u001a\u00020\bH\u00c6\u0003J=\u0010\u0018\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u00052\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011\u00a8\u0006 "}, d2={"Ldev/sterner/witchery/features/necromancy/EtherealEntityAttachment$Data;", "", "ownerUUID", "Ljava/util/UUID;", "canDropLoot", "", "isEthereal", "summonTime", "", "maxLifeTime", "<init>", "(Ljava/util/UUID;ZZJJ)V", "getOwnerUUID", "()Ljava/util/UUID;", "getCanDropLoot", "()Z", "getSummonTime", "()J", "getMaxLifeTime", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "", "toString", "", "Companion", "witchery"})
    public static final class Data {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private final UUID ownerUUID;
        private final boolean canDropLoot;
        private final boolean isEthereal;
        private final long summonTime;
        private final long maxLifeTime;
        @NotNull
        private static final Codec<Data> CODEC;
        @NotNull
        private static final ResourceLocation ID;

        public Data(@Nullable UUID ownerUUID, boolean canDropLoot, boolean isEthereal, long summonTime, long maxLifeTime) {
            this.ownerUUID = ownerUUID;
            this.canDropLoot = canDropLoot;
            this.isEthereal = isEthereal;
            this.summonTime = summonTime;
            this.maxLifeTime = maxLifeTime;
        }

        public /* synthetic */ Data(UUID uUID, boolean bl, boolean bl2, long l, long l2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                uUID = null;
            }
            if ((n & 2) != 0) {
                bl = true;
            }
            if ((n & 4) != 0) {
                bl2 = false;
            }
            if ((n & 8) != 0) {
                l = 0L;
            }
            if ((n & 0x10) != 0) {
                l2 = 0L;
            }
            this(uUID, bl, bl2, l, l2);
        }

        @Nullable
        public final UUID getOwnerUUID() {
            return this.ownerUUID;
        }

        public final boolean getCanDropLoot() {
            return this.canDropLoot;
        }

        public final boolean isEthereal() {
            return this.isEthereal;
        }

        public final long getSummonTime() {
            return this.summonTime;
        }

        public final long getMaxLifeTime() {
            return this.maxLifeTime;
        }

        @Nullable
        public final UUID component1() {
            return this.ownerUUID;
        }

        public final boolean component2() {
            return this.canDropLoot;
        }

        public final boolean component3() {
            return this.isEthereal;
        }

        public final long component4() {
            return this.summonTime;
        }

        public final long component5() {
            return this.maxLifeTime;
        }

        @NotNull
        public final Data copy(@Nullable UUID ownerUUID, boolean canDropLoot, boolean isEthereal, long summonTime, long maxLifeTime) {
            return new Data(ownerUUID, canDropLoot, isEthereal, summonTime, maxLifeTime);
        }

        public static /* synthetic */ Data copy$default(Data data2, UUID uUID, boolean bl, boolean bl2, long l, long l2, int n, Object object) {
            if ((n & 1) != 0) {
                uUID = data2.ownerUUID;
            }
            if ((n & 2) != 0) {
                bl = data2.canDropLoot;
            }
            if ((n & 4) != 0) {
                bl2 = data2.isEthereal;
            }
            if ((n & 8) != 0) {
                l = data2.summonTime;
            }
            if ((n & 0x10) != 0) {
                l2 = data2.maxLifeTime;
            }
            return data2.copy(uUID, bl, bl2, l, l2);
        }

        @NotNull
        public String toString() {
            return "Data(ownerUUID=" + this.ownerUUID + ", canDropLoot=" + this.canDropLoot + ", isEthereal=" + this.isEthereal + ", summonTime=" + this.summonTime + ", maxLifeTime=" + this.maxLifeTime + ")";
        }

        public int hashCode() {
            int result = this.ownerUUID == null ? 0 : this.ownerUUID.hashCode();
            result = result * 31 + Boolean.hashCode(this.canDropLoot);
            result = result * 31 + Boolean.hashCode(this.isEthereal);
            result = result * 31 + Long.hashCode(this.summonTime);
            result = result * 31 + Long.hashCode(this.maxLifeTime);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Data)) {
                return false;
            }
            Data data2 = (Data)other;
            if (!Intrinsics.areEqual((Object)this.ownerUUID, (Object)data2.ownerUUID)) {
                return false;
            }
            if (this.canDropLoot != data2.canDropLoot) {
                return false;
            }
            if (this.isEthereal != data2.isEthereal) {
                return false;
            }
            if (this.summonTime != data2.summonTime) {
                return false;
            }
            return this.maxLifeTime == data2.maxLifeTime;
        }

        private static final App CODEC$lambda$0(RecordCodecBuilder.Instance instance) {
            return instance.group((App)Codecs.UUID.optionalFieldOf("ownerUUID").forGetter(Data::CODEC$lambda$0$0), (App)Codec.BOOL.fieldOf("canDropLoot").forGetter(Data::CODEC$lambda$0$1), (App)Codec.BOOL.fieldOf("isEthereal").forGetter(Data::CODEC$lambda$0$2), (App)Codec.LONG.fieldOf("summonTime").forGetter(Data::CODEC$lambda$0$3), (App)Codec.LONG.fieldOf("maxLifeTime").forGetter(Data::CODEC$lambda$0$4)).apply((Applicative)instance, Data::CODEC$lambda$0$5);
        }

        private static final Optional CODEC$lambda$0$0(Data it) {
            return Optional.ofNullable(it.ownerUUID);
        }

        private static final Boolean CODEC$lambda$0$1(Data it) {
            return it.canDropLoot;
        }

        private static final Boolean CODEC$lambda$0$2(Data it) {
            return it.isEthereal;
        }

        private static final Long CODEC$lambda$0$3(Data it) {
            return it.summonTime;
        }

        private static final Long CODEC$lambda$0$4(Data it) {
            return it.maxLifeTime;
        }

        private static final Data CODEC$lambda$0$5(Optional ownerUUIDOptional, Boolean canDropLoot, Boolean isEthereal, Long summonTime, Long maxLifeTime) {
            UUID uUID = ownerUUIDOptional.orElse(null);
            Intrinsics.checkNotNull((Object)canDropLoot);
            boolean bl = canDropLoot;
            Intrinsics.checkNotNull((Object)isEthereal);
            boolean bl2 = isEthereal;
            Intrinsics.checkNotNull((Object)summonTime);
            long l = summonTime;
            Intrinsics.checkNotNull((Object)maxLifeTime);
            return new Data(uUID, bl, bl2, l, maxLifeTime);
        }

        public Data() {
            this(null, false, false, 0L, 0L, 31, null);
        }

        static {
            Codec codec = RecordCodecBuilder.create(Data::CODEC$lambda$0);
            Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"create(...)");
            CODEC = codec;
            ResourceLocation resourceLocation = Witchery.Companion.id("ethereal");
            Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"id(...)");
            ID = resourceLocation;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Ldev/sterner/witchery/features/necromancy/EtherealEntityAttachment$Data$Companion;", "", "<init>", "()V", "CODEC", "Lcom/mojang/serialization/Codec;", "Ldev/sterner/witchery/features/necromancy/EtherealEntityAttachment$Data;", "getCODEC", "()Lcom/mojang/serialization/Codec;", "ID", "Lnet/minecraft/resources/ResourceLocation;", "getID", "()Lnet/minecraft/resources/ResourceLocation;", "witchery"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Codec<Data> getCODEC() {
                return CODEC;
            }

            @NotNull
            public final ResourceLocation getID() {
                return ID;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

