/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.features.ritual;

import dev.sterner.witchery.Witchery;
import dev.sterner.witchery.content.block.ritual.GoldenChalkBlockEntity;
import dev.sterner.witchery.core.api.Ritual;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Ldev/sterner/witchery/features/ritual/PullMobsRitual;", "Ldev/sterner/witchery/core/api/Ritual;", "<init>", "()V", "radius", "", "onTickRitual", "", "level", "Lnet/minecraft/world/level/Level;", "pos", "Lnet/minecraft/core/BlockPos;", "goldenChalkBlockEntity", "Ldev/sterner/witchery/content/block/ritual/GoldenChalkBlockEntity;", "witchery"})
public final class PullMobsRitual
extends Ritual {
    private final double radius;

    public PullMobsRitual() {
        ResourceLocation resourceLocation = Witchery.Companion.id("pull_mobs");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"id(...)");
        super(resourceLocation);
        this.radius = 4.0;
    }

    @Override
    public void onTickRitual(@NotNull Level level, @NotNull BlockPos pos, @NotNull GoldenChalkBlockEntity goldenChalkBlockEntity) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)goldenChalkBlockEntity, (String)"goldenChalkBlockEntity");
        List entities = level.getEntitiesOfClass(LivingEntity.class, new AABB((double)pos.getX() - this.radius, (double)pos.getY() - this.radius, (double)pos.getZ() - this.radius, (double)pos.getX() + this.radius, (double)pos.getY() + this.radius, (double)pos.getZ() + this.radius), arg_0 -> PullMobsRitual.onTickRitual$lambda$1(PullMobsRitual::onTickRitual$lambda$0, arg_0));
        Vec3 center = new Vec3((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5);
        for (LivingEntity entity : entities) {
            Vec3 entityPos = entity.position();
            double dx = entityPos.x - center.x;
            double dy = entityPos.y - center.y;
            double dz = entityPos.z - center.z;
            double distance = Math.sqrt(dx * dx + dy * dy + dz * dz);
            if (!(distance > this.radius)) continue;
            double pullStrength = 0.25;
            double pullX = -(dx / distance) * pullStrength;
            double pullY = -(dy / distance) * pullStrength;
            double pullZ = -(dz / distance) * pullStrength;
            entity.setDeltaMovement(entity.getDeltaMovement().add(pullX, pullY, pullZ));
        }
    }

    private static final boolean onTickRitual$lambda$0(LivingEntity it) {
        return it instanceof Enemy;
    }

    private static final boolean onTickRitual$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

