/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.mixin;

import dev.sterner.witchery.core.registry.WitcheryMobEffects;
import dev.sterner.witchery.core.registry.WitcheryTags;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AvoidEntityGoal.class})
public abstract class AvoidEntityGoalMixin<T extends LivingEntity> {
    @Shadow
    @Final
    protected Class<T> avoidClass;
    @Shadow
    @Final
    protected PathfinderMob mob;
    @Shadow
    @Final
    protected float maxDist;
    @Shadow
    @Final
    protected Predicate<LivingEntity> predicateOnAvoidEntity;
    @Shadow
    @Final
    protected Predicate<LivingEntity> avoidPredicate;
    @Shadow
    protected T toAvoid;
    @Shadow
    protected Path path;

    @Inject(method={"canUse"}, at={@At(value="HEAD")}, cancellable=true)
    private void witchery$onCanUse(CallbackInfoReturnable<Boolean> cir) {
        Player grotesquePlayer;
        if (this.avoidClass != Player.class && this.mob.getType().is(WitcheryTags.INSTANCE.getSCARED_BY_GROTESQUE()) && (grotesquePlayer = this.witchery$findNearestGrotesquePlayer()) != null) {
            this.toAvoid = grotesquePlayer;
            Vec3 escapePos = DefaultRandomPos.getPosAway((PathfinderMob)this.mob, (int)16, (int)7, (Vec3)this.toAvoid.position());
            if (escapePos == null) {
                cir.setReturnValue((Object)false);
                return;
            }
            if (this.toAvoid.distanceToSqr(escapePos.x, escapePos.y, escapePos.z) < this.toAvoid.distanceToSqr((Entity)this.mob)) {
                cir.setReturnValue((Object)false);
                return;
            }
            this.path = this.mob.getNavigation().createPath(escapePos.x, escapePos.y, escapePos.z, 0);
            if (this.path != null) {
                cir.setReturnValue((Object)true);
            } else {
                cir.setReturnValue((Object)false);
            }
        }
    }

    @Unique
    private Player witchery$findNearestGrotesquePlayer() {
        Predicate<Player> hasGrotesqueEffect = player -> player.hasEffect(WitcheryMobEffects.INSTANCE.getGROTESQUE());
        Predicate<LivingEntity> combinedPredicate = livingEntity -> {
            if (!(livingEntity instanceof Player)) {
                return false;
            }
            Player player = (Player)livingEntity;
            return hasGrotesqueEffect.test(player) && this.predicateOnAvoidEntity.test((LivingEntity)player) && this.avoidPredicate.test((LivingEntity)player);
        };
        return this.mob.level().getNearestPlayer(TargetingConditions.forCombat().range((double)this.maxDist).selector(combinedPredicate), (LivingEntity)this.mob, this.mob.getX(), this.mob.getY(), this.mob.getZ());
    }
}

