/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.mixin.guardvillagers;

import dev.sterner.witchery.core.api.interfaces.VillagerTransfix;
import dev.sterner.witchery.features.affliction.AfflictionPlayerAttachment;
import dev.sterner.witchery.network.SpawnTransfixParticlesS2CPayload;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import tallestegg.guardvillagers.common.entities.Guard;

@Mixin(value={Guard.class})
public class GuardMixin
extends PathfinderMob
implements VillagerTransfix {
    @Unique
    int witchery$transfixCounter = 0;
    @Unique
    Vec3 witchery$transfixVector = null;
    @Unique
    UUID witchery$mesmerisedUUID = null;
    @Unique
    int witchery$mesmerisedUUIDCounter = 0;

    protected GuardMixin(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"doHurtTarget"}, at={@At(value="HEAD")}, cancellable=true)
    private void witchery$forceVampireAttack(Entity entityIn, CallbackInfoReturnable<Boolean> cir) {
        Player player;
        if (entityIn instanceof Player && AfflictionPlayerAttachment.getData(player = (Player)entityIn).getVampireLevel() > 0) {
            double knockbackStrength;
            Guard guard = (Guard)this;
            float attackDamage = (float)guard.getAttributeValue(Attributes.ATTACK_DAMAGE);
            DamageSource damageSource = guard.damageSources().mobAttack((LivingEntity)guard);
            boolean success = player.hurt(damageSource, attackDamage);
            if (success && (knockbackStrength = guard.getAttributeValue(Attributes.ATTACK_KNOCKBACK)) > 0.0) {
                player.knockback(knockbackStrength * 0.5, Math.sin(guard.getYRot() * ((float)Math.PI / 180)), -Math.cos(guard.getYRot() * ((float)Math.PI / 180)));
            }
            cir.setReturnValue((Object)success);
        }
    }

    @Inject(method={"setTarget"}, at={@At(value="HEAD")}, cancellable=true)
    private void witchery$setTargetForVampires(LivingEntity entity, CallbackInfo ci) {
        Player player;
        if (entity instanceof Player && AfflictionPlayerAttachment.getData(player = (Player)entity).getVampireLevel() > 0) {
            super.setTarget(entity);
            ci.cancel();
        }
    }

    @Unique
    private static boolean witchery$isVampHelper(LivingEntity target) {
        if (!(target instanceof Player)) {
            return false;
        }
        Player player = (Player)target;
        return AfflictionPlayerAttachment.getData(player).getVampireLevel() > 0;
    }

    @Inject(method={"registerGoals"}, at={@At(value="TAIL")})
    private void witchery$registerGoals(CallbackInfo ci) {
        Guard guard = (Guard)this;
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)guard, Player.class, 10, true, false, GuardMixin::witchery$isVampHelper));
    }

    @Inject(method={"canAttack"}, at={@At(value="HEAD")}, cancellable=true)
    private void witchery$canAttackVampires(LivingEntity target, CallbackInfoReturnable<Boolean> cir) {
        Player player;
        if (target instanceof Player && AfflictionPlayerAttachment.getData(player = (Player)target).getVampireLevel() > 0) {
            cir.setReturnValue((Object)true);
        }
    }

    @Override
    public void setTransfixedLookVector(@NotNull Vec3 vec3) {
        this.witchery$transfixVector = vec3;
        this.witchery$transfixCounter = 200;
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void witchery$onTick(CallbackInfo ci) {
        Guard guard = (Guard)this;
        if (!guard.level().isClientSide) {
            if (this.witchery$transfixCounter > 0) {
                if (this.witchery$mesmerisedUUIDCounter <= 0) {
                    guard.getNavigation().stop();
                    guard.getMoveControl().strafe(0.0f, 0.0f);
                }
                guard.getLookControl().setLookAt(this.witchery$transfixVector.x, this.witchery$transfixVector.y, this.witchery$transfixVector.z);
                PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)guard, (CustomPacketPayload)new SpawnTransfixParticlesS2CPayload(guard.position(), this.witchery$transfixCounter < 20), (CustomPacketPayload[])new CustomPacketPayload[0]);
                --this.witchery$transfixCounter;
            } else {
                this.witchery$transfixVector = null;
            }
            if (this.witchery$mesmerisedUUIDCounter > 0) {
                Player player = guard.level().getPlayerByUUID(this.witchery$getMesmerized());
                if (player != null) {
                    guard.getNavigation().moveTo((Entity)player, 1.0);
                }
                --this.witchery$mesmerisedUUIDCounter;
            } else {
                this.witchery$mesmerisedUUID = null;
            }
        }
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void witchery$addAdditionalSaveData(CompoundTag compoundTag, CallbackInfo ci) {
        compoundTag.putInt("WitcheryTransfixCounter", this.witchery$transfixCounter);
        compoundTag.putInt("WitcheryMesmerisedUUIDCounter", this.witchery$mesmerisedUUIDCounter);
        if (this.witchery$transfixVector != null) {
            compoundTag.putDouble("WitcheryTransfixVectorX", this.witchery$transfixVector.x);
            compoundTag.putDouble("WitcheryTransfixVectorY", this.witchery$transfixVector.y);
            compoundTag.putDouble("WitcheryTransfixVectorZ", this.witchery$transfixVector.z);
        }
        if (this.witchery$mesmerisedUUID != null) {
            compoundTag.putUUID("WitcheryMesmerisedUUID", this.witchery$mesmerisedUUID);
        }
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void witchery$readAdditionalSaveData(CompoundTag compoundTag, CallbackInfo ci) {
        this.witchery$transfixCounter = compoundTag.getInt("WitcheryTransfixCounter");
        this.witchery$mesmerisedUUIDCounter = compoundTag.getInt("WitcheryMesmerisedUUIDCounter");
        if (compoundTag.contains("WitcheryTransfixVectorX")) {
            this.witchery$transfixVector = new Vec3(compoundTag.getDouble("WitcheryTransfixVectorX"), compoundTag.getDouble("WitcheryTransfixVectorY"), compoundTag.getDouble("WitcheryTransfixVectorZ"));
        }
        if (compoundTag.contains("WitcheryMesmerisedUUID")) {
            this.witchery$mesmerisedUUID = compoundTag.getUUID("WitcheryMesmerisedUUID");
        }
    }

    @Override
    public boolean witchery$isTransfixed() {
        return this.witchery$transfixCounter > 0;
    }

    @Override
    public void witchery$setMesmerized(@NotNull UUID uuid) {
        this.witchery$mesmerisedUUID = uuid;
        this.witchery$mesmerisedUUIDCounter = 400;
    }

    @Override
    public boolean witchery$isMesmerized() {
        return this.witchery$mesmerisedUUID != null;
    }

    @Override
    @NotNull
    public UUID witchery$getMesmerized() {
        return this.witchery$mesmerisedUUID;
    }
}

