/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.client;

import com.mojang.blaze3d.platform.Window;
import dev.sterner.witchery.content.item.LeonardsUrnItem;
import dev.sterner.witchery.content.item.QuartzSphereItem;
import dev.sterner.witchery.core.registry.WitcheryKeyMappings;
import dev.sterner.witchery.network.SelectUrnPotionC2SPayload;
import java.awt.Color;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\fH\u0002J\u0016\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\tH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Ldev/sterner/witchery/client/UrnPotionSelectionHandler;", "", "<init>", "()V", "isMenuOpen", "", "selectedIndex", "", "animationProgress", "", "ANIMATION_SPEED", "tick", "", "minecraft", "Lnet/minecraft/client/Minecraft;", "onMouseScroll", "delta", "", "openMenu", "player", "Lnet/minecraft/world/entity/player/Player;", "closeMenu", "render", "guiGraphics", "Lnet/minecraft/client/gui/GuiGraphics;", "partialTick", "Lnet/minecraft/client/DeltaTracker;", "easeOutCubic", "t", "witchery"})
public final class UrnPotionSelectionHandler {
    @NotNull
    public static final UrnPotionSelectionHandler INSTANCE = new UrnPotionSelectionHandler();
    private static boolean isMenuOpen;
    private static int selectedIndex;
    private static float animationProgress;
    private static final float ANIMATION_SPEED;

    private UrnPotionSelectionHandler() {
    }

    public final void tick(@NotNull Minecraft minecraft) {
        boolean shouldBeOpen;
        Intrinsics.checkNotNullParameter((Object)minecraft, (String)"minecraft");
        LocalPlayer localPlayer = minecraft.player;
        if (localPlayer == null) {
            return;
        }
        LocalPlayer player = localPlayer;
        ItemStack heldItem = player.getMainHandItem();
        boolean bl = shouldBeOpen = heldItem.getItem() instanceof QuartzSphereItem && LeonardsUrnItem.Companion.hasUrn((Player)player) && WitcheryKeyMappings.INSTANCE.getUTILITY_BUTTON().isDown();
        if (shouldBeOpen && !isMenuOpen) {
            this.openMenu((Player)player);
        } else if (!shouldBeOpen && isMenuOpen) {
            this.closeMenu();
        }
        if (isMenuOpen && animationProgress < 1.0f) {
            animationProgress = Math.min(1.0f, animationProgress + ANIMATION_SPEED);
        } else if (!isMenuOpen && animationProgress > 0.0f) {
            animationProgress = Math.max(0.0f, animationProgress - ANIMATION_SPEED);
        }
    }

    public final boolean onMouseScroll(double delta) {
        if (!isMenuOpen) {
            return false;
        }
        LocalPlayer localPlayer = Minecraft.getInstance().player;
        if (localPlayer == null) {
            return false;
        }
        LocalPlayer player = localPlayer;
        ItemStack itemStack = LeonardsUrnItem.Companion.findUrn((Player)player);
        if (itemStack == null) {
            return false;
        }
        ItemStack urn = itemStack;
        List<ItemStack> potions = LeonardsUrnItem.Companion.getStoredPotions(urn);
        if (potions.isEmpty()) {
            return false;
        }
        if (delta > 0.0) {
            selectedIndex = (selectedIndex - 1 + potions.size()) % potions.size();
        } else if (delta < 0.0) {
            selectedIndex = (selectedIndex + 1) % potions.size();
        }
        player.playSound((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), 0.3f, 1.5f);
        return true;
    }

    private final void openMenu(Player player) {
        isMenuOpen = true;
        selectedIndex = 0;
        animationProgress = 0.0f;
    }

    private final void closeMenu() {
        if (isMenuOpen && selectedIndex >= 0) {
            SelectUrnPotionC2SPayload packet = new SelectUrnPotionC2SPayload(selectedIndex);
            PacketDistributor.sendToServer((CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        isMenuOpen = false;
    }

    public final void render(@NotNull GuiGraphics guiGraphics, @NotNull DeltaTracker partialTick) {
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        Intrinsics.checkNotNullParameter((Object)partialTick, (String)"partialTick");
        if (animationProgress <= 0.0f) {
            return;
        }
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer localPlayer = minecraft.player;
        if (localPlayer == null) {
            return;
        }
        LocalPlayer player = localPlayer;
        ItemStack itemStack = LeonardsUrnItem.Companion.findUrn((Player)player);
        if (itemStack == null) {
            return;
        }
        ItemStack urn = itemStack;
        List<ItemStack> potions = LeonardsUrnItem.Companion.getStoredPotions(urn);
        if (potions.isEmpty()) {
            return;
        }
        Window window = minecraft.getWindow();
        int screenWidth = window.getGuiScaledWidth();
        int screenHeight = window.getGuiScaledHeight();
        int targetY = screenHeight / 2 + 25;
        int startY = screenHeight + 20;
        int currentY = (int)Mth.lerp((float)this.easeOutCubic(animationProgress), (float)startY, (float)targetY);
        int itemSize = 18;
        int spacing = 4;
        int padding = 8;
        int contentWidth = 3 * itemSize + (potions.size() - 1) * spacing;
        int panelWidth = contentWidth + padding * 2;
        int panelHeight = itemSize + padding * 2 + 10;
        int panelX = screenWidth / 2 - panelWidth / 2;
        int panelY = currentY;
        guiGraphics.fill(panelX, panelY, panelX + panelWidth, panelY + panelHeight, new Color(80, 65, 50).getRGB());
        guiGraphics.renderOutline(panelX, panelY, panelWidth, panelHeight, new Color(210, 180, 140).getRGB());
        MutableComponent title = Component.translatable((String)"gui.witchery.select_potion");
        guiGraphics.drawCenteredString(minecraft.font, (Component)title, screenWidth / 2, panelY + 4, new Color(220, 200, 170).getRGB());
        int startX = screenWidth / 2 - contentWidth / 2;
        int itemY = panelY + 18;
        Iterator iterator = ((Iterable)potions).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            boolean isSelected;
            int index = n++;
            ItemStack potion = (ItemStack)iterator.next();
            int itemX = startX + index * (itemSize + spacing);
            boolean bl = isSelected = index == selectedIndex;
            if (isSelected) {
                guiGraphics.fill(itemX - 1, itemY - 1, itemX + itemSize + 1, itemY + itemSize + 1, -22016);
                guiGraphics.fill(itemX, itemY, itemX + itemSize, itemY + itemSize, 1157605888);
            }
            guiGraphics.renderItem(potion, itemX, itemY);
            guiGraphics.renderItemDecorations(minecraft.font, potion, itemX, itemY);
            String numberText = String.valueOf(index + 1);
            int numX = itemX + itemSize - minecraft.font.width(numberText) - 1;
            int numY = itemY + itemSize - 8;
            guiGraphics.drawString(minecraft.font, numberText, numX + 1, numY + 1, 0, false);
            guiGraphics.drawString(minecraft.font, numberText, numX, numY, isSelected ? 0xFFFFFF : 0xAAAAAA, false);
        }
    }

    private final float easeOutCubic(float t) {
        float t1 = t - 1.0f;
        return t1 * t1 * t1 + 1.0f;
    }

    static {
        ANIMATION_SPEED = 0.15f;
    }
}

