/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.client.hud;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.sterner.witchery.Witchery;
import dev.sterner.witchery.client.hud.HudPositionData;
import dev.sterner.witchery.core.util.RenderUtils;
import dev.sterner.witchery.features.bark_belt.BarkBeltPlayerAttachment;
import dev.sterner.witchery.features.infusion.InfusionPlayerAttachment;
import dev.sterner.witchery.features.infusion.InfusionType;
import dev.sterner.witchery.features.misc.HudPlayerAttachment;
import dev.sterner.witchery.features.spirit_world.ManifestationPlayerAttachment;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018J\u0018\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018J\u0018\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018R\u0019\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0019\u0010\t\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0019\u0010\u000b\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\bR\u0019\u0010\r\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\bR\u0019\u0010\u000f\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\bR\u0019\u0010\u0011\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\b\u00a8\u0006\u001b"}, d2={"Ldev/sterner/witchery/client/hud/DraggableHuds;", "", "<init>", "()V", "infusionMeter", "Lnet/minecraft/resources/ResourceLocation;", "kotlin.jvm.PlatformType", "getInfusionMeter", "()Lnet/minecraft/resources/ResourceLocation;", "infusionMeterOtherwhere", "getInfusionMeterOtherwhere", "infusionMeterInfernal", "getInfusionMeterInfernal", "infusionMeterNecro", "getInfusionMeterNecro", "infusionMeterOverworld", "getInfusionMeterOverworld", "infusionMeterLight", "getInfusionMeterLight", "renderBarkHud", "", "guiGraphics", "Lnet/minecraft/client/gui/GuiGraphics;", "deltaTracker", "Lnet/minecraft/client/DeltaTracker;", "renderManifestHud", "renderInfusionHud", "witchery"})
public final class DraggableHuds {
    @NotNull
    public static final DraggableHuds INSTANCE = new DraggableHuds();
    private static final ResourceLocation infusionMeter = Witchery.Companion.id("textures/gui/infusion_meter.png");
    private static final ResourceLocation infusionMeterOtherwhere = Witchery.Companion.id("textures/gui/infusion_meter_otherwhere.png");
    private static final ResourceLocation infusionMeterInfernal = Witchery.Companion.id("textures/gui/infusion_meter_infernal.png");
    private static final ResourceLocation infusionMeterNecro = Witchery.Companion.id("textures/gui/infusion_meter_necro.png");
    private static final ResourceLocation infusionMeterOverworld = Witchery.Companion.id("textures/gui/infusion_meter_overworld.png");
    private static final ResourceLocation infusionMeterLight = Witchery.Companion.id("textures/gui/infusion_meter_light.png");

    private DraggableHuds() {
    }

    public final ResourceLocation getInfusionMeter() {
        return infusionMeter;
    }

    public final ResourceLocation getInfusionMeterOtherwhere() {
        return infusionMeterOtherwhere;
    }

    public final ResourceLocation getInfusionMeterInfernal() {
        return infusionMeterInfernal;
    }

    public final ResourceLocation getInfusionMeterNecro() {
        return infusionMeterNecro;
    }

    public final ResourceLocation getInfusionMeterOverworld() {
        return infusionMeterOverworld;
    }

    public final ResourceLocation getInfusionMeterLight() {
        return infusionMeterLight;
    }

    public final void renderBarkHud(@NotNull GuiGraphics guiGraphics, @Nullable DeltaTracker deltaTracker) {
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        Minecraft client = Minecraft.getInstance();
        LocalPlayer localPlayer = client.player;
        if (localPlayer == null) {
            return;
        }
        LocalPlayer player = localPlayer;
        MultiPlayerGameMode multiPlayerGameMode = client.gameMode;
        Intrinsics.checkNotNull((Object)multiPlayerGameMode);
        boolean bl = multiPlayerGameMode.canHurtPlayer();
        if (!bl) {
            return;
        }
        HudPositionData positions = HudPlayerAttachment.getData((Player)player).getHudPositions();
        HudPositionData.Coord coord = positions.getBarkBeltPos(guiGraphics.guiWidth(), guiGraphics.guiHeight());
        int x = coord.component1();
        int y = coord.component2();
        BarkBeltPlayerAttachment.Data bark = BarkBeltPlayerAttachment.getData((Player)player);
        if (bark.getMaxBark() > 0) {
            int i;
            int n = bark.getMaxBark();
            for (i = 0; i < n; ++i) {
                PoseStack poseStack = guiGraphics.pose();
                Intrinsics.checkNotNullExpressionValue((Object)poseStack, (String)"pose(...)");
                RenderUtils.blitWithAlpha$default(RenderUtils.INSTANCE, poseStack, Witchery.Companion.id("textures/gui/bark_empty.png"), x + i * 8, y, 0.0f, 0.0f, 8, 8, 8, 8, 0.0f, 0, 3072, null);
            }
            n = bark.getCurrentBark();
            for (i = 0; i < n; ++i) {
                PoseStack poseStack = guiGraphics.pose();
                Intrinsics.checkNotNullExpressionValue((Object)poseStack, (String)"pose(...)");
                RenderUtils.blitWithAlpha$default(RenderUtils.INSTANCE, poseStack, Witchery.Companion.id("textures/gui/bark_full.png"), x + i * 8, y, 0.0f, 0.0f, 8, 8, 8, 8, 0.0f, 0, 3072, null);
            }
        }
    }

    public final void renderManifestHud(@NotNull GuiGraphics guiGraphics, @Nullable DeltaTracker deltaTracker) {
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer localPlayer = minecraft.player;
        if (localPlayer == null) {
            return;
        }
        LocalPlayer clientPlayer = localPlayer;
        ManifestationPlayerAttachment.Data data2 = ManifestationPlayerAttachment.getData((Player)clientPlayer);
        if (data2.getManifestationTimer() <= 0) {
            return;
        }
        HudPositionData positions = HudPlayerAttachment.getData((Player)clientPlayer).getHudPositions();
        int scaledY = minecraft.getWindow().getGuiScaledHeight();
        HudPositionData.Coord coord = positions.getManifestationPos(scaledY);
        int x = coord.component1();
        int y = coord.component2();
        float chargePercentage = (float)data2.getManifestationTimer() / (float)2400;
        PoseStack poseStack = guiGraphics.pose();
        Intrinsics.checkNotNullExpressionValue((Object)poseStack, (String)"pose(...)");
        RenderUtils.blitWithAlpha$default(RenderUtils.INSTANCE, poseStack, Witchery.Companion.id("textures/gui/zzz_meter_overlay.png"), x, y, 0.0f, 0.0f, 12, 24, 12, 24, 1.0f, 0, 2048, null);
        int overlayHeight = (int)((1.0f - chargePercentage) * (float)24);
        PoseStack poseStack2 = guiGraphics.pose();
        Intrinsics.checkNotNullExpressionValue((Object)poseStack2, (String)"pose(...)");
        RenderUtils.blitWithAlpha$default(RenderUtils.INSTANCE, poseStack2, Witchery.Companion.id("textures/gui/zzz_meter.png"), x, y, 0.0f, 0.0f, 12, overlayHeight, 12, 24, 1.0f, 0, 2048, null);
    }

    public final void renderInfusionHud(@NotNull GuiGraphics guiGraphics, @Nullable DeltaTracker deltaTracker) {
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer localPlayer = minecraft.player;
        if (localPlayer == null) {
            return;
        }
        LocalPlayer clientPlayer = localPlayer;
        InfusionPlayerAttachment.Data data2 = InfusionPlayerAttachment.getData((Player)clientPlayer);
        if (data2.getType() == InfusionType.NONE) {
            return;
        }
        HudPositionData positions = HudPlayerAttachment.getData((Player)clientPlayer).getHudPositions();
        int scaledY = minecraft.getWindow().getGuiScaledHeight();
        HudPositionData.Coord coord = positions.getInfusionPos(scaledY);
        int x = coord.component1();
        int y = coord.component2();
        float chargePercentage = (float)data2.getCharge() / (float)6000;
        ResourceLocation texture = switch (WhenMappings.$EnumSwitchMapping$0[data2.getType().ordinal()]) {
            case 1 -> infusionMeterLight;
            case 2 -> infusionMeterOtherwhere;
            case 3 -> infusionMeterInfernal;
            case 4 -> infusionMeterNecro;
            default -> infusionMeterOverworld;
        };
        PoseStack poseStack = guiGraphics.pose();
        Intrinsics.checkNotNullExpressionValue((Object)poseStack, (String)"pose(...)");
        RenderUtils.blitWithAlpha$default(RenderUtils.INSTANCE, poseStack, infusionMeter, x, y, 0.0f, 0.0f, 15, 47, 15, 47, 1.0f, 0, 2048, null);
        int otherwhereHeight = (int)(chargePercentage * (float)28);
        PoseStack poseStack2 = guiGraphics.pose();
        Intrinsics.checkNotNullExpressionValue((Object)poseStack2, (String)"pose(...)");
        RenderUtils.blitWithAlpha$default(RenderUtils.INSTANCE, poseStack2, texture, x + 6, y + (28 - otherwhereHeight) + 4, 0.0f, (float)(28 - otherwhereHeight), 3, otherwhereHeight, 3, 28, 1.0f, 0, 2048, null);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[InfusionType.values().length];
            try {
                nArray[InfusionType.LIGHT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InfusionType.OTHERWHERE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InfusionType.INFERNAL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InfusionType.NECRO.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

