/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.client.hud;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.sterner.witchery.client.hud.HudPositionData;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KProperty1;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u001d2\u00020\u0001:\u0002\u001c\u001dB%\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000eJ\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u001e"}, d2={"Ldev/sterner/witchery/client/hud/HudPositionData;", "", "infusionCoord", "Ldev/sterner/witchery/client/hud/HudPositionData$Coord;", "manifestationCoord", "barkBeltCoord", "<init>", "(Ldev/sterner/witchery/client/hud/HudPositionData$Coord;Ldev/sterner/witchery/client/hud/HudPositionData$Coord;Ldev/sterner/witchery/client/hud/HudPositionData$Coord;)V", "getInfusionCoord", "()Ldev/sterner/witchery/client/hud/HudPositionData$Coord;", "getManifestationCoord", "getBarkBeltCoord", "getInfusionPos", "screenHeight", "", "getManifestationPos", "getBarkBeltPos", "screenWidth", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "Coord", "Companion", "witchery"})
public final class HudPositionData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Coord infusionCoord;
    @NotNull
    private final Coord manifestationCoord;
    @NotNull
    private final Coord barkBeltCoord;
    @NotNull
    private static final Codec<HudPositionData> CODEC;
    @NotNull
    private static final StreamCodec<RegistryFriendlyByteBuf, HudPositionData> STREAM_CODEC;

    public HudPositionData(@NotNull Coord infusionCoord, @NotNull Coord manifestationCoord, @NotNull Coord barkBeltCoord) {
        Intrinsics.checkNotNullParameter((Object)infusionCoord, (String)"infusionCoord");
        Intrinsics.checkNotNullParameter((Object)manifestationCoord, (String)"manifestationCoord");
        Intrinsics.checkNotNullParameter((Object)barkBeltCoord, (String)"barkBeltCoord");
        this.infusionCoord = infusionCoord;
        this.manifestationCoord = manifestationCoord;
        this.barkBeltCoord = barkBeltCoord;
    }

    public /* synthetic */ HudPositionData(Coord coord, Coord coord2, Coord coord3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            coord = new Coord(10, -1);
        }
        if ((n & 2) != 0) {
            coord2 = new Coord(28, -1);
        }
        if ((n & 4) != 0) {
            coord3 = new Coord(-1, -1);
        }
        this(coord, coord2, coord3);
    }

    @NotNull
    public final Coord getInfusionCoord() {
        return this.infusionCoord;
    }

    @NotNull
    public final Coord getManifestationCoord() {
        return this.manifestationCoord;
    }

    @NotNull
    public final Coord getBarkBeltCoord() {
        return this.barkBeltCoord;
    }

    @NotNull
    public final Coord getInfusionPos(int screenHeight) {
        return this.infusionCoord.getY() == -1 ? new Coord(this.infusionCoord.getX(), screenHeight / 2 - 23) : this.infusionCoord;
    }

    @NotNull
    public final Coord getManifestationPos(int screenHeight) {
        return this.manifestationCoord.getY() == -1 ? new Coord(this.manifestationCoord.getX(), screenHeight / 2 - 12) : this.manifestationCoord;
    }

    @NotNull
    public final Coord getBarkBeltPos(int screenWidth, int screenHeight) {
        Coord coord;
        if (this.barkBeltCoord.getX() == -1 || this.barkBeltCoord.getY() == -1) {
            int y = screenHeight - 18 - 18 - 12;
            int x = screenWidth / 2 - 36 - 54;
            coord = new Coord(x, y);
        } else {
            coord = this.barkBeltCoord;
        }
        return coord;
    }

    @NotNull
    public final Coord component1() {
        return this.infusionCoord;
    }

    @NotNull
    public final Coord component2() {
        return this.manifestationCoord;
    }

    @NotNull
    public final Coord component3() {
        return this.barkBeltCoord;
    }

    @NotNull
    public final HudPositionData copy(@NotNull Coord infusionCoord, @NotNull Coord manifestationCoord, @NotNull Coord barkBeltCoord) {
        Intrinsics.checkNotNullParameter((Object)infusionCoord, (String)"infusionCoord");
        Intrinsics.checkNotNullParameter((Object)manifestationCoord, (String)"manifestationCoord");
        Intrinsics.checkNotNullParameter((Object)barkBeltCoord, (String)"barkBeltCoord");
        return new HudPositionData(infusionCoord, manifestationCoord, barkBeltCoord);
    }

    public static /* synthetic */ HudPositionData copy$default(HudPositionData hudPositionData, Coord coord, Coord coord2, Coord coord3, int n, Object object) {
        if ((n & 1) != 0) {
            coord = hudPositionData.infusionCoord;
        }
        if ((n & 2) != 0) {
            coord2 = hudPositionData.manifestationCoord;
        }
        if ((n & 4) != 0) {
            coord3 = hudPositionData.barkBeltCoord;
        }
        return hudPositionData.copy(coord, coord2, coord3);
    }

    @NotNull
    public String toString() {
        return "HudPositionData(infusionCoord=" + this.infusionCoord + ", manifestationCoord=" + this.manifestationCoord + ", barkBeltCoord=" + this.barkBeltCoord + ")";
    }

    public int hashCode() {
        int result = this.infusionCoord.hashCode();
        result = result * 31 + this.manifestationCoord.hashCode();
        result = result * 31 + this.barkBeltCoord.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof HudPositionData)) {
            return false;
        }
        HudPositionData hudPositionData = (HudPositionData)other;
        if (!Intrinsics.areEqual((Object)this.infusionCoord, (Object)hudPositionData.infusionCoord)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.manifestationCoord, (Object)hudPositionData.manifestationCoord)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.barkBeltCoord, (Object)hudPositionData.barkBeltCoord);
    }

    private static final App CODEC$lambda$0(RecordCodecBuilder.Instance instance) {
        return instance.group((App)Coord.Companion.getCODEC().fieldOf("infusion").forGetter(HudPositionData::CODEC$lambda$0$0), (App)Coord.Companion.getCODEC().fieldOf("manifestation").forGetter(HudPositionData::CODEC$lambda$0$1), (App)Coord.Companion.getCODEC().fieldOf("barkBelt").forGetter(HudPositionData::CODEC$lambda$0$2)).apply((Applicative)instance, HudPositionData::new);
    }

    private static final Coord CODEC$lambda$0$0(HudPositionData it) {
        return it.infusionCoord;
    }

    private static final Coord CODEC$lambda$0$1(HudPositionData it) {
        return it.manifestationCoord;
    }

    private static final Coord CODEC$lambda$0$2(HudPositionData it) {
        return it.barkBeltCoord;
    }

    private static final Coord STREAM_CODEC$lambda$0(KProperty1 $tmp0, HudPositionData p0) {
        return (Coord)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final Coord STREAM_CODEC$lambda$1(KProperty1 $tmp0, HudPositionData p0) {
        return (Coord)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final Coord STREAM_CODEC$lambda$2(KProperty1 $tmp0, HudPositionData p0) {
        return (Coord)((Function1)$tmp0).invoke((Object)p0);
    }

    public HudPositionData() {
        this(null, null, null, 7, null);
    }

    static {
        Codec codec = RecordCodecBuilder.create(HudPositionData::CODEC$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"create(...)");
        CODEC = codec;
        StreamCodec streamCodec = StreamCodec.composite(Coord.Companion.getSTREAM_CODEC(), arg_0 -> HudPositionData.STREAM_CODEC$lambda$0((KProperty1)Companion.STREAM_CODEC.1.INSTANCE, arg_0), Coord.Companion.getSTREAM_CODEC(), arg_0 -> HudPositionData.STREAM_CODEC$lambda$1((KProperty1)Companion.STREAM_CODEC.2.INSTANCE, arg_0), Coord.Companion.getSTREAM_CODEC(), arg_0 -> HudPositionData.STREAM_CODEC$lambda$2((KProperty1)Companion.STREAM_CODEC.3.INSTANCE, arg_0), HudPositionData::new);
        Intrinsics.checkNotNullExpressionValue((Object)streamCodec, (String)"composite(...)");
        STREAM_CODEC = streamCodec;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00060\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Ldev/sterner/witchery/client/hud/HudPositionData$Companion;", "", "<init>", "()V", "CODEC", "Lcom/mojang/serialization/Codec;", "Ldev/sterner/witchery/client/hud/HudPositionData;", "getCODEC", "()Lcom/mojang/serialization/Codec;", "STREAM_CODEC", "Lnet/minecraft/network/codec/StreamCodec;", "Lnet/minecraft/network/RegistryFriendlyByteBuf;", "getSTREAM_CODEC", "()Lnet/minecraft/network/codec/StreamCodec;", "witchery"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Codec<HudPositionData> getCODEC() {
            return CODEC;
        }

        @NotNull
        public final StreamCodec<RegistryFriendlyByteBuf, HudPositionData> getSTREAM_CODEC() {
            return STREAM_CODEC;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0014"}, d2={"Ldev/sterner/witchery/client/hud/HudPositionData$Coord;", "", "x", "", "y", "<init>", "(II)V", "getX", "()I", "getY", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "Companion", "witchery"})
    public static final class Coord {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final int x;
        private final int y;
        @NotNull
        private static final Codec<Coord> CODEC;
        @NotNull
        private static final StreamCodec<RegistryFriendlyByteBuf, Coord> STREAM_CODEC;

        public Coord(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public final int getX() {
            return this.x;
        }

        public final int getY() {
            return this.y;
        }

        public final int component1() {
            return this.x;
        }

        public final int component2() {
            return this.y;
        }

        @NotNull
        public final Coord copy(int x, int y) {
            return new Coord(x, y);
        }

        public static /* synthetic */ Coord copy$default(Coord coord, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = coord.x;
            }
            if ((n3 & 2) != 0) {
                n2 = coord.y;
            }
            return coord.copy(n, n2);
        }

        @NotNull
        public String toString() {
            return "Coord(x=" + this.x + ", y=" + this.y + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.x);
            result = result * 31 + Integer.hashCode(this.y);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Coord)) {
                return false;
            }
            Coord coord = (Coord)other;
            if (this.x != coord.x) {
                return false;
            }
            return this.y == coord.y;
        }

        private static final App CODEC$lambda$0(RecordCodecBuilder.Instance instance) {
            return instance.group((App)Codec.INT.fieldOf("x").forGetter(Coord::CODEC$lambda$0$0), (App)Codec.INT.fieldOf("y").forGetter(Coord::CODEC$lambda$0$1)).apply((Applicative)instance, Coord::new);
        }

        private static final Integer CODEC$lambda$0$0(Coord it) {
            return it.x;
        }

        private static final Integer CODEC$lambda$0$1(Coord it) {
            return it.y;
        }

        private static final void STREAM_CODEC$lambda$0(RegistryFriendlyByteBuf buf, Integer value) {
            Intrinsics.checkNotNull((Object)value);
            buf.writeInt(value.intValue());
        }

        private static final Integer STREAM_CODEC$lambda$1(RegistryFriendlyByteBuf it) {
            return it.readInt();
        }

        private static final Integer STREAM_CODEC$lambda$2(KProperty1 $tmp0, Coord p0) {
            return (Integer)((Function1)$tmp0).invoke((Object)p0);
        }

        private static final void STREAM_CODEC$lambda$3(RegistryFriendlyByteBuf buf, Integer value) {
            Intrinsics.checkNotNull((Object)value);
            buf.writeInt(value.intValue());
        }

        private static final Integer STREAM_CODEC$lambda$4(RegistryFriendlyByteBuf it) {
            return it.readInt();
        }

        private static final Integer STREAM_CODEC$lambda$5(KProperty1 $tmp0, Coord p0) {
            return (Integer)((Function1)$tmp0).invoke((Object)p0);
        }

        static {
            Codec codec = RecordCodecBuilder.create(Coord::CODEC$lambda$0);
            Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"create(...)");
            CODEC = codec;
            StreamCodec streamCodec = StreamCodec.composite((StreamCodec)StreamCodec.of(Coord::STREAM_CODEC$lambda$0, Coord::STREAM_CODEC$lambda$1), arg_0 -> Coord.STREAM_CODEC$lambda$2((KProperty1)Companion.STREAM_CODEC.3.INSTANCE, arg_0), (StreamCodec)StreamCodec.of(Coord::STREAM_CODEC$lambda$3, Coord::STREAM_CODEC$lambda$4), arg_0 -> Coord.STREAM_CODEC$lambda$5((KProperty1)Companion.STREAM_CODEC.6.INSTANCE, arg_0), Coord::new);
            Intrinsics.checkNotNullExpressionValue((Object)streamCodec, (String)"composite(...)");
            STREAM_CODEC = streamCodec;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00060\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Ldev/sterner/witchery/client/hud/HudPositionData$Coord$Companion;", "", "<init>", "()V", "CODEC", "Lcom/mojang/serialization/Codec;", "Ldev/sterner/witchery/client/hud/HudPositionData$Coord;", "getCODEC", "()Lcom/mojang/serialization/Codec;", "STREAM_CODEC", "Lnet/minecraft/network/codec/StreamCodec;", "Lnet/minecraft/network/RegistryFriendlyByteBuf;", "getSTREAM_CODEC", "()Lnet/minecraft/network/codec/StreamCodec;", "witchery"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Codec<Coord> getCODEC() {
                return CODEC;
            }

            @NotNull
            public final StreamCodec<RegistryFriendlyByteBuf, Coord> getSTREAM_CODEC() {
                return STREAM_CODEC;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

