/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.sterner.witchery.Witchery;
import dev.sterner.witchery.content.entity.PoltergeistEntity;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0006\u0018\u0000 #2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001#B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J0\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u0018H\u0016J\b\u0010\u0003\u001a\u00020\u0004H\u0016J8\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\u001eH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\bR\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\bR\u0011\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\b\u00a8\u0006$"}, d2={"Ldev/sterner/witchery/client/model/SpectreEntityModel;", "Lnet/minecraft/client/model/HierarchicalModel;", "Ldev/sterner/witchery/content/entity/PoltergeistEntity;", "root", "Lnet/minecraft/client/model/geom/ModelPart;", "<init>", "(Lnet/minecraft/client/model/geom/ModelPart;)V", "getRoot", "()Lnet/minecraft/client/model/geom/ModelPart;", "body", "getBody", "head", "getHead", "lArm", "getLArm", "rArm", "getRArm", "renderToBuffer", "", "poseStack", "Lcom/mojang/blaze3d/vertex/PoseStack;", "vertexConsumer", "Lcom/mojang/blaze3d/vertex/VertexConsumer;", "packedLight", "", "packedOverlay", "color", "setupAnim", "entity", "limbSwing", "", "limbSwingAmount", "ageInTicks", "netHeadYaw", "headPitch", "Companion", "witchery"})
public final class SpectreEntityModel
extends HierarchicalModel<PoltergeistEntity> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ModelPart root;
    @NotNull
    private final ModelPart body;
    @NotNull
    private final ModelPart head;
    @NotNull
    private final ModelPart lArm;
    @NotNull
    private final ModelPart rArm;
    @NotNull
    private static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(Witchery.Companion.id("spectre"), "main");

    public SpectreEntityModel(@NotNull ModelPart root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        super(SpectreEntityModel::_init_$lambda$0);
        this.root = root;
        ModelPart modelPart = this.root.getChild("body");
        Intrinsics.checkNotNullExpressionValue((Object)modelPart, (String)"getChild(...)");
        this.body = modelPart;
        ModelPart modelPart2 = this.root.getChild("head");
        Intrinsics.checkNotNullExpressionValue((Object)modelPart2, (String)"getChild(...)");
        this.head = modelPart2;
        ModelPart modelPart3 = this.root.getChild("lArm");
        Intrinsics.checkNotNullExpressionValue((Object)modelPart3, (String)"getChild(...)");
        this.lArm = modelPart3;
        ModelPart modelPart4 = this.root.getChild("rArm");
        Intrinsics.checkNotNullExpressionValue((Object)modelPart4, (String)"getChild(...)");
        this.rArm = modelPart4;
    }

    @NotNull
    public final ModelPart getRoot() {
        return this.root;
    }

    @NotNull
    public final ModelPart getBody() {
        return this.body;
    }

    @NotNull
    public final ModelPart getHead() {
        return this.head;
    }

    @NotNull
    public final ModelPart getLArm() {
        return this.lArm;
    }

    @NotNull
    public final ModelPart getRArm() {
        return this.rArm;
    }

    public void renderToBuffer(@NotNull PoseStack poseStack, @NotNull VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        Intrinsics.checkNotNullParameter((Object)vertexConsumer, (String)"vertexConsumer");
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.head.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.lArm.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.rArm.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }

    @NotNull
    public ModelPart root() {
        return this.root;
    }

    public void setupAnim(@NotNull PoltergeistEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        Intrinsics.checkNotNullParameter((Object)((Object)entity), (String)"entity");
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.head.zRot = Mth.sin((float)(ageInTicks * 0.05f)) * 0.05f;
        ModelPart modelPart = this.head;
        modelPart.xRot += Mth.sin((float)(ageInTicks * 0.1f)) * 0.03f;
        this.lArm.xRot = -1.0f + Mth.cos((float)(ageInTicks * 0.1f)) * 0.1f;
        this.lArm.zRot = 0.6f + Mth.sin((float)(ageInTicks * 0.1f)) * 0.05f;
        this.rArm.xRot = -1.0f + Mth.cos((float)(ageInTicks * 0.1f + (float)Math.PI)) * 0.1f;
        this.rArm.zRot = -0.6f - Mth.sin((float)(ageInTicks * 0.1f)) * 0.05f;
        this.body.xRot = Mth.sin((float)(ageInTicks * 0.05f)) * 0.02f;
    }

    private static final RenderType _init_$lambda$0(ResourceLocation location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        return RenderType.entityTranslucent((ResourceLocation)location);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\b\u001a\u00020\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Ldev/sterner/witchery/client/model/SpectreEntityModel$Companion;", "", "<init>", "()V", "LAYER_LOCATION", "Lnet/minecraft/client/model/geom/ModelLayerLocation;", "getLAYER_LOCATION", "()Lnet/minecraft/client/model/geom/ModelLayerLocation;", "createBodyLayer", "Lnet/minecraft/client/model/geom/builders/LayerDefinition;", "witchery"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ModelLayerLocation getLAYER_LOCATION() {
            return LAYER_LOCATION;
        }

        @NotNull
        public final LayerDefinition createBodyLayer() {
            MeshDefinition meshdefinition = new MeshDefinition();
            PartDefinition partdefinition = meshdefinition.getRoot();
            partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)1.0f, (float)0.0f));
            partdefinition.addOrReplaceChild("rArm", CubeListBuilder.create().texOffs(0, 32).addBox(-3.0f, -3.0f, -10.0f, 4.0f, 4.0f, 12.0f, new CubeDeformation(0.0f)).texOffs(0, 40).addBox(1.0f, 1.0f, -10.0f, 0.0f, 4.0f, 12.0f, new CubeDeformation(0.0f)).texOffs(0, 36).addBox(-3.0f, 1.0f, -10.0f, 0.0f, 4.0f, 12.0f, new CubeDeformation(0.0f)).texOffs(0, 56).addBox(-3.0f, 1.0f, -8.0f, 4.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-5.0f, (float)4.0f, (float)0.0f));
            partdefinition.addOrReplaceChild("lArm", CubeListBuilder.create().texOffs(32, 32).addBox(-1.0f, -3.0f, -10.0f, 4.0f, 4.0f, 12.0f, new CubeDeformation(0.0f)).texOffs(32, 40).addBox(3.0f, 1.0f, -10.0f, 0.0f, 4.0f, 12.0f, new CubeDeformation(0.0f)).texOffs(32, 36).addBox(-1.0f, 1.0f, -10.0f, 0.0f, 4.0f, 12.0f, new CubeDeformation(0.0f)).texOffs(32, 56).addBox(-1.0f, 1.0f, -8.0f, 4.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)5.0f, (float)4.0f, (float)0.0f));
            partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(32, 0).addBox(-4.0f, -14.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(40, 20).addBox(4.0f, -2.0f, -2.0f, 0.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(32, 20).addBox(-4.0f, -2.0f, -2.0f, 0.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(36, 16).addBox(-4.0f, -2.0f, -2.0f, 8.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(0, 16).addBox(-4.0f, -2.0f, 2.0f, 8.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)15.0f, (float)0.0f));
            LayerDefinition layerDefinition = LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
            Intrinsics.checkNotNullExpressionValue((Object)layerDefinition, (String)"create(...)");
            return layerDefinition;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

