/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.client.particle;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0011BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u0005\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\b\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0012"}, d2={"Ldev/sterner/witchery/client/particle/BloodSplashParticle;", "Lnet/minecraft/client/particle/TextureSheetParticle;", "clientLevel", "Lnet/minecraft/client/multiplayer/ClientLevel;", "x", "", "y", "z", "dx", "dy", "dz", "spriteSet", "Lnet/minecraft/client/particle/SpriteSet;", "<init>", "(Lnet/minecraft/client/multiplayer/ClientLevel;DDDDDDLnet/minecraft/client/particle/SpriteSet;)V", "getRenderType", "Lnet/minecraft/client/particle/ParticleRenderType;", "ParticleFactory", "witchery"})
public final class BloodSplashParticle
extends TextureSheetParticle {
    public BloodSplashParticle(@NotNull ClientLevel clientLevel, double x, double y, double z, double dx, double dy, double dz, @NotNull SpriteSet spriteSet) {
        Intrinsics.checkNotNullParameter((Object)clientLevel, (String)"clientLevel");
        Intrinsics.checkNotNullParameter((Object)spriteSet, (String)"spriteSet");
        super(clientLevel, x, y, z);
        this.gravity = 0.75f;
        this.friction = 0.999f;
        this.xd *= (double)0.8f;
        this.yd *= (double)0.8f;
        this.zd *= (double)0.8f;
        this.yd = this.random.nextFloat() * 0.1f + 0.05f;
        this.quadSize /= (float)2;
        this.quadSize *= this.random.nextFloat() * 2.0f + 0.2f;
        this.lifetime = (int)(64.0 / (Math.random() * 0.8 + 0.2));
        this.age = (int)(8.0 / (Math.random() * 0.8 + 0.2));
        this.pickSprite(spriteSet);
    }

    @NotNull
    public ParticleRenderType getRenderType() {
        ParticleRenderType particleRenderType = ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
        Intrinsics.checkNotNullExpressionValue((Object)particleRenderType, (String)"PARTICLE_SHEET_TRANSLUCENT");
        return particleRenderType;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006JJ\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\rH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Ldev/sterner/witchery/client/particle/BloodSplashParticle$ParticleFactory;", "Lnet/minecraft/client/particle/ParticleProvider;", "Lnet/minecraft/core/particles/SimpleParticleType;", "spriteSet", "Lnet/minecraft/client/particle/SpriteSet;", "<init>", "(Lnet/minecraft/client/particle/SpriteSet;)V", "createParticle", "Lnet/minecraft/client/particle/Particle;", "typeIn", "worldIn", "Lnet/minecraft/client/multiplayer/ClientLevel;", "x", "", "y", "z", "xSpeed", "ySpeed", "zSpeed", "witchery"})
    public static final class ParticleFactory
    implements ParticleProvider<SimpleParticleType> {
        @NotNull
        private final SpriteSet spriteSet;

        public ParticleFactory(@NotNull SpriteSet spriteSet) {
            Intrinsics.checkNotNullParameter((Object)spriteSet, (String)"spriteSet");
            this.spriteSet = spriteSet;
        }

        @NotNull
        public Particle createParticle(@Nullable SimpleParticleType typeIn, @NotNull ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
            BloodSplashParticle bloodSplashParticle = new BloodSplashParticle(worldIn, x, y, z, xSpeed, ySpeed + 0.25, zSpeed, this.spriteSet);
            return (Particle)bloodSplashParticle;
        }
    }
}

