/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.client.renderer.block;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import dev.sterner.witchery.content.block.phylactery.PhylacteryBlockEntity;
import dev.sterner.witchery.core.registry.WitcheryRenderTypes;
import java.awt.Color;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.SkullModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000  2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001 B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J8\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0016J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J8\u0010\u001e\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Ldev/sterner/witchery/client/renderer/block/PhylacteryBlockEntityRenderer;", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRenderer;", "Ldev/sterner/witchery/content/block/phylactery/PhylacteryBlockEntity;", "ctx", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;", "<init>", "(Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;)V", "skullModel", "Lnet/minecraft/client/model/SkullModel;", "minecraft", "Lnet/minecraft/client/Minecraft;", "kotlin.jvm.PlatformType", "render", "", "blockEntity", "partialTick", "", "poseStack", "Lcom/mojang/blaze3d/vertex/PoseStack;", "bufferSource", "Lnet/minecraft/client/renderer/MultiBufferSource;", "packedLight", "", "packedOverlay", "getOrLoadSkinTexture", "Lnet/minecraft/resources/ResourceLocation;", "uuid", "Ljava/util/UUID;", "name", "", "renderPlayerHead", "skinTexture", "Companion", "witchery"})
@SourceDebugExtension(value={"SMAP\nPhylacteryBlockEntityRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PhylacteryBlockEntityRenderer.kt\ndev/sterner/witchery/client/renderer/block/PhylacteryBlockEntityRenderer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,129:1\n1#2:130\n*E\n"})
public final class PhylacteryBlockEntityRenderer
implements BlockEntityRenderer<PhylacteryBlockEntity> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SkullModel skullModel;
    private final Minecraft minecraft;
    @NotNull
    private static final ConcurrentHashMap<UUID, ResourceLocation> skinCache = new ConcurrentHashMap();
    @NotNull
    private static final ConcurrentHashMap<UUID, Boolean> loadingProfiles = new ConcurrentHashMap();

    public PhylacteryBlockEntityRenderer(@NotNull BlockEntityRendererProvider.Context ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this.skullModel = new SkullModel(ctx.bakeLayer(ModelLayers.PLAYER_HEAD));
        this.minecraft = Minecraft.getInstance();
    }

    public void render(@NotNull PhylacteryBlockEntity blockEntity, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        Intrinsics.checkNotNullParameter((Object)((Object)blockEntity), (String)"blockEntity");
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        Intrinsics.checkNotNullParameter((Object)bufferSource, (String)"bufferSource");
        UUID uUID = blockEntity.getOwnerUUID();
        if (uUID == null) {
            return;
        }
        UUID ownerUUID = uUID;
        String string = blockEntity.getOwnerName();
        if (string == null) {
            string = "Unknown";
        }
        String ownerName = string;
        ResourceLocation skinTexture = this.getOrLoadSkinTexture(ownerUUID, ownerName);
        if (!blockEntity.getHasSoul()) {
            return;
        }
        this.renderPlayerHead(poseStack, bufferSource, packedLight, skinTexture, blockEntity, partialTick);
    }

    private final ResourceLocation getOrLoadSkinTexture(UUID uuid, String name) {
        ResourceLocation resourceLocation = skinCache.get(uuid);
        if (resourceLocation != null) {
            ResourceLocation it = resourceLocation;
            boolean bl = false;
            return it;
        }
        if (Intrinsics.areEqual((Object)loadingProfiles.get(uuid), (Object)true)) {
            ResourceLocation resourceLocation2 = DefaultPlayerSkin.get((UUID)uuid).texture();
            Intrinsics.checkNotNullExpressionValue((Object)resourceLocation2, (String)"texture(...)");
            return resourceLocation2;
        }
        ((Map)loadingProfiles).put(uuid, true);
        GameProfile gameProfile = new GameProfile(uuid, name);
        SkinManager skinManager = this.minecraft.getSkinManager();
        skinManager.getOrLoad(gameProfile).thenAccept(arg_0 -> PhylacteryBlockEntityRenderer.getOrLoadSkinTexture$lambda$2(arg_0 -> PhylacteryBlockEntityRenderer.getOrLoadSkinTexture$lambda$1(uuid, arg_0), arg_0));
        ResourceLocation resourceLocation3 = skinCache.get(uuid);
        if (resourceLocation3 == null) {
            ResourceLocation resourceLocation4 = DefaultPlayerSkin.get((UUID)uuid).texture();
            resourceLocation3 = resourceLocation4;
            Intrinsics.checkNotNullExpressionValue((Object)resourceLocation4, (String)"texture(...)");
        }
        return resourceLocation3;
    }

    private final void renderPlayerHead(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, ResourceLocation skinTexture, PhylacteryBlockEntity blockEntity, float partialTick) {
        Vec3 vec3;
        poseStack.pushPose();
        poseStack.translate(0.5, 0.5, 0.5);
        Level level = blockEntity.getLevel();
        long time = level != null ? level.getGameTime() : 0L;
        float floatOffset = Mth.sin((float)(((float)time + partialTick) * 0.1f)) * 0.05f;
        poseStack.translate(0.0, (double)floatOffset, 0.0);
        float rotation = ((float)time + partialTick) * 2.0f;
        poseStack.mulPose(Axis.YP.rotationDegrees(rotation));
        poseStack.scale(0.5f, 0.5f, 0.5f);
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        RenderType.CompositeRenderType renderType = WitcheryRenderTypes.INSTANCE.getGHOST_ADDITIVE().apply(skinTexture);
        VertexConsumer buffer = bufferSource.getBuffer((RenderType)renderType);
        if (blockEntity.getHasSoul()) {
            float pulse = Mth.sin((float)(((float)time + partialTick) * 0.2f)) * 0.15f + 0.85f;
            vec3 = new Vec3((double)pulse, (double)pulse, 1.0);
        } else {
            vec3 = new Vec3(1.0, 1.0, 1.0);
        }
        Vec3 color = vec3;
        this.skullModel.renderToBuffer(poseStack, buffer, packedLight, OverlayTexture.NO_OVERLAY, new Color((float)color.x, (float)color.y, (float)color.z).getRGB());
        poseStack.popPose();
    }

    private static final Unit getOrLoadSkinTexture$lambda$1(UUID $uuid, PlayerSkin playerSkin) {
        Intrinsics.checkNotNullParameter((Object)playerSkin, (String)"playerSkin");
        ((Map)skinCache).put($uuid, playerSkin.texture());
        loadingProfiles.remove($uuid);
        return Unit.INSTANCE;
    }

    private static final void getOrLoadSkinTexture$lambda$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\n\u001a\u00020\u000bR\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Ldev/sterner/witchery/client/renderer/block/PhylacteryBlockEntityRenderer$Companion;", "", "<init>", "()V", "skinCache", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/util/UUID;", "Lnet/minecraft/resources/ResourceLocation;", "loadingProfiles", "", "clearCache", "", "witchery"})
    public static final class Companion {
        private Companion() {
        }

        public final void clearCache() {
            skinCache.clear();
            loadingProfiles.clear();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

