/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.sterner.witchery.Witchery;
import dev.sterner.witchery.client.model.poppet.ArmorPoppetModel;
import dev.sterner.witchery.client.model.poppet.HungerPoppetModel;
import dev.sterner.witchery.client.model.poppet.VampiricPoppetModel;
import dev.sterner.witchery.client.model.poppet.VoodooPoppetModel;
import dev.sterner.witchery.content.block.poppet.PoppetBlockEntity;
import dev.sterner.witchery.core.registry.WitcheryItems;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J8\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!H\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006#"}, d2={"Ldev/sterner/witchery/client/renderer/block/PoppetBlockEntityRenderer;", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRenderer;", "Ldev/sterner/witchery/content/block/poppet/PoppetBlockEntity;", "ctx", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;", "<init>", "(Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;)V", "vampModel", "Ldev/sterner/witchery/client/model/poppet/VampiricPoppetModel;", "getVampModel", "()Ldev/sterner/witchery/client/model/poppet/VampiricPoppetModel;", "hungModel", "Ldev/sterner/witchery/client/model/poppet/HungerPoppetModel;", "getHungModel", "()Ldev/sterner/witchery/client/model/poppet/HungerPoppetModel;", "armorModel", "Ldev/sterner/witchery/client/model/poppet/ArmorPoppetModel;", "getArmorModel", "()Ldev/sterner/witchery/client/model/poppet/ArmorPoppetModel;", "voodooModel", "Ldev/sterner/witchery/client/model/poppet/VoodooPoppetModel;", "getVoodooModel", "()Ldev/sterner/witchery/client/model/poppet/VoodooPoppetModel;", "render", "", "blockEntity", "partialTick", "", "poseStack", "Lcom/mojang/blaze3d/vertex/PoseStack;", "bufferSource", "Lnet/minecraft/client/renderer/MultiBufferSource;", "packedLight", "", "packedOverlay", "witchery"})
public final class PoppetBlockEntityRenderer
implements BlockEntityRenderer<PoppetBlockEntity> {
    @NotNull
    private final VampiricPoppetModel vampModel;
    @NotNull
    private final HungerPoppetModel hungModel;
    @NotNull
    private final ArmorPoppetModel armorModel;
    @NotNull
    private final VoodooPoppetModel voodooModel;

    public PoppetBlockEntityRenderer(@NotNull BlockEntityRendererProvider.Context ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        ModelPart modelPart = ctx.bakeLayer(VampiricPoppetModel.Companion.getLAYER_LOCATION());
        Intrinsics.checkNotNullExpressionValue((Object)modelPart, (String)"bakeLayer(...)");
        this.vampModel = new VampiricPoppetModel(modelPart);
        ModelPart modelPart2 = ctx.bakeLayer(HungerPoppetModel.Companion.getLAYER_LOCATION());
        Intrinsics.checkNotNullExpressionValue((Object)modelPart2, (String)"bakeLayer(...)");
        this.hungModel = new HungerPoppetModel(modelPart2);
        ModelPart modelPart3 = ctx.bakeLayer(ArmorPoppetModel.Companion.getLAYER_LOCATION());
        Intrinsics.checkNotNullExpressionValue((Object)modelPart3, (String)"bakeLayer(...)");
        this.armorModel = new ArmorPoppetModel(modelPart3);
        ModelPart modelPart4 = ctx.bakeLayer(VoodooPoppetModel.Companion.getLAYER_LOCATION());
        Intrinsics.checkNotNullExpressionValue((Object)modelPart4, (String)"bakeLayer(...)");
        this.voodooModel = new VoodooPoppetModel(modelPart4);
    }

    @NotNull
    public final VampiricPoppetModel getVampModel() {
        return this.vampModel;
    }

    @NotNull
    public final HungerPoppetModel getHungModel() {
        return this.hungModel;
    }

    @NotNull
    public final ArmorPoppetModel getArmorModel() {
        return this.armorModel;
    }

    @NotNull
    public final VoodooPoppetModel getVoodooModel() {
        return this.voodooModel;
    }

    public void render(@NotNull PoppetBlockEntity blockEntity, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        Intrinsics.checkNotNullParameter((Object)((Object)blockEntity), (String)"blockEntity");
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        Intrinsics.checkNotNullParameter((Object)bufferSource, (String)"bufferSource");
        poseStack.pushPose();
        poseStack.translate(0.5, 1.6, 0.5);
        Direction dir = (Direction)blockEntity.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        float dirYRot = dir.toYRot();
        poseStack.mulPose(Axis.YP.rotationDegrees(-dirYRot));
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        if (blockEntity.getPoppetItemStack().is((Item)WitcheryItems.INSTANCE.getVAMPIRIC_POPPET().get())) {
            this.vampModel.renderToBuffer(poseStack, bufferSource.getBuffer(RenderType.entityCutout((ResourceLocation)Witchery.Companion.id("textures/block/poppet_vamp.png"))), packedLight, packedOverlay);
        }
        if (blockEntity.getPoppetItemStack().is((Item)WitcheryItems.INSTANCE.getARMOR_PROTECTION_POPPET().get())) {
            this.armorModel.renderToBuffer(poseStack, bufferSource.getBuffer(RenderType.entityCutout((ResourceLocation)Witchery.Companion.id("textures/block/poppet_armor.png"))), packedLight, packedOverlay);
        }
        if (blockEntity.getPoppetItemStack().is((Item)WitcheryItems.INSTANCE.getHUNGER_PROTECTION_POPPET().get())) {
            this.hungModel.renderToBuffer(poseStack, bufferSource.getBuffer(RenderType.entityCutout((ResourceLocation)Witchery.Companion.id("textures/block/poppet_hunger.png"))), packedLight, packedOverlay);
        }
        if (blockEntity.getPoppetItemStack().is((Item)WitcheryItems.INSTANCE.getVOODOO_POPPET().get())) {
            this.voodooModel.renderToBuffer(poseStack, bufferSource.getBuffer(RenderType.entityCutout((ResourceLocation)Witchery.Companion.id("textures/block/poppet_voodoo.png"))), packedLight, packedOverlay);
        }
        poseStack.popPose();
    }
}

