/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.sterner.witchery.Witchery;
import dev.sterner.witchery.client.model.GlassContainerModel;
import dev.sterner.witchery.content.block.soul_cage.SoulCageBlockEntity;
import dev.sterner.witchery.core.registry.WitcheryRenderTypes;
import dev.sterner.witchery.core.util.RenderUtils;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.client.model.VillagerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0002H\u0016J\u0018\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J8\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020&H\u0016J$\u0010(\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020 0)2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0019\u001a\u00020\u0002H\u0002J<\u0010*\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\"2\u0006\u0010+\u001a\u00020,2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020&2\u0012\u0010-\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020 0)H\u0002R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0014\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006."}, d2={"Ldev/sterner/witchery/client/renderer/block/SoulCageBlockEntityRenderer;", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRenderer;", "Ldev/sterner/witchery/content/block/soul_cage/SoulCageBlockEntity;", "ctx", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;", "<init>", "(Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;)V", "model", "Ldev/sterner/witchery/client/model/GlassContainerModel;", "getModel", "()Ldev/sterner/witchery/client/model/GlassContainerModel;", "villagerHead", "Lnet/minecraft/client/model/VillagerModel;", "Lnet/minecraft/world/entity/npc/Villager;", "getVillagerHead", "()Lnet/minecraft/client/model/VillagerModel;", "outerTexture", "Lnet/minecraft/resources/ResourceLocation;", "kotlin.jvm.PlatformType", "innerTexture", "villagerSkin", "getVillagerSkin", "()Lnet/minecraft/resources/ResourceLocation;", "shouldRenderOffScreen", "", "blockEntity", "shouldRender", "cameraPos", "Lnet/minecraft/world/phys/Vec3;", "render", "", "partialTick", "", "poseStack", "Lcom/mojang/blaze3d/vertex/PoseStack;", "bufferSource", "Lnet/minecraft/client/renderer/MultiBufferSource;", "packedLight", "", "packedOverlay", "calculateHeadRotation", "Lkotlin/Pair;", "renderVillagerHead", "buffer", "Lcom/mojang/blaze3d/vertex/VertexConsumer;", "rotation", "witchery"})
public class SoulCageBlockEntityRenderer
implements BlockEntityRenderer<SoulCageBlockEntity> {
    @NotNull
    private final GlassContainerModel model;
    @NotNull
    private final VillagerModel<Villager> villagerHead;
    private final ResourceLocation outerTexture;
    private final ResourceLocation innerTexture;
    private final ResourceLocation villagerSkin;

    public SoulCageBlockEntityRenderer(@NotNull BlockEntityRendererProvider.Context ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        ModelPart modelPart = ctx.bakeLayer(GlassContainerModel.Companion.getLAYER_LOCATION());
        Intrinsics.checkNotNullExpressionValue((Object)modelPart, (String)"bakeLayer(...)");
        this.model = new GlassContainerModel(modelPart);
        this.villagerHead = new VillagerModel(ctx.bakeLayer(ModelLayers.VILLAGER));
        this.outerTexture = Witchery.Companion.id("textures/block/glass_container.png");
        this.innerTexture = Witchery.Companion.id("textures/block/glass_container_inside.png");
        this.villagerSkin = ResourceLocation.withDefaultNamespace((String)"textures/entity/villager/villager.png");
    }

    @NotNull
    public final GlassContainerModel getModel() {
        return this.model;
    }

    @NotNull
    public final VillagerModel<Villager> getVillagerHead() {
        return this.villagerHead;
    }

    public final ResourceLocation getVillagerSkin() {
        return this.villagerSkin;
    }

    public boolean shouldRenderOffScreen(@NotNull SoulCageBlockEntity blockEntity) {
        Intrinsics.checkNotNullParameter((Object)((Object)blockEntity), (String)"blockEntity");
        return true;
    }

    public boolean shouldRender(@NotNull SoulCageBlockEntity blockEntity, @NotNull Vec3 cameraPos) {
        Intrinsics.checkNotNullParameter((Object)((Object)blockEntity), (String)"blockEntity");
        Intrinsics.checkNotNullParameter((Object)cameraPos, (String)"cameraPos");
        return Vec3.atCenterOf((Vec3i)((Vec3i)blockEntity.getBlockPos())).multiply(1.0, 0.0, 1.0).closerThan((Position)cameraPos.multiply(1.0, 0.0, 1.0), (double)this.getViewDistance());
    }

    public void render(@NotNull SoulCageBlockEntity blockEntity, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        RenderType renderTypeInner;
        Intrinsics.checkNotNullParameter((Object)((Object)blockEntity), (String)"blockEntity");
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        Intrinsics.checkNotNullParameter((Object)bufferSource, (String)"bufferSource");
        Boolean lit = (Boolean)blockEntity.getBlockState().getValue((Property)BlockStateProperties.LIT);
        poseStack.pushPose();
        poseStack.translate(0.5, -0.25, 0.5);
        poseStack.scale(0.85f, 0.85f, 0.85f);
        RenderType renderTypeOuter = lit != false ? RenderType.entityTranslucentEmissive((ResourceLocation)this.outerTexture) : RenderType.entityTranslucent((ResourceLocation)this.outerTexture);
        RenderType renderType = renderTypeInner = lit != false ? (RenderType)WitcheryRenderTypes.INSTANCE.getINNER_SOUL_CAGE().apply(this.innerTexture) : RenderType.entityTranslucent((ResourceLocation)this.innerTexture);
        if (blockEntity.getHasSoul()) {
            Pair<Float, Float> headRotation = this.calculateHeadRotation(partialTick, blockEntity);
            VertexConsumer vertexConsumer = bufferSource.getBuffer((RenderType)WitcheryRenderTypes.INSTANCE.getGHOST_ADDITIVE().apply(this.villagerSkin));
            Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer, (String)"getBuffer(...)");
            this.renderVillagerHead(poseStack, vertexConsumer, packedLight, packedOverlay, headRotation);
        }
        this.model.renderToBuffer(poseStack, bufferSource.getBuffer(renderTypeOuter), packedLight, packedOverlay);
        poseStack.scale(0.9f, 0.9f, 0.9f);
        poseStack.translate(0.0, 0.1, 0.0);
        this.model.renderToBuffer(poseStack, bufferSource.getBuffer(renderTypeInner), packedLight, packedOverlay);
        poseStack.popPose();
        if (blockEntity.isProcessing()) {
            float fadeProgress = RangesKt.coerceIn((float)((float)blockEntity.getAnimationTime() / 20.0f), (float)0.0f, (float)1.0f);
            RenderUtils.INSTANCE.renderGlowBoxEffect11(fadeProgress, poseStack, bufferSource);
        }
    }

    private final Pair<Float, Float> calculateHeadRotation(float partialTick, SoulCageBlockEntity blockEntity) {
        return blockEntity.getInterpolatedRotation(partialTick);
    }

    private final void renderVillagerHead(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, Pair<Float, Float> rotation) {
        poseStack.pushPose();
        poseStack.translate(0.0, 1.0, 0.0);
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        poseStack.scale(0.4f, 0.4f, 0.4f);
        ModelPart headPart = this.villagerHead.root().getChild("head");
        headPart.xRot = (float)Math.toRadians(((Number)rotation.getSecond()).floatValue());
        headPart.yRot = (float)Math.toRadians(((Number)rotation.getFirst()).floatValue());
        this.villagerHead.root().getChild((String)"body").visible = false;
        this.villagerHead.root().getChild((String)"right_leg").visible = false;
        this.villagerHead.root().getChild((String)"left_leg").visible = false;
        this.villagerHead.root().getChild((String)"arms").visible = false;
        this.villagerHead.root().getChild((String)"head").visible = true;
        this.villagerHead.renderToBuffer(poseStack, buffer, packedLight, packedOverlay);
        poseStack.popPose();
    }
}

