/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.sterner.witchery.Witchery;
import dev.sterner.witchery.client.model.ChainModel;
import dev.sterner.witchery.content.entity.ChainEntity;
import dev.sterner.witchery.core.registry.WitcheryRenderTypes;
import dev.sterner.witchery.features.chain.ChainType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0002H\u0016J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0015H\u0002J8\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016Jh\u0010#\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u00022\u0006\u0010$\u001a\u00020\u00152\u0006\u0010%\u001a\u00020\"2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u001c\u001a\u00020\n2\u0006\u0010(\u001a\u00020\n2\u0006\u0010)\u001a\u00020\n2\u0006\u0010*\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010+\u001a\u00020\nH\u0002J\"\u0010,\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u00022\u0006\u0010-\u001a\u00020\u00152\b\b\u0002\u0010.\u001a\u00020\"H\u0002J0\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u00022\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\r2\u0006\u00105\u001a\u00020\r2\u0006\u00106\u001a\u00020\rH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Ldev/sterner/witchery/client/renderer/entity/ChainEntityRenderer;", "Lnet/minecraft/client/renderer/entity/EntityRenderer;", "Ldev/sterner/witchery/content/entity/ChainEntity;", "context", "Lnet/minecraft/client/renderer/entity/EntityRendererProvider$Context;", "<init>", "(Lnet/minecraft/client/renderer/entity/EntityRendererProvider$Context;)V", "chainModel", "Ldev/sterner/witchery/client/model/ChainModel;", "swayAmplitude", "", "swaySpeed", "chainLinkLength", "", "chainOverlap", "linkLength", "particleFrequency", "getTextureLocation", "Lnet/minecraft/resources/ResourceLocation;", "entity", "lerpVec3", "Lnet/minecraft/world/phys/Vec3;", "t", "start", "end", "render", "", "entityYaw", "partialTick", "poseStack", "Lcom/mojang/blaze3d/vertex/PoseStack;", "bufferSource", "Lnet/minecraft/client/renderer/MultiBufferSource;", "packedLight", "", "renderSingleLink", "linkPos", "linkIndex", "worldTime", "", "yaw", "pitch", "linkProgress", "swayMultiplier", "spawnChainParticles", "pos", "count", "shouldRender", "", "livingEntity", "camera", "Lnet/minecraft/client/renderer/culling/Frustum;", "camX", "camY", "camZ", "witchery"})
public final class ChainEntityRenderer
extends EntityRenderer<ChainEntity> {
    @NotNull
    private final ChainModel chainModel;
    private final float swayAmplitude;
    private final float swaySpeed;
    private final double chainLinkLength;
    private final double chainOverlap;
    private final double linkLength;
    private final float particleFrequency;

    public ChainEntityRenderer(@NotNull EntityRendererProvider.Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        ModelPart modelPart = context.bakeLayer(ChainModel.Companion.getLAYER_LOCATION());
        Intrinsics.checkNotNullExpressionValue((Object)modelPart, (String)"bakeLayer(...)");
        this.chainModel = new ChainModel(modelPart);
        this.swayAmplitude = 5.0f;
        this.swaySpeed = 0.05f;
        this.chainLinkLength = 0.5249999910593033;
        this.chainOverlap = 0.22500000894069672;
        this.linkLength = this.chainLinkLength - this.chainOverlap;
        this.particleFrequency = 0.3f;
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull ChainEntity entity) {
        Intrinsics.checkNotNullParameter((Object)((Object)entity), (String)"entity");
        ResourceLocation resourceLocation = Witchery.Companion.id("textures/entity/chain.png");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"id(...)");
        return resourceLocation;
    }

    private final Vec3 lerpVec3(float t, Vec3 start, Vec3 end) {
        double x = start.x + (end.x - start.x) * (double)t;
        double y = start.y + (end.y - start.y) * (double)t;
        double z = start.z + (end.z - start.z) * (double)t;
        return new Vec3(x, y, z);
    }

    public void render(@NotNull ChainEntity entity, float entityYaw, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight) {
        Intrinsics.checkNotNullParameter((Object)((Object)entity), (String)"entity");
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        Intrinsics.checkNotNullParameter((Object)bufferSource, (String)"bufferSource");
        poseStack.pushPose();
        Entity targetEntity = entity.getTargetEntity();
        if (targetEntity != null) {
            Vec3 startPos = entity.position();
            Vec3 targetPos = targetEntity.position().add(0.0, (double)targetEntity.getBbHeight() / 2.0, 0.0);
            Vec3 directionVec = targetPos.subtract(startPos);
            double distance = directionVec.length();
            Vec3 normalizedDir = directionVec.normalize();
            ChainEntity.ChainState chainState = entity.getChainState();
            float retractProgress = entity.getRetractProgress();
            float headPosition = entity.getHeadPosition();
            float rawLinkCount = entity.getRawLinkCount();
            int visibleLinks = (int)Math.floor(rawLinkCount);
            if (rawLinkCount > 0.0f) {
                double yaw = Math.atan2(normalizedDir.x, normalizedDir.z) * 57.29577951308232;
                double pitch = Math.atan2(normalizedDir.y, Math.sqrt(normalizedDir.x * normalizedDir.x + normalizedDir.z * normalizedDir.z)) * 57.29577951308232;
                poseStack.translate(0.0, -0.85, 0.0);
                long worldTime = entity.level().getGameTime();
                switch (WhenMappings.$EnumSwitchMapping$0[chainState.ordinal()]) {
                    case 1: {
                        int i;
                        double headDist = distance * (double)headPosition;
                        Vec3 currentDirection = targetPos.subtract(startPos);
                        double currentDistance = currentDirection.length();
                        Vec3 currentNormalizedDir = currentDistance > 0.0 ? currentDirection.normalize() : normalizedDir;
                        Vec3 dynamicHeadPos = startPos.add(currentNormalizedDir.scale(RangesKt.coerceAtMost((double)headDist, (double)currentDistance)));
                        int minLinks = 2;
                        int currentVisibleLinks = Math.max(minLinks, Math.min((int)Math.ceil(headDist / this.linkLength), visibleLinks));
                        ArrayList<Vec3> linkPositions = new ArrayList<Vec3>();
                        if (currentVisibleLinks <= minLinks && headDist < this.linkLength) {
                            linkPositions.add(startPos);
                            if (currentVisibleLinks > 1) {
                                linkPositions.add(dynamicHeadPos);
                            }
                        } else {
                            for (i = 0; i < currentVisibleLinks; ++i) {
                                float progress = (float)i / (float)RangesKt.coerceAtLeast((int)(currentVisibleLinks - 1), (int)1);
                                float cappedProgress = Math.min(progress, headPosition);
                                Intrinsics.checkNotNull((Object)startPos);
                                Intrinsics.checkNotNull((Object)dynamicHeadPos);
                                Vec3 linkPos = this.lerpVec3(cappedProgress, startPos, dynamicHeadPos);
                                linkPositions.add(linkPos);
                            }
                        }
                        if (0 > (i = ((Collection)linkPositions).size() + -1)) break;
                        do {
                            int i2 = i--;
                            Object e = linkPositions.get(i2);
                            Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
                            this.renderSingleLink(entity, (Vec3)e, i2, worldTime, partialTick, (float)yaw, (float)pitch, (float)i2 / (float)currentVisibleLinks, poseStack, bufferSource, packedLight, 1.5f);
                            if (i2 != 0 && !(entity.level().random.nextFloat() < this.particleFrequency)) continue;
                            Object e2 = linkPositions.get(i2);
                            Intrinsics.checkNotNullExpressionValue(e2, (String)"get(...)");
                            ChainEntityRenderer.spawnChainParticles$default(this, entity, (Vec3)e2, 0, 4, null);
                        } while (0 <= i);
                        break;
                    }
                    case 2: {
                        int i;
                        int properLinkCount = Math.max(2, visibleLinks);
                        ArrayList<Vec3> linkPositions = new ArrayList<Vec3>();
                        for (i = 0; i < properLinkCount; ++i) {
                            float linkProgress = (float)i / (float)RangesKt.coerceAtLeast((int)(properLinkCount - 1), (int)1);
                            Intrinsics.checkNotNull((Object)startPos);
                            Intrinsics.checkNotNull((Object)targetPos);
                            Vec3 linkPos = this.lerpVec3(linkProgress, startPos, targetPos);
                            linkPositions.add(linkPos);
                        }
                        int linkProgress = ((Collection)linkPositions).size();
                        for (i = 0; i < linkProgress; ++i) {
                            Object e = linkPositions.get(i);
                            Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
                            this.renderSingleLink(entity, (Vec3)e, i, worldTime, partialTick, (float)yaw, (float)pitch, (float)i / (float)properLinkCount, poseStack, bufferSource, packedLight, 1.0f);
                            if (!(entity.level().random.nextFloat() < this.particleFrequency)) continue;
                            Object e3 = linkPositions.get(i);
                            Intrinsics.checkNotNullExpressionValue(e3, (String)"get(...)");
                            ChainEntityRenderer.spawnChainParticles$default(this, entity, (Vec3)e3, 0, 4, null);
                        }
                        break;
                    }
                    case 3: {
                        int i;
                        float retractFactor = 1.0f - retractProgress;
                        int currentVisibleLinks = Math.max(2, (int)((float)visibleLinks * retractFactor));
                        if (currentVisibleLinks <= 0) break;
                        ArrayList<Vec3> linkPositions = new ArrayList<Vec3>();
                        Vec3 currentDirection = targetPos.subtract(startPos);
                        double currentDistance = currentDirection.length();
                        Vec3 currentNormalizedDir = currentDistance > 0.0 ? currentDirection.normalize() : normalizedDir;
                        float pullBlend = Math.min(retractProgress * 2.0f, 1.0f);
                        Intrinsics.checkNotNull((Object)targetPos);
                        Vec3 vec3 = startPos.add(currentNormalizedDir.scale(currentDistance * (double)0.3f));
                        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"add(...)");
                        Vec3 adjustedTargetPos = this.lerpVec3(pullBlend, targetPos, vec3);
                        for (i = 0; i < currentVisibleLinks; ++i) {
                            float linkProgress = (float)i / (float)RangesKt.coerceAtLeast((int)(currentVisibleLinks - 1), (int)1);
                            Intrinsics.checkNotNull((Object)startPos);
                            Vec3 linkPos = this.lerpVec3(linkProgress, startPos, adjustedTargetPos);
                            linkPositions.add(linkPos);
                        }
                        int n = ((Collection)linkPositions).size();
                        for (i = 0; i < n; ++i) {
                            Object e = linkPositions.get(i);
                            Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
                            this.renderSingleLink(entity, (Vec3)e, i, worldTime, partialTick, (float)yaw, (float)pitch, (float)i / (float)currentVisibleLinks, poseStack, bufferSource, packedLight, 1.8f);
                            if (i != CollectionsKt.getLastIndex((List)linkPositions) && !(entity.level().random.nextFloat() < this.particleFrequency * 1.5f)) continue;
                            Object e4 = linkPositions.get(i);
                            Intrinsics.checkNotNullExpressionValue(e4, (String)"get(...)");
                            ChainEntityRenderer.spawnChainParticles$default(this, entity, (Vec3)e4, 0, 4, null);
                        }
                        break;
                    }
                }
            }
        }
        poseStack.popPose();
        super.render((Entity)entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
    }

    private final void renderSingleLink(ChainEntity entity, Vec3 linkPos, int linkIndex, long worldTime, float partialTick, float yaw, float pitch, float linkProgress, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, float swayMultiplier) {
        poseStack.pushPose();
        poseStack.translate(linkPos.x - entity.getX(), linkPos.y - entity.getY(), linkPos.z - entity.getZ());
        poseStack.translate(0.0, 1.5, 0.0);
        poseStack.mulPose(Axis.YP.rotationDegrees(yaw - 90.0f));
        poseStack.mulPose(Axis.ZP.rotationDegrees(pitch));
        poseStack.translate(0.0, -1.5, 0.0);
        poseStack.translate(0.25, 0.0, 0.0);
        float animationOffset = (float)linkIndex * 0.5f + ((float)worldTime + partialTick) * this.swaySpeed;
        float swayAngle = (float)Math.sin(animationOffset) * this.swayAmplitude * linkProgress * swayMultiplier;
        if (linkIndex % 2 == 0) {
            poseStack.mulPose(Axis.XP.rotationDegrees(swayAngle));
        } else {
            poseStack.mulPose(Axis.ZP.rotationDegrees(swayAngle));
        }
        float baseScale = 0.75f;
        poseStack.scale(baseScale, baseScale, baseScale);
        if (linkIndex % 2 == 1) {
            poseStack.translate(-2.0f, 1.3125f, 0.0f);
            poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
            poseStack.translate(2.0f, -1.3125f, 0.0f);
        }
        this.chainModel.getChain().render(poseStack, bufferSource.getBuffer(RenderType.entityTranslucentEmissive((ResourceLocation)this.getTextureLocation(entity))), packedLight, OverlayTexture.NO_OVERLAY, -1);
        Integer n = (Integer)entity.getEntityData().get(ChainEntity.Companion.getTYPE());
        int n2 = ChainType.SPIRIT.getIndex();
        RenderType.CompositeRenderType ov = n != null && n == n2 ? WitcheryRenderTypes.INSTANCE.getSPIRIT_CHAIN().apply(this.getTextureLocation(entity)) : WitcheryRenderTypes.INSTANCE.getSOUL_CHAIN().apply(this.getTextureLocation(entity));
        this.chainModel.getOverlay().render(poseStack, bufferSource.getBuffer((RenderType)ov), packedLight, OverlayTexture.NO_OVERLAY, -1);
        poseStack.popPose();
    }

    private final void spawnChainParticles(ChainEntity entity, Vec3 pos, int count) {
        Level level = entity.level();
        RandomSource random = level.random;
        block4: for (int i = 0; i < count; ++i) {
            float offsetX = (random.nextFloat() - 0.5f) * 0.5f;
            float offsetY = (random.nextFloat() - 0.5f) * 0.5f;
            float offsetZ = (random.nextFloat() - 0.5f) * 0.5f;
            ChainEntity.ChainState chainState = entity.getChainState();
            Vec3 particlePos = new Vec3(pos.x + (double)offsetX, pos.y + (double)offsetY, pos.z + (double)offsetZ);
            if (!(random.nextFloat() < 0.1f)) continue;
            level.addParticle((ParticleOptions)ParticleTypes.SMOKE, particlePos.x, particlePos.y, particlePos.z, 0.0, 0.0, 0.0);
            switch (WhenMappings.$EnumSwitchMapping$0[chainState.ordinal()]) {
                case 1: {
                    level.addParticle((ParticleOptions)ParticleTypes.WITCH, particlePos.x, particlePos.y, particlePos.z, 0.0, 0.05, 0.0);
                    continue block4;
                }
                case 3: {
                    level.addParticle((ParticleOptions)ParticleTypes.WITCH, particlePos.x, particlePos.y, particlePos.z, (double)offsetX * 0.1, 0.05, (double)offsetZ * 0.1);
                }
            }
        }
    }

    static /* synthetic */ void spawnChainParticles$default(ChainEntityRenderer chainEntityRenderer, ChainEntity chainEntity, Vec3 vec3, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 1;
        }
        chainEntityRenderer.spawnChainParticles(chainEntity, vec3, n);
    }

    public boolean shouldRender(@NotNull ChainEntity livingEntity, @NotNull Frustum camera, double camX, double camY, double camZ) {
        Intrinsics.checkNotNullParameter((Object)((Object)livingEntity), (String)"livingEntity");
        Intrinsics.checkNotNullParameter((Object)camera, (String)"camera");
        AABB aABB = livingEntity.getBoundingBoxForCulling().inflate(1.5).expandTowards(livingEntity.position());
        if (camera.isVisible(aABB)) {
            return true;
        }
        return super.shouldRender((Entity)livingEntity, camera, camX, camY, camZ);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ChainEntity.ChainState.values().length];
            try {
                nArray[ChainEntity.ChainState.EXTENDING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ChainEntity.ChainState.CONNECTED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ChainEntity.ChainState.RETRACTING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

