/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.sterner.witchery.Witchery;
import dev.sterner.witchery.client.model.EntEntityModel;
import dev.sterner.witchery.content.entity.EntEntity;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J8\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J8\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u0011H\u0014J\u0010\u0010\u001e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Ldev/sterner/witchery/client/renderer/entity/EntEntityRenderer;", "Lnet/minecraft/client/renderer/entity/MobRenderer;", "Ldev/sterner/witchery/content/entity/EntEntity;", "Ldev/sterner/witchery/client/model/EntEntityModel;", "context", "Lnet/minecraft/client/renderer/entity/EntityRendererProvider$Context;", "<init>", "(Lnet/minecraft/client/renderer/entity/EntityRendererProvider$Context;)V", "ROWAN", "Lnet/minecraft/resources/ResourceLocation;", "kotlin.jvm.PlatformType", "ALDER", "HAWTHORN", "render", "", "entity", "entityYaw", "", "partialTicks", "poseStack", "Lcom/mojang/blaze3d/vertex/PoseStack;", "buffer", "Lnet/minecraft/client/renderer/MultiBufferSource;", "packedLight", "", "setupRotations", "bob", "yBodyRot", "partialTick", "scale", "getTextureLocation", "witchery"})
public final class EntEntityRenderer
extends MobRenderer<EntEntity, EntEntityModel> {
    private final ResourceLocation ROWAN;
    private final ResourceLocation ALDER;
    private final ResourceLocation HAWTHORN;

    public EntEntityRenderer(@NotNull EntityRendererProvider.Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ModelPart modelPart = context.bakeLayer(EntEntityModel.Companion.getLAYER_LOCATION());
        Intrinsics.checkNotNullExpressionValue((Object)modelPart, (String)"bakeLayer(...)");
        super(context, (EntityModel)new EntEntityModel(modelPart), 0.8f);
        this.ROWAN = Witchery.Companion.id("textures/entity/rowan_ent.png");
        this.ALDER = Witchery.Companion.id("textures/entity/alder_ent.png");
        this.HAWTHORN = Witchery.Companion.id("textures/entity/hawthorn_ent.png");
    }

    public void render(@NotNull EntEntity entity, float entityYaw, float partialTicks, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int packedLight) {
        Intrinsics.checkNotNullParameter((Object)((Object)entity), (String)"entity");
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        poseStack.pushPose();
        super.render((LivingEntity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
        poseStack.popPose();
    }

    protected void setupRotations(@NotNull EntEntity entity, @NotNull PoseStack poseStack, float bob, float yBodyRot, float partialTick, float scale) {
        Intrinsics.checkNotNullParameter((Object)((Object)entity), (String)"entity");
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        super.setupRotations((LivingEntity)entity, poseStack, bob, yBodyRot, partialTick, scale);
        if (!((double)entity.walkAnimation.speed() < 0.01)) {
            float g = entity.walkAnimation.position(partialTick) + 6.0f;
            float h = (float)((Math.abs((double)(g % 13.0f - 6.5f)) - (double)3.25f) / (double)3.25f);
            poseStack.mulPose(Axis.ZP.rotationDegrees(6.5f * h));
        }
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull EntEntity entity) {
        Intrinsics.checkNotNullParameter((Object)((Object)entity), (String)"entity");
        EntEntity.Type variant = entity.getVariant();
        if (variant == EntEntity.Type.ALDER) {
            ResourceLocation resourceLocation = this.ALDER;
            Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"ALDER");
            return resourceLocation;
        }
        if (variant == EntEntity.Type.HAWTHORN) {
            ResourceLocation resourceLocation = this.HAWTHORN;
            Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"HAWTHORN");
            return resourceLocation;
        }
        ResourceLocation resourceLocation = this.ROWAN;
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"ROWAN");
        return resourceLocation;
    }
}

