/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.client.renderer.entity;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.sterner.witchery.client.SleepingClientPlayerEntity;
import dev.sterner.witchery.client.particle.ZzzData;
import dev.sterner.witchery.content.entity.player_shell.SleepingPlayerEntity;
import dev.sterner.witchery.core.api.entity.PlayerShellEntity;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016J8\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u0002H\u0002R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u001d"}, d2={"Ldev/sterner/witchery/client/renderer/entity/SleepingPlayerEntityRenderer;", "Lnet/minecraft/client/renderer/entity/EntityRenderer;", "Ldev/sterner/witchery/core/api/entity/PlayerShellEntity;", "context", "Lnet/minecraft/client/renderer/entity/EntityRendererProvider$Context;", "<init>", "(Lnet/minecraft/client/renderer/entity/EntityRendererProvider$Context;)V", "sleepPlayer", "Ldev/sterner/witchery/client/SleepingClientPlayerEntity;", "getSleepPlayer", "()Ldev/sterner/witchery/client/SleepingClientPlayerEntity;", "setSleepPlayer", "(Ldev/sterner/witchery/client/SleepingClientPlayerEntity;)V", "getTextureLocation", "Lnet/minecraft/resources/ResourceLocation;", "entity", "render", "", "entityYaw", "", "partialTick", "poseStack", "Lcom/mojang/blaze3d/vertex/PoseStack;", "bufferSource", "Lnet/minecraft/client/renderer/MultiBufferSource;", "packedLight", "", "addZ", "player", "witchery"})
public final class SleepingPlayerEntityRenderer
extends EntityRenderer<PlayerShellEntity> {
    @Nullable
    private SleepingClientPlayerEntity sleepPlayer;

    public SleepingPlayerEntityRenderer(@NotNull EntityRendererProvider.Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
    }

    @Nullable
    public final SleepingClientPlayerEntity getSleepPlayer() {
        return this.sleepPlayer;
    }

    public final void setSleepPlayer(@Nullable SleepingClientPlayerEntity sleepingClientPlayerEntity) {
        this.sleepPlayer = sleepingClientPlayerEntity;
    }

    @Nullable
    public ResourceLocation getTextureLocation(@NotNull PlayerShellEntity entity) {
        Intrinsics.checkNotNullParameter((Object)((Object)entity), (String)"entity");
        return null;
    }

    public void render(@NotNull PlayerShellEntity entity, float entityYaw, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight) {
        Intrinsics.checkNotNullParameter((Object)((Object)entity), (String)"entity");
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        Intrinsics.checkNotNullParameter((Object)bufferSource, (String)"bufferSource");
        poseStack.pushPose();
        poseStack.mulPose(Axis.YP.rotationDegrees(-entity.getYRot()));
        if (entity instanceof SleepingPlayerEntity) {
            if (((SleepingPlayerEntity)entity).isFaceplanted()) {
                poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
                poseStack.translate(0.0, -1.0, -0.125625);
            } else {
                poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
                poseStack.translate(0.0, -1.0, 0.125625);
            }
        }
        if (this.sleepPlayer == null) {
            ResolvableProfile resolvable = (ResolvableProfile)entity.getEntityData().get(PlayerShellEntity.Companion.getRESOLVEABLE());
            GameProfile gameProfile = resolvable.gameProfile();
            Level level = entity.level();
            Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.client.multiplayer.ClientLevel");
            ClientLevel clientLevel = (ClientLevel)level;
            Intrinsics.checkNotNull((Object)gameProfile);
            this.sleepPlayer = new SleepingClientPlayerEntity(clientLevel, gameProfile, entity.getEquipment(), entity.getModel());
        }
        if (this.sleepPlayer != null) {
            Object object = entity.getEntityData().get(PlayerShellEntity.Companion.getHURT_TIME());
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            this.sleepPlayer.hurtTime = ((Number)object).intValue();
        }
        if (entity instanceof SleepingPlayerEntity) {
            if (this.sleepPlayer != null) {
                this.sleepPlayer.yHeadRotO = 0.0f;
            }
            if (this.sleepPlayer != null) {
                this.sleepPlayer.yHeadRot = 0.0f;
            }
        } else {
            if (this.sleepPlayer != null) {
                this.sleepPlayer.yHeadRotO = entity.getYHeadRot();
            }
            if (this.sleepPlayer != null) {
                this.sleepPlayer.yHeadRot = entity.getYHeadRot();
            }
        }
        SleepingClientPlayerEntity sleepingClientPlayerEntity = this.sleepPlayer;
        if (sleepingClientPlayerEntity != null) {
            SleepingClientPlayerEntity it = sleepingClientPlayerEntity;
            boolean bl = false;
            Minecraft.getInstance().getEntityRenderDispatcher().getRenderer((Entity)it).render((Entity)it, 0.0f, partialTick, poseStack, bufferSource, packedLight);
        }
        if (entity instanceof SleepingPlayerEntity && entity.level().random.nextDouble() < 0.05) {
            this.addZ(entity);
        }
        poseStack.popPose();
    }

    private final void addZ(PlayerShellEntity player) {
        Vec3 pos = player.position();
        double headHeightOffset = 0.5;
        double horizontalOffset = 0.6;
        double yawRad = Math.toRadians((double)player.getYRot() - (double)90);
        double xOffset = horizontalOffset * Math.cos(yawRad);
        double zOffset = horizontalOffset * Math.sin(yawRad);
        player.level().addAlwaysVisibleParticle((ParticleOptions)new ZzzData(1.0f), true, pos.x + xOffset + Mth.nextDouble((RandomSource)player.level().random, (double)-0.1, (double)0.1), pos.y + headHeightOffset, pos.z + zOffset + Mth.nextDouble((RandomSource)player.level().random, (double)-0.1, (double)0.1), 0.0, 0.0, 0.0);
    }
}

