/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.client.screen;

import dev.sterner.witchery.Witchery;
import dev.sterner.witchery.features.affliction.AfflictionPlayerAttachment;
import dev.sterner.witchery.features.affliction.AfflictionTypes;
import dev.sterner.witchery.features.affliction.ability.AfflictionAbility;
import dev.sterner.witchery.features.affliction.ability.AfflictionAbilityHandler;
import dev.sterner.witchery.features.affliction.lich.LichdomAbility;
import dev.sterner.witchery.features.affliction.vampire.VampireAbility;
import dev.sterner.witchery.features.affliction.werewolf.WerewolfAbility;
import dev.sterner.witchery.network.UpdateSelectedAbilitiesC2SPayload;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\u0010\u0006\n\u0002\b\n\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0014J(\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J(\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J \u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0007H\u0002J\u0010\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J(\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0007H\u0002J \u0010\u001f\u001a\u00020 2\u0006\u0010\u0016\u001a\u00020!2\u0006\u0010\u0017\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0007H\u0016J\u0010\u0010#\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\fH\u0002J8\u0010$\u001a\u00020 2\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010%\u001a\u00020\u00072\u0006\u0010&\u001a\u00020\u00072\u0006\u0010'\u001a\u00020\u00072\u0006\u0010(\u001a\u00020\u0007H\u0002J\b\u0010)\u001a\u00020\u0012H\u0002J\b\u0010*\u001a\u00020 H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Ldev/sterner/witchery/client/screen/AbilitySelectionScreen;", "Lnet/minecraft/client/gui/screens/Screen;", "player", "Lnet/minecraft/world/entity/player/Player;", "<init>", "(Lnet/minecraft/world/entity/player/Player;)V", "ABILITIES_PER_ROW", "", "SLOT_SIZE", "MAX_SELECTED", "availableAbilities", "", "Ldev/sterner/witchery/features/affliction/ability/AfflictionAbility;", "selectedAbilities", "", "", "hoveredAbility", "init", "", "render", "guiGraphics", "Lnet/minecraft/client/gui/GuiGraphics;", "mouseX", "mouseY", "partialTick", "", "renderBackground", "renderAbilityGrid", "renderSelectedBar", "renderTooltip", "ability", "mouseClicked", "", "", "button", "toggleAbility", "isMouseOver", "x", "y", "width", "height", "saveAndClose", "isPauseScreen", "witchery"})
@SourceDebugExtension(value={"SMAP\nAbilitySelectionScreen.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbilitySelectionScreen.kt\ndev/sterner/witchery/client/screen/AbilitySelectionScreen\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,284:1\n1878#2,3:285\n1878#2,3:289\n1#3:288\n*S KotlinDebug\n*F\n+ 1 AbilitySelectionScreen.kt\ndev/sterner/witchery/client/screen/AbilitySelectionScreen\n*L\n100#1:285,3\n225#1:289,3\n*E\n"})
public final class AbilitySelectionScreen
extends Screen {
    @NotNull
    private final Player player;
    private final int ABILITIES_PER_ROW;
    private final int SLOT_SIZE;
    private final int MAX_SELECTED;
    @NotNull
    private List<? extends AfflictionAbility> availableAbilities;
    @NotNull
    private List<String> selectedAbilities;
    @Nullable
    private AfflictionAbility hoveredAbility;

    public AbilitySelectionScreen(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        super((Component)Component.literal((String)"Select Abilities"));
        this.player = player;
        this.ABILITIES_PER_ROW = 5;
        this.SLOT_SIZE = 26;
        this.MAX_SELECTED = 5;
        this.availableAbilities = CollectionsKt.emptyList();
        this.selectedAbilities = new ArrayList();
    }

    protected void init() {
        super.init();
        this.availableAbilities = AfflictionAbilityHandler.INSTANCE.getAllAvailableAbilities(this.player);
        AfflictionPlayerAttachment.Data data2 = AfflictionPlayerAttachment.getData(this.player);
        this.selectedAbilities = CollectionsKt.toMutableList((Collection)data2.getSelectedAbilities());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)((Component)Component.literal((String)"Confirm")), arg_0 -> AbilitySelectionScreen.init$lambda$0(this, arg_0)).pos(this.width / 2 - 50, this.height - 30).size(100, 20).build());
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        guiGraphics.drawCenteredString(this.font, "Select 5 Active Abilities", this.width / 2, 20, 0xFFFFFF);
        int selectedColor = this.selectedAbilities.size() == this.MAX_SELECTED ? 65280 : 0xFFFFFF;
        guiGraphics.drawString(this.font, "Selected: " + this.selectedAbilities.size() + "/" + this.MAX_SELECTED, this.width / 2 - 40, 35, selectedColor);
        this.renderAbilityGrid(guiGraphics, mouseX, mouseY);
        this.renderSelectedBar(guiGraphics);
        AfflictionAbility afflictionAbility = this.hoveredAbility;
        if (afflictionAbility != null) {
            AfflictionAbility it = afflictionAbility;
            boolean bl = false;
            this.renderTooltip(guiGraphics, it, mouseX, mouseY);
        }
        super.render(guiGraphics, mouseX, mouseY, partialTick);
    }

    public void renderBackground(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
    }

    /*
     * WARNING - void declaration
     */
    private final void renderAbilityGrid(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int startX = this.width / 2 - this.ABILITIES_PER_ROW * this.SLOT_SIZE / 2;
        int startY = 60;
        this.hoveredAbility = null;
        Iterable $this$forEachIndexed$iv = this.availableAbilities;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void ability;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            AfflictionAbility afflictionAbility = (AfflictionAbility)item$iv;
            int index = n;
            boolean bl = false;
            int row = index / this.ABILITIES_PER_ROW;
            int col = index % this.ABILITIES_PER_ROW;
            int x = startX + col * this.SLOT_SIZE;
            int y = startY + row * this.SLOT_SIZE;
            boolean isSelected = this.selectedAbilities.contains(ability.getId());
            int slotColor = isSelected ? 0x4400FF00 : (this.isMouseOver(mouseX, mouseY, x, y, this.SLOT_SIZE, this.SLOT_SIZE) ? 0x44FFFFFF : 0x44000000);
            guiGraphics.fill(x, y, x + this.SLOT_SIZE - 2, y + this.SLOT_SIZE - 2, slotColor);
            guiGraphics.renderOutline(x, y, this.SLOT_SIZE - 2, this.SLOT_SIZE - 2, -5592406);
            void var21_21 = ability;
            String iconPath = var21_21 instanceof VampireAbility ? "textures/gui/affliction_abilities/" + ability.getId() + ".png" : (var21_21 instanceof WerewolfAbility ? "textures/gui/affliction_abilities/" + ability.getId() + ".png" : (var21_21 instanceof LichdomAbility ? "textures/gui/affliction_abilities/" + ability.getId() + ".png" : "textures/gui/affliction_abilities/unknown.png"));
            guiGraphics.blit(Witchery.Companion.id(iconPath), x + 4, y + 4, 16, 16, 0.0f, 0.0f, 16, 16, 16, 16);
            if (!this.isMouseOver(mouseX, mouseY, x, y, this.SLOT_SIZE, this.SLOT_SIZE)) continue;
            this.hoveredAbility = ability;
        }
    }

    private final void renderSelectedBar(GuiGraphics guiGraphics) {
        int barY = this.height - 70;
        int barWidth = this.MAX_SELECTED * this.SLOT_SIZE;
        int startX = this.width / 2 - barWidth / 2;
        guiGraphics.fill(startX - 2, barY - 2, startX + barWidth + 2, barY + this.SLOT_SIZE, -2013265920);
        int n = this.MAX_SELECTED;
        for (int i = 0; i < n; ++i) {
            AfflictionAbility it;
            Object v0;
            int x;
            block2: {
                x = startX + i * this.SLOT_SIZE;
                guiGraphics.renderOutline(x, barY, this.SLOT_SIZE - 2, this.SLOT_SIZE - 2, -1);
                if (i >= this.selectedAbilities.size()) continue;
                String abilityId = this.selectedAbilities.get(i);
                Iterable iterable = this.availableAbilities;
                for (Object t : iterable) {
                    AfflictionAbility it2 = (AfflictionAbility)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it2.getId(), (Object)abilityId)) continue;
                    v0 = t;
                    break block2;
                }
                v0 = null;
            }
            AfflictionAbility ability = v0;
            if (ability == null) continue;
            boolean bl = false;
            String iconPath = "textures/gui/affliction_abilities/" + it.getId() + ".png";
            guiGraphics.blit(Witchery.Companion.id(iconPath), x + 5, barY + 5, 16, 16, 0.0f, 0.0f, 16, 16, 16, 16);
        }
        guiGraphics.drawCenteredString(this.font, "Active Abilities", this.width / 2, barY - 15, 0xFFFFFF);
    }

    private final void renderTooltip(GuiGraphics guiGraphics, AfflictionAbility ability, int mouseX, int mouseY) {
        List tooltip = new ArrayList();
        MutableComponent mutableComponent = Component.literal((String)StringsKt.capitalize((String)StringsKt.replace$default((String)ability.getId(), (char)'_', (char)' ', (boolean)false, (int)4, null))).withStyle(ChatFormatting.YELLOW);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"withStyle(...)");
        tooltip.add(mutableComponent);
        ChatFormatting typeColor = switch (WhenMappings.$EnumSwitchMapping$0[ability.getAffliction().ordinal()]) {
            case 1 -> ChatFormatting.RED;
            case 2 -> ChatFormatting.GOLD;
            default -> ChatFormatting.WHITE;
        };
        MutableComponent mutableComponent2 = Component.literal((String)("Type: " + ability.getAffliction().name())).withStyle(typeColor);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent2, (String)"withStyle(...)");
        tooltip.add(mutableComponent2);
        MutableComponent mutableComponent3 = Component.literal((String)("Required Level: " + ability.getRequiredLevel())).withStyle(ChatFormatting.GRAY);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent3, (String)"withStyle(...)");
        tooltip.add(mutableComponent3);
        boolean isSelected = this.selectedAbilities.contains(ability.getId());
        if (isSelected) {
            MutableComponent mutableComponent4 = Component.literal((String)"Selected").withStyle(ChatFormatting.GREEN);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent4, (String)"withStyle(...)");
            v5 = tooltip.add(mutableComponent4);
        } else if (this.selectedAbilities.size() >= this.MAX_SELECTED) {
            MutableComponent mutableComponent5 = Component.literal((String)"Max abilities selected").withStyle(ChatFormatting.RED);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent5, (String)"withStyle(...)");
            v5 = tooltip.add(mutableComponent5);
        } else {
            MutableComponent mutableComponent6 = Component.literal((String)"Click to select").withStyle(ChatFormatting.GREEN);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent6, (String)"withStyle(...)");
            v5 = tooltip.add(mutableComponent6);
        }
        guiGraphics.renderComponentTooltip(this.font, tooltip, mouseX, mouseY);
    }

    /*
     * WARNING - void declaration
     */
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0) {
            int startX = this.width / 2 - this.ABILITIES_PER_ROW * this.SLOT_SIZE / 2;
            int startY = 60;
            Iterable $this$forEachIndexed$iv = this.availableAbilities;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void ability;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                AfflictionAbility afflictionAbility = (AfflictionAbility)item$iv;
                int index = n;
                boolean bl = false;
                int col = index % this.ABILITIES_PER_ROW;
                int x = startX + col * this.SLOT_SIZE;
                int row = index / this.ABILITIES_PER_ROW;
                int y = startY + row * this.SLOT_SIZE;
                if (!this.isMouseOver((int)mouseX, (int)mouseY, x, y, this.SLOT_SIZE, this.SLOT_SIZE)) continue;
                this.toggleAbility((AfflictionAbility)ability);
                return true;
            }
            int barY = this.height - 70;
            int barWidth = this.MAX_SELECTED * this.SLOT_SIZE;
            int barStartX = this.width / 2 - barWidth / 2;
            int n = ((Collection)this.selectedAbilities).size();
            for (int i = 0; i < n; ++i) {
                int x = barStartX + i * this.SLOT_SIZE;
                if (!this.isMouseOver((int)mouseX, (int)mouseY, x, barY, this.SLOT_SIZE, this.SLOT_SIZE)) continue;
                this.selectedAbilities.remove(i);
                Minecraft minecraft = this.minecraft;
                if (minecraft != null && (minecraft = minecraft.getSoundManager()) != null) {
                    minecraft.play((SoundInstance)SimpleSoundInstance.forUI((Holder)((Holder)SoundEvents.UI_BUTTON_CLICK), (float)1.0f));
                }
                return true;
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    private final void toggleAbility(AfflictionAbility ability) {
        block1: {
            block2: {
                block0: {
                    if (!this.selectedAbilities.contains(ability.getId())) break block0;
                    this.selectedAbilities.remove(ability.getId());
                    Minecraft minecraft = this.minecraft;
                    if (minecraft == null || (minecraft = minecraft.getSoundManager()) == null) break block1;
                    minecraft.play((SoundInstance)SimpleSoundInstance.forUI((Holder)((Holder)SoundEvents.UI_BUTTON_CLICK), (float)0.8f));
                    break block1;
                }
                if (this.selectedAbilities.size() >= this.MAX_SELECTED) break block2;
                this.selectedAbilities.add(ability.getId());
                Minecraft minecraft = this.minecraft;
                if (minecraft == null || (minecraft = minecraft.getSoundManager()) == null) break block1;
                minecraft.play((SoundInstance)SimpleSoundInstance.forUI((Holder)((Holder)SoundEvents.UI_BUTTON_CLICK), (float)1.2f));
                break block1;
            }
            Minecraft minecraft = this.minecraft;
            if (minecraft == null || (minecraft = minecraft.getSoundManager()) == null) break block1;
            minecraft.play((SoundInstance)SimpleSoundInstance.forUI((Holder)((Holder)SoundEvents.UI_BUTTON_CLICK), (float)0.5f));
        }
    }

    private final boolean isMouseOver(int mouseX, int mouseY, int x, int y, int width, int height) {
        return mouseX >= x && mouseX < x + width && mouseY >= y && mouseY < y + height;
    }

    private final void saveAndClose() {
        Minecraft minecraft = this.minecraft;
        if ((minecraft != null ? minecraft.player : null) != null) {
            if (this.selectedAbilities.isEmpty()) {
                this.player.getInventory().selected = 0;
            }
            PacketDistributor.sendToServer((CustomPacketPayload)new UpdateSelectedAbilitiesC2SPayload(this.selectedAbilities), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        this.onClose();
    }

    public boolean isPauseScreen() {
        return false;
    }

    private static final void init$lambda$0(AbilitySelectionScreen this$0, Button button) {
        this$0.saveAndClose();
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AfflictionTypes.values().length];
            try {
                nArray[AfflictionTypes.VAMPIRISM.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AfflictionTypes.LYCANTHROPY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

