/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.sterner.witchery.Witchery;
import dev.sterner.witchery.content.menu.SoulTradingMenu;
import dev.sterner.witchery.core.util.RenderUtils;
import dev.sterner.witchery.network.SelectSoulTradeC2SPayload;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0016\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u000b\u0018\u0000 X2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001XB\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u00102\u001a\u000203H\u0014J\b\u00104\u001a\u00020)H\u0016J\b\u00105\u001a\u000203H\u0014J(\u00106\u001a\u0002032\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020%2\u0006\u0010:\u001a\u00020\u000e2\u0006\u0010;\u001a\u00020\u000eH\u0014J \u0010<\u001a\u0002032\u0006\u00107\u001a\u0002082\u0006\u0010:\u001a\u00020\u000e2\u0006\u0010;\u001a\u00020\u000eH\u0014J0\u0010=\u001a\u0002032\u0006\u00107\u001a\u0002082\u0006\u0010>\u001a\u00020\u000e2\u0006\u0010?\u001a\u00020\u000e2\u0006\u0010:\u001a\u00020\u000e2\u0006\u0010;\u001a\u00020\u000eH\u0002J0\u0010@\u001a\u0002032\u0006\u00107\u001a\u0002082\u0006\u0010>\u001a\u00020\u000e2\u0006\u0010?\u001a\u00020\u000e2\u0006\u0010:\u001a\u00020\u000e2\u0006\u0010;\u001a\u00020\u000eH\u0002J(\u0010A\u001a\u0002032\u0006\u00107\u001a\u0002082\u0006\u0010>\u001a\u00020\u000e2\u0006\u0010?\u001a\u00020\u000e2\u0006\u00109\u001a\u00020%H\u0002J(\u0010B\u001a\u0002032\u0006\u00107\u001a\u0002082\u0006\u0010C\u001a\u00020\u000e2\u0006\u0010D\u001a\u00020\u000e2\u0006\u0010E\u001a\u00020%H\u0002J\u001a\u0010F\u001a\u00020%2\u0006\u0010G\u001a\u00020\u000e2\b\u0010H\u001a\u0004\u0018\u00010IH\u0002J\u0014\u0010J\u001a\u00020\u000e2\n\u0010K\u001a\u0006\u0012\u0002\b\u00030LH\u0002J \u0010M\u001a\u00020)2\u0006\u0010:\u001a\u00020N2\u0006\u0010;\u001a\u00020N2\u0006\u0010O\u001a\u00020\u000eH\u0016J0\u0010P\u001a\u00020)2\u0006\u0010:\u001a\u00020N2\u0006\u0010;\u001a\u00020N2\u0006\u0010O\u001a\u00020\u000e2\u0006\u0010Q\u001a\u00020N2\u0006\u0010R\u001a\u00020NH\u0016J \u0010S\u001a\u00020)2\u0006\u0010:\u001a\u00020N2\u0006\u0010;\u001a\u00020N2\u0006\u0010O\u001a\u00020\u000eH\u0016J(\u0010T\u001a\u00020)2\u0006\u0010:\u001a\u00020N2\u0006\u0010;\u001a\u00020N2\u0006\u0010U\u001a\u00020N2\u0006\u0010V\u001a\u00020NH\u0016J(\u0010W\u001a\u0002032\u0006\u00107\u001a\u0002082\u0006\u0010:\u001a\u00020\u000e2\u0006\u0010;\u001a\u00020\u000e2\u0006\u00109\u001a\u00020%H\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000eX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000eX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000eX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000eX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u000eX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u000eX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u000eX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u000eX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u000eX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u000eX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u000eX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u000eX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u000eX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u000eX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u000eX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u000eX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u000eX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u000eX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u000eX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u000eX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020%X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020)X\u0082\u000e\u00a2\u0006\u0002\n\u0000R,\u0010*\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00020-0,0+X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010/\"\u0004\b0\u00101\u00a8\u0006Y"}, d2={"Ldev/sterner/witchery/client/screen/SoulTradingScreen;", "Lnet/minecraft/client/gui/screens/inventory/AbstractContainerScreen;", "Ldev/sterner/witchery/content/menu/SoulTradingMenu;", "menu", "inventory", "Lnet/minecraft/world/entity/player/Inventory;", "title", "Lnet/minecraft/network/chat/Component;", "<init>", "(Ldev/sterner/witchery/content/menu/SoulTradingMenu;Lnet/minecraft/world/entity/player/Inventory;Lnet/minecraft/network/chat/Component;)V", "texture", "Lnet/minecraft/resources/ResourceLocation;", "soulHeadsTexture", "tradeScrollOffset", "", "soulScrollOffset", "tradeColumnX", "tradeColumnY", "tradeColumnWidth", "tradeColumnHeight", "soulColumnX", "soulColumnY", "soulColumnWidth", "soulColumnHeight", "scaleStandX", "scaleStandY", "scaleStandWidth", "scaleStandHeight", "scaleArmX", "scaleArmY", "scaleArmWidth", "scaleArmHeight", "scaleBowlX", "scaleBowlY", "scaleBowlWidth", "scaleBowlHeight", "currentRotation", "", "targetRotation", "rotationSpeed", "isDraggingTradeScroll", "", "tradeSlotButtons", "", "Lkotlin/Pair;", "Lnet/minecraft/client/gui/components/ImageButton;", "getTradeSlotButtons", "()Ljava/util/Set;", "setTradeSlotButtons", "(Ljava/util/Set;)V", "init", "", "isPauseScreen", "containerTick", "renderBg", "guiGraphics", "Lnet/minecraft/client/gui/GuiGraphics;", "partialTick", "mouseX", "mouseY", "renderLabels", "renderTradeColumn", "screenX", "screenY", "renderSoulColumn", "renderScale", "renderRotatedArm", "centerX", "centerY", "rotation", "calculateScaleRotation", "totalCost", "soul", "Ldev/sterner/witchery/content/menu/SoulTradingMenu$SoulData;", "getSoulHeadIndex", "entityType", "Lnet/minecraft/world/entity/EntityType;", "mouseClicked", "", "button", "mouseDragged", "dragX", "dragY", "mouseReleased", "mouseScrolled", "scrollX", "scrollY", "render", "Companion", "witchery"})
@SourceDebugExtension(value={"SMAP\nSoulTradingScreen.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SoulTradingScreen.kt\ndev/sterner/witchery/client/screen/SoulTradingScreen\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,427:1\n1#2:428\n*E\n"})
public final class SoulTradingScreen
extends AbstractContainerScreen<SoulTradingMenu> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ResourceLocation texture;
    @NotNull
    private final ResourceLocation soulHeadsTexture;
    private int tradeScrollOffset;
    private int soulScrollOffset;
    private final int tradeColumnX;
    private final int tradeColumnY;
    private final int tradeColumnWidth;
    private final int tradeColumnHeight;
    private final int soulColumnX;
    private final int soulColumnY;
    private final int soulColumnWidth;
    private final int soulColumnHeight;
    private final int scaleStandX;
    private final int scaleStandY;
    private final int scaleStandWidth;
    private final int scaleStandHeight;
    private final int scaleArmX;
    private final int scaleArmY;
    private final int scaleArmWidth;
    private final int scaleArmHeight;
    private final int scaleBowlX;
    private final int scaleBowlY;
    private final int scaleBowlWidth;
    private final int scaleBowlHeight;
    private float currentRotation;
    private float targetRotation;
    private final float rotationSpeed;
    private boolean isDraggingTradeScroll;
    @NotNull
    private Set<Pair<ImageButton, ImageButton>> tradeSlotButtons;
    @NotNull
    private static final WidgetSprites INCREMENT_SPRITE = new WidgetSprites(Witchery.Companion.id("increment_button_highlighted"), Witchery.Companion.id("increment_button"));
    @NotNull
    private static final WidgetSprites DECREMENT_SPRITE = new WidgetSprites(Witchery.Companion.id("decrement_button_highlighted"), Witchery.Companion.id("decrement_button"));
    @NotNull
    private static final WidgetSprites CONFIRM_SPRITE = new WidgetSprites(Witchery.Companion.id("confirm_button_highlighted"), Witchery.Companion.id("confirm_button"));
    @NotNull
    private static final ResourceLocation SCROLLER_SPRITE;

    public SoulTradingScreen(@NotNull SoulTradingMenu menu, @NotNull Inventory inventory, @NotNull Component title) {
        Intrinsics.checkNotNullParameter((Object)((Object)menu), (String)"menu");
        Intrinsics.checkNotNullParameter((Object)inventory, (String)"inventory");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        super((AbstractContainerMenu)menu, inventory, title);
        ResourceLocation resourceLocation = Witchery.Companion.id("textures/gui/soul_trading.png");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"id(...)");
        this.texture = resourceLocation;
        ResourceLocation resourceLocation2 = Witchery.Companion.id("textures/gui/soul_heads.png");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation2, (String)"id(...)");
        this.soulHeadsTexture = resourceLocation2;
        this.tradeColumnX = 22;
        this.tradeColumnY = 10;
        this.tradeColumnWidth = 16;
        this.tradeColumnHeight = 65;
        this.soulColumnX = 145;
        this.soulColumnY = 10;
        this.soulColumnWidth = 18;
        this.soulColumnHeight = 65;
        this.scaleStandX = 176;
        this.scaleStandY = 32;
        this.scaleStandWidth = 20;
        this.scaleStandHeight = 48;
        this.scaleArmX = 176;
        this.scaleArmWidth = 56;
        this.scaleArmHeight = 8;
        this.scaleBowlX = 176;
        this.scaleBowlY = 9;
        this.scaleBowlWidth = 21;
        this.scaleBowlHeight = 23;
        this.rotationSpeed = 0.15f;
        this.tradeSlotButtons = new LinkedHashSet();
        this.imageWidth = 176;
        this.imageHeight = 166;
    }

    @NotNull
    public final Set<Pair<ImageButton, ImageButton>> getTradeSlotButtons() {
        return this.tradeSlotButtons;
    }

    public final void setTradeSlotButtons(@NotNull Set<Pair<ImageButton, ImageButton>> set) {
        Intrinsics.checkNotNullParameter(set, (String)"<set-?>");
        this.tradeSlotButtons = set;
    }

    protected void init() {
        super.init();
        this.tradeSlotButtons.clear();
        for (int slotIndex = 0; slotIndex < 4; ++slotIndex) {
            int slotX = this.leftPos + 8;
            int slotY = this.topPos + 10 + slotIndex * 16;
            ImageButton plusButton = new ImageButton(slotX, slotY, 13, 7, INCREMENT_SPRITE, arg_0 -> SoulTradingScreen.init$lambda$0(this, slotIndex, arg_0));
            ImageButton minusButton = new ImageButton(slotX, slotY + 8, 13, 7, DECREMENT_SPRITE, arg_0 -> SoulTradingScreen.init$lambda$1(this, slotIndex, arg_0));
            this.addRenderableWidget((GuiEventListener)plusButton);
            this.addRenderableWidget((GuiEventListener)minusButton);
            this.tradeSlotButtons.add((Pair<ImageButton, ImageButton>)new Pair((Object)plusButton, (Object)minusButton));
        }
        int confirmX = this.leftPos + 125;
        int confirmY = this.topPos + 54;
        this.addRenderableWidget((GuiEventListener)new ImageButton(confirmX, confirmY, 13, 7, CONFIRM_SPRITE, arg_0 -> SoulTradingScreen.init$lambda$2(this, arg_0)));
    }

    public boolean isPauseScreen() {
        return false;
    }

    protected void containerTick() {
        super.containerTick();
        SoulTradingMenu.SoulData soul = ((SoulTradingMenu)this.menu).getSelectedSoul();
        int totalCost = ((SoulTradingMenu)this.menu).getTotalSoulCost();
        this.targetRotation = this.calculateScaleRotation(totalCost, soul);
        float diff = this.targetRotation - this.currentRotation;
        this.currentRotation += diff * this.rotationSpeed;
        if (Math.abs(diff) < 0.01f) {
            this.currentRotation = this.targetRotation;
        }
    }

    protected void renderBg(@NotNull GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        RenderSystem.setShader(SoulTradingScreen::renderBg$lambda$0);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.texture);
        int i = this.leftPos;
        int j = this.topPos;
        guiGraphics.blit(this.texture, i, j, 0.0f, 0.0f, 176, 166, 256, 256);
        this.renderTradeColumn(guiGraphics, i, j, mouseX, mouseY);
        this.renderSoulColumn(guiGraphics, i, j, mouseX, mouseY);
        this.renderScale(guiGraphics, i, j, partialTick);
    }

    protected void renderLabels(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        guiGraphics.drawString(this.font, this.title, this.titleLabelX + 48 + 5, this.titleLabelY, 0x404040, false);
    }

    private final void renderTradeColumn(GuiGraphics guiGraphics, int screenX, int screenY, int mouseX, int mouseY) {
        int index;
        List<SoulTradingMenu.SoulTrade> trades = ((SoulTradingMenu)this.menu).getAvailableTrades();
        int maxVisible = 4;
        int itemSize = 16;
        int n = RangesKt.coerceAtMost((int)maxVisible, (int)(trades.size() - this.tradeScrollOffset));
        for (int i = 0; i < n && (index = i + this.tradeScrollOffset) < trades.size(); ++i) {
            Object v0;
            int y;
            int x;
            SoulTradingMenu.SoulTrade trade;
            block3: {
                trade = trades.get(index);
                x = screenX + this.tradeColumnX;
                y = screenY + this.tradeColumnY + i * itemSize;
                Iterable iterable = ((SoulTradingMenu)this.menu).getSelectedTrades();
                for (Object t : iterable) {
                    SoulTradingMenu.SelectedTrade it = (SoulTradingMenu.SelectedTrade)t;
                    boolean bl = false;
                    if (!(it.getTradeIndex() == index)) continue;
                    v0 = t;
                    break block3;
                }
                v0 = null;
            }
            SoulTradingMenu.SelectedTrade selectedTrade = v0;
            guiGraphics.renderItem(trade.getOutput(), x, y);
            if (selectedTrade == null) continue;
            guiGraphics.renderItemDecorations(this.font, trade.getOutput(), x, y, String.valueOf(selectedTrade.getAmount()));
        }
        if (trades.size() > maxVisible) {
            int scrollBarX = screenX + this.tradeColumnX + this.tradeColumnWidth + 2;
            int scrollBarY = screenY + this.tradeColumnY;
            int scrollBarHeight = this.tradeColumnHeight;
            int scrollHandleHeight = 27;
            int totalScrollable = RangesKt.coerceAtLeast((int)(trades.size() - maxVisible), (int)1);
            float scrollProgress = (float)this.tradeScrollOffset / (float)totalScrollable;
            int handleY = scrollBarY + (int)(scrollProgress * (float)(scrollBarHeight - scrollHandleHeight));
            guiGraphics.blitSprite(SCROLLER_SPRITE, scrollBarX, handleY + scrollHandleHeight - 27, 0, 6, 27);
        }
    }

    private final void renderSoulColumn(GuiGraphics guiGraphics, int screenX, int screenY, int mouseX, int mouseY) {
        int index;
        List<SoulTradingMenu.SoulData> souls = ((SoulTradingMenu)this.menu).getAvailableSouls();
        int maxVisible = 4;
        int itemSize = 16;
        int n = RangesKt.coerceAtMost((int)maxVisible, (int)(souls.size() - this.soulScrollOffset));
        for (int i = 0; i < n && (index = i + this.soulScrollOffset) < souls.size(); ++i) {
            SoulTradingMenu.SoulData soul = souls.get(index);
            int x = screenX + this.soulColumnX;
            int y = screenY + this.soulColumnY + i * itemSize;
            Object object = BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.parse((String)soul.getEntityType()));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            int headIndex = this.getSoulHeadIndex((EntityType)object);
            int headU = headIndex % 8 * 16;
            int headV = headIndex / 8 * 16;
            PoseStack poseStack = guiGraphics.pose();
            Intrinsics.checkNotNullExpressionValue((Object)poseStack, (String)"pose(...)");
            RenderUtils.blitWithAlpha$default(RenderUtils.INSTANCE, poseStack, this.soulHeadsTexture, (float)x, (float)y, (float)headU, (float)headV, 16, 16, 128, 128, 0.0f, 0, 3072, null);
        }
        if (souls.size() > maxVisible) {
            int scrollBarX = screenX + this.soulColumnX + this.soulColumnWidth + 2;
            int scrollBarY = screenY + this.soulColumnY;
            int scrollBarHeight = this.soulColumnHeight;
            int scrollHandleHeight = 27;
            float scrollProgress = (float)this.soulScrollOffset / (float)(souls.size() - maxVisible - 1);
            int handleY = scrollBarY + (int)(scrollProgress * (float)(scrollBarHeight - scrollHandleHeight));
            guiGraphics.blitSprite(SCROLLER_SPRITE, scrollBarX, handleY + scrollHandleHeight - 27, 0, 6, 27);
        }
    }

    private final void renderScale(GuiGraphics guiGraphics, int screenX, int screenY, float partialTick) {
        int standX = screenX + 79;
        int standY = screenY + 20;
        guiGraphics.blit(this.texture, standX, standY, (float)this.scaleStandX, (float)this.scaleStandY, this.scaleStandWidth, this.scaleStandHeight, 256, 256);
        SoulTradingMenu.SoulData soul = ((SoulTradingMenu)this.menu).getSelectedSoul();
        float rotation = this.currentRotation + (this.targetRotation - this.currentRotation) * partialTick * this.rotationSpeed;
        int armCenterX = standX + this.scaleStandWidth / 2;
        int armCenterY = standY + 10;
        this.renderRotatedArm(guiGraphics, armCenterX, armCenterY, rotation);
        int armLength = this.scaleArmWidth / 2 - 10;
        double rad = Math.toRadians(-((double)rotation));
        double xSwingFactor = 0.2;
        double dx = armLength;
        double dy = 0.0;
        float leftBowlX = (float)((double)armCenterX - dx * Math.cos(rad) - dy * Math.sin(rad) + Math.sin(rad) * (double)armLength * xSwingFactor);
        float leftBowlY = (float)((double)armCenterY - dx * Math.sin(rad) + dy * Math.cos(rad) + (double)(this.scaleBowlHeight / 2) + (double)2);
        float rightBowlX = (float)((double)armCenterX + dx * Math.cos(rad) + dy * Math.sin(rad) - Math.sin(rad) * (double)armLength * xSwingFactor);
        float rightBowlY = (float)((double)armCenterY + dx * Math.sin(rad) - dy * Math.cos(rad) + (double)(this.scaleBowlHeight / 2) + (double)2);
        PoseStack poseStack = guiGraphics.pose();
        Intrinsics.checkNotNullExpressionValue((Object)poseStack, (String)"pose(...)");
        RenderUtils.blitWithAlpha$default(RenderUtils.INSTANCE, poseStack, this.texture, leftBowlX - (float)this.scaleBowlWidth / 2.0f, leftBowlY - (float)this.scaleBowlHeight / 2.0f, 200.0f, this.scaleBowlX, this.scaleBowlY, this.scaleBowlWidth, this.scaleBowlHeight, 256, 256, 0.0f, 0, 6144, null);
        PoseStack poseStack2 = guiGraphics.pose();
        Intrinsics.checkNotNullExpressionValue((Object)poseStack2, (String)"pose(...)");
        RenderUtils.blitWithAlpha$default(RenderUtils.INSTANCE, poseStack2, this.texture, rightBowlX - (float)this.scaleBowlWidth / 2.0f, rightBowlY - (float)this.scaleBowlHeight / 2.0f, 200.0f, this.scaleBowlX, this.scaleBowlY, this.scaleBowlWidth, this.scaleBowlHeight, 256, 256, 0.0f, 0, 6144, null);
        List<SoulTradingMenu.SelectedTrade> selectedTrades = ((SoulTradingMenu)this.menu).getSelectedTrades();
        if (!((Collection)selectedTrades).isEmpty()) {
            float verticalSpacing = 4.0f;
            float horizontalSpacing = 4.0f;
            float startY = leftBowlY - 4.0f;
            for (IndexedValue indexedValue : CollectionsKt.reversed((Iterable)CollectionsKt.withIndex((Iterable)selectedTrades))) {
                int idx = indexedValue.component1();
                SoulTradingMenu.SelectedTrade selected = (SoulTradingMenu.SelectedTrade)indexedValue.component2();
                if (selected.getTradeIndex() >= ((SoulTradingMenu)this.menu).getAvailableTrades().size()) continue;
                SoulTradingMenu.SoulTrade trade = ((SoulTradingMenu)this.menu).getAvailableTrades().get(selected.getTradeIndex());
                float offsetY = startY - (float)idx * verticalSpacing;
                float offsetX = leftBowlX - 8.0f + (float)(idx % 2) * horizontalSpacing - horizontalSpacing / 2.0f;
                RenderUtils.INSTANCE.renderItemWithAlpha(guiGraphics, trade.getOutput(), offsetX, offsetY, 1.0f);
                Font font = this.font;
                Intrinsics.checkNotNullExpressionValue((Object)font, (String)"font");
                RenderUtils.INSTANCE.renderItemDecorations(guiGraphics, font, trade.getOutput(), offsetX, offsetY);
            }
        }
        if (soul != null) {
            Object object = BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.parse((String)soul.getEntityType()));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            int headIndex = this.getSoulHeadIndex((EntityType)object);
            int headU = headIndex % 8 * 16;
            int headV = headIndex / 8 * 16;
            PoseStack poseStack3 = guiGraphics.pose();
            Intrinsics.checkNotNullExpressionValue((Object)poseStack3, (String)"pose(...)");
            RenderUtils.blitWithAlpha$default(RenderUtils.INSTANCE, poseStack3, this.soulHeadsTexture, rightBowlX - 8.0f, rightBowlY - 3.0f, (float)headU, (float)headV, 16, 16, 128, 128, 0.0f, 0, 3072, null);
        }
    }

    private final void renderRotatedArm(GuiGraphics guiGraphics, int centerX, int centerY, float rotation) {
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        poseStack.translate((double)centerX, (double)centerY, 0.0);
        poseStack.mulPose(Axis.ZN.rotationDegrees(rotation));
        poseStack.translate((double)(-this.scaleArmWidth) / 2.0, (double)(-this.scaleArmHeight) / 2.0, 0.0);
        guiGraphics.blit(this.texture, 0, 0, (float)this.scaleArmX, (float)this.scaleArmY, this.scaleArmWidth, this.scaleArmHeight, 256, 256);
        poseStack.popPose();
    }

    private final float calculateScaleRotation(int totalCost, SoulTradingMenu.SoulData soul) {
        float maxRotation = 25.0f;
        if (totalCost == 0 && (soul == null || soul.getWeight() == 0)) {
            return 0.0f;
        }
        SoulTradingMenu.SoulData soulData = soul;
        int soulWeight = soulData != null ? soulData.getWeight() : 0;
        int weightDiff = totalCost - soulWeight;
        int combinedWeight = RangesKt.coerceAtLeast((int)(totalCost + soulWeight), (int)1);
        float normalizedDiff = (float)weightDiff / (float)combinedWeight;
        float sensitivity = maxRotation * 2.0f;
        return RangesKt.coerceIn((float)(normalizedDiff * sensitivity), (float)(-maxRotation), (float)maxRotation);
    }

    private final int getSoulHeadIndex(EntityType<?> entityType) {
        EntityType<?> entityType2 = entityType;
        return Intrinsics.areEqual(entityType2, (Object)EntityType.VILLAGER) ? 0 : (Intrinsics.areEqual(entityType2, (Object)EntityType.PILLAGER) ? 1 : (Intrinsics.areEqual(entityType2, (Object)EntityType.VINDICATOR) ? 1 : 2));
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        int index;
        double relX = mouseX - (double)this.leftPos;
        double relY = mouseY - (double)this.topPos;
        List<SoulTradingMenu.SoulTrade> trades = ((SoulTradingMenu)this.menu).getAvailableTrades();
        int maxVisible = 4;
        if (trades.size() > maxVisible) {
            int scrollBarX = this.tradeColumnX + this.tradeColumnWidth + 2;
            int scrollBarY = this.tradeColumnY;
            int scrollBarHeight = this.tradeColumnHeight;
            int scrollHandleHeight = 27;
            int totalScrollable = RangesKt.coerceAtLeast((int)(trades.size() - maxVisible), (int)1);
            float scrollProgress = (float)this.tradeScrollOffset / (float)totalScrollable;
            float handleY = (float)scrollBarY + scrollProgress * (float)(scrollBarHeight - scrollHandleHeight);
            double d = scrollBarX;
            boolean bl = relX <= (double)scrollBarX + 6.0 ? d <= relX : false;
            if (bl) {
                boolean bl2 = (double)handleY <= relY ? relY <= (double)(handleY + (float)scrollHandleHeight) : false;
                if (bl2) {
                    this.isDraggingTradeScroll = true;
                    return true;
                }
            }
        }
        if (relX >= (double)this.soulColumnX && relX <= (double)(this.soulColumnX + this.soulColumnWidth) && relY >= (double)this.soulColumnY && relY <= (double)(this.soulColumnY + this.soulColumnHeight) && (index = (int)((relY - (double)this.soulColumnY) / (double)16) + this.soulScrollOffset) < ((SoulTradingMenu)this.menu).getAvailableSouls().size()) {
            PacketDistributor.sendToServer((CustomPacketPayload)new SelectSoulTradeC2SPayload(SelectSoulTradeC2SPayload.Action.SELECT_SOUL, false, index), (CustomPacketPayload[])new CustomPacketPayload[0]);
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isDraggingTradeScroll) {
            List<SoulTradingMenu.SoulTrade> trades = ((SoulTradingMenu)this.menu).getAvailableTrades();
            int maxVisible = 4;
            if (trades.size() > maxVisible) {
                int scrollBarHeight = this.tradeColumnHeight;
                int scrollHandleHeight = 27;
                int totalScrollable = RangesKt.coerceAtLeast((int)(trades.size() - maxVisible), (int)1);
                double deltaY = mouseY - (double)this.topPos - (double)this.tradeColumnY - (double)scrollHandleHeight / 2.0;
                float progress = RangesKt.coerceIn((float)((float)(deltaY / (double)(scrollBarHeight - scrollHandleHeight))), (float)0.0f, (float)1.0f);
                this.tradeScrollOffset = (int)(progress * (float)totalScrollable);
            }
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.isDraggingTradeScroll) {
            this.isDraggingTradeScroll = false;
            return true;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        double relX = mouseX - (double)this.leftPos;
        double relY = mouseY - (double)this.topPos;
        if (relX >= (double)this.tradeColumnX && relX <= (double)(this.tradeColumnX + this.tradeColumnWidth + 8) && relY >= (double)this.tradeColumnY && relY <= (double)(this.tradeColumnY + this.tradeColumnHeight)) {
            this.tradeScrollOffset = RangesKt.coerceIn((int)(this.tradeScrollOffset - (int)scrollY), (int)0, (int)RangesKt.coerceAtLeast((int)(((SoulTradingMenu)this.menu).getAvailableTrades().size() - 4), (int)0));
            return true;
        }
        if (relX >= (double)this.soulColumnX && relX <= (double)(this.soulColumnX + this.soulColumnWidth + 8) && relY >= (double)this.soulColumnY && relY <= (double)(this.soulColumnY + this.soulColumnHeight)) {
            this.soulScrollOffset = RangesKt.coerceIn((int)(this.soulScrollOffset - (int)scrollY), (int)0, (int)RangesKt.coerceAtLeast((int)(((SoulTradingMenu)this.menu).getAvailableSouls().size() - 4), (int)0));
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    private static final void init$lambda$0(SoulTradingScreen this$0, int $slotIndex, Button it) {
        int index = this$0.tradeScrollOffset + $slotIndex;
        if (index >= ((SoulTradingMenu)this$0.menu).getAvailableTrades().size()) {
            return;
        }
        PacketDistributor.sendToServer((CustomPacketPayload)new SelectSoulTradeC2SPayload(SelectSoulTradeC2SPayload.Action.INCREMENT_AMOUNT, AbstractContainerScreen.hasShiftDown(), index), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private static final void init$lambda$1(SoulTradingScreen this$0, int $slotIndex, Button it) {
        int index = this$0.tradeScrollOffset + $slotIndex;
        if (index >= ((SoulTradingMenu)this$0.menu).getAvailableTrades().size()) {
            return;
        }
        PacketDistributor.sendToServer((CustomPacketPayload)new SelectSoulTradeC2SPayload(SelectSoulTradeC2SPayload.Action.DECREMENT_AMOUNT, AbstractContainerScreen.hasShiftDown(), index), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private static final void init$lambda$2(SoulTradingScreen this$0, Button it) {
        if (((SoulTradingMenu)this$0.menu).canMakeTrade()) {
            PacketDistributor.sendToServer((CustomPacketPayload)new SelectSoulTradeC2SPayload(SelectSoulTradeC2SPayload.Action.CONFIRM_TRADE, false, 0), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private static final ShaderInstance renderBg$lambda$0() {
        return GameRenderer.getPositionTexShader();
    }

    static {
        ResourceLocation resourceLocation = ResourceLocation.withDefaultNamespace((String)"container/villager/scroller");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"withDefaultNamespace(...)");
        SCROLLER_SPRITE = resourceLocation;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Ldev/sterner/witchery/client/screen/SoulTradingScreen$Companion;", "", "<init>", "()V", "INCREMENT_SPRITE", "Lnet/minecraft/client/gui/components/WidgetSprites;", "getINCREMENT_SPRITE", "()Lnet/minecraft/client/gui/components/WidgetSprites;", "DECREMENT_SPRITE", "getDECREMENT_SPRITE", "CONFIRM_SPRITE", "getCONFIRM_SPRITE", "SCROLLER_SPRITE", "Lnet/minecraft/resources/ResourceLocation;", "getSCROLLER_SPRITE", "()Lnet/minecraft/resources/ResourceLocation;", "witchery"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final WidgetSprites getINCREMENT_SPRITE() {
            return INCREMENT_SPRITE;
        }

        @NotNull
        public final WidgetSprites getDECREMENT_SPRITE() {
            return DECREMENT_SPRITE;
        }

        @NotNull
        public final WidgetSprites getCONFIRM_SPRITE() {
            return CONFIRM_SPRITE;
        }

        @NotNull
        public final ResourceLocation getSCROLLER_SPRITE() {
            return SCROLLER_SPRITE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

