/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.block;

import dev.sterner.witchery.content.entity.HornedHuntsmanEntity;
import dev.sterner.witchery.core.registry.WitcheryEntityTypes;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HayBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u001fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J@\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u0012H\u0002J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u0012H\u0002R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Ldev/sterner/witchery/content/block/BloodHayBlock;", "Lnet/minecraft/world/level/block/HayBlock;", "properties", "Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;", "<init>", "(Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;)V", "structure", "", "Ldev/sterner/witchery/content/block/BloodHayBlock$Coord;", "useItemOn", "Lnet/minecraft/world/ItemInteractionResult;", "stack", "Lnet/minecraft/world/item/ItemStack;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "level", "Lnet/minecraft/world/level/Level;", "pos", "Lnet/minecraft/core/BlockPos;", "player", "Lnet/minecraft/world/entity/player/Player;", "hand", "Lnet/minecraft/world/InteractionHand;", "hitResult", "Lnet/minecraft/world/phys/BlockHitResult;", "checkBloodHayStructure", "", "ignitePos", "runRitual", "", "basePos", "Coord", "witchery"})
public final class BloodHayBlock
extends HayBlock {
    @NotNull
    private final List<Coord> structure;

    /*
     * WARNING - void declaration
     */
    public BloodHayBlock(@NotNull BlockBehaviour.Properties properties) {
        void $this$structure_u24lambda_u240;
        List list;
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
        List list2 = list = CollectionsKt.createListBuilder();
        BloodHayBlock bloodHayBlock = this;
        boolean bl = false;
        Object[] objectArray = new Coord[]{new Coord(1, 0), new Coord(2, 0)};
        $this$structure_u24lambda_u240.addAll(CollectionsKt.listOf((Object[])objectArray));
        objectArray = new Coord[]{new Coord(1, 1), new Coord(2, 1)};
        $this$structure_u24lambda_u240.addAll(CollectionsKt.listOf((Object[])objectArray));
        objectArray = new Coord[]{new Coord(1, 2), new Coord(2, 2)};
        $this$structure_u24lambda_u240.addAll(CollectionsKt.listOf((Object[])objectArray));
        objectArray = new Coord[]{new Coord(0, 3), new Coord(1, 3), new Coord(2, 3), new Coord(3, 3)};
        $this$structure_u24lambda_u240.addAll(CollectionsKt.listOf((Object[])objectArray));
        objectArray = new Coord[]{new Coord(0, 4), new Coord(1, 4), new Coord(2, 4), new Coord(3, 4)};
        $this$structure_u24lambda_u240.addAll(CollectionsKt.listOf((Object[])objectArray));
        objectArray = new Coord[]{new Coord(1, 5), new Coord(2, 5)};
        $this$structure_u24lambda_u240.addAll(CollectionsKt.listOf((Object[])objectArray));
        objectArray = new Coord[]{new Coord(1, 6), new Coord(2, 6)};
        $this$structure_u24lambda_u240.addAll(CollectionsKt.listOf((Object[])objectArray));
        bloodHayBlock.structure = CollectionsKt.build((List)list);
    }

    @NotNull
    public ItemInteractionResult useItemOn(@NotNull ItemStack stack, @NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        BlockPos firePos;
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        Intrinsics.checkNotNullParameter((Object)hitResult, (String)"hitResult");
        ItemStack itemStack = player.getItemInHand(hand);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItemInHand(...)");
        ItemStack stack2 = itemStack;
        if (stack2.is(Items.FLINT_AND_STEEL) && level.getBlockState(firePos = pos.relative(hitResult.getDirection())).isAir()) {
            level.playSound(player, firePos, SoundEvents.FLINTANDSTEEL_USE, SoundSource.BLOCKS, 1.0f, level.getRandom().nextFloat() * 0.4f + 0.8f);
            BlockState fire = BaseFireBlock.getState((BlockGetter)((BlockGetter)level), (BlockPos)firePos);
            level.setBlock(firePos, fire, 11);
            level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_PLACE, firePos);
            if (!player.isCreative()) {
                stack2.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
            }
            if (this.checkBloodHayStructure(level, pos)) {
                this.runRitual(level, pos);
            }
            ItemInteractionResult itemInteractionResult = ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
            Intrinsics.checkNotNullExpressionValue((Object)itemInteractionResult, (String)"sidedSuccess(...)");
            return itemInteractionResult;
        }
        ItemInteractionResult itemInteractionResult = super.useItemOn(stack2, state, level, pos, player, hand, hitResult);
        Intrinsics.checkNotNullExpressionValue((Object)itemInteractionResult, (String)"useItemOn(...)");
        return itemInteractionResult;
    }

    private final boolean checkBloodHayStructure(Level level, BlockPos ignitePos) {
        Function2[] function2Array = new Function2[]{BloodHayBlock::checkBloodHayStructure$lambda$0, BloodHayBlock::checkBloodHayStructure$lambda$1, BloodHayBlock::checkBloodHayStructure$lambda$2, BloodHayBlock::checkBloodHayStructure$lambda$3};
        List orientations = CollectionsKt.listOf((Object[])function2Array);
        for (Function2 orient : orientations) {
            for (Coord anchor : this.structure) {
                Pair pair = (Pair)orient.invoke((Object)anchor.getX(), (Object)0);
                int ax = ((Number)pair.component1()).intValue();
                int az = ((Number)pair.component2()).intValue();
                int baseX = ignitePos.getX() - ax;
                int baseY = ignitePos.getY() - anchor.getY();
                int baseZ = ignitePos.getZ() - az;
                boolean allMatch = true;
                for (Coord coord : this.structure) {
                    Pair pair2 = (Pair)orient.invoke((Object)coord.getX(), (Object)0);
                    int dx = ((Number)pair2.component1()).intValue();
                    int dz = ((Number)pair2.component2()).intValue();
                    BlockPos checkPos = new BlockPos(baseX + dx, baseY + coord.getY(), baseZ + dz);
                    if (level.getBlockState(checkPos).getBlock() instanceof BloodHayBlock) continue;
                    allMatch = false;
                    break;
                }
                if (!allMatch) continue;
                return true;
            }
        }
        return false;
    }

    private final void runRitual(Level level, BlockPos basePos) {
        RandomSource random = level.random;
        BlockPos spawnPos = null;
        for (int i = 0; i < 50; ++i) {
            int z;
            int y;
            int dx = random.nextInt(41) - 20;
            int dz = random.nextInt(41) - 20;
            int x = basePos.getX() + dx;
            BlockPos candidate = new BlockPos(x, y = level.getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, x, z = basePos.getZ() + dz), z);
            if (!level.getBlockState(candidate.below()).isSolid() || !level.getBlockState(candidate).isAir()) continue;
            spawnPos = candidate;
            break;
        }
        if (spawnPos == null) {
            return;
        }
        Function2[] dx = new Function2[]{BloodHayBlock::runRitual$lambda$0, BloodHayBlock::runRitual$lambda$1, BloodHayBlock::runRitual$lambda$2, BloodHayBlock::runRitual$lambda$3};
        List orientations = CollectionsKt.listOf((Object[])dx);
        for (Function2 orient : orientations) {
            for (Coord coord : this.structure) {
                Pair pair = (Pair)orient.invoke((Object)coord.getX(), (Object)0);
                int dx2 = ((Number)pair.component1()).intValue();
                int dz = ((Number)pair.component2()).intValue();
                BlockPos hayPos = new BlockPos(basePos.getX() + dx2, basePos.getY() + coord.getY(), basePos.getZ() + dz);
                if (!(level.getBlockState(hayPos).getBlock() instanceof BloodHayBlock)) continue;
                for (Direction dir : EntriesMappings.entries$0) {
                    BlockPos firePos = hayPos.relative(dir);
                    if (!level.getBlockState(firePos).isAir()) continue;
                    level.setBlock(firePos, Blocks.FIRE.defaultBlockState(), 3);
                }
            }
        }
        HornedHuntsmanEntity zombie = (HornedHuntsmanEntity)((EntityType)WitcheryEntityTypes.INSTANCE.getHORNED_HUNTSMAN().get()).create(level);
        if (zombie != null) {
            zombie.moveTo((double)spawnPos.getX() + 0.5, spawnPos.getY(), (double)spawnPos.getZ() + 0.5, random.nextFloat() * 360.0f, 0.0f);
            level.addFreshEntity((Entity)zombie);
        }
    }

    private static final Pair checkBloodHayStructure$lambda$0(int x, int z) {
        return new Pair((Object)x, (Object)z);
    }

    private static final Pair checkBloodHayStructure$lambda$1(int x, int z) {
        return new Pair((Object)(-x), (Object)z);
    }

    private static final Pair checkBloodHayStructure$lambda$2(int x, int z) {
        return new Pair((Object)z, (Object)x);
    }

    private static final Pair checkBloodHayStructure$lambda$3(int x, int z) {
        return new Pair((Object)z, (Object)(-x));
    }

    private static final Pair runRitual$lambda$0(int x, int z) {
        return new Pair((Object)x, (Object)z);
    }

    private static final Pair runRitual$lambda$1(int x, int z) {
        return new Pair((Object)(-x), (Object)z);
    }

    private static final Pair runRitual$lambda$2(int x, int z) {
        return new Pair((Object)z, (Object)x);
    }

    private static final Pair runRitual$lambda$3(int x, int z) {
        return new Pair((Object)z, (Object)(-x));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0013"}, d2={"Ldev/sterner/witchery/content/block/BloodHayBlock$Coord;", "", "x", "", "y", "<init>", "(II)V", "getX", "()I", "getY", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "witchery"})
    public static final class Coord {
        private final int x;
        private final int y;

        public Coord(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public final int getX() {
            return this.x;
        }

        public final int getY() {
            return this.y;
        }

        public final int component1() {
            return this.x;
        }

        public final int component2() {
            return this.y;
        }

        @NotNull
        public final Coord copy(int x, int y) {
            return new Coord(x, y);
        }

        public static /* synthetic */ Coord copy$default(Coord coord, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = coord.x;
            }
            if ((n3 & 2) != 0) {
                n2 = coord.y;
            }
            return coord.copy(n, n2);
        }

        @NotNull
        public String toString() {
            return "Coord(x=" + this.x + ", y=" + this.y + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.x);
            result = result * 31 + Integer.hashCode(this.y);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Coord)) {
                return false;
            }
            Coord coord = (Coord)other;
            if (this.x != coord.x) {
                return false;
            }
            return this.y == coord.y;
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<Direction> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])Direction.values()));
        }
    }
}

