/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.block;

import com.mojang.serialization.MapCodec;
import dev.sterner.witchery.content.worldgen.WitcheryWorldgenKeys;
import dev.sterner.witchery.core.registry.WitcheryItems;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J:\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\rH\u0014J\u001c\u0010\u0017\u001a\u00020\u00072\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u000f0\u0019H\u0014J\u0010\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u001cH\u0014J(\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\u001f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010 \u001a\u00020!H\u0014\u00a8\u0006#"}, d2={"Ldev/sterner/witchery/content/block/CottonBlock;", "Lnet/minecraft/world/level/block/BushBlock;", "properties", "Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;", "<init>", "(Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;)V", "playerDestroy", "", "level", "Lnet/minecraft/world/level/Level;", "player", "Lnet/minecraft/world/entity/player/Player;", "pos", "Lnet/minecraft/core/BlockPos;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "blockEntity", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "tool", "Lnet/minecraft/world/item/ItemStack;", "canSurvive", "", "Lnet/minecraft/world/level/LevelReader;", "createBlockStateDefinition", "builder", "Lnet/minecraft/world/level/block/state/StateDefinition$Builder;", "Lnet/minecraft/world/level/block/Block;", "codec", "Lcom/mojang/serialization/MapCodec;", "getShape", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "Lnet/minecraft/world/level/BlockGetter;", "context", "Lnet/minecraft/world/phys/shapes/CollisionContext;", "Companion", "witchery"})
public final class CottonBlock
extends BushBlock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final BooleanProperty SPIRITED;
    @NotNull
    private static final MapCodec<CottonBlock> CODEC;
    @NotNull
    private static final VoxelShape SHAPE;

    public CottonBlock(@NotNull BlockBehaviour.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)SPIRITED, (Comparable)Boolean.valueOf(false)));
    }

    public void playerDestroy(@NotNull Level level, @NotNull Player player, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable BlockEntity blockEntity, @NotNull ItemStack tool) {
        ItemStack drop;
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)tool, (String)"tool");
        Object object = Intrinsics.areEqual((Object)level.dimension(), WitcheryWorldgenKeys.INSTANCE.getDREAM()) ? ((BlockItem)WitcheryItems.INSTANCE.getWISPY_COTTON().get()).getDefaultInstance() : (drop = Intrinsics.areEqual((Object)level.dimension(), WitcheryWorldgenKeys.INSTANCE.getNIGHTMARE()) ? ((BlockItem)WitcheryItems.INSTANCE.getDISTURBED_COTTON().get()).getDefaultInstance() : null);
        if (drop != null) {
            Containers.dropItemStack((Level)level, (double)((double)pos.getX() + 0.5), (double)((double)pos.getY() + 0.5), (double)((double)pos.getZ() + 0.5), (ItemStack)drop);
        }
        super.playerDestroy(level, player, pos, state, blockEntity, tool);
    }

    protected boolean canSurvive(@NotNull BlockState state, @NotNull LevelReader level, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        if (((Boolean)state.getValue((Property)SPIRITED)).booleanValue() && !level.dimensionType().hasFixedTime()) {
            return false;
        }
        return super.canSurvive(state, level, pos);
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        Property[] propertyArray = new Property[]{SPIRITED};
        super.createBlockStateDefinition(builder.add(propertyArray));
    }

    @NotNull
    protected MapCodec<? extends BushBlock> codec() {
        return CODEC;
    }

    @NotNull
    protected VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Vec3 vec3 = state.getOffset(level, pos);
        VoxelShape voxelShape = SHAPE.move(vec3.x, vec3.y, vec3.z);
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape, (String)"move(...)");
        return voxelShape;
    }

    private static final CottonBlock CODEC$lambda$0(BlockBehaviour.Properties arg) {
        Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
        return new CottonBlock(arg);
    }

    static {
        BooleanProperty booleanProperty = BooleanProperty.create((String)"spirited");
        Intrinsics.checkNotNullExpressionValue((Object)booleanProperty, (String)"create(...)");
        SPIRITED = booleanProperty;
        MapCodec mapCodec = BushBlock.simpleCodec(CottonBlock::CODEC$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)mapCodec, (String)"simpleCodec(...)");
        CODEC = mapCodec;
        VoxelShape voxelShape = BushBlock.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)10.0, (double)11.0);
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape, (String)"box(...)");
        SHAPE = voxelShape;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Ldev/sterner/witchery/content/block/CottonBlock$Companion;", "", "<init>", "()V", "SPIRITED", "Lnet/minecraft/world/level/block/state/properties/BooleanProperty;", "getSPIRITED", "()Lnet/minecraft/world/level/block/state/properties/BooleanProperty;", "CODEC", "Lcom/mojang/serialization/MapCodec;", "Ldev/sterner/witchery/content/block/CottonBlock;", "getCODEC", "()Lcom/mojang/serialization/MapCodec;", "SHAPE", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "getSHAPE", "()Lnet/minecraft/world/phys/shapes/VoxelShape;", "witchery"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BooleanProperty getSPIRITED() {
            return SPIRITED;
        }

        @NotNull
        public final MapCodec<CottonBlock> getCODEC() {
            return CODEC;
        }

        @NotNull
        public final VoxelShape getSHAPE() {
            return SHAPE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

