/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.block;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.WaterloggedTransparentBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 $2\u00020\u00012\u00020\u0002:\u0001$B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0018\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0014J \u0010\u000e\u001a\u00020\u000f2\u0016\u0010\u0010\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0011H\u0014J(\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0018\u001a\u00020\u001bH\u0016J8\u0010\u001c\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020 2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010!\u001a\u00020\u0017H\u0014J\u0010\u0010\"\u001a\u00020#2\u0006\u0010\t\u001a\u00020\bH\u0014\u00a8\u0006%"}, d2={"Ldev/sterner/witchery/content/block/GravestoneBlock;", "Lnet/minecraft/world/level/block/Block;", "Lnet/minecraft/world/level/block/SimpleWaterloggedBlock;", "properties", "Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;", "<init>", "(Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;)V", "rotate", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "rotation", "Lnet/minecraft/world/level/block/Rotation;", "mirror", "Lnet/minecraft/world/level/block/Mirror;", "createBlockStateDefinition", "", "builder", "Lnet/minecraft/world/level/block/state/StateDefinition$Builder;", "getShape", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "level", "Lnet/minecraft/world/level/BlockGetter;", "pos", "Lnet/minecraft/core/BlockPos;", "context", "Lnet/minecraft/world/phys/shapes/CollisionContext;", "getStateForPlacement", "Lnet/minecraft/world/item/context/BlockPlaceContext;", "updateShape", "direction", "Lnet/minecraft/core/Direction;", "neighborState", "Lnet/minecraft/world/level/LevelAccessor;", "neighborPos", "getFluidState", "Lnet/minecraft/world/level/material/FluidState;", "Companion", "witchery"})
public final class GravestoneBlock
extends Block
implements SimpleWaterloggedBlock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final VoxelShape EAST_WEST = Shapes.box((double)0.375, (double)0.0, (double)0.125, (double)0.625, (double)1.0, (double)0.875);
    private static final VoxelShape NORTH_SOUTH = Shapes.box((double)0.125, (double)0.0, (double)0.375, (double)0.875, (double)1.0, (double)0.625);

    public GravestoneBlock(@NotNull BlockBehaviour.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    protected BlockState rotate(@NotNull BlockState state, @NotNull Rotation rotation) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)rotation, (String)"rotation");
        Object object = state.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"setValue(...)");
        return (BlockState)object;
    }

    @NotNull
    protected BlockState mirror(@NotNull BlockState state, @NotNull Mirror mirror) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)mirror, (String)"mirror");
        BlockState blockState = state.rotate(mirror.getRotation((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)));
        Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"rotate(...)");
        return blockState;
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        Property[] propertyArray = new Property[]{BlockStateProperties.HORIZONTAL_FACING, BlockStateProperties.WATERLOGGED};
        builder.add(propertyArray);
    }

    @NotNull
    protected VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        VoxelShape voxelShape;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Direction direction = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        switch (direction == null ? -1 : WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
            case 1: {
                VoxelShape voxelShape2 = NORTH_SOUTH;
                voxelShape = voxelShape2;
                Intrinsics.checkNotNullExpressionValue((Object)voxelShape2, (String)"NORTH_SOUTH");
                break;
            }
            case 2: {
                VoxelShape voxelShape3 = NORTH_SOUTH;
                voxelShape = voxelShape3;
                Intrinsics.checkNotNullExpressionValue((Object)voxelShape3, (String)"NORTH_SOUTH");
                break;
            }
            default: {
                VoxelShape voxelShape4 = EAST_WEST;
                voxelShape = voxelShape4;
                Intrinsics.checkNotNullExpressionValue((Object)voxelShape4, (String)"EAST_WEST");
            }
        }
        return voxelShape;
    }

    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        FluidState fluidState = context.getLevel().getFluidState(context.getClickedPos());
        BlockState blockState = super.getStateForPlacement(context);
        Intrinsics.checkNotNull((Object)blockState);
        return (BlockState)((BlockState)blockState.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.is((Fluid)Fluids.WATER)));
    }

    @NotNull
    protected BlockState updateShape(@NotNull BlockState state, @NotNull Direction direction, @NotNull BlockState neighborState, @NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockPos neighborPos) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        Intrinsics.checkNotNullParameter((Object)neighborState, (String)"neighborState");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)neighborPos, (String)"neighborPos");
        Comparable comparable = state.getValue((Property)WaterloggedTransparentBlock.WATERLOGGED);
        Intrinsics.checkNotNull((Object)comparable, (String)"null cannot be cast to non-null type kotlin.Boolean");
        if (((Boolean)comparable).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        BlockState blockState = super.updateShape(state, direction, neighborState, level, pos, neighborPos);
        Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"updateShape(...)");
        return blockState;
    }

    @NotNull
    protected FluidState getFluidState(@NotNull BlockState state) {
        FluidState fluidState;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (((Boolean)state.getValue((Property)WaterloggedTransparentBlock.WATERLOGGED)).booleanValue()) {
            FluidState fluidState2 = Fluids.WATER.getSource(true);
            fluidState = fluidState2;
            Intrinsics.checkNotNullExpressionValue((Object)fluidState2, (String)"getSource(...)");
        } else {
            FluidState fluidState3 = super.getFluidState(state);
            fluidState = fluidState3;
            Intrinsics.checkNotNullExpressionValue((Object)fluidState3, (String)"getFluidState(...)");
        }
        return fluidState;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0019\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0019\u0010\t\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u000b"}, d2={"Ldev/sterner/witchery/content/block/GravestoneBlock$Companion;", "", "<init>", "()V", "EAST_WEST", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "kotlin.jvm.PlatformType", "getEAST_WEST", "()Lnet/minecraft/world/phys/shapes/VoxelShape;", "NORTH_SOUTH", "getNORTH_SOUTH", "witchery"})
    public static final class Companion {
        private Companion() {
        }

        public final VoxelShape getEAST_WEST() {
            return EAST_WEST;
        }

        public final VoxelShape getNORTH_SOUTH() {
            return NORTH_SOUTH;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Direction.values().length];
            try {
                nArray[Direction.NORTH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.SOUTH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

