/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.block;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B#\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J \u0010\u0014\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0007H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J \u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\r2\u0006\u0010!\u001a\u00020\u0019H\u0016J \u0010\"\u001a\u00020\r2\u0006\u0010#\u001a\u00020\u00072\u0006\u0010$\u001a\u00020\u00052\u0006\u0010%\u001a\u00020\u0005H\u0016J\u0018\u0010&\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u001a\u0010'\u001a\u00020\r2\b\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010*\u001a\n\u0012\u0004\u0012\u00020,\u0018\u00010+H\u0016J\b\u0010-\u001a\u00020\rH\u0016J\u0010\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0016J\u0018\u00102\u001a\u00020\r2\u0006\u00103\u001a\u00020/2\u0006\u00104\u001a\u000201H\u0014J \u00105\u001a\u00020\r2\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u000201H\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Ldev/sterner/witchery/content/block/WitcheryBaseBlockEntity;", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "blockEntityType", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "blockPos", "Lnet/minecraft/core/BlockPos;", "blockState", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/world/level/block/entity/BlockEntityType;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "initialized", "", "tick", "", "level", "Lnet/minecraft/world/level/Level;", "pos", "tickServer", "serverLevel", "Lnet/minecraft/server/level/ServerLevel;", "init", "state", "onUseWithoutItem", "Lnet/minecraft/world/InteractionResult;", "pPlayer", "Lnet/minecraft/world/entity/player/Player;", "onUseWithItem", "Lnet/minecraft/world/ItemInteractionResult;", "pStack", "Lnet/minecraft/world/item/ItemStack;", "pHand", "Lnet/minecraft/world/InteractionHand;", "onBreak", "player", "onNeighborUpdate", "pState", "pPos", "pFromPos", "onUse", "onPlace", "pPlacer", "Lnet/minecraft/world/entity/LivingEntity;", "getUpdatePacket", "Lnet/minecraft/network/protocol/Packet;", "Lnet/minecraft/network/protocol/game/ClientGamePacketListener;", "setChanged", "getUpdateTag", "Lnet/minecraft/nbt/CompoundTag;", "registries", "Lnet/minecraft/core/HolderLookup$Provider;", "loadAdditional", "pTag", "pRegistries", "onDataPacket", "net", "Lnet/minecraft/network/Connection;", "pkt", "Lnet/minecraft/network/protocol/game/ClientboundBlockEntityDataPacket;", "lookupProvider", "witchery"})
public class WitcheryBaseBlockEntity
extends BlockEntity {
    private boolean initialized;

    public WitcheryBaseBlockEntity(@NotNull BlockEntityType<?> blockEntityType, @NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        Intrinsics.checkNotNullParameter(blockEntityType, (String)"blockEntityType");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        super(blockEntityType, blockPos, blockState);
    }

    public void tick(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        if (!this.initialized) {
            this.initialized = true;
            this.init(level, pos, blockState);
        }
        if (level instanceof ServerLevel) {
            this.tickServer((ServerLevel)level);
        }
    }

    public void tickServer(@NotNull ServerLevel serverLevel) {
        Intrinsics.checkNotNullParameter((Object)serverLevel, (String)"serverLevel");
    }

    public void init(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
    }

    @NotNull
    public InteractionResult onUseWithoutItem(@NotNull Player pPlayer) {
        Intrinsics.checkNotNullParameter((Object)pPlayer, (String)"pPlayer");
        return InteractionResult.PASS;
    }

    @NotNull
    public ItemInteractionResult onUseWithItem(@NotNull Player pPlayer, @NotNull ItemStack pStack, @NotNull InteractionHand pHand) {
        Intrinsics.checkNotNullParameter((Object)pPlayer, (String)"pPlayer");
        Intrinsics.checkNotNullParameter((Object)pStack, (String)"pStack");
        Intrinsics.checkNotNullParameter((Object)pHand, (String)"pHand");
        return ItemInteractionResult.FAIL;
    }

    public void onBreak(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
    }

    public void onNeighborUpdate(@NotNull BlockState pState, @NotNull BlockPos pPos, @NotNull BlockPos pFromPos) {
        Intrinsics.checkNotNullParameter((Object)pState, (String)"pState");
        Intrinsics.checkNotNullParameter((Object)pPos, (String)"pPos");
        Intrinsics.checkNotNullParameter((Object)pFromPos, (String)"pFromPos");
    }

    @NotNull
    public ItemInteractionResult onUse(@NotNull Player pPlayer, @NotNull InteractionHand pHand) {
        Intrinsics.checkNotNullParameter((Object)pPlayer, (String)"pPlayer");
        Intrinsics.checkNotNullParameter((Object)pHand, (String)"pHand");
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public void onPlace(@Nullable LivingEntity pPlacer, @NotNull ItemStack pStack) {
        Intrinsics.checkNotNullParameter((Object)pStack, (String)"pStack");
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return (Packet)ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void setChanged() {
        if (this.level instanceof ServerLevel) {
            Level level = this.level;
            Intrinsics.checkNotNull((Object)level);
            level.blockEntityChanged(this.getBlockPos());
            Level level2 = this.level;
            Intrinsics.checkNotNull((Object)level2);
            level2.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
        }
        super.setChanged();
    }

    @NotNull
    public CompoundTag getUpdateTag(@NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        CompoundTag compoundTag = this.saveWithoutMetadata(registries);
        Intrinsics.checkNotNullExpressionValue((Object)compoundTag, (String)"saveWithoutMetadata(...)");
        return compoundTag;
    }

    protected void loadAdditional(@NotNull CompoundTag pTag, @NotNull HolderLookup.Provider pRegistries) {
        Intrinsics.checkNotNullParameter((Object)pTag, (String)"pTag");
        Intrinsics.checkNotNullParameter((Object)pRegistries, (String)"pRegistries");
        this.initialized = false;
        super.loadAdditional(pTag, pRegistries);
    }

    public void onDataPacket(@NotNull Connection net, @NotNull ClientboundBlockEntityDataPacket pkt, @NotNull HolderLookup.Provider lookupProvider) {
        Intrinsics.checkNotNullParameter((Object)net, (String)"net");
        Intrinsics.checkNotNullParameter((Object)pkt, (String)"pkt");
        Intrinsics.checkNotNullParameter((Object)lookupProvider, (String)"lookupProvider");
        super.onDataPacket(net, pkt, lookupProvider);
        CompoundTag tag = pkt.getTag();
        CompoundTag compoundTag = tag;
        if (compoundTag == null) {
            compoundTag = new CompoundTag();
        }
        this.loadAdditional(compoundTag, lookupProvider);
    }
}

