/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.block;

import com.mojang.serialization.MapCodec;
import dev.sterner.witchery.core.registry.WitcheryBlocks;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 G2\u00020\u00012\u00020\u0002:\u0002FGB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00000\bH\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J(\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\u0014H\u0016J8\u0010\u0015\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u0013H\u0016J \u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u001d2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J \u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J \u0010\u001f\u001a\u00020 2\u0016\u0010!\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010#\u0012\u0006\u0012\u0004\u0018\u00010\n0\"H\u0014J(\u0010$\u001a\u00020 2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020%2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010&\u001a\u00020'H\u0016J\u0018\u0010(\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010)\u001a\u00020\fH\u0016J2\u0010*\u001a\u00020 2\u0006\u0010\u0010\u001a\u00020%2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\n2\b\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010-\u001a\u00020.H\u0016J\u0010\u0010/\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\nH\u0016J \u00100\u001a\u0002012\u0006\u00102\u001a\u00020#2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J(\u00103\u001a\u00020 2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u0002042\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u00105\u001a\u000206H\u0016J \u00107\u001a\u00020 2\u0006\u0010\u0010\u001a\u0002042\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u00108\u001a\u00020\u001c2\u0006\u0010\u0010\u001a\u00020\u001d2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u00109\u001a\u00020\u001c2\u0006\u0010\u0010\u001a\u00020\u001d2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010:\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\nH\u0002J\u0010\u0010;\u001a\u00020\u001c2\u0006\u0010<\u001a\u00020=H\u0002J(\u0010>\u001a\u00020\u001c2\u0006\u0010?\u001a\u00020\u001d2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010<\u001a\u00020=H\u0002J\u0010\u0010@\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\nH\u0002J\"\u0010A\u001a\u0004\u0018\u00010B2\u0006\u0010\u0010\u001a\u00020\u001d2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\nH\u0002J \u0010C\u001a\u00020\u001c2\u0006\u0010\u0010\u001a\u00020\u001d2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\nH\u0016J(\u0010D\u001a\u00020\u001c2\u0006\u0010\u0010\u001a\u00020%2\u0006\u00105\u001a\u0002062\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\nH\u0016J(\u0010E\u001a\u00020 2\u0006\u0010\u0010\u001a\u0002042\u0006\u00105\u001a\u0002062\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\nH\u0016\u00a8\u0006H"}, d2={"Ldev/sterner/witchery/content/block/WormwoodCropBlock;", "Lnet/minecraft/world/level/block/DoublePlantBlock;", "Lnet/minecraft/world/level/block/BonemealableBlock;", "properties", "Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;", "<init>", "(Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;)V", "codec", "Lcom/mojang/serialization/MapCodec;", "getStateForPlacement", "Lnet/minecraft/world/level/block/state/BlockState;", "context", "Lnet/minecraft/world/item/context/BlockPlaceContext;", "getShape", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "state", "level", "Lnet/minecraft/world/level/BlockGetter;", "pos", "Lnet/minecraft/core/BlockPos;", "Lnet/minecraft/world/phys/shapes/CollisionContext;", "updateShape", "direction", "Lnet/minecraft/core/Direction;", "neighborState", "Lnet/minecraft/world/level/LevelAccessor;", "neighborPos", "canSurvive", "", "Lnet/minecraft/world/level/LevelReader;", "mayPlaceOn", "createBlockStateDefinition", "", "builder", "Lnet/minecraft/world/level/block/state/StateDefinition$Builder;", "Lnet/minecraft/world/level/block/Block;", "entityInside", "Lnet/minecraft/world/level/Level;", "entity", "Lnet/minecraft/world/entity/Entity;", "canBeReplaced", "useContext", "setPlacedBy", "placer", "Lnet/minecraft/world/entity/LivingEntity;", "stack", "Lnet/minecraft/world/item/ItemStack;", "isRandomlyTicking", "getGrowthSpeed", "", "block", "randomTick", "Lnet/minecraft/server/level/ServerLevel;", "random", "Lnet/minecraft/util/RandomSource;", "grow", "canGrowInto", "sufficientLight", "isLower", "isDouble", "age", "", "canGrow", "reader", "isMaxAge", "getLowerHalf", "Ldev/sterner/witchery/content/block/WormwoodCropBlock$PosAndState;", "isValidBonemealTarget", "isBonemealSuccess", "performBonemeal", "PosAndState", "Companion", "witchery"})
public final class WormwoodCropBlock
extends DoublePlantBlock
implements BonemealableBlock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final MapCodec<WormwoodCropBlock> CODEC;
    @NotNull
    private static final VoxelShape FULL_UPPER_SHAPE;
    @NotNull
    private static final VoxelShape FULL_LOWER_SHAPE;
    @NotNull
    private static final VoxelShape COLLISION_SHAPE_BULB;
    @NotNull
    private static final VoxelShape[] UPPER_SHAPE_BY_AGE;
    @NotNull
    private static final VoxelShape[] LOWER_SHAPE_BY_AGE;

    public WormwoodCropBlock(@NotNull BlockBehaviour.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties.noCollission());
    }

    @NotNull
    public MapCodec<WormwoodCropBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.defaultBlockState();
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        VoxelShape voxelShape;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (state.getValue((Property)DoublePlantBlock.HALF) == DoubleBlockHalf.UPPER) {
            Comparable comparable = state.getValue((Property)BlockStateProperties.AGE_4);
            Intrinsics.checkNotNull((Object)comparable, (String)"null cannot be cast to non-null type kotlin.Int");
            double d = Math.abs((double)(4 - ((Integer)comparable + 1)));
            double d2 = UPPER_SHAPE_BY_AGE.length - 1;
            voxelShape = UPPER_SHAPE_BY_AGE[(int)Math.min(d, d2)];
        } else {
            Comparable comparable = state.getValue((Property)BlockStateProperties.AGE_4);
            Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"getValue(...)");
            voxelShape = LOWER_SHAPE_BY_AGE[((Number)((Object)comparable)).intValue()];
        }
        return voxelShape;
    }

    @NotNull
    public BlockState updateShape(@NotNull BlockState state, @NotNull Direction direction, @NotNull BlockState neighborState, @NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockPos neighborPos) {
        BlockState blockState;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        Intrinsics.checkNotNullParameter((Object)neighborState, (String)"neighborState");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)neighborPos, (String)"neighborPos");
        Comparable comparable = state.getValue((Property)BlockStateProperties.AGE_4);
        Intrinsics.checkNotNull((Object)comparable, (String)"null cannot be cast to non-null type kotlin.Int");
        if (this.isDouble((Integer)comparable)) {
            BlockState blockState2 = super.updateShape(state, direction, neighborState, level, pos, neighborPos);
            Intrinsics.checkNotNull((Object)blockState2);
            blockState = blockState2;
        } else if (state.canSurvive((LevelReader)level, pos)) {
            blockState = state;
        } else {
            BlockState blockState3 = Blocks.AIR.defaultBlockState();
            blockState = blockState3;
            Intrinsics.checkNotNullExpressionValue((Object)blockState3, (String)"defaultBlockState(...)");
        }
        return blockState;
    }

    public boolean canSurvive(@NotNull BlockState state, @NotNull LevelReader level, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return this.isLower(state) && !this.sufficientLight(level, pos) ? false : super.canSurvive(state, level, pos);
    }

    protected boolean mayPlaceOn(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return state.is(Blocks.FARMLAND);
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        Property[] propertyArray = new Property[]{BlockStateProperties.AGE_4};
        builder.add(propertyArray);
        super.createBlockStateDefinition(builder);
    }

    public void entityInside(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (entity instanceof Ravager && level.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) {
            level.destroyBlock(pos, true, entity);
        }
        super.entityInside(state, level, pos, entity);
    }

    public boolean canBeReplaced(@NotNull BlockState state, @NotNull BlockPlaceContext useContext) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)useContext, (String)"useContext");
        return false;
    }

    public void setPlacedBy(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity placer, @NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
    }

    public boolean isRandomlyTicking(@NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return state.getValue((Property)DoublePlantBlock.HALF) == DoubleBlockHalf.LOWER && !this.isMaxAge(state);
    }

    private final float getGrowthSpeed(Block block, BlockGetter level, BlockPos pos) {
        boolean bl2;
        float f = 1.0f;
        BlockPos blockPos = pos.below();
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                float g = 0.0f;
                BlockState blockState = level.getBlockState(blockPos.offset(i, 0, j));
                if (blockState.is(Blocks.FARMLAND)) {
                    g = 1.0f;
                    Comparable comparable = blockState.getValue((Property)FarmBlock.MOISTURE);
                    Intrinsics.checkNotNull((Object)comparable, (String)"null cannot be cast to non-null type kotlin.Int");
                    if ((Integer)comparable > 0) {
                        g = 3.0f;
                    }
                }
                if (i != 0 || j != 0) {
                    g /= 4.0f;
                }
                f += g;
            }
        }
        BlockPos blockPos2 = pos.north();
        BlockPos blockPos3 = pos.south();
        BlockPos blockPos4 = pos.west();
        BlockPos blockPos5 = pos.east();
        boolean bl = level.getBlockState(blockPos4).is(block) || level.getBlockState(blockPos5).is(block);
        boolean bl3 = bl2 = level.getBlockState(blockPos2).is(block) || level.getBlockState(blockPos3).is(block);
        if (bl && bl2) {
            f /= 2.0f;
        } else {
            boolean bl32;
            boolean bl4 = bl32 = level.getBlockState(blockPos4.north()).is(block) || level.getBlockState(blockPos5.north()).is(block) || level.getBlockState(blockPos5.south()).is(block) || level.getBlockState(blockPos4.south()).is(block);
            if (bl32) {
                f /= 2.0f;
            }
        }
        return f;
    }

    public void randomTick(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        float f = this.getGrowthSpeed((Block)this, (BlockGetter)level, pos);
        boolean bl2 = bl = random.nextInt((int)(25.0f / f) + 1) == 0;
        if (bl) {
            this.grow(level, state, pos);
        }
    }

    private final void grow(ServerLevel level, BlockState state, BlockPos pos) {
        Comparable comparable = state.getValue((Property)BlockStateProperties.AGE_4);
        Intrinsics.checkNotNull((Object)comparable, (String)"null cannot be cast to non-null type kotlin.Int");
        double d = (Integer)comparable + 1;
        double d2 = 4.0;
        int i = (int)Math.min(d, d2);
        if (this.canGrow((LevelReader)level, pos, state, i)) {
            BlockState blockState = (BlockState)state.setValue((Property)BlockStateProperties.AGE_4, (Comparable)Integer.valueOf(i));
            level.setBlock(pos, blockState, 2);
            if (this.isDouble(i)) {
                level.setBlock(pos.above(), (BlockState)blockState.setValue((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
            }
        }
    }

    private final boolean canGrowInto(LevelReader level, BlockPos pos) {
        BlockState blockState = level.getBlockState(pos);
        return blockState.isAir() || blockState.is((Block)WitcheryBlocks.INSTANCE.getWORMWOOD_CROP().get());
    }

    private final boolean sufficientLight(LevelReader level, BlockPos pos) {
        return level.getRawBrightness(pos, 0) >= 8;
    }

    private final boolean isLower(BlockState state) {
        return state.is((Block)WitcheryBlocks.INSTANCE.getWORMWOOD_CROP().get()) && state.getValue((Property)DoublePlantBlock.HALF) == DoubleBlockHalf.LOWER;
    }

    private final boolean isDouble(int age) {
        return age >= 3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean canGrow(LevelReader reader, BlockPos pos, BlockState state, int age) {
        if (this.isMaxAge(state)) return false;
        if (!this.sufficientLight(reader, pos)) return false;
        if (!this.isDouble(age)) return true;
        BlockPos blockPos = pos.above();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"above(...)");
        if (!this.canGrowInto(reader, blockPos)) return false;
        return true;
    }

    private final boolean isMaxAge(BlockState state) {
        return ((Number)((Object)state.getValue((Property)BlockStateProperties.AGE_4))).intValue() >= 4;
    }

    private final PosAndState getLowerHalf(LevelReader level, BlockPos pos, BlockState state) {
        PosAndState posAndState;
        if (this.isLower(state)) {
            return new PosAndState(pos, state);
        }
        BlockPos blockPos = pos.below();
        BlockState blockState = level.getBlockState(blockPos);
        Intrinsics.checkNotNull((Object)blockState);
        if (this.isLower(blockState)) {
            Intrinsics.checkNotNull((Object)blockPos);
            posAndState = new PosAndState(blockPos, blockState);
        } else {
            posAndState = null;
        }
        return posAndState;
    }

    public boolean isValidBonemealTarget(@NotNull LevelReader level, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        PosAndState posAndState = this.getLowerHalf(level, pos, state);
        return posAndState == null ? false : this.canGrow(level, posAndState.pos(), posAndState.state(), ((Number)((Object)posAndState.state().getValue((Property)BlockStateProperties.AGE_4))).intValue() + 1);
    }

    public boolean isBonemealSuccess(@NotNull Level level, @NotNull RandomSource random, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return true;
    }

    public void performBonemeal(@NotNull ServerLevel level, @NotNull RandomSource random, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        PosAndState posAndState = this.getLowerHalf((LevelReader)level, pos, state);
        if (posAndState != null) {
            this.grow(level, posAndState.state(), posAndState.pos());
        }
    }

    private static final WormwoodCropBlock CODEC$lambda$0(BlockBehaviour.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        return new WormwoodCropBlock(properties);
    }

    static {
        MapCodec mapCodec = DoublePlantBlock.simpleCodec(WormwoodCropBlock::CODEC$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)mapCodec, (String)"simpleCodec(...)");
        CODEC = mapCodec;
        VoxelShape voxelShape = DoublePlantBlock.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)15.0, (double)13.0);
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape, (String)"box(...)");
        FULL_UPPER_SHAPE = voxelShape;
        VoxelShape voxelShape2 = DoublePlantBlock.box((double)3.0, (double)-1.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape2, (String)"box(...)");
        FULL_LOWER_SHAPE = voxelShape2;
        VoxelShape voxelShape3 = DoublePlantBlock.box((double)5.0, (double)-1.0, (double)5.0, (double)11.0, (double)3.0, (double)11.0);
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape3, (String)"box(...)");
        COLLISION_SHAPE_BULB = voxelShape3;
        VoxelShape[] voxelShapeArray = new VoxelShape[2];
        Intrinsics.checkNotNullExpressionValue((Object)DoublePlantBlock.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)11.0, (double)13.0), (String)"box(...)");
        voxelShapeArray[1] = FULL_UPPER_SHAPE;
        UPPER_SHAPE_BY_AGE = voxelShapeArray;
        voxelShapeArray = new VoxelShape[5];
        voxelShapeArray[0] = COLLISION_SHAPE_BULB;
        Intrinsics.checkNotNullExpressionValue((Object)DoublePlantBlock.box((double)3.0, (double)-1.0, (double)3.0, (double)13.0, (double)8.0, (double)13.0), (String)"box(...)");
        Intrinsics.checkNotNullExpressionValue((Object)DoublePlantBlock.box((double)3.0, (double)-1.0, (double)3.0, (double)13.0, (double)13.0, (double)13.0), (String)"box(...)");
        Intrinsics.checkNotNullExpressionValue((Object)DoublePlantBlock.box((double)3.0, (double)-1.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0), (String)"box(...)");
        voxelShapeArray[4] = FULL_LOWER_SHAPE;
        LOWER_SHAPE_BY_AGE = voxelShapeArray;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000e\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u000f\u0010\u0010R\u0019\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u000e\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u0013\u0010\u0010\u00a8\u0006\u0014"}, d2={"Ldev/sterner/witchery/content/block/WormwoodCropBlock$Companion;", "", "<init>", "()V", "CODEC", "Lcom/mojang/serialization/MapCodec;", "Ldev/sterner/witchery/content/block/WormwoodCropBlock;", "getCODEC", "()Lcom/mojang/serialization/MapCodec;", "FULL_UPPER_SHAPE", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "FULL_LOWER_SHAPE", "COLLISION_SHAPE_BULB", "UPPER_SHAPE_BY_AGE", "", "getUPPER_SHAPE_BY_AGE", "()[Lnet/minecraft/world/phys/shapes/VoxelShape;", "[Lnet/minecraft/world/phys/shapes/VoxelShape;", "LOWER_SHAPE_BY_AGE", "getLOWER_SHAPE_BY_AGE", "witchery"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MapCodec<WormwoodCropBlock> getCODEC() {
            return CODEC;
        }

        @NotNull
        public final VoxelShape[] getUPPER_SHAPE_BY_AGE() {
            return UPPER_SHAPE_BY_AGE;
        }

        @NotNull
        public final VoxelShape[] getLOWER_SHAPE_BY_AGE() {
            return LOWER_SHAPE_BY_AGE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\t\u00a8\u0006\u0015"}, d2={"Ldev/sterner/witchery/content/block/WormwoodCropBlock$PosAndState;", "Ljava/lang/Record;", "pos", "Lnet/minecraft/core/BlockPos;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "()Lnet/minecraft/core/BlockPos;", "()Lnet/minecraft/world/level/block/state/BlockState;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "witchery"})
    public static final class PosAndState
    extends Record {
        @NotNull
        private final BlockPos pos;
        @NotNull
        private final BlockState state;

        public PosAndState(@NotNull BlockPos pos, @NotNull BlockState state) {
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            this.pos = pos;
            this.state = state;
        }

        @NotNull
        public final BlockPos pos() {
            return this.pos;
        }

        @NotNull
        public final BlockState state() {
            return this.state;
        }

        @NotNull
        public final BlockPos component1() {
            return this.pos;
        }

        @NotNull
        public final BlockState component2() {
            return this.state;
        }

        @NotNull
        public final PosAndState copy(@NotNull BlockPos pos, @NotNull BlockState state) {
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            return new PosAndState(pos, state);
        }

        public static /* synthetic */ PosAndState copy$default(PosAndState posAndState, BlockPos blockPos, BlockState blockState, int n, Object object) {
            if ((n & 1) != 0) {
                blockPos = posAndState.pos;
            }
            if ((n & 2) != 0) {
                blockState = posAndState.state;
            }
            return posAndState.copy(blockPos, blockState);
        }

        @Override
        @NotNull
        public String toString() {
            return "PosAndState(pos=" + this.pos + ", state=" + this.state + ")";
        }

        @Override
        public int hashCode() {
            int result = this.pos.hashCode();
            result = result * 31 + this.state.hashCode();
            return result;
        }

        @Override
        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PosAndState)) {
                return false;
            }
            PosAndState posAndState = (PosAndState)other;
            if (!Intrinsics.areEqual((Object)this.pos, (Object)posAndState.pos)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.state, (Object)posAndState.state);
        }
    }
}

