/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.block.arthana;

import dev.sterner.witchery.content.block.WitcheryBaseEntityBlock;
import dev.sterner.witchery.content.block.arthana.ArthanaBlockEntity;
import dev.sterner.witchery.content.item.ArthanaItem;
import dev.sterner.witchery.core.registry.WitcheryItems;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J0\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J:\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020!H\u0014J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020#H\u0014J \u0010$\u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00020%2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J(\u0010&\u001a\u00020'2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020(2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010)\u001a\u00020*H\u0014\u00a8\u0006+"}, d2={"Ldev/sterner/witchery/content/block/arthana/ArthanaBlock;", "Ldev/sterner/witchery/content/block/WitcheryBaseEntityBlock;", "properties", "Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;", "<init>", "(Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;)V", "newBlockEntity", "Ldev/sterner/witchery/content/block/arthana/ArthanaBlockEntity;", "pos", "Lnet/minecraft/core/BlockPos;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "useWithoutItem", "Lnet/minecraft/world/InteractionResult;", "pState", "pLevel", "Lnet/minecraft/world/level/Level;", "pPos", "pPlayer", "Lnet/minecraft/world/entity/player/Player;", "pHitResult", "Lnet/minecraft/world/phys/BlockHitResult;", "playerDestroy", "", "level", "player", "blockEntity", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "tool", "Lnet/minecraft/world/item/ItemStack;", "canBeReplaced", "", "fluid", "Lnet/minecraft/world/level/material/Fluid;", "useContext", "Lnet/minecraft/world/item/context/BlockPlaceContext;", "getCloneItemStack", "Lnet/minecraft/world/level/LevelReader;", "getShape", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "Lnet/minecraft/world/level/BlockGetter;", "context", "Lnet/minecraft/world/phys/shapes/CollisionContext;", "witchery"})
public final class ArthanaBlock
extends WitcheryBaseEntityBlock {
    public ArthanaBlock(@NotNull BlockBehaviour.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        BlockBehaviour.Properties properties2 = properties.noCollission().noOcclusion().noLootTable().instabreak();
        Intrinsics.checkNotNullExpressionValue((Object)properties2, (String)"instabreak(...)");
        super(properties2);
    }

    @NotNull
    public ArthanaBlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return new ArthanaBlockEntity(pos, state);
    }

    @Override
    @NotNull
    protected InteractionResult useWithoutItem(@NotNull BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull Player pPlayer, @NotNull BlockHitResult pHitResult) {
        Intrinsics.checkNotNullParameter((Object)pState, (String)"pState");
        Intrinsics.checkNotNullParameter((Object)pLevel, (String)"pLevel");
        Intrinsics.checkNotNullParameter((Object)pPos, (String)"pPos");
        Intrinsics.checkNotNullParameter((Object)pPlayer, (String)"pPlayer");
        Intrinsics.checkNotNullParameter((Object)pHitResult, (String)"pHitResult");
        BlockEntity be = pLevel.getBlockEntity(pPos);
        if (pPlayer instanceof ServerPlayer && be instanceof ArthanaBlockEntity) {
            ItemStack arthana = ((ArthanaBlockEntity)be).getArthana().copy();
            pPlayer.setItemInHand(InteractionHand.MAIN_HAND, arthana);
            pLevel.setBlockAndUpdate(pPos, Blocks.AIR.defaultBlockState());
        }
        return InteractionResult.SUCCESS;
    }

    public void playerDestroy(@NotNull Level level, @NotNull Player player, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable BlockEntity blockEntity, @NotNull ItemStack tool) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)tool, (String)"tool");
        if (!level.isClientSide && blockEntity instanceof ArthanaBlockEntity) {
            ItemEntity item = new ItemEntity(level, pos.getCenter().x, pos.getCenter().y, pos.getCenter().z, ((ArthanaBlockEntity)blockEntity).getArthana().copy());
            level.addFreshEntity((Entity)item);
        }
        super.playerDestroy(level, player, pos, state, blockEntity, tool);
    }

    protected boolean canBeReplaced(@NotNull BlockState state, @NotNull Fluid fluid) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)fluid, (String)"fluid");
        return false;
    }

    protected boolean canBeReplaced(@NotNull BlockState state, @NotNull BlockPlaceContext useContext) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)useContext, (String)"useContext");
        return false;
    }

    @NotNull
    public ItemStack getCloneItemStack(@NotNull LevelReader level, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        BlockEntity be = level.getBlockEntity(pos);
        if (be instanceof ArthanaBlockEntity) {
            ItemStack itemStack = ((ArthanaBlockEntity)be).getArthana().copy();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"copy(...)");
            return itemStack;
        }
        ItemStack itemStack = ((ArthanaItem)((Object)WitcheryItems.INSTANCE.getARTHANA().get())).getDefaultInstance();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getDefaultInstance(...)");
        return itemStack;
    }

    @NotNull
    protected VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        VoxelShape voxelShape = Shapes.box((double)0.125, (double)0.0, (double)0.125, (double)0.875, (double)0.0625, (double)0.875);
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape, (String)"box(...)");
        return voxelShape;
    }
}

