/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.block.coffin;

import dev.sterner.witchery.content.block.WitcheryBaseBlockEntity;
import dev.sterner.witchery.content.block.coffin.CoffinBlockEntity;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 ;2\u00020\u0001:\u0001;B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J>\u0010\f\u001a\f\u0012\u0006\u0012\u0004\u0018\u0001H\u000e\u0018\u00010\r\"\n\b\u0000\u0010\u000e*\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u000e\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\u000e0\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J(\u0010\u0019\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\u001c\u0010\u001d\u001a\u00020\u001e2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\u00130 H\u0014J\u0010\u0010\"\u001a\u00020#2\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J8\u0010$\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020(2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010)\u001a\u00020\u0018H\u0014J\u0018\u0010*\u001a\u00020&2\u0006\u0010+\u001a\u00020,2\u0006\u0010%\u001a\u00020&H\u0002J2\u0010-\u001a\u00020\u001e2\u0006\u0010.\u001a\u00020\u00112\u0006\u0010/\u001a\u00020\u00182\u0006\u00100\u001a\u00020\u00132\b\u00101\u001a\u0004\u0018\u0001022\u0006\u00103\u001a\u000204H\u0016J2\u00105\u001a\u0004\u0018\u0001062\u0006\u00100\u001a\u00020\u00132\u0006\u0010.\u001a\u00020\u00112\u0006\u0010/\u001a\u00020\u00182\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:H\u0014R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006<"}, d2={"Ldev/sterner/witchery/content/block/coffin/CoffinBlock;", "Lnet/minecraft/world/level/block/BedBlock;", "properties", "Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;", "color", "Lnet/minecraft/world/item/DyeColor;", "<init>", "(Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;Lnet/minecraft/world/item/DyeColor;)V", "SHAPE", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "getSHAPE", "()Lnet/minecraft/world/phys/shapes/VoxelShape;", "getTicker", "Lnet/minecraft/world/level/block/entity/BlockEntityTicker;", "T", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "level", "Lnet/minecraft/world/level/Level;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "blockEntityType", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "newBlockEntity", "pos", "Lnet/minecraft/core/BlockPos;", "getShape", "Lnet/minecraft/world/level/BlockGetter;", "context", "Lnet/minecraft/world/phys/shapes/CollisionContext;", "createBlockStateDefinition", "", "builder", "Lnet/minecraft/world/level/block/state/StateDefinition$Builder;", "Lnet/minecraft/world/level/block/Block;", "getRenderShape", "Lnet/minecraft/world/level/block/RenderShape;", "updateShape", "direction", "Lnet/minecraft/core/Direction;", "neighborState", "Lnet/minecraft/world/level/LevelAccessor;", "neighborPos", "getDirectionTowardsOtherPart", "part", "Lnet/minecraft/world/level/block/state/properties/BedPart;", "setPlacedBy", "pLevel", "pPos", "pState", "pPlacer", "Lnet/minecraft/world/entity/LivingEntity;", "pStack", "Lnet/minecraft/world/item/ItemStack;", "useWithoutItem", "Lnet/minecraft/world/InteractionResult;", "pPlayer", "Lnet/minecraft/world/entity/player/Player;", "hitResult", "Lnet/minecraft/world/phys/BlockHitResult;", "Companion", "witchery"})
public final class CoffinBlock
extends BedBlock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final VoxelShape SHAPE;
    @NotNull
    private static final BooleanProperty OPEN;

    public CoffinBlock(@NotNull BlockBehaviour.Properties properties, @NotNull DyeColor color) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        super(color, properties);
        VoxelShape voxelShape = Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.625, (double)1.0);
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape, (String)"box(...)");
        this.SHAPE = voxelShape;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BedBlock.PART, (Comparable)BedPart.FOOT)).setValue((Property)BedBlock.OCCUPIED, (Comparable)Boolean.valueOf(false))).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    public final VoxelShape getSHAPE() {
        return this.SHAPE;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> blockEntityType) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter(blockEntityType, (String)"blockEntityType");
        return (arg_0, arg_1, arg_2, arg_3) -> CoffinBlock.getTicker$lambda$0(level, state, arg_0, arg_1, arg_2, arg_3);
    }

    @NotNull
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return new CoffinBlockEntity(pos, state);
    }

    @NotNull
    protected VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.SHAPE;
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        Property[] propertyArray = new Property[]{OPEN};
        builder.add(propertyArray);
        super.createBlockStateDefinition(builder);
    }

    @NotNull
    protected RenderShape getRenderShape(@NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return RenderShape.INVISIBLE;
    }

    @NotNull
    protected BlockState updateShape(@NotNull BlockState state, @NotNull Direction direction, @NotNull BlockState neighborState, @NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockPos neighborPos) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        Intrinsics.checkNotNullParameter((Object)neighborState, (String)"neighborState");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)neighborPos, (String)"neighborPos");
        Comparable comparable = state.getValue((Property)BedBlock.PART);
        Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"getValue(...)");
        BedPart bedPart = (BedPart)comparable;
        Comparable comparable2 = state.getValue((Property)BedBlock.FACING);
        Intrinsics.checkNotNullExpressionValue((Object)comparable2, (String)"getValue(...)");
        if (direction == this.getDirectionTowardsOtherPart(bedPart, (Direction)comparable2)) {
            BlockState blockState;
            if (neighborState.is((Block)this) && neighborState.getValue((Property)BedBlock.PART) != state.getValue((Property)BedBlock.PART)) {
                Object object = ((BlockState)state.setValue((Property)BedBlock.OCCUPIED, neighborState.getValue((Property)BedBlock.OCCUPIED))).setValue((Property)OPEN, neighborState.getValue((Property)OPEN));
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"setValue(...)");
                blockState = (BlockState)object;
            } else {
                BlockState blockState2 = Blocks.AIR.defaultBlockState();
                blockState = blockState2;
                Intrinsics.checkNotNullExpressionValue((Object)blockState2, (String)"defaultBlockState(...)");
            }
            return blockState;
        }
        BlockState blockState = super.updateShape(state, direction, neighborState, level, pos, neighborPos);
        Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"updateShape(...)");
        return blockState;
    }

    private final Direction getDirectionTowardsOtherPart(BedPart part, Direction direction) {
        Direction direction2;
        if (part == BedPart.FOOT) {
            direction2 = direction;
        } else {
            Direction direction3 = direction.getOpposite();
            direction2 = direction3;
            Intrinsics.checkNotNullExpressionValue((Object)direction3, (String)"getOpposite(...)");
        }
        return direction2;
    }

    public void setPlacedBy(@NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull BlockState pState, @Nullable LivingEntity pPlacer, @NotNull ItemStack pStack) {
        Intrinsics.checkNotNullParameter((Object)pLevel, (String)"pLevel");
        Intrinsics.checkNotNullParameter((Object)pPos, (String)"pPos");
        Intrinsics.checkNotNullParameter((Object)pState, (String)"pState");
        Intrinsics.checkNotNullParameter((Object)pStack, (String)"pStack");
        BlockEntity be = pLevel.getBlockEntity(pPos);
        if (be instanceof WitcheryBaseBlockEntity) {
            ((WitcheryBaseBlockEntity)be).onPlace(pPlacer, pStack);
        }
        super.setPlacedBy(pLevel, pPos, pState, pPlacer, pStack);
    }

    @Nullable
    protected InteractionResult useWithoutItem(@NotNull BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull Player pPlayer, @NotNull BlockHitResult hitResult) {
        Intrinsics.checkNotNullParameter((Object)pState, (String)"pState");
        Intrinsics.checkNotNullParameter((Object)pLevel, (String)"pLevel");
        Intrinsics.checkNotNullParameter((Object)pPos, (String)"pPos");
        Intrinsics.checkNotNullParameter((Object)pPlayer, (String)"pPlayer");
        Intrinsics.checkNotNullParameter((Object)hitResult, (String)"hitResult");
        if (pLevel.isClientSide) {
            return InteractionResult.CONSUME;
        }
        if (pPlayer.isShiftKeyDown()) {
            BlockState state = (BlockState)pState.cycle((Property)OPEN);
            pLevel.setBlockAndUpdate(pPos, state);
            return InteractionResult.SUCCESS;
        }
        if (((Boolean)pState.getValue((Property)OPEN)).booleanValue()) {
            BlockState state = (BlockState)pState.cycle((Property)OPEN);
            pLevel.setBlockAndUpdate(pPos, state);
            return super.useWithoutItem(pState, pLevel, pPos, pPlayer, hitResult);
        }
        return InteractionResult.CONSUME;
    }

    private static final void getTicker$lambda$0(Level $level, BlockState $state, Level level, BlockPos pos, BlockState blockState, BlockEntity blockEntity) {
        if (blockEntity instanceof CoffinBlockEntity) {
            CoffinBlockEntity coffinBlockEntity = (CoffinBlockEntity)blockEntity;
            Intrinsics.checkNotNull((Object)pos);
            coffinBlockEntity.tick($level, pos, $state);
        }
    }

    static {
        BooleanProperty booleanProperty = BlockStateProperties.OPEN;
        Intrinsics.checkNotNullExpressionValue((Object)booleanProperty, (String)"OPEN");
        OPEN = booleanProperty;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Ldev/sterner/witchery/content/block/coffin/CoffinBlock$Companion;", "", "<init>", "()V", "OPEN", "Lnet/minecraft/world/level/block/state/properties/BooleanProperty;", "getOPEN", "()Lnet/minecraft/world/level/block/state/properties/BooleanProperty;", "witchery"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BooleanProperty getOPEN() {
            return OPEN;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

