/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.block.dream_weaver;

import dev.sterner.witchery.content.block.WitcheryBaseBlockEntity;
import dev.sterner.witchery.core.registry.WitcheryBlockEntityTypes;
import dev.sterner.witchery.core.registry.WitcheryBlocks;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u000e"}, d2={"Ldev/sterner/witchery/content/block/dream_weaver/DreamWeaverBlockEntity;", "Ldev/sterner/witchery/content/block/WitcheryBaseBlockEntity;", "blockPos", "Lnet/minecraft/core/BlockPos;", "blockState", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "applyWakeUpEffect", "", "player", "Lnet/minecraft/world/entity/player/Player;", "corruptCount", "", "witchery"})
public final class DreamWeaverBlockEntity
extends WitcheryBaseBlockEntity {
    public DreamWeaverBlockEntity(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        Object object = WitcheryBlockEntityTypes.INSTANCE.getDREAM_WEAVER().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        super((BlockEntityType)object, blockPos, blockState);
    }

    public final void applyWakeUpEffect(@NotNull Player player, int corruptCount) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (this.getBlockState().is((Block)WitcheryBlocks.INSTANCE.getDREAM_WEAVER_OF_FLEET_FOOT().get())) {
            boolean bl = corruptCount > 0 ? player.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 6000)) : player.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 6000));
        }
        if (this.getBlockState().is((Block)WitcheryBlocks.INSTANCE.getDREAM_WEAVER_OF_FASTING().get())) {
            if (corruptCount > 0) {
                player.addEffect(new MobEffectInstance(MobEffects.HUNGER, 6000));
                v1 = player.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 6000));
            } else {
                v1 = player.addEffect(new MobEffectInstance(MobEffects.SATURATION, 6000));
            }
        }
        if (this.getBlockState().is((Block)WitcheryBlocks.INSTANCE.getDREAM_WEAVER_OF_NIGHTMARES().get()) && corruptCount > 0) {
            player.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 1200));
            if (corruptCount > 1) {
                player.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 1200));
            }
        }
        if (this.getBlockState().is((Block)WitcheryBlocks.INSTANCE.getDREAM_WEAVER_OF_IRON_ARM().get())) {
            if (corruptCount > 0) {
                player.addEffect(new MobEffectInstance(MobEffects.DIG_SLOWDOWN, 6000));
                v2 = player.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 6000));
            } else {
                v2 = player.addEffect(new MobEffectInstance(MobEffects.DIG_SPEED, 6000));
            }
        }
    }
}

