/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.block.mirror;

import dev.sterner.witchery.content.block.WitcheryBaseEntityBlock;
import dev.sterner.witchery.content.block.mirror.MirrorBlockComponent;
import dev.sterner.witchery.content.block.mirror.MirrorBlockEntity;
import dev.sterner.witchery.content.item.MirrorItem;
import dev.sterner.witchery.core.api.multiblock.MultiBlockHorizontalDirectionStructure;
import dev.sterner.witchery.core.api.multiblock.MultiBlockStructure;
import dev.sterner.witchery.core.registry.WitcheryBlocks;
import dev.sterner.witchery.core.registry.WitcheryItems;
import dev.sterner.witchery.features.mirror.MirrorStuckPlayerAttachment;
import java.util.UUID;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 )2\u00020\u0001:\u0001)B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0016J0\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J:\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\b\u0010\u0019\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001a\u001a\u00020\u000fH\u0016J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J \u0010\u001e\u001a\u00020\u00172\u0016\u0010\u001f\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010!\u0012\u0006\u0012\u0004\u0018\u00010\t0 H\u0014J(\u0010\"\u001a\u00020\u00172\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\r2\u0006\u0010#\u001a\u00020$H\u0014J(\u0010%\u001a\u00020&2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020'2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020(H\u0014\u00a8\u0006*"}, d2={"Ldev/sterner/witchery/content/block/mirror/MirrorBlock;", "Ldev/sterner/witchery/content/block/WitcheryBaseEntityBlock;", "properties", "Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;", "<init>", "(Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;)V", "getRenderShape", "Lnet/minecraft/world/level/block/RenderShape;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "newBlockEntity", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "pos", "Lnet/minecraft/core/BlockPos;", "getCloneItemStack", "Lnet/minecraft/world/item/ItemStack;", "target", "Lnet/minecraft/world/phys/HitResult;", "level", "Lnet/minecraft/world/level/LevelReader;", "player", "Lnet/minecraft/world/entity/player/Player;", "playerDestroy", "", "Lnet/minecraft/world/level/Level;", "blockEntity", "tool", "getStateForPlacement", "context", "Lnet/minecraft/world/item/context/BlockPlaceContext;", "createBlockStateDefinition", "builder", "Lnet/minecraft/world/level/block/state/StateDefinition$Builder;", "Lnet/minecraft/world/level/block/Block;", "entityInside", "entity", "Lnet/minecraft/world/entity/Entity;", "getShape", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "Lnet/minecraft/world/level/BlockGetter;", "Lnet/minecraft/world/phys/shapes/CollisionContext;", "Companion", "witchery"})
@SourceDebugExtension(value={"SMAP\nMirrorBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MirrorBlock.kt\ndev/sterner/witchery/content/block/mirror/MirrorBlock\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,159:1\n1#2:160\n*E\n"})
public final class MirrorBlock
extends WitcheryBaseEntityBlock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Supplier<MultiBlockHorizontalDirectionStructure> STRUCTURE = MirrorBlock::STRUCTURE$lambda$0;
    @NotNull
    private static final DirectionProperty FACING;
    @NotNull
    private static final VoxelShape SOUTH_AABB;
    @NotNull
    private static final VoxelShape NORTH_AABB;
    @NotNull
    private static final VoxelShape WEST_AABB;
    @NotNull
    private static final VoxelShape EAST_AABB;

    public MirrorBlock(@NotNull BlockBehaviour.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    @NotNull
    protected RenderShape getRenderShape(@NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @NotNull
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return new MirrorBlockEntity(pos, state);
    }

    @NotNull
    public ItemStack getCloneItemStack(@NotNull BlockState state, @NotNull HitResult target, @NotNull LevelReader level, @NotNull BlockPos pos, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        ItemStack stack = ((MirrorItem)((Object)WitcheryItems.INSTANCE.getMIRROR().get())).getDefaultInstance();
        BlockEntity blockEntity = level.getBlockEntity(pos);
        MirrorBlockEntity be = blockEntity instanceof MirrorBlockEntity ? (MirrorBlockEntity)blockEntity : null;
        Object object = be;
        if (object != null && (object = ((MirrorBlockEntity)object).getPairId()) != null) {
            Object it = object;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)stack);
            MirrorItem.Companion.setPairId(stack, (UUID)it);
        }
        Intrinsics.checkNotNull((Object)stack);
        return stack;
    }

    public void playerDestroy(@NotNull Level level, @NotNull Player player, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable BlockEntity blockEntity, @NotNull ItemStack tool) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)tool, (String)"tool");
        if (blockEntity instanceof MirrorBlockEntity && !level.isClientSide && !player.isCreative() && !player.isSpectator()) {
            ItemStack itemStack = ((MirrorItem)((Object)WitcheryItems.INSTANCE.getMIRROR().get())).getDefaultInstance();
            UUID uUID = ((MirrorBlockEntity)blockEntity).getPairId();
            if (uUID != null) {
                UUID it = uUID;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)itemStack);
                MirrorItem.Companion.setPairId(itemStack, it);
            }
            ItemEntity itemEntity = new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, itemStack);
            itemEntity.setDefaultPickUpDelay();
            level.addFreshEntity((Entity)itemEntity);
        }
        super.playerDestroy(level, player, pos, state, blockEntity, tool);
    }

    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        BlockPos blockPos = context.getClickedPos();
        Level level = context.getLevel();
        return blockPos.getY() < level.getMaxBuildHeight() - 1 && level.getBlockState(blockPos.above()).canBeReplaced(context) ? (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite()) : null;
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        super.createBlockStateDefinition(builder);
        Property[] propertyArray = new Property[]{FACING};
        builder.add(propertyArray);
    }

    protected void entityInside(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        VoxelShape shape = state.getShape((BlockGetter)level, pos);
        AABB entityBox = entity.getBoundingBox();
        AABB shapeWorld = shape.bounds().move((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
        if (!entityBox.intersects(shapeWorld)) {
            return;
        }
        entity.makeStuckInBlock(state, new Vec3(0.25, 0.05, 0.25));
        if (level.isClientSide) {
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        MirrorBlockEntity mirrorBlockEntity = blockEntity instanceof MirrorBlockEntity ? (MirrorBlockEntity)blockEntity : null;
        if (mirrorBlockEntity == null) {
            return;
        }
        MirrorBlockEntity be = mirrorBlockEntity;
        if (be.getMode() != MirrorBlockEntity.Mode.TELEPORT) {
            return;
        }
        if (be.isOnCooldown(entity)) {
            return;
        }
        if (!be.canEntityTeleport(entity)) {
            return;
        }
        Direction facing = (Direction)state.getValue((Property)FACING);
        Vec3 facingVec = new Vec3((double)facing.getStepX(), 0.0, (double)facing.getStepZ());
        Vec3 mirrorCenter = Vec3.atCenterOf((Vec3i)((Vec3i)pos));
        Vec3 toEntity = entity.position().subtract(mirrorCenter);
        double dot = toEntity.dot(facingVec);
        if (entity instanceof ItemEntity) {
            if (dot < -0.3) {
                be.tryTeleportEntity(entity);
            }
            return;
        }
        BlockPos wallPos = pos.relative(facing.getOpposite());
        UUID uUID = entity.getUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        Intrinsics.checkNotNull((Object)wallPos);
        MirrorStuckPlayerAttachment.INSTANCE.setWallPos(level, uUID, wallPos);
        if (dot < -0.6) {
            be.tryTeleportEntity(entity);
            UUID uUID2 = entity.getUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"getUUID(...)");
            MirrorStuckPlayerAttachment.INSTANCE.removeEntry(level, uUID2);
        }
    }

    @NotNull
    protected VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Direction direction = (Direction)state.getValue((Property)FACING);
        return switch (direction == null ? -1 : WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
            case 1 -> SOUTH_AABB;
            case 2 -> WEST_AABB;
            case 3 -> NORTH_AABB;
            default -> EAST_AABB;
        };
    }

    private static final MultiBlockHorizontalDirectionStructure STRUCTURE$lambda$0() {
        MultiBlockStructure.StructurePiece[] structurePieceArray = new MultiBlockStructure.StructurePiece[1];
        BlockState blockState = ((MirrorBlockComponent)((Object)WitcheryBlocks.INSTANCE.getMIRROR_COMPONENT().get())).defaultBlockState();
        Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"defaultBlockState(...)");
        structurePieceArray[0] = new MultiBlockStructure.StructurePiece(0, 1, 0, blockState);
        return MultiBlockHorizontalDirectionStructure.Companion.of(structurePieceArray);
    }

    static {
        DirectionProperty directionProperty = HorizontalDirectionalBlock.FACING;
        Intrinsics.checkNotNullExpressionValue((Object)directionProperty, (String)"FACING");
        FACING = directionProperty;
        VoxelShape voxelShape = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0);
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape, (String)"box(...)");
        SOUTH_AABB = voxelShape;
        VoxelShape voxelShape2 = Block.box((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0);
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape2, (String)"box(...)");
        NORTH_AABB = voxelShape2;
        VoxelShape voxelShape3 = Block.box((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape3, (String)"box(...)");
        WEST_AABB = voxelShape3;
        VoxelShape voxelShape4 = Block.box((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0);
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape4, (String)"box(...)");
        EAST_AABB = voxelShape4;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u0011\u0010\u0013\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0010R\u0011\u0010\u0015\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0010\u00a8\u0006\u0017"}, d2={"Ldev/sterner/witchery/content/block/mirror/MirrorBlock$Companion;", "", "<init>", "()V", "STRUCTURE", "Ljava/util/function/Supplier;", "Ldev/sterner/witchery/core/api/multiblock/MultiBlockHorizontalDirectionStructure;", "getSTRUCTURE", "()Ljava/util/function/Supplier;", "FACING", "Lnet/minecraft/world/level/block/state/properties/DirectionProperty;", "getFACING", "()Lnet/minecraft/world/level/block/state/properties/DirectionProperty;", "SOUTH_AABB", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "getSOUTH_AABB", "()Lnet/minecraft/world/phys/shapes/VoxelShape;", "NORTH_AABB", "getNORTH_AABB", "WEST_AABB", "getWEST_AABB", "EAST_AABB", "getEAST_AABB", "witchery"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Supplier<MultiBlockHorizontalDirectionStructure> getSTRUCTURE() {
            return STRUCTURE;
        }

        @NotNull
        public final DirectionProperty getFACING() {
            return FACING;
        }

        @NotNull
        public final VoxelShape getSOUTH_AABB() {
            return SOUTH_AABB;
        }

        @NotNull
        public final VoxelShape getNORTH_AABB() {
            return NORTH_AABB;
        }

        @NotNull
        public final VoxelShape getWEST_AABB() {
            return WEST_AABB;
        }

        @NotNull
        public final VoxelShape getEAST_AABB() {
            return EAST_AABB;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Direction.values().length];
            try {
                nArray[Direction.SOUTH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.WEST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.NORTH.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

