/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.block.mushroom_log;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.sterner.witchery.content.block.mushroom_log.MushroomLogBlock;
import dev.sterner.witchery.core.api.multiblock.MultiBlockCoreEntity;
import dev.sterner.witchery.core.api.multiblock.MultiBlockHorizontalDirectionStructure;
import dev.sterner.witchery.core.registry.WitcheryBlockEntityTypes;
import dev.sterner.witchery.core.registry.WitcheryTags;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001<B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\tJ \u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\t2\u0006\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020\u001fH\u0002J\u0010\u0010)\u001a\u00020\u001f2\u0006\u0010*\u001a\u00020+H\u0016J\u0018\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u0003H\u0002J\u0018\u00101\u001a\u0004\u0018\u00010\t2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u0003J\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u001803J\u0018\u00104\u001a\u00020\u001f2\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u000208H\u0014J\u0018\u00109\u001a\u00020\u001f2\u0006\u0010:\u001a\u0002062\u0006\u0010;\u001a\u000208H\u0014R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u000fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u000fX\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0019\u001a\n \u001b*\u0004\u0018\u00010\u001a0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Ldev/sterner/witchery/content/block/mushroom_log/MushroomLogBlockEntity;", "Ldev/sterner/witchery/core/api/multiblock/MultiBlockCoreEntity;", "blockPos", "Lnet/minecraft/core/BlockPos;", "blockState", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "currentMushroom", "Lnet/minecraft/world/item/ItemStack;", "getCurrentMushroom", "()Lnet/minecraft/world/item/ItemStack;", "setCurrentMushroom", "(Lnet/minecraft/world/item/ItemStack;)V", "growthStage", "", "getGrowthStage", "()F", "setGrowthStage", "(F)V", "maxGrowthStage", "growthRate", "mushroomPositions", "", "Ldev/sterner/witchery/content/block/mushroom_log/MushroomLogBlockEntity$MushroomData;", "random", "Lnet/minecraft/util/RandomSource;", "kotlin.jvm.PlatformType", "harvestAmount", "", "setMushroom", "", "mushroom", "onUseWithItem", "Lnet/minecraft/world/ItemInteractionResult;", "pPlayer", "Lnet/minecraft/world/entity/player/Player;", "pStack", "pHand", "Lnet/minecraft/world/InteractionHand;", "generateMushroomPositions", "tickServer", "serverLevel", "Lnet/minecraft/server/level/ServerLevel;", "canGrow", "", "level", "Lnet/minecraft/world/level/Level;", "pos", "harvest", "getMushroomData", "", "saveAdditional", "tag", "Lnet/minecraft/nbt/CompoundTag;", "registries", "Lnet/minecraft/core/HolderLookup$Provider;", "loadAdditional", "pTag", "pRegistries", "MushroomData", "witchery"})
@SourceDebugExtension(value={"SMAP\nMushroomLogBlockEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MushroomLogBlockEntity.kt\ndev/sterner/witchery/content/block/mushroom_log/MushroomLogBlockEntity\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,288:1\n1869#2,2:289\n1869#2,2:291\n1869#2,2:293\n*S KotlinDebug\n*F\n+ 1 MushroomLogBlockEntity.kt\ndev/sterner/witchery/content/block/mushroom_log/MushroomLogBlockEntity\n*L\n82#1:289,2\n136#1:291,2\n242#1:293,2\n*E\n"})
public final class MushroomLogBlockEntity
extends MultiBlockCoreEntity {
    @NotNull
    private ItemStack currentMushroom;
    private float growthStage;
    private final float maxGrowthStage;
    private final float growthRate;
    @NotNull
    private final List<MushroomData> mushroomPositions;
    private final RandomSource random;
    private final int harvestAmount;

    public MushroomLogBlockEntity(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        Object object = WitcheryBlockEntityTypes.INSTANCE.getMUSHROOM_LOG().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        BlockEntityType blockEntityType = (BlockEntityType)object;
        MultiBlockHorizontalDirectionStructure multiBlockHorizontalDirectionStructure = MushroomLogBlock.Companion.getSTRUCTURE().get();
        Intrinsics.checkNotNullExpressionValue((Object)multiBlockHorizontalDirectionStructure, (String)"get(...)");
        super(blockEntityType, multiBlockHorizontalDirectionStructure, blockPos, blockState);
        ItemStack itemStack = ItemStack.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
        this.currentMushroom = itemStack;
        this.maxGrowthStage = 1.0f;
        this.growthRate = 0.005f;
        this.mushroomPositions = new ArrayList();
        this.random = RandomSource.create((long)blockPos.asLong());
        this.harvestAmount = 1;
    }

    @NotNull
    public final ItemStack getCurrentMushroom() {
        return this.currentMushroom;
    }

    public final void setCurrentMushroom(@NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"<set-?>");
        this.currentMushroom = itemStack;
    }

    public final float getGrowthStage() {
        return this.growthStage;
    }

    public final void setGrowthStage(float f) {
        this.growthStage = f;
    }

    public final void setMushroom(@NotNull ItemStack mushroom) {
        Intrinsics.checkNotNullParameter((Object)mushroom, (String)"mushroom");
        boolean shouldGeneratePositions = this.currentMushroom.isEmpty() || !Intrinsics.areEqual((Object)this.currentMushroom.getItem(), (Object)mushroom.getItem()) || this.mushroomPositions.isEmpty();
        ItemStack itemStack = mushroom.copy();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"copy(...)");
        this.currentMushroom = itemStack;
        this.growthStage = 0.0f;
        if (shouldGeneratePositions) {
            this.generateMushroomPositions();
        } else {
            Iterable $this$forEach$iv = this.mushroomPositions;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                MushroomData it = (MushroomData)element$iv;
                boolean bl = false;
                it.setScale(0.0f);
            }
        }
        this.setChanged();
    }

    @Override
    @NotNull
    public ItemInteractionResult onUseWithItem(@NotNull Player pPlayer, @NotNull ItemStack pStack, @NotNull InteractionHand pHand) {
        Intrinsics.checkNotNullParameter((Object)pPlayer, (String)"pPlayer");
        Intrinsics.checkNotNullParameter((Object)pStack, (String)"pStack");
        Intrinsics.checkNotNullParameter((Object)pHand, (String)"pHand");
        if (this.level != null) {
            if (pPlayer.getMainHandItem().isEmpty()) {
                Level level = this.level;
                Intrinsics.checkNotNull((Object)level);
                BlockPos blockPos = this.getBlockPos();
                Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
                ItemStack itemStack = this.harvest(level, blockPos);
                if (itemStack != null) {
                    ItemStack it = itemStack;
                    boolean bl = false;
                    Level level2 = this.level;
                    Intrinsics.checkNotNull((Object)level2);
                    Containers.dropItemStack((Level)level2, (double)this.getBlockPos().getX(), (double)this.getBlockPos().getY(), (double)this.getBlockPos().getZ(), (ItemStack)it);
                }
            } else if (pStack.is(WitcheryTags.INSTANCE.getMUSHROOMS())) {
                Level level = this.level;
                Intrinsics.checkNotNull((Object)level);
                Containers.dropItemStack((Level)level, (double)this.getBlockPos().getX(), (double)this.getBlockPos().getY(), (double)this.getBlockPos().getZ(), (ItemStack)this.currentMushroom.copy());
                this.setMushroom(pStack);
                pPlayer.getMainHandItem().shrink(1);
                pPlayer.swing(pHand);
                return ItemInteractionResult.SUCCESS;
            }
        }
        return super.onUseWithItem(pPlayer, pStack, pHand);
    }

    private final void generateMushroomPositions() {
        long seed = this.getBlockPos().asLong() + (this.currentMushroom.isEmpty() ? 0L : (long)this.currentMushroom.getItem().getDescriptionId().hashCode());
        this.random.setSeed(seed);
        this.mushroomPositions.clear();
        int count = 4 + this.random.nextInt(4);
        List positions = new ArrayList();
        Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)30);
        boolean $i$f$forEach = false;
        Iterator<Object> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv;
            int i = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            float x = -0.4f + this.random.nextFloat() * 0.8f;
            float z = -1.5f + this.random.nextFloat() * 2.0f;
            boolean tooClose = false;
            for (Pair pos : positions) {
                float dz;
                float dx = ((Number)pos.getFirst()).floatValue() - x;
                float distSq = dx * dx + (dz = ((Number)pos.getSecond()).floatValue() - z) * dz;
                if (!(distSq < 0.040000003f)) continue;
                tooClose = true;
                break;
            }
            if (tooClose) continue;
            positions.add(new Pair((Object)Float.valueOf(x), (Object)Float.valueOf(z)));
        }
        List shuffledPositions = CollectionsKt.shuffled((Iterable)positions, (Random)new Random(seed));
        List selectedPositions = CollectionsKt.take((Iterable)shuffledPositions, (int)count);
        for (Pair pos : selectedPositions) {
            float rotation = this.random.nextFloat() * 360.0f;
            float targetScale = 0.4f + this.random.nextFloat() * 0.6f;
            float growthOffset = this.random.nextFloat() * 0.3f;
            this.mushroomPositions.add(new MushroomData(((Number)pos.getFirst()).floatValue(), ((Number)pos.getSecond()).floatValue(), rotation, 0.0f, targetScale, growthOffset));
        }
    }

    @Override
    public void tickServer(@NotNull ServerLevel serverLevel) {
        Intrinsics.checkNotNullParameter((Object)serverLevel, (String)"serverLevel");
        if (serverLevel.getGameTime() % (long)20 == 0L && serverLevel.random.nextFloat() < 0.33f && !this.currentMushroom.isEmpty() && this.growthStage < this.maxGrowthStage) {
            Level level = (Level)serverLevel;
            BlockPos blockPos = this.getBlockPos();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
            if (this.canGrow(level, blockPos)) {
                this.growthStage = Math.min(this.maxGrowthStage, this.growthStage + this.growthRate);
                if ((int)(this.growthStage * (float)100) % 10 == 0) {
                    this.setChanged();
                    serverLevel.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
                }
            }
        }
    }

    private final boolean canGrow(Level level, BlockPos pos) {
        if (!(level instanceof ServerLevel)) {
            return false;
        }
        int lightLevel = level.getBrightness(LightLayer.BLOCK, pos);
        boolean isRaining = ((ServerLevel)level).isRaining();
        return this.random.nextFloat() < (1.0f - (float)lightLevel / 15.0f) * (isRaining ? 1.5f : 1.0f);
    }

    @Nullable
    public final ItemStack harvest(@NotNull Level level, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        if (this.currentMushroom.isEmpty() || this.growthStage < 0.5f) {
            return null;
        }
        ItemStack harvestedMushroom = this.currentMushroom.copy();
        harvestedMushroom.setCount(this.harvestAmount);
        this.growthStage = RangesKt.coerceAtLeast((float)0.2f, (float)(this.growthStage - 0.3f));
        this.setChanged();
        level.playSound(null, pos, SoundEvents.FUNGUS_BREAK, SoundSource.BLOCKS, 0.8f, 0.8f + level.random.nextFloat() * 0.4f);
        return harvestedMushroom;
    }

    @NotNull
    public final List<MushroomData> getMushroomData() {
        if (!this.currentMushroom.isEmpty() && this.mushroomPositions.isEmpty()) {
            this.generateMushroomPositions();
        }
        Iterable $this$forEach$iv = this.mushroomPositions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MushroomData data2 = (MushroomData)element$iv;
            boolean bl = false;
            float actualGrowth = Math.max(0.0f, this.growthStage - data2.getGrowthOffset());
            data2.setScale(actualGrowth * data2.getTargetScale());
        }
        return this.mushroomPositions;
    }

    @Override
    protected void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        super.saveAdditional(tag, registries);
        if (!this.currentMushroom.isEmpty()) {
            Tag itemTag = this.currentMushroom.save(registries);
            tag.put("currentMushroom", itemTag);
        }
        tag.putFloat("growthStage", this.growthStage);
        Tag mushroomPositionsNbt = (Tag)MushroomData.Companion.getCODEC().listOf().encodeStart((DynamicOps)NbtOps.INSTANCE, this.mushroomPositions).getOrThrow();
        tag.put("mushroomPositions", mushroomPositionsNbt);
    }

    @Override
    protected void loadAdditional(@NotNull CompoundTag pTag, @NotNull HolderLookup.Provider pRegistries) {
        Intrinsics.checkNotNullParameter((Object)pTag, (String)"pTag");
        Intrinsics.checkNotNullParameter((Object)pRegistries, (String)"pRegistries");
        super.loadAdditional(pTag, pRegistries);
        if (pTag.contains("currentMushroom", 10)) {
            CompoundTag itemTag = pTag.getCompound("currentMushroom");
            ItemStack itemStack = ItemStack.parse((HolderLookup.Provider)pRegistries, (Tag)((Tag)itemTag)).orElse(ItemStack.EMPTY);
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"orElse(...)");
            this.currentMushroom = itemStack;
        }
        this.growthStage = pTag.getFloat("growthStage");
        if (pTag.contains("mushroomPositions")) {
            List result = (List)MushroomData.Companion.getCODEC().listOf().parse((DynamicOps)NbtOps.INSTANCE, (Object)pTag.get("mushroomPositions")).getOrThrow();
            this.mushroomPositions.clear();
            Intrinsics.checkNotNull((Object)result);
            this.mushroomPositions.addAll(result);
        }
        if (this.mushroomPositions.isEmpty() && !this.currentMushroom.isEmpty()) {
            this.generateMushroomPositions();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0018\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \"2\u00020\u0001:\u0001\"B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003JE\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001J\t\u0010 \u001a\u00020!H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u001a\u0010\u0006\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\f\"\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\fR\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\f\u00a8\u0006#"}, d2={"Ldev/sterner/witchery/content/block/mushroom_log/MushroomLogBlockEntity$MushroomData;", "", "xOffset", "", "zOffset", "rotation", "scale", "targetScale", "growthOffset", "<init>", "(FFFFFF)V", "getXOffset", "()F", "getZOffset", "getRotation", "getScale", "setScale", "(F)V", "getTargetScale", "getGrowthOffset", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Companion", "witchery"})
    public static final class MushroomData {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final float xOffset;
        private final float zOffset;
        private final float rotation;
        private float scale;
        private final float targetScale;
        private final float growthOffset;
        @NotNull
        private static final Codec<MushroomData> CODEC;

        public MushroomData(float xOffset, float zOffset, float rotation, float scale, float targetScale, float growthOffset) {
            this.xOffset = xOffset;
            this.zOffset = zOffset;
            this.rotation = rotation;
            this.scale = scale;
            this.targetScale = targetScale;
            this.growthOffset = growthOffset;
        }

        public final float getXOffset() {
            return this.xOffset;
        }

        public final float getZOffset() {
            return this.zOffset;
        }

        public final float getRotation() {
            return this.rotation;
        }

        public final float getScale() {
            return this.scale;
        }

        public final void setScale(float f) {
            this.scale = f;
        }

        public final float getTargetScale() {
            return this.targetScale;
        }

        public final float getGrowthOffset() {
            return this.growthOffset;
        }

        public final float component1() {
            return this.xOffset;
        }

        public final float component2() {
            return this.zOffset;
        }

        public final float component3() {
            return this.rotation;
        }

        public final float component4() {
            return this.scale;
        }

        public final float component5() {
            return this.targetScale;
        }

        public final float component6() {
            return this.growthOffset;
        }

        @NotNull
        public final MushroomData copy(float xOffset, float zOffset, float rotation, float scale, float targetScale, float growthOffset) {
            return new MushroomData(xOffset, zOffset, rotation, scale, targetScale, growthOffset);
        }

        public static /* synthetic */ MushroomData copy$default(MushroomData mushroomData, float f, float f2, float f3, float f4, float f5, float f6, int n, Object object) {
            if ((n & 1) != 0) {
                f = mushroomData.xOffset;
            }
            if ((n & 2) != 0) {
                f2 = mushroomData.zOffset;
            }
            if ((n & 4) != 0) {
                f3 = mushroomData.rotation;
            }
            if ((n & 8) != 0) {
                f4 = mushroomData.scale;
            }
            if ((n & 0x10) != 0) {
                f5 = mushroomData.targetScale;
            }
            if ((n & 0x20) != 0) {
                f6 = mushroomData.growthOffset;
            }
            return mushroomData.copy(f, f2, f3, f4, f5, f6);
        }

        @NotNull
        public String toString() {
            return "MushroomData(xOffset=" + this.xOffset + ", zOffset=" + this.zOffset + ", rotation=" + this.rotation + ", scale=" + this.scale + ", targetScale=" + this.targetScale + ", growthOffset=" + this.growthOffset + ")";
        }

        public int hashCode() {
            int result = Float.hashCode(this.xOffset);
            result = result * 31 + Float.hashCode(this.zOffset);
            result = result * 31 + Float.hashCode(this.rotation);
            result = result * 31 + Float.hashCode(this.scale);
            result = result * 31 + Float.hashCode(this.targetScale);
            result = result * 31 + Float.hashCode(this.growthOffset);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MushroomData)) {
                return false;
            }
            MushroomData mushroomData = (MushroomData)other;
            if (Float.compare(this.xOffset, mushroomData.xOffset) != 0) {
                return false;
            }
            if (Float.compare(this.zOffset, mushroomData.zOffset) != 0) {
                return false;
            }
            if (Float.compare(this.rotation, mushroomData.rotation) != 0) {
                return false;
            }
            if (Float.compare(this.scale, mushroomData.scale) != 0) {
                return false;
            }
            if (Float.compare(this.targetScale, mushroomData.targetScale) != 0) {
                return false;
            }
            return Float.compare(this.growthOffset, mushroomData.growthOffset) == 0;
        }

        private static final App CODEC$lambda$0(RecordCodecBuilder.Instance instance) {
            return instance.group((App)Codec.FLOAT.fieldOf("xOffset").forGetter(MushroomData::CODEC$lambda$0$0), (App)Codec.FLOAT.fieldOf("zOffset").forGetter(MushroomData::CODEC$lambda$0$1), (App)Codec.FLOAT.fieldOf("rotation").forGetter(MushroomData::CODEC$lambda$0$2), (App)Codec.FLOAT.fieldOf("scale").forGetter(MushroomData::CODEC$lambda$0$3), (App)Codec.FLOAT.fieldOf("targetScale").forGetter(MushroomData::CODEC$lambda$0$4), (App)Codec.FLOAT.fieldOf("growthOffset").forGetter(MushroomData::CODEC$lambda$0$5)).apply((Applicative)instance, MushroomData::new);
        }

        private static final Float CODEC$lambda$0$0(MushroomData it) {
            return Float.valueOf(it.xOffset);
        }

        private static final Float CODEC$lambda$0$1(MushroomData it) {
            return Float.valueOf(it.zOffset);
        }

        private static final Float CODEC$lambda$0$2(MushroomData it) {
            return Float.valueOf(it.rotation);
        }

        private static final Float CODEC$lambda$0$3(MushroomData it) {
            return Float.valueOf(it.scale);
        }

        private static final Float CODEC$lambda$0$4(MushroomData it) {
            return Float.valueOf(it.targetScale);
        }

        private static final Float CODEC$lambda$0$5(MushroomData it) {
            return Float.valueOf(it.growthOffset);
        }

        static {
            Codec codec = RecordCodecBuilder.create(MushroomData::CODEC$lambda$0);
            Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"create(...)");
            CODEC = codec;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Ldev/sterner/witchery/content/block/mushroom_log/MushroomLogBlockEntity$MushroomData$Companion;", "", "<init>", "()V", "CODEC", "Lcom/mojang/serialization/Codec;", "Ldev/sterner/witchery/content/block/mushroom_log/MushroomLogBlockEntity$MushroomData;", "getCODEC", "()Lcom/mojang/serialization/Codec;", "witchery"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Codec<MushroomData> getCODEC() {
                return CODEC;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

