/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.block.oven;

import dev.sterner.witchery.content.block.WitcheryBaseEntityBlock;
import dev.sterner.witchery.content.block.cauldron.WitcheryCauldronBlock;
import dev.sterner.witchery.content.block.oven.OvenBlock;
import dev.sterner.witchery.content.block.oven.OvenFumeExtensionBlockComponent;
import dev.sterner.witchery.core.api.multiblock.MultiBlockHorizontalDirectionStructure;
import dev.sterner.witchery.core.api.multiblock.MultiBlockStructure;
import dev.sterner.witchery.core.registry.WitcheryBlockEntityTypes;
import dev.sterner.witchery.core.registry.WitcheryBlocks;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 /2\u00020\u0001:\u0001/B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J8\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J-\u0010\u0017\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0018\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u0019J.\u0010\u001a\u001a\u0010\u0012\u0004\u0012\u00020\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u00160\u001b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\u001e\u001a\u00020\u00162\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\b\u001a\u00020\tH\u0014J0\u0010\u001f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\t2\u0006\u0010 \u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\u0016H\u0014J\u0010\u0010\"\u001a\u00020#2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0010\u0010$\u001a\u00020\u000b2\u0006\u0010%\u001a\u00020&H\u0016J\u001c\u0010'\u001a\u00020\r2\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u000b0)H\u0014J(\u0010*\u001a\u00020+2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020,2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010-\u001a\u00020.H\u0014\u00a8\u00060"}, d2={"Ldev/sterner/witchery/content/block/oven/OvenFumeExtensionBlock;", "Ldev/sterner/witchery/content/block/WitcheryBaseEntityBlock;", "properties", "Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;", "<init>", "(Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;)V", "newBlockEntity", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "pos", "Lnet/minecraft/core/BlockPos;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "neighborChanged", "", "pState", "pLevel", "Lnet/minecraft/world/level/Level;", "pPos", "pBlock", "Lnet/minecraft/world/level/block/Block;", "pFromPos", "pIsMoving", "", "updateLit", "isOvenRight", "(Lnet/minecraft/world/level/Level;Ljava/lang/Boolean;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "checkOvenPlacement", "Lkotlin/Pair;", "level", "Lnet/minecraft/world/level/LevelReader;", "canSurvive", "onPlace", "oldState", "movedByPiston", "getRenderShape", "Lnet/minecraft/world/level/block/RenderShape;", "getStateForPlacement", "blockPlaceContext", "Lnet/minecraft/world/item/context/BlockPlaceContext;", "createBlockStateDefinition", "builder", "Lnet/minecraft/world/level/block/state/StateDefinition$Builder;", "getShape", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "Lnet/minecraft/world/level/BlockGetter;", "context", "Lnet/minecraft/world/phys/shapes/CollisionContext;", "Companion", "witchery"})
public class OvenFumeExtensionBlock
extends WitcheryBaseEntityBlock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Supplier<MultiBlockHorizontalDirectionStructure> STRUCTURE = OvenFumeExtensionBlock::STRUCTURE$lambda$0;
    private static final VoxelShape shape = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)3.0, (double)13.0);
    private static final VoxelShape shape2 = Block.box((double)3.0, (double)12.0, (double)3.0, (double)13.0, (double)15.0, (double)13.0);
    private static final VoxelShape smallShape = Block.box((double)5.0, (double)14.0, (double)5.0, (double)11.0, (double)15.0, (double)11.0);
    private static final VoxelShape bigShape = Block.box((double)5.0, (double)3.0, (double)5.0, (double)11.0, (double)15.0, (double)11.0);
    @NotNull
    private static final VoxelShape SHAPE;

    public OvenFumeExtensionBlock(@NotNull BlockBehaviour.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        BlockBehaviour.Properties properties2 = properties.noOcclusion().lightLevel(WitcheryCauldronBlock.Companion.litBlockEmission(8));
        Intrinsics.checkNotNullExpressionValue((Object)properties2, (String)"lightLevel(...)");
        super(properties2);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(false))).setValue((Property)OvenFumeExtensionBlockComponent.Companion.getALT(), (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return ((BlockEntityType)WitcheryBlockEntityTypes.INSTANCE.getOVEN_FUME_EXTENSION().get()).create(pos, state);
    }

    @Override
    public void neighborChanged(@NotNull BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull Block pBlock, @NotNull BlockPos pFromPos, boolean pIsMoving) {
        Intrinsics.checkNotNullParameter((Object)pState, (String)"pState");
        Intrinsics.checkNotNullParameter((Object)pLevel, (String)"pLevel");
        Intrinsics.checkNotNullParameter((Object)pPos, (String)"pPos");
        Intrinsics.checkNotNullParameter((Object)pBlock, (String)"pBlock");
        Intrinsics.checkNotNullParameter((Object)pFromPos, (String)"pFromPos");
        super.neighborChanged(pState, pLevel, pPos, pBlock, pFromPos, pIsMoving);
        Pair<Boolean, Boolean> pair = this.checkOvenPlacement(pState, (LevelReader)pLevel, pPos);
        boolean canSurvive = (Boolean)pair.component1();
        Boolean isOvenRight = (Boolean)pair.component2();
        if (canSurvive) {
            this.updateLit(pLevel, isOvenRight, pPos, pState);
        }
    }

    public final void updateLit(@NotNull Level pLevel, @Nullable Boolean isOvenRight, @NotNull BlockPos pPos, @NotNull BlockState pState) {
        Intrinsics.checkNotNullParameter((Object)pLevel, (String)"pLevel");
        Intrinsics.checkNotNullParameter((Object)pPos, (String)"pPos");
        Intrinsics.checkNotNullParameter((Object)pState, (String)"pState");
        BlockPos ovenPos = Intrinsics.areEqual((Object)isOvenRight, (Object)true) ? pPos.relative(((Direction)pState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).getClockWise()) : pPos.relative(((Direction)pState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).getCounterClockWise());
        BlockState ovenState = pLevel.getBlockState(ovenPos);
        Boolean isOvenLit = (Boolean)ovenState.getValue((Property)BlockStateProperties.LIT);
        pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)BlockStateProperties.LIT, (Comparable)isOvenLit), 3);
    }

    private final Pair<Boolean, Boolean> checkOvenPlacement(BlockState state, LevelReader level, BlockPos pos) {
        Direction blockFacing = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        BlockPos leftPos = pos.relative(blockFacing.getCounterClockWise());
        BlockPos rightPos = pos.relative(blockFacing.getClockWise());
        BlockState leftState = level.getBlockState(leftPos);
        BlockState rightState = level.getBlockState(rightPos);
        boolean isOvenLeft = leftState.getBlock() instanceof OvenBlock;
        boolean isOvenRight = rightState.getBlock() instanceof OvenBlock;
        if (!isOvenLeft && !isOvenRight) {
            return new Pair((Object)false, null);
        }
        Direction ovenFacing = isOvenLeft ? (Direction)leftState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING) : (Direction)rightState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        return new Pair((Object)(blockFacing == ovenFacing ? 1 : 0), (Object)isOvenRight);
    }

    protected boolean canSurvive(@NotNull BlockState state, @NotNull LevelReader level, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        boolean canSurvive = (Boolean)this.checkOvenPlacement(state, level, pos).component1();
        return canSurvive;
    }

    protected void onPlace(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState oldState, boolean movedByPiston) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)oldState, (String)"oldState");
        super.onPlace(state, level, pos, oldState, movedByPiston);
        Pair<Boolean, Boolean> pair = this.checkOvenPlacement(state, (LevelReader)level, pos);
        boolean canSurvive = (Boolean)pair.component1();
        Boolean isOvenRight = (Boolean)pair.component2();
        if (canSurvive) {
            Object object = state.setValue((Property)OvenFumeExtensionBlockComponent.Companion.getALT(), (Comparable)Boolean.valueOf(Intrinsics.areEqual((Object)isOvenRight, (Object)false)));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"setValue(...)");
            this.updateLit(level, isOvenRight, pos, (BlockState)object);
        }
    }

    @NotNull
    protected RenderShape getRenderShape(@NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return RenderShape.MODEL;
    }

    @NotNull
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext blockPlaceContext) {
        Intrinsics.checkNotNullParameter((Object)blockPlaceContext, (String)"blockPlaceContext");
        Object object = this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)blockPlaceContext.getHorizontalDirection().getOpposite());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"setValue(...)");
        return (BlockState)object;
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        Property[] propertyArray = new Property[]{BlockStateProperties.HORIZONTAL_FACING, BlockStateProperties.LIT, OvenFumeExtensionBlockComponent.Companion.getALT()};
        builder.add(propertyArray);
    }

    @NotNull
    protected VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return SHAPE;
    }

    private static final MultiBlockHorizontalDirectionStructure STRUCTURE$lambda$0() {
        MultiBlockStructure.StructurePiece[] structurePieceArray = new MultiBlockStructure.StructurePiece[1];
        BlockState blockState = ((OvenFumeExtensionBlockComponent)((Object)WitcheryBlocks.INSTANCE.getIRON_WITCHES_OVEN_FUME_EXTENSION_COMPONENT().get())).defaultBlockState();
        Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"defaultBlockState(...)");
        structurePieceArray[0] = new MultiBlockStructure.StructurePiece(0, 1, 0, blockState);
        return MultiBlockHorizontalDirectionStructure.Companion.of(structurePieceArray);
    }

    static {
        VoxelShape voxelShape = Shapes.join((VoxelShape)Shapes.join((VoxelShape)shape, (VoxelShape)bigShape, (BooleanOp)BooleanOp.OR), (VoxelShape)Shapes.join((VoxelShape)shape2, (VoxelShape)smallShape, (BooleanOp)BooleanOp.OR), (BooleanOp)BooleanOp.OR);
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape, (String)"join(...)");
        SHAPE = voxelShape;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0019\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0019\u0010\u000e\u001a\n \u000b*\u0004\u0018\u00010\n0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0019\u0010\u0010\u001a\n \u000b*\u0004\u0018\u00010\n0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rR\u0019\u0010\u0012\u001a\n \u000b*\u0004\u0018\u00010\n0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\rR\u0011\u0010\u0014\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\r\u00a8\u0006\u0016"}, d2={"Ldev/sterner/witchery/content/block/oven/OvenFumeExtensionBlock$Companion;", "", "<init>", "()V", "STRUCTURE", "Ljava/util/function/Supplier;", "Ldev/sterner/witchery/core/api/multiblock/MultiBlockHorizontalDirectionStructure;", "getSTRUCTURE", "()Ljava/util/function/Supplier;", "shape", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "kotlin.jvm.PlatformType", "getShape", "()Lnet/minecraft/world/phys/shapes/VoxelShape;", "shape2", "getShape2", "smallShape", "getSmallShape", "bigShape", "getBigShape", "SHAPE", "getSHAPE", "witchery"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Supplier<MultiBlockHorizontalDirectionStructure> getSTRUCTURE() {
            return STRUCTURE;
        }

        public final VoxelShape getShape() {
            return shape;
        }

        public final VoxelShape getShape2() {
            return shape2;
        }

        public final VoxelShape getSmallShape() {
            return smallShape;
        }

        public final VoxelShape getBigShape() {
            return bigShape;
        }

        @NotNull
        public final VoxelShape getSHAPE() {
            return SHAPE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

