/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.block.poppet;

import dev.sterner.witchery.content.block.WitcheryBaseBlockEntity;
import dev.sterner.witchery.content.block.poppet.PoppetBlock;
import dev.sterner.witchery.content.item.PoppetItem;
import dev.sterner.witchery.core.registry.WitcheryBlockEntityTypes;
import dev.sterner.witchery.core.registry.WitcheryBlocks;
import dev.sterner.witchery.core.registry.WitcheryDataComponents;
import dev.sterner.witchery.core.registry.WitcheryItems;
import dev.sterner.witchery.core.registry.WitcheryTags;
import dev.sterner.witchery.features.poppet.PoppetLevelAttachment;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0005H\u0016J\u0018\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J\u0018\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u0019H\u0014R\"\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u001e"}, d2={"Ldev/sterner/witchery/content/block/poppet/PoppetBlockEntity;", "Ldev/sterner/witchery/content/block/WitcheryBaseBlockEntity;", "blockPos", "Lnet/minecraft/core/BlockPos;", "blockState", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "poppetItemStack", "Lnet/minecraft/world/item/ItemStack;", "kotlin.jvm.PlatformType", "getPoppetItemStack", "()Lnet/minecraft/world/item/ItemStack;", "setPoppetItemStack", "(Lnet/minecraft/world/item/ItemStack;)V", "init", "", "level", "Lnet/minecraft/world/level/Level;", "pos", "state", "saveAdditional", "tag", "Lnet/minecraft/nbt/CompoundTag;", "registries", "Lnet/minecraft/core/HolderLookup$Provider;", "loadAdditional", "pTag", "pRegistries", "Companion", "witchery"})
public final class PoppetBlockEntity
extends WitcheryBaseBlockEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private ItemStack poppetItemStack;

    public PoppetBlockEntity(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        Object object = WitcheryBlockEntityTypes.INSTANCE.getPOPPET().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        super((BlockEntityType)object, blockPos, blockState);
        this.poppetItemStack = ItemStack.EMPTY;
    }

    public final ItemStack getPoppetItemStack() {
        return this.poppetItemStack;
    }

    public final void setPoppetItemStack(ItemStack itemStack) {
        this.poppetItemStack = itemStack;
    }

    @Override
    public void init(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state) {
        ItemStack data2;
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super.init(level, pos, state);
        if (level instanceof ServerLevel && (data2 = PoppetLevelAttachment.INSTANCE.getPoppet((ServerLevel)level, pos)) != null) {
            this.poppetItemStack = data2.copy();
            this.setChanged();
        }
    }

    protected void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        super.saveAdditional(tag, registries);
        if (!this.poppetItemStack.isEmpty()) {
            Tag itemTag = this.poppetItemStack.save(registries, (Tag)new CompoundTag());
            tag.put("Item", itemTag);
        }
    }

    @Override
    protected void loadAdditional(@NotNull CompoundTag pTag, @NotNull HolderLookup.Provider pRegistries) {
        Intrinsics.checkNotNullParameter((Object)pTag, (String)"pTag");
        Intrinsics.checkNotNullParameter((Object)pRegistries, (String)"pRegistries");
        super.loadAdditional(pTag, pRegistries);
        ItemStack.parse((HolderLookup.Provider)pRegistries, (Tag)((Tag)pTag.getCompound("Item"))).ifPresent(arg_0 -> PoppetBlockEntity.loadAdditional$lambda$1(arg_0 -> PoppetBlockEntity.loadAdditional$lambda$0(this, arg_0), arg_0));
    }

    private static final Unit loadAdditional$lambda$0(PoppetBlockEntity this$0, ItemStack it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.poppetItemStack = it;
        return Unit.INSTANCE;
    }

    private static final void loadAdditional$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u000e"}, d2={"Ldev/sterner/witchery/content/block/poppet/PoppetBlockEntity$Companion;", "", "<init>", "()V", "placePoppet", "", "level", "Lnet/minecraft/world/level/Level;", "pos", "Lnet/minecraft/core/BlockPos;", "player", "Lnet/minecraft/world/entity/player/Player;", "direction", "Lnet/minecraft/core/Direction;", "witchery"})
    @SourceDebugExtension(value={"SMAP\nPoppetBlockEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PoppetBlockEntity.kt\ndev/sterner/witchery/content/block/poppet/PoppetBlockEntity$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,113:1\n1#2:114\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean placePoppet(@NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull Direction direction) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
            BlockPos targetPos = direction.getAxis().isVertical() ? pos.relative(player.getDirection()) : pos.relative(direction);
            ItemStack handItem = player.getMainHandItem();
            if (!level.isClientSide && handItem.getItem() instanceof PoppetItem && level.getBlockState(targetPos).canBeReplaced() && handItem.is(WitcheryTags.INSTANCE.getPLACEABLE_POPPETS())) {
                if (handItem.has((DataComponentType)WitcheryDataComponents.INSTANCE.getPLAYER_UUID().get()) || handItem.has((DataComponentType)WitcheryDataComponents.INSTANCE.getENTITY_ID_COMPONENT().get())) {
                    if (handItem.has((DataComponentType)WitcheryDataComponents.INSTANCE.getPLAYER_UUID().get())) {
                        UUID uuid = (UUID)handItem.get((DataComponentType)WitcheryDataComponents.INSTANCE.getPLAYER_UUID().get());
                        if (uuid != null) {
                            UUID it = uuid;
                            boolean bl = false;
                            var8_12 = level.getPlayerByUUID(it);
                            if (var8_12 != null) {
                                var8_12.hurt(level.damageSources().playerAttack(player), 2.0f);
                            }
                        }
                    } else {
                        String id = (String)handItem.get((DataComponentType)WitcheryDataComponents.INSTANCE.getENTITY_ID_COMPONENT().get());
                        if (id != null) {
                            String it = id;
                            boolean bl = false;
                            var8_12 = ((ServerLevel)level).getEntity(UUID.fromString(id));
                            if (var8_12 != null) {
                                var8_12.hurt(level.damageSources().playerAttack(player), 2.0f);
                            }
                        }
                    }
                    if (handItem.is((Item)WitcheryItems.INSTANCE.getVAMPIRIC_POPPET().get()) || handItem.is((Item)WitcheryItems.INSTANCE.getVOODOO_POPPET().get())) {
                        handItem.setDamageValue(handItem.getDamageValue() + handItem.getMaxDamage() / 10);
                    } else {
                        handItem.setDamageValue(handItem.getDamageValue() + 1);
                    }
                    if (handItem.getDamageValue() >= player.getMainHandItem().getMaxDamage()) {
                        handItem.shrink(1);
                        return false;
                    }
                }
                Direction horizontalDirection = direction.getAxis().isVertical() ? player.getDirection() : direction;
                BlockState state = (BlockState)((PoppetBlock)((Object)WitcheryBlocks.INSTANCE.getPOPPET().get())).defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)horizontalDirection.getOpposite());
                level.setBlockAndUpdate(targetPos, state);
                Intrinsics.checkNotNull((Object)targetPos);
                Intrinsics.checkNotNull((Object)state);
                PoppetBlockEntity be = new PoppetBlockEntity(targetPos, state);
                be.setPoppetItemStack(player.getMainHandItem().copy());
                player.getMainHandItem().shrink(1);
                level.setBlockEntity((BlockEntity)be);
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    ItemStack itemStack = be.getPoppetItemStack().copy();
                    Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"copy(...)");
                    PoppetLevelAttachment.INSTANCE.addPoppetData(serverLevel, new PoppetLevelAttachment.PoppetData.Data(pos, itemStack));
                }
                return true;
            }
            return false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

