/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.entity;

import dev.sterner.witchery.content.entity.HuntsmanSpearEntity;
import dev.sterner.witchery.core.registry.WitcheryEntityTypes;
import dev.sterner.witchery.core.registry.WitcheryItems;
import java.util.EnumSet;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.Holder;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 42\u00020\u0001:\u000245B\u001f\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00000\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\bJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\b\u0010\u0013\u001a\u00020\u0010H\u0014J,\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0004\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0015H\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0014J\u0010\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020 H\u0014J\b\u0010!\u001a\u00020\u001dH\u0014J\b\u0010\"\u001a\u00020\u0010H\u0016J\b\u0010#\u001a\u00020\u0010H\u0014J\u0018\u0010$\u001a\u00020\r2\u0006\u0010%\u001a\u00020 2\u0006\u0010&\u001a\u00020'H\u0016J\u0010\u0010(\u001a\u00020\u00102\u0006\u0010)\u001a\u00020*H\u0002J\u000e\u0010+\u001a\u00020\u00102\u0006\u0010)\u001a\u00020*J \u0010,\u001a\u00020\u00102\u0006\u0010\u0004\u001a\u00020-2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010.\u001a\u00020\rH\u0014J\u0006\u0010/\u001a\u00020\rJ\u000e\u00100\u001a\u00020\u00102\u0006\u00101\u001a\u00020\rJ\u0006\u00102\u001a\u00020\rJ\u000e\u00103\u001a\u00020\u00102\u0006\u00102\u001a\u00020\rR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Ldev/sterner/witchery/content/entity/HornedHuntsmanEntity;", "Lnet/minecraft/world/entity/monster/Monster;", "entityType", "Lnet/minecraft/world/entity/EntityType;", "level", "Lnet/minecraft/world/level/Level;", "<init>", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V", "(Lnet/minecraft/world/level/Level;)V", "attackCooldown", "", "spearThrowCooldown", "strafingBackwards", "", "strafingTime", "defineSynchedData", "", "builder", "Lnet/minecraft/network/syncher/SynchedEntityData$Builder;", "registerGoals", "finalizeSpawn", "Lnet/minecraft/world/entity/SpawnGroupData;", "Lnet/minecraft/world/level/ServerLevelAccessor;", "difficulty", "Lnet/minecraft/world/DifficultyInstance;", "spawnType", "Lnet/minecraft/world/entity/MobSpawnType;", "spawnGroupData", "getAmbientSound", "Lnet/minecraft/sounds/SoundEvent;", "getHurtSound", "damageSource", "Lnet/minecraft/world/damagesource/DamageSource;", "getDeathSound", "tick", "customServerAiStep", "hurt", "source", "amount", "", "performMeleeAttack", "target", "Lnet/minecraft/world/entity/LivingEntity;", "performRangedAttack", "dropCustomDeathLoot", "Lnet/minecraft/server/level/ServerLevel;", "recentlyHit", "isAttacking", "setAttacking", "attacking", "hasSpear", "setHasSpear", "Companion", "HuntsmanRangedAttackGoal", "witchery"})
public final class HornedHuntsmanEntity
extends Monster {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int attackCooldown;
    private int spearThrowCooldown;
    private boolean strafingBackwards;
    private int strafingTime;
    private static final EntityDataAccessor<Boolean> ATTACKING = SynchedEntityData.defineId(HornedHuntsmanEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> HAS_SPEAR = SynchedEntityData.defineId(HornedHuntsmanEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final int RANGED_ATTACK_INTERVAL = 60;
    private static final int MELEE_ATTACK_INTERVAL = 20;
    private static final int SPEAR_RECOVERY_TIME = 100;

    public HornedHuntsmanEntity(@NotNull EntityType<? extends HornedHuntsmanEntity> entityType, @NotNull Level level) {
        Intrinsics.checkNotNullParameter(entityType, (String)"entityType");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        super(entityType, level);
    }

    public HornedHuntsmanEntity(@NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Object object = WitcheryEntityTypes.INSTANCE.getHORNED_HUNTSMAN().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        this((EntityType<? extends HornedHuntsmanEntity>)((EntityType)object), level);
    }

    protected void defineSynchedData(@NotNull SynchedEntityData.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        super.defineSynchedData(builder);
        builder.define(ATTACKING, (Object)false);
        builder.define(HAS_SPEAR, (Object)true);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.goalSelector.addGoal(2, (Goal)new HuntsmanRangedAttackGoal(this));
        this.goalSelector.addGoal(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(@NotNull ServerLevelAccessor level, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)difficulty, (String)"difficulty");
        Intrinsics.checkNotNullParameter((Object)spawnType, (String)"spawnType");
        this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)WitcheryItems.INSTANCE.getHUNTSMAN_SPEAR().get()));
        this.setDropChance(EquipmentSlot.MAINHAND, 0.0f);
        this.setHasSpear(true);
        return super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
    }

    @NotNull
    protected SoundEvent getAmbientSound() {
        SoundEvent soundEvent = SoundEvents.RAVAGER_AMBIENT;
        Intrinsics.checkNotNullExpressionValue((Object)soundEvent, (String)"RAVAGER_AMBIENT");
        return soundEvent;
    }

    @NotNull
    protected SoundEvent getHurtSound(@NotNull DamageSource damageSource) {
        Intrinsics.checkNotNullParameter((Object)damageSource, (String)"damageSource");
        SoundEvent soundEvent = SoundEvents.RAVAGER_HURT;
        Intrinsics.checkNotNullExpressionValue((Object)soundEvent, (String)"RAVAGER_HURT");
        return soundEvent;
    }

    @NotNull
    protected SoundEvent getDeathSound() {
        SoundEvent soundEvent = SoundEvents.RAVAGER_DEATH;
        Intrinsics.checkNotNullExpressionValue((Object)soundEvent, (String)"RAVAGER_DEATH");
        return soundEvent;
    }

    public void tick() {
        int n;
        super.tick();
        if (this.attackCooldown > 0) {
            n = this.attackCooldown;
            this.attackCooldown = n + -1;
        }
        if (this.spearThrowCooldown > 0) {
            n = this.spearThrowCooldown;
            this.spearThrowCooldown = n + -1;
        }
        if (!this.hasSpear() && this.spearThrowCooldown <= 0 && !this.level().isClientSide) {
            this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)WitcheryItems.INSTANCE.getHUNTSMAN_SPEAR().get()));
            this.setHasSpear(true);
        }
    }

    protected void customServerAiStep() {
        super.customServerAiStep();
        if (this.isAttacking() && this.getTarget() == null) {
            this.setAttacking(false);
        }
    }

    public boolean hurt(@NotNull DamageSource source, float amount) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (source.getDirectEntity() instanceof LivingEntity) {
            Entity entity = source.getDirectEntity();
            Intrinsics.checkNotNull((Object)entity, (String)"null cannot be cast to non-null type net.minecraft.world.entity.LivingEntity");
            LivingEntity attacker = (LivingEntity)entity;
            float angleToAttacker = Mth.degreesDifferenceAbs((float)this.getYRot(), (float)Mth.wrapDegrees((float)attacker.getYRot()));
            if (angleToAttacker > 120.0f) {
                return super.hurt(source, amount * 1.5f);
            }
        }
        return super.hurt(source, amount);
    }

    private final void performMeleeAttack(LivingEntity target) {
        if (this.attackCooldown <= 0 && this.distanceToSqr((Entity)target) < 4.0) {
            this.attackCooldown = 20;
            this.doHurtTarget((Entity)target);
            if (this.random.nextFloat() < 0.2f) {
                Holder effect = switch (this.random.nextInt(3)) {
                    case 0 -> MobEffects.WEAKNESS;
                    case 1 -> MobEffects.MOVEMENT_SLOWDOWN;
                    default -> MobEffects.POISON;
                };
                target.addEffect(new MobEffectInstance(effect, 100, 1));
            }
        }
    }

    public final void performRangedAttack(@NotNull LivingEntity target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        if (!this.hasSpear() || this.spearThrowCooldown > 0) {
            return;
        }
        Level level = this.level();
        Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
        HuntsmanSpearEntity spearEntity = new HuntsmanSpearEntity(level);
        double dx = target.getX() - this.getX();
        double dy = target.getY() + (double)target.getEyeHeight() / 2.0 - spearEntity.getY();
        double dz = target.getZ() - this.getZ();
        double horizontalDistance = Math.sqrt(dx * dx + dz * dz);
        float velocity = 1.6f;
        spearEntity.shoot(dx, dy + horizontalDistance * 0.2, dz, velocity, 1.0f);
        this.playSound((SoundEvent)SoundEvents.TRIDENT_THROW.value(), 1.0f, 1.0f);
        if (!this.level().isClientSide) {
            this.level().addFreshEntity((Entity)spearEntity);
            this.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
            this.setHasSpear(false);
            this.spearThrowCooldown = 100;
        }
    }

    protected void dropCustomDeathLoot(@NotNull ServerLevel level, @NotNull DamageSource damageSource, boolean recentlyHit) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)damageSource, (String)"damageSource");
        super.dropCustomDeathLoot(level, damageSource, recentlyHit);
        this.spawnAtLocation((ItemLike)WitcheryItems.INSTANCE.getHUNTSMAN_SPEAR().get());
    }

    public final boolean isAttacking() {
        Object object = this.entityData.get(ATTACKING);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (Boolean)object;
    }

    public final void setAttacking(boolean attacking) {
        this.entityData.set(ATTACKING, (Object)attacking);
    }

    public final boolean hasSpear() {
        Object object = this.entityData.get(HAS_SPEAR);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (Boolean)object;
    }

    public final void setHasSpear(boolean hasSpear) {
        this.entityData.set(HAS_SPEAR, (Object)hasSpear);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\r\u001a\u00020\u000eR2\u0010\u0004\u001a&\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006 \u0007*\u0012\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\b\u001a&\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006 \u0007*\u0012\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Ldev/sterner/witchery/content/entity/HornedHuntsmanEntity$Companion;", "", "<init>", "()V", "ATTACKING", "Lnet/minecraft/network/syncher/EntityDataAccessor;", "", "kotlin.jvm.PlatformType", "HAS_SPEAR", "RANGED_ATTACK_INTERVAL", "", "MELEE_ATTACK_INTERVAL", "SPEAR_RECOVERY_TIME", "createAttributes", "Lnet/minecraft/world/entity/ai/attributes/AttributeSupplier$Builder;", "witchery"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AttributeSupplier.Builder createAttributes() {
            AttributeSupplier.Builder builder = Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 150.0).add(Attributes.ATTACK_DAMAGE, 12.0).add(Attributes.MOVEMENT_SPEED, 0.3).add(Attributes.FOLLOW_RANGE, 40.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.6).add(Attributes.ARMOR, 8.0);
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"add(...)");
            return builder;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0010H\u0016J\b\u0010\u0012\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Ldev/sterner/witchery/content/entity/HornedHuntsmanEntity$HuntsmanRangedAttackGoal;", "Lnet/minecraft/world/entity/ai/goal/Goal;", "huntsman", "Ldev/sterner/witchery/content/entity/HornedHuntsmanEntity;", "<init>", "(Ldev/sterner/witchery/content/entity/HornedHuntsmanEntity;)V", "attackTime", "", "targetX", "", "targetY", "targetZ", "canUse", "", "canContinueToUse", "start", "", "stop", "tick", "witchery"})
    private static final class HuntsmanRangedAttackGoal
    extends Goal {
        @NotNull
        private final HornedHuntsmanEntity huntsman;
        private int attackTime;
        private double targetX;
        private double targetY;
        private double targetZ;

        public HuntsmanRangedAttackGoal(@NotNull HornedHuntsmanEntity huntsman) {
            Intrinsics.checkNotNullParameter((Object)((Object)huntsman), (String)"huntsman");
            this.huntsman = huntsman;
            this.attackTime = -1;
            this.setFlags(EnumSet.of((Enum)Goal.Flag.MOVE, (Enum)Goal.Flag.LOOK));
        }

        public boolean canUse() {
            LivingEntity target = this.huntsman.getTarget();
            return target != null && target.isAlive() && this.huntsman.hasSpear() && this.huntsman.spearThrowCooldown <= 0 && this.huntsman.distanceToSqr((Entity)target) > 36.0;
        }

        public boolean canContinueToUse() {
            return this.canUse() || !this.huntsman.navigation.isDone();
        }

        public void start() {
            super.start();
            this.huntsman.setAttacking(true);
        }

        public void stop() {
            super.stop();
            this.huntsman.setAttacking(false);
            this.attackTime = -1;
            this.huntsman.strafingBackwards = false;
            this.huntsman.strafingTime = 0;
        }

        public void tick() {
            boolean inRange;
            LivingEntity livingEntity = this.huntsman.getTarget();
            if (livingEntity == null) {
                return;
            }
            LivingEntity target = livingEntity;
            double distanceToTarget = this.huntsman.distanceToSqr((Entity)target);
            boolean bl = inRange = distanceToTarget <= 100.0 && this.huntsman.hasLineOfSight((Entity)target);
            if (distanceToTarget <= 64.0) {
                HornedHuntsmanEntity hornedHuntsmanEntity = this.huntsman;
                hornedHuntsmanEntity.strafingTime = hornedHuntsmanEntity.strafingTime + 1;
                if (hornedHuntsmanEntity.strafingTime >= 20) {
                    this.huntsman.strafingBackwards = !this.huntsman.strafingBackwards;
                    this.huntsman.strafingTime = 0;
                }
            } else {
                this.huntsman.strafingBackwards = false;
                this.huntsman.strafingTime = 0;
            }
            if (distanceToTarget > 225.0) {
                this.huntsman.navigation.moveTo((Entity)target, 1.0);
            } else if (distanceToTarget < 64.0) {
                double dx = target.getX() - this.huntsman.getX();
                double dz = target.getZ() - this.huntsman.getZ();
                double angle = Math.atan2(dz, dx) - 1.5707963267948966;
                this.targetX = this.huntsman.getX() - Math.cos(angle) * 10.0;
                this.targetZ = this.huntsman.getZ() - Math.sin(angle) * 10.0;
                this.targetY = target.getY();
                this.huntsman.navigation.moveTo(this.targetX, this.targetY, this.targetZ, 1.0);
            }
            this.huntsman.lookAt((Entity)target, 30.0f, 30.0f);
            this.attackTime += -1;
            if (this.attackTime <= 0 && inRange) {
                this.huntsman.performRangedAttack(target);
                this.attackTime = 60;
            }
        }
    }
}

