/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.entity;

import dev.sterner.witchery.core.registry.WitcheryEntityTypes;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.IntIterator;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.ranges.RangesKt;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.sensing.Sensing;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 *2\u00020\u0001:\u0003*+,B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0014J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010J,\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0002\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0013H\u0016J\b\u0010\u001a\u001a\u00020\u000bH\u0016J\b\u0010\u001b\u001a\u00020\u000bH\u0002J\b\u0010\u001c\u001a\u00020\u000bH\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020#H\u0016J\u0018\u0010%\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0010H\u0016J\u0010\u0010)\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020'H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Ldev/sterner/witchery/content/entity/InsanityEntity;", "Lnet/minecraft/world/entity/PathfinderMob;", "level", "Lnet/minecraft/world/level/Level;", "<init>", "(Lnet/minecraft/world/level/Level;)V", "oldSwell", "", "swell", "maxSwell", "registerGoals", "", "defineSynchedData", "builder", "Lnet/minecraft/network/syncher/SynchedEntityData$Builder;", "getSwelling", "", "partialTicks", "finalizeSpawn", "Lnet/minecraft/world/entity/SpawnGroupData;", "Lnet/minecraft/world/level/ServerLevelAccessor;", "difficulty", "Lnet/minecraft/world/DifficultyInstance;", "spawnType", "Lnet/minecraft/world/entity/MobSpawnType;", "spawnGroupData", "tick", "playMobSound", "playerDeathSound", "doHurtTarget", "", "target", "Lnet/minecraft/world/entity/Entity;", "addAdditionalSaveData", "compound", "Lnet/minecraft/nbt/CompoundTag;", "readAdditionalSaveData", "hurt", "source", "Lnet/minecraft/world/damagesource/DamageSource;", "amount", "isInvulnerableTo", "Companion", "InsanityMobType", "SwellGoal", "witchery"})
@SourceDebugExtension(value={"SMAP\nInsanityEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InsanityEntity.kt\ndev/sterner/witchery/content/entity/InsanityEntity\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,228:1\n1869#2,2:229\n*S KotlinDebug\n*F\n+ 1 InsanityEntity.kt\ndev/sterner/witchery/content/entity/InsanityEntity\n*L\n159#1:229,2\n*E\n"})
public final class InsanityEntity
extends PathfinderMob {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int oldSwell;
    private int swell;
    private int maxSwell;
    @NotNull
    private static final EntityDataAccessor<Integer> DATA_SWELL_DIR;
    @NotNull
    private static final EntityDataAccessor<String> DATA_MIMIC;

    public InsanityEntity(@NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        super((EntityType)WitcheryEntityTypes.INSTANCE.getINSANITY().get(), level);
        this.maxSwell = 30;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.goalSelector.addGoal(2, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new SwellGoal(this));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    protected void defineSynchedData(@NotNull SynchedEntityData.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        super.defineSynchedData(builder);
        builder.define(DATA_SWELL_DIR, (Object)-1);
        builder.define(DATA_MIMIC, (Object)"");
    }

    public final float getSwelling(float partialTicks) {
        return Mth.lerp((float)partialTicks, (float)this.oldSwell, (float)this.swell) / (float)(this.maxSwell - 2);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(@NotNull ServerLevelAccessor level, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)difficulty, (String)"difficulty");
        Intrinsics.checkNotNullParameter((Object)spawnType, (String)"spawnType");
        InsanityMobType mimicType = (InsanityMobType)((Object)InsanityMobType.getEntries().get(Random.Default.nextInt(InsanityMobType.getEntries().size())));
        String string = mimicType.name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        this.entityData.set(DATA_MIMIC, (Object)string);
        return super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
    }

    public void tick() {
        Object object = this.entityData.get(DATA_MIMIC);
        String string = "CREEPER".toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        if (Intrinsics.areEqual((Object)object, (Object)string) && this.isAlive()) {
            this.oldSwell = this.swell;
            Object object2 = this.entityData.get(DATA_SWELL_DIR);
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
            int i = ((Number)object2).intValue();
            if (i > 0 && this.swell == 0) {
                this.playSound(SoundEvents.CREEPER_PRIMED, 1.0f, 0.5f);
                this.gameEvent((Holder)GameEvent.PRIME_FUSE);
            }
            this.swell += i;
            if (this.swell < 0) {
                this.swell = 0;
            }
            if (this.swell >= this.maxSwell) {
                this.swell = this.maxSwell;
                this.remove(Entity.RemovalReason.DISCARDED);
                this.level().addParticle((ParticleOptions)ParticleTypes.EXPLOSION, this.getX(), this.getY() + 1.0, this.getZ(), 0.0, 0.0, 0.0);
                this.playSound((SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), 1.0f, 1.0f);
            }
        }
        if (Random.Default.nextInt(200) == 0) {
            this.playMobSound();
        }
        super.tick();
    }

    private final void playMobSound() {
        if (Intrinsics.areEqual((Object)this.entityData.get(DATA_MIMIC), (Object)"zombie")) {
            this.playSound(SoundEvents.ZOMBIE_AMBIENT, 1.0f, 1.0f);
        }
        if (Intrinsics.areEqual((Object)this.entityData.get(DATA_MIMIC), (Object)"skeleton")) {
            this.playSound(SoundEvents.SKELETON_AMBIENT, 1.0f, 1.0f);
        }
        if (Intrinsics.areEqual((Object)this.entityData.get(DATA_MIMIC), (Object)"enderman")) {
            this.playSound(SoundEvents.ENDERMAN_AMBIENT, 1.0f, 1.0f);
        }
    }

    private final void playerDeathSound() {
        if (Intrinsics.areEqual((Object)this.entityData.get(DATA_MIMIC), (Object)"zombie")) {
            this.playSound(SoundEvents.ZOMBIE_HURT, 1.0f, 1.0f);
        }
        if (Intrinsics.areEqual((Object)this.entityData.get(DATA_MIMIC), (Object)"skeleton")) {
            this.playSound(SoundEvents.SKELETON_HURT, 1.0f, 1.0f);
        }
        if (Intrinsics.areEqual((Object)this.entityData.get(DATA_MIMIC), (Object)"enderman")) {
            this.playSound(SoundEvents.ENDERMAN_HURT, 1.0f, 1.0f);
        }
        if (Intrinsics.areEqual((Object)this.entityData.get(DATA_MIMIC), (Object)"creeper")) {
            this.playSound(SoundEvents.CREEPER_HURT, 1.0f, 1.0f);
        }
    }

    public boolean doHurtTarget(@NotNull Entity target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return false;
    }

    public void addAdditionalSaveData(@NotNull CompoundTag compound) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        super.addAdditionalSaveData(compound);
        compound.putShort("Fuse", (short)this.maxSwell);
        compound.putString("Mimic", (String)this.entityData.get(DATA_MIMIC));
    }

    public void readAdditionalSaveData(@NotNull CompoundTag compound) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        super.readAdditionalSaveData(compound);
        if (compound.contains("Fuse", 99)) {
            this.maxSwell = compound.getShort("Fuse");
        }
        if (compound.contains("Mimic", 99)) {
            this.entityData.set(DATA_MIMIC, (Object)compound.getString("Mimic"));
        }
    }

    public boolean hurt(@NotNull DamageSource source, float amount) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (source.getEntity() instanceof Player) {
            Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)20);
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                int element$iv;
                int i = element$iv = ((IntIterator)iterator).nextInt();
                boolean bl = false;
                this.level().addParticle((ParticleOptions)ParticleTypes.POOF, this.getX() + (Random.Default.nextDouble() - 0.5) * (double)this.getBbWidth(), this.getY() + Random.Default.nextDouble() * (double)this.getBbHeight(), this.getZ() + (Random.Default.nextDouble() - 0.5) * (double)this.getBbWidth(), 0.0, 0.0, 0.0);
                this.playerDeathSound();
            }
            this.remove(Entity.RemovalReason.KILLED);
            return true;
        }
        return false;
    }

    public boolean isInvulnerableTo(@NotNull DamageSource source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return !(source.getEntity() instanceof Player) || super.isInvulnerableTo(source);
    }

    static {
        EntityDataAccessor entityDataAccessor = SynchedEntityData.defineId(InsanityEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor, (String)"defineId(...)");
        DATA_SWELL_DIR = entityDataAccessor;
        EntityDataAccessor entityDataAccessor2 = SynchedEntityData.defineId(InsanityEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor2, (String)"defineId(...)");
        DATA_MIMIC = entityDataAccessor2;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u000e"}, d2={"Ldev/sterner/witchery/content/entity/InsanityEntity$Companion;", "", "<init>", "()V", "createAttributes", "Lnet/minecraft/world/entity/ai/attributes/AttributeSupplier$Builder;", "DATA_SWELL_DIR", "Lnet/minecraft/network/syncher/EntityDataAccessor;", "", "getDATA_SWELL_DIR", "()Lnet/minecraft/network/syncher/EntityDataAccessor;", "DATA_MIMIC", "", "getDATA_MIMIC", "witchery"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AttributeSupplier.Builder createAttributes() {
            AttributeSupplier.Builder builder = PathfinderMob.createMobAttributes().add(Attributes.MAX_HEALTH, 1.0).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.ATTACK_DAMAGE, 0.0);
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"add(...)");
            return builder;
        }

        @NotNull
        public final EntityDataAccessor<Integer> getDATA_SWELL_DIR() {
            return DATA_SWELL_DIR;
        }

        @NotNull
        public final EntityDataAccessor<String> getDATA_MIMIC() {
            return DATA_MIMIC;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Ldev/sterner/witchery/content/entity/InsanityEntity$InsanityMobType;", "", "<init>", "(Ljava/lang/String;I)V", "CREEPER", "ZOMBIE", "SKELETON", "ENDERMAN", "witchery"})
    public static final class InsanityMobType
    extends Enum<InsanityMobType> {
        public static final /* enum */ InsanityMobType CREEPER = new InsanityMobType();
        public static final /* enum */ InsanityMobType ZOMBIE = new InsanityMobType();
        public static final /* enum */ InsanityMobType SKELETON = new InsanityMobType();
        public static final /* enum */ InsanityMobType ENDERMAN = new InsanityMobType();
        private static final /* synthetic */ InsanityMobType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static InsanityMobType[] values() {
            return (InsanityMobType[])$VALUES.clone();
        }

        public static InsanityMobType valueOf(String value) {
            return Enum.valueOf(InsanityMobType.class, value);
        }

        @NotNull
        public static EnumEntries<InsanityMobType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = insanityMobTypeArray = new InsanityMobType[]{InsanityMobType.CREEPER, InsanityMobType.ZOMBIE, InsanityMobType.SKELETON, InsanityMobType.ENDERMAN};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0016J\b\u0010\r\u001a\u00020\tH\u0016J\b\u0010\u000e\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Ldev/sterner/witchery/content/entity/InsanityEntity$SwellGoal;", "Lnet/minecraft/world/entity/ai/goal/Goal;", "creeper", "Ldev/sterner/witchery/content/entity/InsanityEntity;", "<init>", "(Ldev/sterner/witchery/content/entity/InsanityEntity;)V", "target", "Lnet/minecraft/world/entity/LivingEntity;", "canUse", "", "start", "", "stop", "requiresUpdateEveryTick", "tick", "witchery"})
    public static final class SwellGoal
    extends Goal {
        @NotNull
        private final InsanityEntity creeper;
        @Nullable
        private LivingEntity target;

        public SwellGoal(@NotNull InsanityEntity creeper) {
            Intrinsics.checkNotNullParameter((Object)((Object)creeper), (String)"creeper");
            this.creeper = creeper;
            this.setFlags(EnumSet.of((Enum)Goal.Flag.MOVE));
        }

        public boolean canUse() {
            Object object = this.creeper.entityData.get(Companion.getDATA_MIMIC());
            String string = "CREEPER".toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            boolean bl = Intrinsics.areEqual((Object)object, (Object)string);
            LivingEntity livingEntity = this.creeper.getTarget();
            return bl && (((Number)this.creeper.entityData.get(Companion.getDATA_SWELL_DIR())).intValue() > 0 || livingEntity != null && this.creeper.distanceToSqr((Entity)livingEntity) < 9.0);
        }

        public void start() {
            this.creeper.navigation.stop();
            this.target = this.creeper.getTarget();
        }

        public void stop() {
            this.target = null;
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public void tick() {
            if (this.target == null) {
                this.creeper.entityData.set(Companion.getDATA_SWELL_DIR(), (Object)-1);
            } else {
                LivingEntity livingEntity = this.target;
                Intrinsics.checkNotNull((Object)livingEntity);
                if (this.creeper.distanceToSqr((Entity)livingEntity) > 49.0) {
                    this.creeper.entityData.set(Companion.getDATA_SWELL_DIR(), (Object)-1);
                } else {
                    Sensing sensing = this.creeper.getSensing();
                    LivingEntity livingEntity2 = this.target;
                    Intrinsics.checkNotNull((Object)livingEntity2);
                    if (!sensing.hasLineOfSight((Entity)livingEntity2)) {
                        this.creeper.entityData.set(Companion.getDATA_SWELL_DIR(), (Object)-1);
                    } else {
                        this.creeper.entityData.set(Companion.getDATA_SWELL_DIR(), (Object)1);
                    }
                }
            }
        }
    }
}

