/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.entity;

import dev.sterner.witchery.core.registry.WitcheryEntityTypes;
import dev.sterner.witchery.features.affliction.AfflictionPlayerAttachment;
import dev.sterner.witchery.features.affliction.vampire.VampireLeveling;
import dev.sterner.witchery.network.SpawnSmokeParticlesS2CPayload;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.BossEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 J2\u00020\u0001:\u0002JKB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0017\u001a\u00020\u0018H\u0014J\u0010\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0014J\u0010\u0010\"\u001a\u00020\u00072\u0006\u0010#\u001a\u00020\u0007H\u0016J\b\u0010$\u001a\u00020\u0007H\u0016J(\u0010%\u001a\u00020\u00182\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u00072\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0014J \u0010-\u001a\u00020\u00072\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020/2\u0006\u00101\u001a\u000202H\u0016J\u0010\u00103\u001a\u00020\u00072\u0006\u00101\u001a\u000202H\u0016J\b\u00104\u001a\u00020\u0018H\u0016J\u0010\u00105\u001a\u0002062\u0006\u00107\u001a\u000208H\u0016J\u0014\u00109\u001a\u00020\u00182\n\u0010:\u001a\u0006\u0012\u0002\b\u00030;H\u0016J\u0018\u0010<\u001a\u00020\u00072\u0006\u00101\u001a\u0002022\u0006\u0010=\u001a\u00020/H\u0016J\b\u0010>\u001a\u00020\u0018H\u0014J\u0010\u0010?\u001a\u00020\u00182\u0006\u0010@\u001a\u00020AH\u0016J\u0010\u0010B\u001a\u00020\u00182\u0006\u0010@\u001a\u00020AH\u0016J\u0012\u0010C\u001a\u00020\u00182\b\u0010D\u001a\u0004\u0018\u00010EH\u0016J\u0010\u0010F\u001a\u00020\u00182\u0006\u0010G\u001a\u00020HH\u0016J\u0010\u0010I\u001a\u00020\u00182\u0006\u0010G\u001a\u00020HH\u0016R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\t\"\u0004\b\u000e\u0010\u000bR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006L"}, d2={"Ldev/sterner/witchery/content/entity/LilithEntity;", "Lnet/minecraft/world/entity/monster/Monster;", "level", "Lnet/minecraft/world/level/Level;", "<init>", "(Lnet/minecraft/world/level/Level;)V", "onceOnDefeat", "", "getOnceOnDefeat", "()Z", "setOnceOnDefeat", "(Z)V", "hasUsedLilith", "getHasUsedLilith", "setHasUsedLilith", "despawnTicks", "", "getDespawnTicks", "()I", "setDespawnTicks", "(I)V", "bossEvent", "Lnet/minecraft/server/level/ServerBossEvent;", "registerGoals", "", "defineSynchedData", "builder", "Lnet/minecraft/network/syncher/SynchedEntityData$Builder;", "mobInteract", "Lnet/minecraft/world/InteractionResult;", "player", "Lnet/minecraft/world/entity/player/Player;", "hand", "Lnet/minecraft/world/InteractionHand;", "canUsePortal", "allowPassengers", "fireImmune", "checkFallDamage", "y", "", "onGround", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "pos", "Lnet/minecraft/core/BlockPos;", "causeFallDamage", "fallDistance", "", "multiplier", "source", "Lnet/minecraft/world/damagesource/DamageSource;", "isInvulnerableTo", "baseTick", "getDefaultDimensions", "Lnet/minecraft/world/entity/EntityDimensions;", "pose", "Lnet/minecraft/world/entity/Pose;", "onSyncedDataUpdated", "dataAccessor", "Lnet/minecraft/network/syncher/EntityDataAccessor;", "hurt", "amount", "customServerAiStep", "startSeenByPlayer", "serverPlayer", "Lnet/minecraft/server/level/ServerPlayer;", "stopSeenByPlayer", "setCustomName", "name", "Lnet/minecraft/network/chat/Component;", "addAdditionalSaveData", "compound", "Lnet/minecraft/nbt/CompoundTag;", "readAdditionalSaveData", "Companion", "TargetWhenNotDefeated", "witchery"})
public final class LilithEntity
extends Monster {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean onceOnDefeat;
    private boolean hasUsedLilith;
    private int despawnTicks;
    @NotNull
    private final ServerBossEvent bossEvent;
    @NotNull
    private static final EntityDataAccessor<Boolean> IS_DEFEATED;

    public LilithEntity(@NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        super((EntityType)WitcheryEntityTypes.INSTANCE.getLILITH().get(), level);
        this.onceOnDefeat = true;
        BossEvent bossEvent = new ServerBossEvent(this.getDisplayName(), BossEvent.BossBarColor.PURPLE, BossEvent.BossBarOverlay.PROGRESS).setDarkenScreen(true);
        Intrinsics.checkNotNull((Object)bossEvent, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerBossEvent");
        this.bossEvent = (ServerBossEvent)bossEvent;
    }

    public final boolean getOnceOnDefeat() {
        return this.onceOnDefeat;
    }

    public final void setOnceOnDefeat(boolean bl) {
        this.onceOnDefeat = bl;
    }

    public final boolean getHasUsedLilith() {
        return this.hasUsedLilith;
    }

    public final void setHasUsedLilith(boolean bl) {
        this.hasUsedLilith = bl;
    }

    public final int getDespawnTicks() {
        return this.despawnTicks;
    }

    public final void setDespawnTicks(int n) {
        this.despawnTicks = n;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.goalSelector.addGoal(2, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, (Boolean)this.entityData.get(IS_DEFEATED) != false ? 0.5 : 1.0));
        this.goalSelector.addGoal(2, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 15.0f, 1.0f));
        this.targetSelector.addGoal(1, (Goal)new TargetWhenNotDefeated(this, LivingEntity.class));
        super.registerGoals();
    }

    protected void defineSynchedData(@NotNull SynchedEntityData.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        builder.define(IS_DEFEATED, (Object)true);
        super.defineSynchedData(builder);
    }

    @NotNull
    protected InteractionResult mobInteract(@NotNull Player player, @NotNull InteractionHand hand) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        if (player instanceof ServerPlayer && hand == InteractionHand.MAIN_HAND && AfflictionPlayerAttachment.getData(player).getVampireLevel() == 6 && ((ServerPlayer)player).getMainHandItem().is(Items.POPPY)) {
            VampireLeveling.givePoppy((ServerPlayer)player);
            this.hasUsedLilith = true;
            return InteractionResult.SUCCESS;
        }
        InteractionResult interactionResult = super.mobInteract(player, hand);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResult, (String)"mobInteract(...)");
        return interactionResult;
    }

    public boolean canUsePortal(boolean allowPassengers) {
        return false;
    }

    public boolean fireImmune() {
        return true;
    }

    protected void checkFallDamage(double y, boolean onGround, @NotNull BlockState state, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
    }

    public boolean causeFallDamage(float fallDistance, float multiplier, @NotNull DamageSource source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return false;
    }

    public boolean isInvulnerableTo(@NotNull DamageSource source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return super.isInvulnerableTo(source) || (Boolean)this.entityData.get(IS_DEFEATED) != false;
    }

    public void baseTick() {
        super.baseTick();
        if (this.hasUsedLilith) {
            int n = this.despawnTicks;
            this.despawnTicks = n + 1;
            if (this.despawnTicks > 100) {
                if (this.level() instanceof ServerLevel) {
                    Level level = this.level();
                    Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
                    ServerLevel serverLevel = (ServerLevel)level;
                    Vec3 vec3 = this.position();
                    Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"position(...)");
                    PacketDistributor.sendToPlayersInDimension((ServerLevel)serverLevel, (CustomPacketPayload)new SpawnSmokeParticlesS2CPayload(vec3), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
                this.discard();
            }
        }
        if ((double)(this.getHealth() / this.getMaxHealth()) <= 0.05) {
            this.entityData.set(IS_DEFEATED, (Object)true);
        }
        if (!((Boolean)this.entityData.get(IS_DEFEATED)).booleanValue()) {
            if (this.level().getGameTime() % (long)20 == 0L) {
                this.heal(5.0f);
            }
        } else if (this.onceOnDefeat) {
            this.onceOnDefeat = false;
            if (this.level() instanceof ServerLevel) {
                Level level = this.level();
                Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
                ServerLevel serverLevel = (ServerLevel)level;
                Vec3 vec3 = this.position();
                Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"position(...)");
                PacketDistributor.sendToPlayersInDimension((ServerLevel)serverLevel, (CustomPacketPayload)new SpawnSmokeParticlesS2CPayload(vec3), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    @NotNull
    public EntityDimensions getDefaultDimensions(@NotNull Pose pose) {
        Intrinsics.checkNotNullParameter((Object)pose, (String)"pose");
        EntityDimensions entityDimensions = super.getDefaultDimensions(pose).scale((Boolean)this.entityData.get(IS_DEFEATED) != false ? 0.75f : 1.0f);
        Intrinsics.checkNotNullExpressionValue((Object)entityDimensions, (String)"scale(...)");
        return entityDimensions;
    }

    public void onSyncedDataUpdated(@NotNull EntityDataAccessor<?> dataAccessor) {
        Intrinsics.checkNotNullParameter(dataAccessor, (String)"dataAccessor");
        if (Intrinsics.areEqual(IS_DEFEATED, dataAccessor)) {
            this.refreshDimensions();
        }
        super.onSyncedDataUpdated(dataAccessor);
    }

    public boolean hurt(@NotNull DamageSource source, float amount) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (this.getHealth() == 1.0f) {
            return false;
        }
        if (amount > this.getHealth()) {
            this.setHealth(1.0f);
            return false;
        }
        return super.hurt(source, amount);
    }

    protected void customServerAiStep() {
        super.customServerAiStep();
        if (((Boolean)this.entityData.get(IS_DEFEATED)).booleanValue()) {
            this.bossEvent.removeAllPlayers();
        } else {
            this.bossEvent.setProgress(this.getHealth() / this.getMaxHealth());
        }
    }

    public void startSeenByPlayer(@NotNull ServerPlayer serverPlayer) {
        Intrinsics.checkNotNullParameter((Object)serverPlayer, (String)"serverPlayer");
        super.startSeenByPlayer(serverPlayer);
        if (!((Boolean)this.entityData.get(IS_DEFEATED)).booleanValue()) {
            this.bossEvent.addPlayer(serverPlayer);
        }
    }

    public void stopSeenByPlayer(@NotNull ServerPlayer serverPlayer) {
        Intrinsics.checkNotNullParameter((Object)serverPlayer, (String)"serverPlayer");
        super.stopSeenByPlayer(serverPlayer);
        this.bossEvent.removePlayer(serverPlayer);
    }

    public void setCustomName(@Nullable Component name) {
        super.setCustomName(name);
        this.bossEvent.setName(this.getDisplayName());
    }

    public void addAdditionalSaveData(@NotNull CompoundTag compound) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        super.addAdditionalSaveData(compound);
        Object object = this.entityData.get(IS_DEFEATED);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        compound.putBoolean("IsDefeated", ((Boolean)object).booleanValue());
        compound.putBoolean("HasUsedLilith", this.hasUsedLilith);
        compound.putInt("DespawnTicks", this.despawnTicks);
    }

    public void readAdditionalSaveData(@NotNull CompoundTag compound) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        super.readAdditionalSaveData(compound);
        this.entityData.set(IS_DEFEATED, (Object)compound.getBoolean("IsDefeated"));
        this.hasUsedLilith = compound.getBoolean("HasUsedLilith");
        this.despawnTicks = compound.getInt("DespawnTicks");
        if (this.hasCustomName()) {
            this.bossEvent.setName(this.getDisplayName());
        }
    }

    static {
        EntityDataAccessor entityDataAccessor = SynchedEntityData.defineId(LilithEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor, (String)"defineId(...)");
        IS_DEFEATED = entityDataAccessor;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Ldev/sterner/witchery/content/entity/LilithEntity$Companion;", "", "<init>", "()V", "createAttributes", "Lnet/minecraft/world/entity/ai/attributes/AttributeSupplier$Builder;", "IS_DEFEATED", "Lnet/minecraft/network/syncher/EntityDataAccessor;", "", "getIS_DEFEATED", "()Lnet/minecraft/network/syncher/EntityDataAccessor;", "witchery"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AttributeSupplier.Builder createAttributes() {
            AttributeSupplier.Builder builder = Monster.createMobAttributes().add(Attributes.MAX_HEALTH, 200.0).add(Attributes.MOVEMENT_SPEED, 0.4).add(Attributes.ATTACK_DAMAGE, 8.0).add(Attributes.FOLLOW_RANGE, 48.0);
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"add(...)");
            return builder;
        }

        @NotNull
        public final EntityDataAccessor<Boolean> getIS_DEFEATED() {
            return IS_DEFEATED;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000e"}, d2={"Ldev/sterner/witchery/content/entity/LilithEntity$TargetWhenNotDefeated;", "Lnet/minecraft/world/entity/ai/goal/target/NearestAttackableTargetGoal;", "Lnet/minecraft/world/entity/LivingEntity;", "lilithEntity", "Ldev/sterner/witchery/content/entity/LilithEntity;", "targetType", "Ljava/lang/Class;", "<init>", "(Ldev/sterner/witchery/content/entity/LilithEntity;Ljava/lang/Class;)V", "getLilithEntity", "()Ldev/sterner/witchery/content/entity/LilithEntity;", "canUse", "", "canContinueToUse", "witchery"})
    public static final class TargetWhenNotDefeated
    extends NearestAttackableTargetGoal<LivingEntity> {
        @NotNull
        private final LilithEntity lilithEntity;

        public TargetWhenNotDefeated(@NotNull LilithEntity lilithEntity, @NotNull Class<LivingEntity> targetType) {
            Intrinsics.checkNotNullParameter((Object)((Object)lilithEntity), (String)"lilithEntity");
            Intrinsics.checkNotNullParameter(targetType, (String)"targetType");
            super((Mob)lilithEntity, targetType, 10, true, true, TargetWhenNotDefeated::_init_$lambda$0);
            this.lilithEntity = lilithEntity;
        }

        @NotNull
        public final LilithEntity getLilithEntity() {
            return this.lilithEntity;
        }

        public boolean canUse() {
            return super.canUse() && (Boolean)this.lilithEntity.entityData.get(Companion.getIS_DEFEATED()) == false;
        }

        public boolean canContinueToUse() {
            return super.canContinueToUse() && (Boolean)this.lilithEntity.entityData.get(Companion.getIS_DEFEATED()) == false;
        }

        private static final boolean _init_$lambda$0(LivingEntity it) {
            return it instanceof Player;
        }
    }
}

