/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.entity.goal;

import dev.sterner.witchery.content.entity.DeathEntity;
import java.util.EnumSet;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0010H\u0016J\b\u0010\u0012\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Ldev/sterner/witchery/content/entity/goal/PrioritizeSetTargetGoal;", "Lnet/minecraft/world/entity/ai/goal/Goal;", "mob", "Lnet/minecraft/world/entity/Mob;", "priorityDuration", "", "<init>", "(Lnet/minecraft/world/entity/Mob;I)V", "forcedTarget", "Lnet/minecraft/world/entity/LivingEntity;", "forcedTargetSetTime", "", "canUse", "", "canContinueToUse", "start", "", "tick", "stop", "witchery"})
public final class PrioritizeSetTargetGoal
extends Goal {
    @NotNull
    private final Mob mob;
    private final int priorityDuration;
    @Nullable
    private LivingEntity forcedTarget;
    private long forcedTargetSetTime;

    public PrioritizeSetTargetGoal(@NotNull Mob mob, int priorityDuration) {
        Intrinsics.checkNotNullParameter((Object)mob, (String)"mob");
        this.mob = mob;
        this.priorityDuration = priorityDuration;
        this.setFlags(EnumSet.of((Enum)Goal.Flag.TARGET));
    }

    public /* synthetic */ PrioritizeSetTargetGoal(Mob mob, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 400;
        }
        this(mob, n);
    }

    public boolean canUse() {
        block8: {
            block10: {
                block9: {
                    if (this.mob instanceof DeathEntity && !((DeathEntity)this.mob).getHasForcedTarget()) {
                        return false;
                    }
                    LivingEntity target = this.mob.getTarget();
                    if (target != null && this.forcedTarget == null) {
                        this.forcedTarget = target;
                        this.forcedTargetSetTime = this.mob.level().getGameTime();
                        return true;
                    }
                    if (this.forcedTarget == null) break block8;
                    long timeSinceSet = this.mob.level().getGameTime() - this.forcedTargetSetTime;
                    if (timeSinceSet >= (long)this.priorityDuration) {
                        this.forcedTarget = null;
                        if (this.mob instanceof DeathEntity) {
                            ((DeathEntity)this.mob).setHasForcedTarget(false);
                        }
                        return false;
                    }
                    LivingEntity livingEntity = this.forcedTarget;
                    Intrinsics.checkNotNull((Object)livingEntity);
                    if (!livingEntity.isAlive()) break block9;
                    LivingEntity livingEntity2 = this.forcedTarget;
                    Intrinsics.checkNotNull((Object)livingEntity2);
                    if (!livingEntity2.isRemoved()) break block10;
                }
                this.forcedTarget = null;
                if (this.mob instanceof DeathEntity) {
                    ((DeathEntity)this.mob).setHasForcedTarget(false);
                }
                return false;
            }
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canContinueToUse() {
        if (this.forcedTarget == null) {
            return false;
        }
        long timeSinceSet = this.mob.level().getGameTime() - this.forcedTargetSetTime;
        if (timeSinceSet >= (long)this.priorityDuration) return false;
        LivingEntity livingEntity = this.forcedTarget;
        Intrinsics.checkNotNull((Object)livingEntity);
        if (!livingEntity.isAlive()) return false;
        LivingEntity livingEntity2 = this.forcedTarget;
        Intrinsics.checkNotNull((Object)livingEntity2);
        if (livingEntity2.isRemoved()) return false;
        return true;
    }

    public void start() {
        if (this.forcedTarget != null) {
            this.mob.setTarget(this.forcedTarget);
        }
    }

    public void tick() {
        if (this.forcedTarget != null && !Intrinsics.areEqual((Object)this.mob.getTarget(), (Object)this.forcedTarget)) {
            this.mob.setTarget(this.forcedTarget);
        }
    }

    public void stop() {
        if (this.mob instanceof DeathEntity) {
            ((DeathEntity)this.mob).setHasForcedTarget(false);
        }
    }
}

