/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.entity.goal;

import dev.sterner.witchery.content.entity.AbstractSpectralEntity;
import java.util.EnumSet;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Ldev/sterner/witchery/content/entity/goal/RandomFloatAroundGoal;", "Lnet/minecraft/world/entity/ai/goal/Goal;", "bansheeEntity", "Ldev/sterner/witchery/content/entity/AbstractSpectralEntity;", "<init>", "(Ldev/sterner/witchery/content/entity/AbstractSpectralEntity;)V", "canUse", "", "canContinueToUse", "start", "", "witchery"})
public final class RandomFloatAroundGoal
extends Goal {
    @NotNull
    private final AbstractSpectralEntity bansheeEntity;

    public RandomFloatAroundGoal(@NotNull AbstractSpectralEntity bansheeEntity) {
        Intrinsics.checkNotNullParameter((Object)((Object)bansheeEntity), (String)"bansheeEntity");
        this.bansheeEntity = bansheeEntity;
        this.setFlags(EnumSet.of((Enum)Goal.Flag.MOVE));
    }

    public boolean canUse() {
        double f;
        double e;
        MoveControl moveControl = this.bansheeEntity.getMoveControl();
        if (!moveControl.hasWanted()) {
            return true;
        }
        double d = moveControl.getWantedX() - this.bansheeEntity.getX();
        double g = d * d + (e = moveControl.getWantedY() - this.bansheeEntity.getY()) * e + (f = moveControl.getWantedZ() - this.bansheeEntity.getZ()) * f;
        return g < 1.0 || g > 3600.0;
    }

    public boolean canContinueToUse() {
        return false;
    }

    public void start() {
        RandomSource randomSource = this.bansheeEntity.getRandom();
        double d = this.bansheeEntity.getX() + (double)((randomSource.nextFloat() * 2.0f - 1.0f) * 8.0f);
        double e = (double)randomSource.nextFloat() < 0.6 ? this.bansheeEntity.getY() - (double)(randomSource.nextFloat() * 8.0f) : this.bansheeEntity.getY() + (double)(randomSource.nextFloat() * 8.0f);
        double f = this.bansheeEntity.getZ() + (double)((randomSource.nextFloat() * 2.0f - 1.0f) * 8.0f);
        this.bansheeEntity.getMoveControl().setWantedPosition(d, e, f, 1.0);
    }
}

