/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.entity.goal;

import dev.sterner.witchery.content.entity.DeathEntity;
import java.util.EnumSet;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0011\u001a\u00020\u000eH\u0016J\b\u0010\u0012\u001a\u00020\u000eH\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0014H\u0016J\b\u0010\u0016\u001a\u00020\u000eH\u0016J\b\u0010\u0017\u001a\u00020\u0014H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Ldev/sterner/witchery/content/entity/goal/ScytheThrowGoal;", "Lnet/minecraft/world/entity/ai/goal/Goal;", "death", "Ldev/sterner/witchery/content/entity/DeathEntity;", "maxRange", "", "attackIntervalMin", "", "attackIntervalMax", "<init>", "(Ldev/sterner/witchery/content/entity/DeathEntity;DII)V", "attackTime", "seeTime", "strafingClockwise", "", "strafingBackwards", "strafingTime", "canUse", "canContinueToUse", "start", "", "stop", "requiresUpdateEveryTick", "tick", "witchery"})
public final class ScytheThrowGoal
extends Goal {
    @NotNull
    private final DeathEntity death;
    private final double maxRange;
    private final int attackIntervalMin;
    private final int attackIntervalMax;
    private int attackTime;
    private int seeTime;
    private boolean strafingClockwise;
    private boolean strafingBackwards;
    private int strafingTime;

    public ScytheThrowGoal(@NotNull DeathEntity death, double maxRange, int attackIntervalMin, int attackIntervalMax) {
        Intrinsics.checkNotNullParameter((Object)((Object)death), (String)"death");
        this.death = death;
        this.maxRange = maxRange;
        this.attackIntervalMin = attackIntervalMin;
        this.attackIntervalMax = attackIntervalMax;
        this.attackTime = -1;
        this.strafingTime = -1;
        this.setFlags(EnumSet.of((Enum)Goal.Flag.MOVE, (Enum)Goal.Flag.LOOK));
    }

    public boolean canUse() {
        LivingEntity livingEntity = this.death.getTarget();
        if (livingEntity == null) {
            return false;
        }
        LivingEntity target = livingEntity;
        if (!target.isAlive()) {
            return false;
        }
        if (!this.death.canThrowScythe()) {
            return false;
        }
        double distance = this.death.distanceToSqr((Entity)target);
        return distance >= 64.0 && distance <= this.maxRange * this.maxRange;
    }

    public boolean canContinueToUse() {
        LivingEntity livingEntity = this.death.getTarget();
        if (livingEntity == null) {
            return false;
        }
        LivingEntity target = livingEntity;
        if (!target.isAlive()) {
            return false;
        }
        double distance = this.death.distanceToSqr((Entity)target);
        return distance >= 49.0 && distance <= (this.maxRange + 5.0) * (this.maxRange + 5.0) && this.death.canThrowScythe();
    }

    public void start() {
        super.start();
        this.death.setAggressive(true);
        this.strafingTime = 0;
    }

    public void stop() {
        super.stop();
        this.death.setAggressive(false);
        this.seeTime = 0;
        this.attackTime = -1;
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void tick() {
        int n;
        LivingEntity livingEntity = this.death.getTarget();
        if (livingEntity == null) {
            return;
        }
        LivingEntity target = livingEntity;
        double distanceSq = this.death.distanceToSqr((Entity)target);
        boolean canSee = this.death.getSensing().hasLineOfSight((Entity)target);
        if (canSee) {
            n = this.seeTime;
            this.seeTime = n + 1;
        } else {
            this.seeTime = 0;
        }
        this.death.getLookControl().setLookAt((Entity)target, 30.0f, 30.0f);
        if (distanceSq <= this.maxRange * this.maxRange) {
            n = this.strafingTime;
            this.strafingTime = n + 1;
            if (this.strafingTime >= 20) {
                if (this.death.getRandom().nextFloat() < 0.3f) {
                    boolean bl = this.strafingClockwise = !this.strafingClockwise;
                }
                if (this.death.getRandom().nextFloat() < 0.3f) {
                    this.strafingBackwards = !this.strafingBackwards;
                }
                this.strafingTime = 0;
            }
            if (this.strafingTime > -1) {
                if (distanceSq > this.maxRange * 0.75 * (this.maxRange * 0.75)) {
                    this.strafingBackwards = false;
                } else if (distanceSq < this.maxRange * 0.5 * (this.maxRange * 0.5)) {
                    this.strafingBackwards = true;
                }
                this.death.getMoveControl().strafe(this.strafingBackwards ? -0.5f : 0.5f, this.strafingClockwise ? 0.5f : -0.5f);
            }
            if (this.attackTime <= 0 && canSee && this.seeTime >= 5) {
                int attackInterval;
                this.death.throwScythe(target);
                this.attackTime = attackInterval = this.attackIntervalMin + this.death.getRandom().nextInt(this.attackIntervalMax - this.attackIntervalMin + 1);
            }
            if (this.attackTime > 0) {
                n = this.attackTime;
                this.attackTime = n + -1;
            }
        }
    }
}

