/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.entity.goal;

import dev.sterner.witchery.content.entity.VampireEntity;
import java.util.EnumSet;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Ldev/sterner/witchery/content/entity/goal/VampireHurtByTargetGoal;", "Lnet/minecraft/world/entity/ai/goal/target/TargetGoal;", "vampire", "Ldev/sterner/witchery/content/entity/VampireEntity;", "<init>", "(Ldev/sterner/witchery/content/entity/VampireEntity;)V", "getVampire", "()Ldev/sterner/witchery/content/entity/VampireEntity;", "timestamp", "", "canUse", "", "start", "", "Companion", "witchery"})
public class VampireHurtByTargetGoal
extends TargetGoal {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final VampireEntity vampire;
    private int timestamp;
    @NotNull
    private static final TargetingConditions HURT_BY_TARGETING;

    public VampireHurtByTargetGoal(@NotNull VampireEntity vampire) {
        Intrinsics.checkNotNullParameter((Object)((Object)vampire), (String)"vampire");
        super((Mob)vampire, true);
        this.vampire = vampire;
        this.setFlags(EnumSet.of((Enum)Goal.Flag.TARGET));
    }

    @NotNull
    public final VampireEntity getVampire() {
        return this.vampire;
    }

    public boolean canUse() {
        int i = this.vampire.getLastHurtByMobTimestamp();
        LivingEntity livingEntity = this.vampire.getLastHurtByMob();
        return i != this.timestamp && livingEntity != null && !Intrinsics.areEqual((Object)this.vampire.getOwnerUUID(), (Object)livingEntity.getUUID()) ? this.canAttack(livingEntity, HURT_BY_TARGETING) : false;
    }

    public void start() {
        this.mob.setTarget(this.mob.getLastHurtByMob());
        this.targetMob = this.mob.getTarget();
        this.timestamp = this.mob.getLastHurtByMobTimestamp();
        this.unseenMemoryTicks = 300;
        super.start();
    }

    static {
        TargetingConditions targetingConditions = TargetingConditions.forCombat().ignoreLineOfSight().ignoreInvisibilityTesting();
        Intrinsics.checkNotNullExpressionValue((Object)targetingConditions, (String)"ignoreInvisibilityTesting(...)");
        HURT_BY_TARGETING = targetingConditions;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Ldev/sterner/witchery/content/entity/goal/VampireHurtByTargetGoal$Companion;", "", "<init>", "()V", "HURT_BY_TARGETING", "Lnet/minecraft/world/entity/ai/targeting/TargetingConditions;", "witchery"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

