/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.entity.projectile;

import dev.sterner.witchery.core.registry.WitcheryEntityTypes;
import dev.sterner.witchery.core.registry.WitcheryItems;
import dev.sterner.witchery.features.affliction.vampire.VampireLeveling;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustColorTransitionOptions;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B#\b\u0016\u0012\u0010\u0010\u0002\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00000\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\bB\u0019\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u0006\u0010\u000bB)\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\r\u0012\u0006\u0010\u000f\u001a\u00020\r\u00a2\u0006\u0004\b\u0006\u0010\u0010J\b\u0010\u0011\u001a\u00020\u0012H\u0014J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\u0010\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001fH\u0014J\u0010\u0010 \u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020!H\u0014R\u0014\u0010\u0013\u001a\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\""}, d2={"Ldev/sterner/witchery/content/entity/projectile/SunGrenadeProjectile;", "Lnet/minecraft/world/entity/projectile/ThrowableItemProjectile;", "entityType", "Lnet/minecraft/world/entity/EntityType;", "level", "Lnet/minecraft/world/level/Level;", "<init>", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V", "(Lnet/minecraft/world/level/Level;)V", "shooter", "Lnet/minecraft/world/entity/LivingEntity;", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/LivingEntity;)V", "x", "", "y", "z", "(Lnet/minecraft/world/level/Level;DDD)V", "getDefaultItem", "Lnet/minecraft/world/item/Item;", "particle", "Lnet/minecraft/core/particles/ParticleOptions;", "getParticle", "()Lnet/minecraft/core/particles/ParticleOptions;", "handleEntityEvent", "", "id", "", "onHitEntity", "result", "Lnet/minecraft/world/phys/EntityHitResult;", "onHitBlock", "Lnet/minecraft/world/phys/BlockHitResult;", "onHit", "Lnet/minecraft/world/phys/HitResult;", "witchery"})
public final class SunGrenadeProjectile
extends ThrowableItemProjectile {
    public SunGrenadeProjectile(@NotNull EntityType<? extends SunGrenadeProjectile> entityType, @NotNull Level level) {
        Intrinsics.checkNotNullParameter(entityType, (String)"entityType");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        super(entityType, level);
    }

    public SunGrenadeProjectile(@NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        super((EntityType)WitcheryEntityTypes.INSTANCE.getSUN_GRENADE().get(), level);
    }

    public SunGrenadeProjectile(@NotNull Level level, @NotNull LivingEntity shooter) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)shooter, (String)"shooter");
        super((EntityType)WitcheryEntityTypes.INSTANCE.getSUN_GRENADE().get(), shooter, level);
    }

    public SunGrenadeProjectile(@NotNull Level level, double x, double y, double z) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        super((EntityType)WitcheryEntityTypes.INSTANCE.getSUN_GRENADE().get(), x, y, z, level);
    }

    @NotNull
    protected Item getDefaultItem() {
        Object object = WitcheryItems.INSTANCE.getQUARTZ_SPHERE().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (Item)object;
    }

    private final ParticleOptions getParticle() {
        ItemStack itemstack = this.getItem();
        ParticleOptions particleOptions = !itemstack.isEmpty() && !itemstack.is(this.getDefaultItem()) ? (ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, itemstack) : (ParticleOptions)ParticleTypes.ITEM_SNOWBALL;
        Intrinsics.checkNotNull((Object)particleOptions, (String)"null cannot be cast to non-null type net.minecraft.core.particles.ParticleOptions");
        return particleOptions;
    }

    public void handleEntityEvent(byte id) {
        if (id == 3) {
            int it;
            ParticleOptions baseParticle = this.getParticle();
            Vec3 paleYellow = new Vec3(1.0, 1.0, 0.6);
            Vec3 white = new Vec3(1.0, 1.0, 1.0);
            DustColorTransitionOptions sunParticle = new DustColorTransitionOptions(paleYellow.toVector3f(), white.toVector3f(), 1.0f);
            this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), SoundEvents.GLASS_BREAK, SoundSource.NEUTRAL, 0.8f, 1.2f + (float)Math.random() * 0.3f, false);
            int n = 4;
            int n2 = 0;
            while (n2 < n) {
                it = n2++;
                boolean bl = false;
                this.level().addParticle((ParticleOptions)sunParticle, this.getX() + SunGrenadeProjectile.handleEntityEvent$spread(this), this.getY() + SunGrenadeProjectile.handleEntityEvent$spread(this), this.getZ() + SunGrenadeProjectile.handleEntityEvent$spread(this), 0.0, 0.01, 0.0);
            }
            n = 8;
            n2 = 0;
            while (n2 < n) {
                it = n2++;
                boolean bl = false;
                this.level().addParticle(baseParticle, this.getX() + SunGrenadeProjectile.handleEntityEvent$spread(this), this.getY() + SunGrenadeProjectile.handleEntityEvent$spread(this), this.getZ() + SunGrenadeProjectile.handleEntityEvent$spread(this), 0.0, 0.0, 0.0);
            }
            n = 4;
            n2 = 0;
            while (n2 < n) {
                it = n2++;
                boolean bl = false;
                this.level().addParticle((ParticleOptions)ParticleTypes.END_ROD, this.getX() + SunGrenadeProjectile.handleEntityEvent$spread(this), this.getY() + SunGrenadeProjectile.handleEntityEvent$spread(this), this.getZ() + SunGrenadeProjectile.handleEntityEvent$spread(this), 0.0, 0.01, 0.0);
            }
        }
    }

    protected void onHitEntity(@NotNull EntityHitResult result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        super.onHitEntity(result);
        Entity e = result.getEntity();
        e.hurt(this.damageSources().thrown((Entity)this, this.getOwner()), 1.0f);
        e.setRemainingFireTicks(80);
        if (e instanceof ServerPlayer) {
            VampireLeveling.increaseUsedSunGrenades((ServerPlayer)e);
        }
    }

    protected void onHitBlock(@NotNull BlockHitResult result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        super.onHitBlock(result);
        BlockPos hitPos = result.getBlockPos().relative(result.getDirection());
        double radius = 1.5;
        AABB aabb = new AABB((double)hitPos.getX() - radius, (double)hitPos.getY() - radius, (double)hitPos.getZ() - radius, (double)hitPos.getX() + radius, (double)hitPos.getY() + radius, (double)hitPos.getZ() + radius);
        List entities = this.level().getEntities((Entity)this, aabb);
        for (Entity e : entities) {
            e.hurt(this.damageSources().thrown((Entity)this, this.getOwner()), 1.0f);
            e.setRemainingFireTicks(80);
            if (!(e instanceof ServerPlayer)) continue;
            VampireLeveling.increaseUsedSunGrenades((ServerPlayer)e);
        }
    }

    protected void onHit(@NotNull HitResult result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        super.onHit(result);
        if (!this.level().isClientSide) {
            this.level().broadcastEntityEvent((Entity)this, (byte)3);
            this.discard();
        }
    }

    private static final double handleEntityEvent$spread(SunGrenadeProjectile this$0) {
        return (this$0.level().random.nextDouble() - 0.5) * 1.0;
    }
}

